/*
 * Decompiled with CFR 0.152.
 */
package chococraft.common.entities;

import chococraft.common.ModChocoCraft;
import chococraft.common.config.ChocoCraftBlocks;
import chococraft.common.config.ChocoCraftItems;
import chococraft.common.config.Constants;
import chococraft.common.entities.ChocoboNames;
import chococraft.common.entities.EntityChicobo;
import chococraft.common.entities.EntityChocobo;
import chococraft.common.entities.ai.ChocoboAIFollowOwner;
import chococraft.common.entities.ai.ChocoboAILookIdle;
import chococraft.common.entities.ai.ChocoboAISwimming;
import chococraft.common.entities.ai.ChocoboAITeleportToOwner;
import chococraft.common.entities.ai.ChocoboAIWander;
import chococraft.common.entities.ai.ChocoboAIWatchClosest;
import chococraft.common.gui.GuiStarter;
import chococraft.common.helper.ChocoboEntityHelper;
import chococraft.common.helper.ChocoboMathHelper;
import chococraft.common.helper.ChocoboParticleHelper;
import chococraft.common.network.PacketRegistry;
import chococraft.common.network.clientSide.ChocoboHealth;
import chococraft.common.network.clientSide.ChocoboHunger;
import chococraft.common.network.clientSide.ChocoboParticles;
import chococraft.common.network.clientSide.ChocoboTamed;
import chococraft.common.network.serverSide.ChocoboAttribute;
import chococraft.common.network.serverSide.ChocoboChangeOwner;
import chococraft.common.network.serverSide.ChocoboSetInLove;
import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIPanic;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.pathfinding.PathEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public abstract class EntityAnimalChocobo
extends EntityTameable
implements IEntityAdditionalSpawnData {
    public chocoboColor color = chocoboColor.YELLOW;
    protected boolean hasMate;
    public int field_70882_e = 0;
    protected PathEntity field_70786_d;
    public Entity field_70789_a;
    protected boolean field_70787_b = false;
    protected int field_70788_c = 0;
    protected int taskNumber = 0;
    public float flyingMovementFactor;
    public boolean canClimb;
    public boolean canCrossWater;
    public boolean canJumpHigh;
    public boolean canFly;
    public double landSpeedFactor;
    public double waterSpeedFactor;
    public double airbornSpeedFactor;

    public EntityAnimalChocobo(World world) {
        super(world);
        this.setHidename(true);
        this.setWander(true);
        this.func_70903_f(false);
        this.setFollowing(false);
        this.setIsMale(this.getRandomIsMale());
        this.func_70661_as().func_75491_a(true);
        this.hasMate = false;
        this.field_70714_bg.func_75776_a(this.taskNumber++, (EntityAIBase)new ChocoboAISwimming(this));
        this.field_70714_bg.func_75776_a(this.taskNumber++, (EntityAIBase)new EntityAIPanic((EntityCreature)this, (double)0.38f));
        this.field_70714_bg.func_75776_a(this.taskNumber++, (EntityAIBase)new ChocoboAIWander(this, 0.25f));
        this.field_70714_bg.func_75776_a(this.taskNumber++, (EntityAIBase)new ChocoboAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.field_70714_bg.func_75776_a(this.taskNumber++, (EntityAIBase)new ChocoboAILookIdle((EntityLiving)this));
        this.field_70714_bg.func_75776_a(this.taskNumber++, (EntityAIBase)new ChocoboAIFollowOwner(this, 20.0f));
        this.field_70714_bg.func_75776_a(this.taskNumber++, (EntityAIBase)new ChocoboAITeleportToOwner(this, 20.0f));
    }

    protected boolean isClient() {
        return this.field_70170_p.field_72995_K;
    }

    protected boolean isServer() {
        return !this.field_70170_p.field_72995_K;
    }

    public ResourceLocation getResourceLocation() {
        return new ResourceLocation("chococraft", this.getEntityTexture());
    }

    public boolean func_70650_aV() {
        return true;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(Constants.DW_ID_EAC_NAME, (Object)"");
        this.field_70180_af.func_75682_a(Constants.DW_ID_EAC_FLAGS, (Object)0);
        this.field_70180_af.func_75682_a(Constants.DW_ID_EAC_TIME_UNTIL_HUNGER, (Object)0);
    }

    public void func_70014_b(NBTTagCompound nbttagcompound) {
        super.func_70014_b(nbttagcompound);
        nbttagcompound.func_74778_a("Name", this.getName());
        nbttagcompound.func_74768_a("Age", this.func_70874_b());
        nbttagcompound.func_74757_a("isMale", this.isMale());
        nbttagcompound.func_74757_a("Follow", this.isFollowing().booleanValue());
        nbttagcompound.func_74757_a("wander", this.isWander());
        nbttagcompound.func_74757_a("hidename", this.isHidename());
        nbttagcompound.func_74757_a("tamed", this.func_70909_n());
        nbttagcompound.func_74768_a("timeUntilHunger", this.getTimeUntilHunger());
    }

    public void func_70037_a(NBTTagCompound nbttagcompound) {
        super.func_70037_a(nbttagcompound);
        this.setName(nbttagcompound.func_74779_i("Name"));
        this.func_70873_a(nbttagcompound.func_74762_e("Age"));
        this.setHidename(nbttagcompound.func_74767_n("hidename"));
        this.setFollowing(nbttagcompound.func_74767_n("Follow"));
        this.setWander(nbttagcompound.func_74767_n("wander"));
        this.setIsMale(nbttagcompound.func_74767_n("isMale"));
        this.func_70903_f(nbttagcompound.func_74767_n("tamed"));
        this.setTimeUntilHunger(nbttagcompound.func_74762_e("timeUntilHunger"));
    }

    public void writeSpawnData(ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.getName());
        buf.writeBoolean(this.isMale());
        buf.writeBoolean(this.isHidename());
        buf.writeBoolean(this.isWander());
        buf.writeBoolean(this.isFollowing().booleanValue());
    }

    public void readSpawnData(ByteBuf buf) {
        this.setName(ByteBufUtils.readUTF8String((ByteBuf)buf));
        this.setIsMale(buf.readBoolean());
        this.setHidename(buf.readBoolean());
        this.setWander(buf.readBoolean());
        this.setFollowing(buf.readBoolean());
    }

    public abstract String getEntityTexture();

    public void setName(String name) {
        this.field_70180_af.func_75692_b(Constants.DW_ID_EAC_NAME, (Object)name);
        if (this.isClient()) {
            this.sendAttributeUpdate();
        }
    }

    public String getName() {
        String name = this.field_70180_af.func_75681_e(Constants.DW_ID_EAC_NAME);
        if (name.isEmpty()) {
            name = ChocoboNames.getRandomName(this.isMale());
            this.field_70180_af.func_75692_b(Constants.DW_ID_EAC_NAME, (Object)name);
        }
        return name;
    }

    public int getTimeUntilHunger() {
        return this.field_70180_af.func_75679_c(Constants.DW_ID_EAC_TIME_UNTIL_HUNGER);
    }

    public void setTimeUntilHunger(int timeUntilHunger) {
        if (timeUntilHunger > 0) {
            this.field_70180_af.func_75692_b(Constants.DW_ID_EAC_TIME_UNTIL_HUNGER, (Object)timeUntilHunger);
        } else {
            this.field_70180_af.func_75692_b(Constants.DW_ID_EAC_TIME_UNTIL_HUNGER, (Object)0);
        }
    }

    public boolean isHungry() {
        boolean hungry = this.getTimeUntilHunger() <= 0;
        return hungry && ModChocoCraft.hungerEnabled;
    }

    public void feeding() {
        int timeUntilHunger = this.func_70631_g_() ? ModChocoCraft.hungerDelayChicobo : ModChocoCraft.hungerDelayChocobo;
        this.setTimeUntilHunger(timeUntilHunger);
        this.sendParticleUpdate("mobSpell", this, 7);
    }

    public void func_70873_a(int growingAge) {
        if (!this.isHungry()) {
            super.func_70873_a(growingAge);
        }
    }

    public boolean func_70880_s() {
        return (this.field_70180_af.func_75683_a(Constants.DW_ID_EAC_FLAGS) & Constants.DW_VAL_EAC_INLOVE_ON) != 0;
    }

    public void setInLove(boolean inLove) {
        byte eacFlags = this.field_70180_af.func_75683_a(Constants.DW_ID_EAC_FLAGS);
        if (inLove) {
            this.field_70180_af.func_75692_b(Constants.DW_ID_EAC_FLAGS, (Object)((byte)(eacFlags | Constants.DW_VAL_EAC_INLOVE_ON)));
        } else {
            this.field_70180_af.func_75692_b(Constants.DW_ID_EAC_FLAGS, (Object)((byte)(eacFlags & Constants.DW_VAL_EAC_INLOVE_OFF)));
        }
        this.sendSetInLoveUpdate();
    }

    public boolean isMale() {
        return (this.field_70180_af.func_75683_a(Constants.DW_ID_EAC_FLAGS) & Constants.DW_VAL_EAC_ISMALE_ON) != 0;
    }

    public void setIsMale(boolean isMale) {
        byte eacFlags = this.field_70180_af.func_75683_a(Constants.DW_ID_EAC_FLAGS);
        if (isMale) {
            this.field_70180_af.func_75692_b(Constants.DW_ID_EAC_FLAGS, (Object)((byte)(eacFlags | Constants.DW_VAL_EAC_ISMALE_ON)));
        } else {
            this.field_70180_af.func_75692_b(Constants.DW_ID_EAC_FLAGS, (Object)((byte)(eacFlags & Constants.DW_VAL_EAC_ISMALE_OFF)));
        }
    }

    public boolean getRandomIsMale() {
        return new Random().nextInt(100) < ModChocoCraft.genderMaleChance;
    }

    public boolean isHidename() {
        return (this.field_70180_af.func_75683_a(Constants.DW_ID_EAC_FLAGS) & Constants.DW_VAL_EAC_HIDENAME_ON) != 0;
    }

    public void setHidename(boolean hidename) {
        byte eacFlags = this.field_70180_af.func_75683_a(Constants.DW_ID_EAC_FLAGS);
        if (hidename) {
            this.field_70180_af.func_75692_b(Constants.DW_ID_EAC_FLAGS, (Object)((byte)(eacFlags | Constants.DW_VAL_EAC_HIDENAME_ON)));
        } else {
            this.field_70180_af.func_75692_b(Constants.DW_ID_EAC_FLAGS, (Object)((byte)(eacFlags & Constants.DW_VAL_EAC_HIDENAME_OFF)));
        }
        if (this.isClient()) {
            this.sendAttributeUpdate();
        }
    }

    public boolean isWander() {
        return (this.field_70180_af.func_75683_a(Constants.DW_ID_EAC_FLAGS) & Constants.DW_VAL_EAC_WANDER_ON) != 0;
    }

    public void setWander(boolean wander) {
        byte eacFlags = this.field_70180_af.func_75683_a(Constants.DW_ID_EAC_FLAGS);
        if (wander) {
            this.field_70180_af.func_75692_b(Constants.DW_ID_EAC_FLAGS, (Object)((byte)(eacFlags | Constants.DW_VAL_EAC_WANDER_ON)));
        } else {
            this.field_70180_af.func_75692_b(Constants.DW_ID_EAC_FLAGS, (Object)((byte)(eacFlags & Constants.DW_VAL_EAC_WANDER_OFF)));
        }
        if (this.isClient()) {
            this.sendAttributeUpdate();
        }
    }

    public Boolean isFollowing() {
        return (this.field_70180_af.func_75683_a(Constants.DW_ID_EAC_FLAGS) & Constants.DW_VAL_EAC_FOLLOWING_ON) != 0;
    }

    public void setFollowing(Boolean following) {
        byte eacFlags = this.field_70180_af.func_75683_a(Constants.DW_ID_EAC_FLAGS);
        if (following.booleanValue()) {
            this.field_70180_af.func_75692_b(Constants.DW_ID_EAC_FLAGS, (Object)((byte)(eacFlags | Constants.DW_VAL_EAC_FOLLOWING_ON)));
        } else {
            this.field_70180_af.func_75692_b(Constants.DW_ID_EAC_FLAGS, (Object)((byte)(eacFlags & Constants.DW_VAL_EAC_FOLLOWING_OFF)));
        }
        if (this.isClient()) {
            this.sendAttributeUpdate();
        }
    }

    public String getGender() {
        return this.isMale() ? "Male" : "Female";
    }

    protected boolean func_70780_i() {
        return false;
    }

    public void toggleFollowWanderStay() {
        if (this.isFollowing().booleanValue() && !this.isWander()) {
            this.setFollowing(false);
            this.setWander(false);
        } else if (!this.isFollowing().booleanValue() && !this.isWander()) {
            this.setFollowing(false);
            this.setWander(true);
        } else {
            this.setFollowing(true);
            this.setWander(false);
        }
        this.showAmountHeartsOrSmokeFx(this.isFollowing(), 7);
    }

    public void toggleFollowStay() {
        if (!this.isFollowing().booleanValue() && !this.isWander()) {
            this.setFollowing(true);
            this.setWander(false);
        } else {
            this.setFollowing(false);
            this.setWander(false);
        }
        this.showAmountHeartsOrSmokeFx(this.isFollowing(), 7);
    }

    public EntityPlayer getOwner() {
        EntityPlayer owner = this.field_70170_p.func_72924_a(this.func_152113_b());
        if (null == owner && this.field_70170_p.field_73010_i.size() == 1) {
            if (this.func_152113_b().equals("Player")) {
                Object playerObj = this.field_70170_p.field_73010_i.get(0);
                if (playerObj instanceof EntityPlayer) {
                    EntityPlayer updatedOwner = (EntityPlayer)playerObj;
                    this.func_152115_b(updatedOwner.getDisplayName());
                    owner = updatedOwner;
                }
            } else {
                EntityPlayer offlinePlayer;
                Object playerObj = this.field_70170_p.field_73010_i.get(0);
                if (playerObj instanceof EntityPlayer && (offlinePlayer = (EntityPlayer)playerObj).getDisplayName().equals("Player")) {
                    owner = offlinePlayer;
                }
            }
        }
        return owner;
    }

    public boolean isOwner(EntityPlayer player) {
        return !ModChocoCraft.isRemoteClient || player.equals((Object)this.getOwner());
    }

    public void func_70636_d() {
        super.func_70636_d();
        this.setTimeUntilHunger(this.getTimeUntilHunger() - 1);
        this.doStrawHealing();
    }

    private void doStrawHealing() {
        int range;
        Block blockBelow;
        int d100;
        if (this.isServer() && this.func_70909_n() && this.func_110143_aJ() < this.func_110138_aP() && this.field_70170_p.func_72820_D() % 40L == 0L && (d100 = this.field_70146_Z.nextInt(100)) < ModChocoCraft.penHealProbability && (blockBelow = this.field_70170_p.func_147439_a(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.field_70121_D.field_72338_b), MathHelper.func_76128_c((double)this.field_70161_v))).equals(ChocoCraftBlocks.strawBlock) && this.isFilledCauldronNear(this.field_70165_t, this.field_70163_u, this.field_70161_v, range = ModChocoCraft.penHealCauldronRange, 2, range)) {
            this.func_70691_i(this.field_70146_Z.nextInt(3) + 1);
            this.sendHealthUpdate();
            this.sendParticleUpdate(Constants.PARTICLE_HEART, this, 1);
        }
    }

    private boolean isFilledCauldronNear(double posX, double posY, double posZ, int rangeX, int rangeY, int rangeZ) {
        int y;
        int iPosX = (int)posX;
        int iPosY = (int)posY;
        int iPosZ = (int)posZ;
        if (this.isFilledCauldronNearAtYLevel(iPosX, iPosY + 1, iPosZ, rangeX, rangeZ)) {
            return true;
        }
        for (y = iPosY + 2; y <= iPosY + rangeY; ++y) {
            if (!this.isFilledCauldronNearAtYLevel(iPosX, y, iPosZ, rangeX, rangeZ)) continue;
            return true;
        }
        for (y = iPosY; y >= iPosY - rangeY; --y) {
            if (!this.isFilledCauldronNearAtYLevel(iPosX, y, iPosZ, rangeX, rangeZ)) continue;
            return true;
        }
        return false;
    }

    private boolean isFilledCauldronNearAtYLevel(int posX, int posY, int posZ, int rangeX, int rangeZ) {
        for (int x = posX - rangeX; x <= posX + rangeX; ++x) {
            for (int z = posZ - rangeZ; z <= posZ + rangeZ; ++z) {
                int fillStatus;
                if (!this.field_70170_p.func_147439_a(x, posY, z).equals(Blocks.field_150383_bp) || (fillStatus = this.field_70170_p.func_72805_g(x, posY, z)) <= 0) continue;
                return true;
            }
        }
        return false;
    }

    public boolean func_70085_c(EntityPlayer entityplayer) {
        boolean interacted = false;
        ItemStack itemstack = entityplayer.field_71071_by.func_70448_g();
        if (itemstack != null) {
            System.out.println(itemstack.func_77973_b().toString());
            if (itemstack.func_77973_b().equals(ChocoCraftItems.chocopediaItem)) {
                this.onChocopediaUse();
                interacted = true;
            } else if (itemstack.func_77973_b().equals(Item.func_150898_a((Block)ChocoCraftBlocks.gysahlGreenBlock))) {
                this.onGysahlGreenUse(entityplayer);
                interacted = true;
            } else if (itemstack.func_77973_b().equals(Items.field_151099_bA)) {
                this.onWritableBookUse(entityplayer);
                interacted = true;
            }
        }
        return interacted;
    }

    protected boolean onEmptyHandInteraction(EntityPlayer entityplayer) {
        return false;
    }

    protected void onChocopediaUse() {
        if (this.isClient()) {
            if (this.func_70909_n()) {
                GuiStarter.startChocopediaGui(this);
            } else {
                this.showAmountHeartsOrSmokeFx(false, 7);
            }
        }
    }

    protected void onWritableBookUse(EntityPlayer player) {
        int selectedSlot = player.field_71071_by.field_70461_c;
        player.field_71071_by.field_70462_a[selectedSlot] = new ItemStack(ChocoCraftItems.chocopediaItem, 1);
    }

    protected void onGysahlGreenUse(EntityPlayer entityplayer) {
        if (!this.func_70909_n()) {
            this.useItem(entityplayer);
            if (this.isServer()) {
                if (this.field_70146_Z.nextInt(3) == 0) {
                    this.func_70903_f(true);
                    this.setWander(true);
                    this.setFollowing(false);
                    this.setHidename(true);
                    this.field_70170_p.func_72960_a((Entity)this, (byte)7);
                    this.func_152115_b(entityplayer.getDisplayName());
                    this.sendTamedUpdate();
                } else {
                    this.field_70170_p.func_72960_a((Entity)this, (byte)6);
                }
            }
            this.showAmountHeartsOrSmokeFx(this.func_70909_n(), 7);
        } else if (this.func_110143_aJ() < this.func_110138_aP()) {
            this.useItem(entityplayer);
            if (!this.field_70170_p.field_72995_K) {
                this.func_70691_i(10.0f);
                this.sendHealthUpdate();
            }
            this.showAmountHeartsOrSmokeFx(true, 7);
        } else if (this.isHungry()) {
            this.useItem(entityplayer);
            if (!this.field_70170_p.field_72995_K) {
                this.feeding();
                this.sendHungerUpdate();
            }
        }
    }

    protected void func_70785_a(Entity entity, float targetDistance) {
        if (entity instanceof EntityAnimalChocobo) {
            EntityAnimalChocobo otherChocobo = (EntityAnimalChocobo)entity;
            if (this.func_70874_b() > 0 && otherChocobo.func_70874_b() < 0) {
                if ((double)targetDistance < 2.5) {
                    this.field_70787_b = true;
                }
            } else if (this.func_70880_s() && otherChocobo.func_70880_s()) {
                if (otherChocobo.field_70789_a == null) {
                    otherChocobo.field_70789_a = this;
                }
                if (otherChocobo.field_70789_a == this && (double)targetDistance < 5.0) {
                    otherChocobo.setInLove(true);
                    this.setInLove(true);
                    ++this.field_70882_e;
                    if (this.field_70882_e % 4 == 0 && this.isClient()) {
                        ChocoboParticleHelper.showParticleAroundEntityFx(Constants.PARTICLE_HEART, (Entity)this);
                    }
                    if (this.field_70882_e == 60) {
                        this.procreate((EntityAnimalChocobo)entity);
                    }
                } else {
                    otherChocobo.field_70789_a = null;
                    this.field_70882_e = 0;
                }
            } else {
                this.field_70882_e = 0;
            }
        }
    }

    public void procreate(EntityAnimalChocobo otherParent) {
        EntityChicobo babyChicobo;
        if (this.isServer() && (babyChicobo = (EntityChicobo)this.func_90011_a((EntityAgeable)otherParent)) != null) {
            babyChicobo.setTimeUntilAdult(this.field_70146_Z.nextInt(ModChocoCraft.growupDelayRandom) + ModChocoCraft.growupDelayStatic);
            babyChicobo.func_70873_a(babyChicobo.getTimeUntilAdult());
            babyChicobo.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, this.field_70125_A);
            this.field_70170_p.func_72838_d((Entity)babyChicobo);
            this.func_70873_a(this.isMale() ? ModChocoCraft.breedingDelayMale : ModChocoCraft.breedingDelayFemale);
            otherParent.func_70873_a(otherParent.isMale() ? ModChocoCraft.breedingDelayMale : ModChocoCraft.breedingDelayFemale);
            this.field_70789_a = null;
            otherParent.field_70789_a = null;
            this.field_70882_e = 0;
            otherParent.field_70882_e = 0;
            this.setInLove(false);
            otherParent.setInLove(false);
            this.sendParticleUpdate(Constants.PARTICLE_HEART, this, 7);
        }
    }

    public void damageHandling() {
        this.field_70788_c = 60;
        this.field_70789_a = null;
        this.setInLove(false);
    }

    protected Entity func_70782_k() {
        if (this.field_70788_c > 0) {
            return null;
        }
        if (this.func_70880_s()) {
            List list = this.field_70170_p.func_72872_a(EntityChocobo.class, this.field_70121_D.func_72314_b(8.0, 8.0, 8.0));
            for (Object aList : list) {
                boolean canMate;
                EntityChocobo otherChoco = (EntityChocobo)((Object)aList);
                if (otherChoco == this || !(canMate = otherChoco.func_70880_s() && otherChoco.isMale() != this.isMale()) || otherChoco.func_70631_g_()) continue;
                this.hasMate = true;
                otherChoco.hasMate = true;
                return otherChoco;
            }
        }
        return null;
    }

    public int func_70641_bl() {
        return ModChocoCraft.spawnTotalMax;
    }

    public boolean func_70601_bi() {
        int z;
        int y;
        int x = MathHelper.func_76128_c((double)this.field_70165_t);
        Boolean isPosPathWeight = this.func_70783_a(x, y = MathHelper.func_76128_c((double)this.field_70121_D.field_72338_b), z = MathHelper.func_76128_c((double)this.field_70161_v)) >= 0.0f;
        return isPosPathWeight != false && super.func_70601_bi();
    }

    public boolean canSpawnAtLoc(int x, int y, int z) {
        return World.func_147466_a((IBlockAccess)this.field_70170_p, (int)x, (int)(y - 1), (int)z) && ChocoboEntityHelper.isSpaceAroundLocationFree(this.field_70170_p, x, y, z, 1, 3, 1);
    }

    public boolean teleportToOwner() {
        if (this.getOwner() != null) {
            int ownerPosX = MathHelper.func_76128_c((double)this.getOwner().field_70165_t) - 2;
            int ownerPosZ = MathHelper.func_76128_c((double)this.getOwner().field_70161_v) - 2;
            int ownerPosY = MathHelper.func_76128_c((double)this.getOwner().field_70121_D.field_72338_b);
            for (int xOffset = 0; xOffset <= 4; ++xOffset) {
                for (int yOffset = 0; yOffset <= 4; ++yOffset) {
                    int zTele;
                    int yTele;
                    int xTele;
                    if (xOffset >= 1 && yOffset >= 1 && xOffset <= 3 && yOffset <= 3 || !this.canSpawnAtLoc(xTele = ownerPosX + xOffset, yTele = ownerPosY, zTele = ownerPosZ + yOffset)) continue;
                    double finXTele = (double)xTele + 0.5;
                    double finYTele = yTele;
                    double finZTele = (double)zTele + 0.5;
                    this.func_70012_b(finXTele, finYTele, finZTele, this.field_70177_z, this.field_70125_A);
                    this.func_70661_as().func_75499_g();
                    return true;
                }
            }
        }
        return false;
    }

    public void changeOwner(String newOwner) {
        this.func_152115_b(newOwner);
        this.sendChangeOwnerUpdate();
    }

    public int func_70627_aG() {
        return 150;
    }

    protected boolean func_70692_ba() {
        return ModChocoCraft.wildCanDespawn && !this.func_70909_n();
    }

    public void func_70106_y() {
        this.field_70128_L = true;
    }

    public boolean playerInRange(double range) {
        double dZ;
        double dY;
        double dX;
        double delta;
        EntityPlayer player = this.field_70170_p.func_72890_a((Entity)this, -1.0);
        return null != player && (delta = (dX = player.field_70165_t - this.field_70165_t) * dX + (dY = player.field_70163_u - this.field_70163_u) * dY + (dZ = player.field_70161_v - this.field_70161_v) * dZ) < range;
    }

    protected boolean isLoverlyGysahl(ItemStack itemstack) {
        return itemstack.func_77973_b().equals(ChocoCraftItems.gysahlLoverlyItem);
    }

    protected boolean isGoldenGysahl(ItemStack itemstack) {
        return itemstack.func_77973_b().equals(ChocoCraftItems.gysahlGoldenItem);
    }

    protected void useItem(EntityPlayer entityplayer) {
        if (entityplayer.field_71075_bZ.field_75098_d) {
            return;
        }
        ItemStack itemstack = entityplayer.field_71071_by.func_70448_g();
        --itemstack.field_77994_a;
        if (itemstack.field_77994_a <= 0) {
            entityplayer.field_71071_by.func_70299_a(entityplayer.field_71071_by.field_70461_c, null);
        }
    }

    public boolean func_70631_g_() {
        return this instanceof EntityChicobo;
    }

    protected void func_70069_a(float fallHeight) {
        int i = (int)Math.ceil(fallHeight - 6.0f);
        if (i > 0) {
            if (i > 4) {
                this.field_70170_p.func_72956_a((Entity)this, "damage.fallbig", 1.0f, 1.0f);
            } else {
                this.field_70170_p.func_72956_a((Entity)this, "damage.fallsmall", 1.0f, 1.0f);
            }
            this.func_70097_a(DamageSource.field_76379_h, i);
            int blockPosX = MathHelper.func_76128_c((double)this.field_70165_t);
            int blockPosY = MathHelper.func_76128_c((double)(this.field_70163_u - 0.2 - (double)this.field_70129_M));
            int blockPosZ = MathHelper.func_76128_c((double)this.field_70161_v);
            Block block = this.field_70170_p.func_147439_a(blockPosX, blockPosY, blockPosZ);
            if (block != null) {
                Block.SoundType stepsound = block.field_149762_H;
                this.field_70170_p.func_72956_a((Entity)this, stepsound.field_150501_a, stepsound.func_150497_c() * 0.5f, stepsound.func_150494_d() * 0.75f);
            }
        }
    }

    protected void getPathOrWalkableBlock(Entity entity, float distance) {
        boolean canDrown = true;
        PathEntity pathentity = this.field_70170_p.func_72865_a((Entity)this, entity, 16.0f, this.canCrossWater, this.canClimb, this.canFly, canDrown);
        if (pathentity == null && distance > 12.0f) {
            int entityPosX = MathHelper.func_76128_c((double)entity.field_70165_t) - 2;
            int entityPosY = MathHelper.func_76128_c((double)entity.field_70121_D.field_72338_b);
            int entityPosZ = MathHelper.func_76128_c((double)entity.field_70161_v) - 2;
            for (int i = 0; i <= 4; ++i) {
                for (int j = 0; j <= 4; ++j) {
                    if (i >= 1 && j >= 1 && i <= 3 && j <= 3 || !this.field_70170_p.func_147439_a(entityPosX + i, entityPosY - 1, entityPosZ + j).func_149662_c() || this.field_70170_p.func_147439_a(entityPosX + i, entityPosY, entityPosZ + j).func_149662_c() || this.field_70170_p.func_147439_a(entityPosX + i, entityPosY + 1, entityPosZ + j).func_149662_c()) continue;
                    float gPosX = (float)(entityPosX + i) + 0.5f;
                    float gPosY = entityPosY;
                    float gPosZ = (float)(entityPosZ + j) + 0.5f;
                    if (ChocoboEntityHelper.isSpaceAroundLocationFree(this.field_70170_p, entityPosX + i, entityPosY, entityPosZ + j, 1, 3, 1)) {
                        // empty if block
                    }
                    this.func_70012_b(gPosX, gPosY, gPosZ, this.field_70177_z, this.field_70125_A);
                    return;
                }
            }
        } else {
            this.func_70778_a(pathentity);
        }
    }

    protected void func_70779_j() {
        for (int i = 0; i < 10; ++i) {
            int wanderZ;
            int wanderY;
            int wanderX = MathHelper.func_76128_c((double)(this.field_70165_t + (double)this.field_70146_Z.nextInt(13) - 6.0));
            if (!(this.func_70783_a(wanderX, wanderY = MathHelper.func_76128_c((double)(this.field_70163_u + (double)this.field_70146_Z.nextInt(7) - 3.0)), wanderZ = MathHelper.func_76128_c((double)(this.field_70161_v + (double)this.field_70146_Z.nextInt(13) - 6.0))) > -99999.0f)) continue;
            this.field_70786_d = this.field_70170_p.func_72844_a((Entity)this, wanderX, wanderY, wanderZ, 10.0f, false, false, false, false);
            break;
        }
    }

    protected void func_70626_be() {
        if (this.field_70788_c > 0) {
            --this.field_70788_c;
        }
        EntityPlayer nearestPlayer = this.getNearestPlayer();
        if (this.func_70909_n() || nearestPlayer == null || !((double)this.func_70032_d((Entity)nearestPlayer) < 16.0) || this.func_70631_g_() || this.func_70635_at().func_75522_a((Entity)nearestPlayer)) {
            // empty if block
        }
        this.field_70787_b = this.func_70780_i();
        float f = 16.0f;
        if (this.field_70789_a == null) {
            this.field_70789_a = this.func_70782_k();
            if (this.field_70789_a != null) {
                this.field_70786_d = this.field_70170_p.func_72865_a((Entity)this, this.field_70789_a, f, false, false, false, false);
            }
        } else if (!this.field_70789_a.func_70089_S()) {
            this.field_70789_a = null;
        } else {
            float distToAttackEntity = this.field_70789_a.func_70032_d((Entity)this);
            if (this.func_70685_l(this.field_70789_a)) {
                this.func_70785_a(this.field_70789_a, distToAttackEntity);
            }
        }
        if (!(this.field_70787_b || this.field_70789_a == null || this.field_70786_d != null && this.field_70146_Z.nextInt(20) != 0)) {
            this.field_70786_d = this.field_70170_p.func_72865_a((Entity)this, this.field_70789_a, f, false, false, false, false);
        } else if (!this.field_70787_b && this.isWander() && (this.field_70786_d == null && this.field_70146_Z.nextInt(180) == 0 || this.field_70146_Z.nextInt(120) == 0 || this.field_70788_c > 0) && this.field_70708_bq < 100) {
            this.func_70779_j();
        }
        int i = MathHelper.func_76128_c((double)(this.field_70121_D.field_72338_b + 0.5));
        this.field_70125_A = 0.0f;
        if (this.field_70786_d == null || this.field_70146_Z.nextInt(100) == 0) {
            super.func_70626_be();
            this.field_70786_d = null;
            return;
        }
        Vec3 vector = this.field_70786_d.func_75878_a((Entity)this);
        double d = this.field_70130_N * 2.0f;
        while (vector != null && vector.func_72445_d(this.field_70165_t, vector.field_72448_b, this.field_70161_v) < d * d) {
            this.field_70786_d.func_75875_a();
            if (this.field_70786_d.func_75879_b()) {
                vector = null;
                this.field_70786_d = null;
                continue;
            }
            vector = this.field_70786_d.func_75878_a((Entity)this);
        }
        this.field_70703_bu = false;
        if (vector != null) {
            float f3;
            double d1 = vector.field_72450_a - this.field_70165_t;
            double d2 = vector.field_72449_c - this.field_70161_v;
            double d3 = vector.field_72448_b - (double)i;
            float f2 = (float)(Math.atan2(d2, d1) * 180.0 / Math.PI) - 90.0f;
            for (f3 = f2 - this.field_70177_z; f3 < -180.0f; f3 += 360.0f) {
            }
            while (f3 >= 180.0f) {
                f3 -= 360.0f;
            }
            ChocoboMathHelper.clamp(f3, -30.0f, 30.0f);
            this.field_70177_z += f3;
            if (this.field_70787_b && this.field_70789_a != null) {
                double distToAttackX = this.field_70789_a.field_70165_t - this.field_70165_t;
                double distToAttackZ = this.field_70789_a.field_70161_v - this.field_70161_v;
                float tmpRotYaw = this.field_70177_z;
                this.field_70177_z = (float)(Math.atan2(distToAttackZ, distToAttackX) * 180.0 / Math.PI) - 90.0f;
                float f5 = (tmpRotYaw - this.field_70177_z + 90.0f) * (float)Math.PI / 180.0f;
                this.field_70702_br = -MathHelper.func_76126_a((float)f5) * this.field_70701_bs * 1.0f;
                this.field_70701_bs = MathHelper.func_76134_b((float)f5) * this.field_70701_bs * 1.0f;
            }
            if (d3 > 0.0) {
                this.field_70703_bu = true;
            }
        }
        if (this.field_70789_a != null) {
            this.func_70625_a(this.field_70789_a, 30.0f, 30.0f);
        }
        if (this.field_70123_F && !this.func_70781_l()) {
            this.field_70703_bu = true;
        }
        if (this.field_70146_Z.nextFloat() < 0.8f && (this.func_70090_H() || this.func_70058_J())) {
            this.field_70703_bu = true;
        }
    }

    protected void showAmountHeartsOrSmokeFx(boolean showHeart, int amount) {
        if (this.isClient()) {
            for (int i = 0; i < amount; ++i) {
                ChocoboParticleHelper.showParticleAroundEntityFx(showHeart ? Constants.PARTICLE_HEART : Constants.PARTICLE_SMOKE, (Entity)this);
            }
        }
    }

    protected EntityPlayer getNearestPlayer() {
        EntityPlayer nearestPlayer = null;
        double distance = 9999.0;
        List players = this.field_70170_p.func_72872_a(EntityPlayer.class, this.field_70121_D.func_72314_b(8.0, 8.0, 8.0));
        for (EntityPlayer player : players) {
            double tmpDistance = this.func_70032_d((Entity)player);
            if (!(tmpDistance < distance)) continue;
            distance = tmpDistance;
            nearestPlayer = player;
        }
        return nearestPlayer;
    }

    public boolean canRenderName() {
        return this.isClient() && ModChocoCraft.showChocoboNames && this.func_70909_n() && this.field_70153_n == null && !this.isHidename() && !this.getName().isEmpty();
    }

    protected void sendChangeOwnerUpdate() {
        if (this.isClient()) {
            ChocoboChangeOwner packet = new ChocoboChangeOwner(this);
            PacketRegistry.INSTANCE.sendToServer((IMessage)packet);
        }
    }

    protected void sendTamedUpdate() {
        if (this.isServer()) {
            ChocoboTamed packet = new ChocoboTamed(this);
            int dimension = this.field_70170_p.field_73011_w.field_76574_g;
            NetworkRegistry.TargetPoint targetPoint = new NetworkRegistry.TargetPoint(dimension, this.field_70142_S, this.field_70137_T, this.field_70136_U, 80.0);
            PacketRegistry.INSTANCE.sendToAllAround((IMessage)packet, targetPoint);
        }
    }

    protected void sendAttributeUpdate() {
        if (this.isClient()) {
            ChocoboAttribute packet = new ChocoboAttribute(this);
            PacketRegistry.INSTANCE.sendToServer((IMessage)packet);
        }
    }

    protected void sendHungerUpdate() {
        if (this.isServer()) {
            ChocoboHunger packet = new ChocoboHunger(this);
            int dimension = this.field_70170_p.field_73011_w.field_76574_g;
            NetworkRegistry.TargetPoint targetPoint = new NetworkRegistry.TargetPoint(dimension, this.field_70142_S, this.field_70137_T, this.field_70136_U, 80.0);
            PacketRegistry.INSTANCE.sendToAllAround((IMessage)packet, targetPoint);
        }
    }

    protected void sendHealthUpdate() {
        if (this.isServer()) {
            ChocoboHealth packet = new ChocoboHealth(this);
            int dimension = this.field_70170_p.field_73011_w.field_76574_g;
            NetworkRegistry.TargetPoint targetPoint = new NetworkRegistry.TargetPoint(dimension, this.field_70142_S, this.field_70137_T, this.field_70136_U, 80.0);
            PacketRegistry.INSTANCE.sendToAllAround((IMessage)packet, targetPoint);
        }
    }

    public void sendParticleUpdate(String particleName, EntityAnimalChocobo chocobo, int amount) {
        if (this.isServer()) {
            ChocoboParticles packet = new ChocoboParticles(chocobo, particleName, amount);
            int dimension = chocobo.field_70170_p.field_73011_w.field_76574_g;
            NetworkRegistry.TargetPoint targetPoint = new NetworkRegistry.TargetPoint(dimension, this.field_70142_S, this.field_70137_T, this.field_70136_U, 80.0);
            PacketRegistry.INSTANCE.sendToAllAround((IMessage)packet, targetPoint);
        }
    }

    protected void sendSetInLoveUpdate() {
        if (this.isClient()) {
            ChocoboSetInLove packet = new ChocoboSetInLove(this);
            PacketRegistry.INSTANCE.sendToAll((IMessage)packet);
        }
    }

    public static enum chocoboColor {
        YELLOW,
        GREEN,
        BLUE,
        WHITE,
        BLACK,
        GOLD,
        PINK,
        RED,
        PURPLE;

    }
}

