/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.render;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.core.render.TextureManager;
import forestry.farming.blocks.BlockFarmType;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;

public enum EnumFarmBlockTexture {
    BRICK_STONE(new ItemStack(Blocks.field_150417_aV, 1, 0)),
    BRICK_MOSSY(new ItemStack(Blocks.field_150417_aV, 1, 1)),
    BRICK_CRACKED(new ItemStack(Blocks.field_150417_aV, 1, 2)),
    BRICK(new ItemStack(Blocks.field_150336_V)),
    SANDSTONE_SMOOTH(new ItemStack(Blocks.field_150322_A, 1, 2)),
    SANDSTONE_CHISELED(new ItemStack(Blocks.field_150322_A, 1, 1)),
    BRICK_NETHER(new ItemStack(Blocks.field_150385_bj)),
    BRICK_CHISELED(new ItemStack(Blocks.field_150417_aV, 1, 3)),
    QUARTZ(new ItemStack(Blocks.field_150371_ca, 1, 0)),
    QUARTZ_CHISELED(new ItemStack(Blocks.field_150371_ca, 1, 1)),
    QUARTZ_LINES(new ItemStack(Blocks.field_150371_ca, 1, 2));

    private static final int TYPE_PLAIN = 0;
    private static final int TYPE_REVERSE = 1;
    private static final int TYPE_TOP = 2;
    private static final int TYPE_BAND = 3;
    private static final int TYPE_GEARS = 4;
    private static final int TYPE_HATCH = 5;
    private static final int TYPE_VALVE = 6;
    private static final int TYPE_CONTROL = 7;
    @SideOnly(value=Side.CLIENT)
    private static List<IIcon> icons;
    private final ItemStack base;

    @SideOnly(value=Side.CLIENT)
    public static void registerIcons(IIconRegister register) {
        icons = Arrays.asList(TextureManager.registerTex(register, "farm/plain"), TextureManager.registerTex(register, "farm/reverse"), TextureManager.registerTex(register, "farm/top"), TextureManager.registerTex(register, "farm/band"), TextureManager.registerTex(register, "farm/gears"), TextureManager.registerTex(register, "farm/hatch"), TextureManager.registerTex(register, "farm/valve"), TextureManager.registerTex(register, "farm/control"));
    }

    private EnumFarmBlockTexture(ItemStack base) {
        this.base = base;
    }

    @SideOnly(value=Side.CLIENT)
    public static IIcon getIcon(BlockFarmType type, int side) {
        switch (type) {
            case BASIC: {
                if (side == 2) {
                    return icons.get(1);
                }
                if (side == 0 || side == 1) {
                    return icons.get(2);
                }
                return icons.get(0);
            }
            case BAND: {
                return icons.get(3);
            }
            case GEARBOX: {
                return icons.get(4);
            }
            case HATCH: {
                return icons.get(5);
            }
            case VALVE: {
                return icons.get(6);
            }
            case CONTROL: {
                return icons.get(7);
            }
        }
        return icons.get(0);
    }

    public void saveToCompound(NBTTagCompound compound) {
        compound.func_74768_a("FarmBlock", this.ordinal());
    }

    public String getName() {
        return this.base.func_77973_b().func_77653_i(this.base);
    }

    public ItemStack getBase() {
        return this.base;
    }

    public static EnumFarmBlockTexture getFromCompound(NBTTagCompound compound) {
        int farmBlockOrdinal;
        if (compound != null && (farmBlockOrdinal = compound.func_74762_e("FarmBlock")) < EnumFarmBlockTexture.values().length) {
            return EnumFarmBlockTexture.values()[farmBlockOrdinal];
        }
        return BRICK_STONE;
    }
}

