/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.entities;

import forestry.core.entities.EntityMinecartForestry;
import forestry.core.inventory.IInventoryAdapter;
import forestry.core.tiles.IFilterSlotDelegate;
import forestry.core.utils.InventoryUtil;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public abstract class EntityMinecartContainerForestry
extends EntityMinecartForestry
implements ISidedInventory,
IFilterSlotDelegate {
    private boolean dropContentsWhenDead = true;

    public EntityMinecartContainerForestry(World world) {
        super(world);
    }

    public EntityMinecartContainerForestry(World world, double posX, double posY, double posZ) {
        super(world, posX, posY, posZ);
    }

    @Override
    protected void func_70037_a(NBTTagCompound nbtTagCompound) {
        super.func_70037_a(nbtTagCompound);
        this.getInternalInventory().readFromNBT(nbtTagCompound);
    }

    @Override
    protected void func_70014_b(NBTTagCompound nbtTagCompound) {
        super.func_70014_b(nbtTagCompound);
        this.getInternalInventory().writeToNBT(nbtTagCompound);
    }

    public void func_70106_y() {
        if (this.dropContentsWhenDead && !this.field_70170_p.field_72995_K) {
            InventoryUtil.dropInventory((IInventory)this.getInternalInventory(), this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v);
        }
        super.func_70106_y();
    }

    protected void func_94101_h() {
        int redstoneLevel = 15 - Container.func_94526_b((IInventory)this);
        double drag = 0.98f + (float)redstoneLevel * 0.001f;
        this.field_70159_w *= drag;
        this.field_70181_x *= 0.0;
        this.field_70179_y *= drag;
    }

    public void func_71027_c(int dimensionId) {
        this.dropContentsWhenDead = false;
        super.func_71027_c(dimensionId);
    }

    public boolean func_70300_a(EntityPlayer player) {
        return !this.field_70128_L && player.func_70068_e((Entity)this) <= 64.0;
    }

    public int func_70302_i_() {
        return this.getInternalInventory().func_70302_i_();
    }

    public final ItemStack func_70301_a(int slotIndex) {
        return this.getInternalInventory().func_70301_a(slotIndex);
    }

    public ItemStack func_70298_a(int slotIndex, int amount) {
        return this.getInternalInventory().func_70298_a(slotIndex, amount);
    }

    public final ItemStack func_70304_b(int slotIndex) {
        return this.getInternalInventory().func_70304_b(slotIndex);
    }

    public void func_70299_a(int slotIndex, ItemStack itemstack) {
        this.getInternalInventory().func_70299_a(slotIndex, itemstack);
    }

    public final int func_70297_j_() {
        return this.getInternalInventory().func_70297_j_();
    }

    public final void func_70295_k_() {
        this.getInternalInventory().func_70295_k_();
    }

    public final void func_70305_f() {
        this.getInternalInventory().func_70305_f();
    }

    public final String func_145825_b() {
        return this.getInternalInventory().func_145825_b();
    }

    public final boolean func_145818_k_() {
        return false;
    }

    public final boolean func_94041_b(int slotIndex, ItemStack itemStack) {
        return this.getInternalInventory().func_94041_b(slotIndex, itemStack);
    }

    @Override
    public final boolean canSlotAccept(int slotIndex, ItemStack itemStack) {
        return this.getInternalInventory().canSlotAccept(slotIndex, itemStack);
    }

    @Override
    public boolean isLocked(int slotIndex) {
        return this.getInternalInventory().isLocked(slotIndex);
    }

    public int[] func_94128_d(int side) {
        return this.getInternalInventory().func_94128_d(side);
    }

    public boolean func_102007_a(int slot, ItemStack stack, int side) {
        return this.getInternalInventory().func_102007_a(slot, stack, side);
    }

    public boolean func_102008_b(int slot, ItemStack stack, int side) {
        return this.getInternalInventory().func_102008_b(slot, stack, side);
    }

    public void func_70296_d() {
    }

    protected abstract IInventoryAdapter getInternalInventory();
}

