/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.icbm.mods.oc;

import com.builtbroken.icbm.api.modules.IMissile;
import com.builtbroken.icbm.content.crafting.missile.casing.Missile;
import com.builtbroken.icbm.content.launcher.controller.direct.TileSiloController;
import com.builtbroken.mc.lib.transform.vector.Pos;
import com.builtbroken.mc.prefab.tile.Tile;
import li.cil.oc.api.Network;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.Analyzable;
import li.cil.oc.api.network.Environment;
import li.cil.oc.api.network.Message;
import li.cil.oc.api.network.Node;
import li.cil.oc.api.network.Visibility;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;

public class TileSiloControllerOC
extends TileSiloController
implements Environment,
Analyzable {
    private Node node;

    @Override
    public Tile newTile() {
        return new TileSiloControllerOC();
    }

    public void firstTick() {
        super.firstTick();
        Network.joinOrCreateNetwork((TileEntity)this);
    }

    @Override
    public void update() {
        super.update();
        if (this.ticks % 5L == 0L && this.node() != null && this.node().network() == null) {
            Network.joinOrCreateNetwork((TileEntity)this);
        }
    }

    public Node[] onAnalyze(EntityPlayer entityPlayer, int i, float v, float v1, float v2) {
        return new Node[]{this.node()};
    }

    public Node node() {
        if (this.node == null) {
            this.node = Network.newNode((Environment)this, (Visibility)Visibility.Network).withComponent("icbmSiloConnector", Visibility.Network).withConnector().create();
        }
        return this.node;
    }

    public void onConnect(Node node) {
    }

    public void onDisconnect(Node node) {
    }

    public void onMessage(Message message) {
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        if (nbt.func_74764_b("OCNode") && this.node() != null && this.node().host() == this) {
            this.node().load(nbt.func_74775_l("OCNode"));
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        if (this.node() != null && this.node().host() == this) {
            NBTTagCompound tag = new NBTTagCompound();
            this.node().save(tag);
            nbt.func_74782_a("OCNode", (NBTBase)tag);
        }
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        if (this.node() != null) {
            this.node().remove();
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.node() != null) {
            this.node().remove();
        }
    }

    @Callback
    public Object[] isConnectedToLauncher(Context context, Arguments args) {
        return new Object[]{this.launcher != null};
    }

    @Callback
    public Object[] hasMissile(Context context, Arguments args) {
        if (this.launcher == null) {
            throw new RuntimeException("Not connected to a launcher");
        }
        return new Object[]{this.launcher.getMissile() != null};
    }

    @Callback
    public Object[] doesMissileHaveWarhead(Context context, Arguments args) {
        if (this.launcher == null) {
            throw new RuntimeException("Not connected to a launcher");
        }
        IMissile missile = this.launcher.getMissile();
        if (missile == null) {
            throw new RuntimeException("No missile loaded");
        }
        return new Object[]{((Missile)missile).getWarhead() != null};
    }

    @Callback
    public Object[] doesMissileHaveGuidance(Context context, Arguments args) {
        if (this.launcher == null) {
            throw new RuntimeException("Not connected to a launcher");
        }
        IMissile missile = this.launcher.getMissile();
        if (missile == null) {
            throw new RuntimeException("No missile loaded");
        }
        return new Object[]{((Missile)missile).getGuidance() != null};
    }

    @Callback
    public Object[] doesMissileHaveEngine(Context context, Arguments args) {
        if (this.launcher == null) {
            throw new RuntimeException("Not connected to a launcher");
        }
        IMissile missile = this.launcher.getMissile();
        if (missile == null) {
            throw new RuntimeException("No missile loaded");
        }
        return new Object[]{((Missile)missile).getEngine() != null};
    }

    @Callback
    public Object[] fireMissile(Context context, Arguments args) {
        if (this.launcher == null) {
            throw new RuntimeException("Not connected to a launcher");
        }
        if (this.launcher.target == null) {
            throw new RuntimeException("No target set in the launcher");
        }
        return new Object[]{this.launcher.fireMissile()};
    }

    @Callback
    public Object[] canFireMissile(Context context, Arguments args) {
        if (this.launcher == null) {
            throw new RuntimeException("Not connected to a launcher");
        }
        if (this.launcher.target == null) {
            return new Object[]{false, "No target set"};
        }
        if (!this.launcher.canFireMissile()) {
            IMissile missile = this.launcher.getMissile();
            if (missile == null) {
                if (this.launcher.getMissileItem() != null) {
                    return new Object[]{false, "Invalid item in missile tube"};
                }
                return new Object[]{false, "No missile loaded"};
            }
            if (!((Missile)missile).canLaunch()) {
                if (((Missile)missile).getEngine() != null) {
                    return new Object[]{false, "Engine is invalid or has no fuel"};
                }
                return new Object[]{false, "Missile has no engine"};
            }
            return new Object[]{false, "Unknown reason"};
        }
        return new Object[]{true, "All green"};
    }

    @Callback
    public Object[] setTarget(Context context, Arguments args) {
        if (this.launcher == null) {
            throw new RuntimeException("Not connected to a launcher");
        }
        if (!(args.isDouble(0) && args.isDouble(1) && args.isDouble(2))) {
            throw new RuntimeException("3 doubles are expected");
        }
        this.launcher.setTarget(new Pos(args.checkDouble(0), args.checkDouble(1), args.checkDouble(2)));
        return new Object[]{true};
    }

    @Callback
    public Object[] getTarget(Context context, Arguments args) throws Exception {
        if (this.launcher == null) {
            throw new RuntimeException("Not connected to a launcher");
        }
        if (this.launcher.target == null) {
            throw new RuntimeException("No target set in the launcher");
        }
        return new Object[]{this.launcher.target.x(), this.launcher.target.y(), this.launcher.target.z()};
    }
}

