/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.icbm.content.missile.tracking;

import com.builtbroken.icbm.content.crafting.missile.casing.Missile;
import com.builtbroken.icbm.content.missile.EntityMissile;
import com.builtbroken.jlib.data.vector.IPos2D;
import com.builtbroken.jlib.data.vector.IPos3D;
import com.builtbroken.mc.lib.helper.NBTUtility;
import com.builtbroken.mc.lib.transform.vector.Point;
import com.builtbroken.mc.lib.transform.vector.Pos;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class MissileTrackingData {
    protected NBTTagCompound m_save;
    protected Missile missile;
    protected IPos3D target;
    protected Long ticks = 0L;
    protected Long respawnTicks = -1L;

    public MissileTrackingData(EntityMissile missile) {
        this.m_save = new NBTTagCompound();
        missile.func_70039_c(this.m_save);
        this.target = missile.target_pos;
        this.missile = missile.getMissile();
        this.respawnTicks = MissileTrackingData.getRespawnTicks(new Pos((Entity)missile), new Pos(missile.target_pos), missile.getMissile().getEngine() != null ? missile.getMissile().getEngine().getSpeed(missile.getMissile()) : 1.0f);
    }

    public static long getRespawnTicks(Pos start, Pos end, float speed) {
        long respawnTicks = (long)start.toVector2().distance((IPos2D)end.toVector2());
        respawnTicks = (long)((float)respawnTicks / speed + 1.0f);
        return respawnTicks;
    }

    public MissileTrackingData(World world, NBTTagCompound tag) {
        Entity entity;
        if (tag.func_74764_b("missile") && (entity = EntityList.func_75615_a((NBTTagCompound)tag.func_74775_l("missile"), (World)world)) instanceof EntityMissile && ((EntityMissile)entity).target_pos != null) {
            this.target = ((EntityMissile)entity).target_pos;
            this.respawnTicks = (long)new Point(((EntityMissile)entity).field_70165_t, ((EntityMissile)entity).field_70161_v).distance((IPos2D)new Point(((EntityMissile)entity).target_pos.x(), ((EntityMissile)entity).target_pos.z()));
        }
    }

    public boolean shouldRespawn() {
        return this.ticks >= this.respawnTicks;
    }

    public NBTTagCompound save() {
        NBTTagCompound nbt = new NBTTagCompound();
        if (this.m_save != null) {
            nbt.func_74782_a("missile", (NBTBase)this.m_save);
        }
        return nbt;
    }

    public boolean isValid() {
        return this.m_save != null && this.respawnTicks > 0L;
    }

    public String toString() {
        return "MissileTrackingData[" + this.target + ", " + this.missile + "]";
    }

    public boolean equals(Object object) {
        if (object instanceof MissileTrackingData) {
            if (((MissileTrackingData)object).target == null && this.target != null || ((MissileTrackingData)object).target != null && this.target == null) {
                return false;
            }
            if (!((MissileTrackingData)object).target.equals(this.target)) {
                return false;
            }
            return NBTUtility.doTagsMatch((NBTTagCompound)((MissileTrackingData)object).m_save, (NBTTagCompound)this.m_save);
        }
        return false;
    }
}

