/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.icbm.content.missile;

import com.builtbroken.icbm.api.IWarheadHandler;
import com.builtbroken.icbm.api.crafting.IModularMissileItem;
import com.builtbroken.icbm.api.missile.IMissileItem;
import com.builtbroken.icbm.content.crafting.missile.MissileModuleBuilder;
import com.builtbroken.icbm.content.crafting.missile.casing.Missile;
import com.builtbroken.icbm.content.crafting.missile.casing.MissileCasings;
import com.builtbroken.icbm.content.crafting.missile.engine.RocketEngine;
import com.builtbroken.icbm.content.crafting.missile.guidance.Guidance;
import com.builtbroken.icbm.content.crafting.missile.warhead.Warhead;
import com.builtbroken.icbm.content.crafting.missile.warhead.WarheadCasings;
import com.builtbroken.icbm.content.crafting.parts.MissileCraftingParts;
import com.builtbroken.icbm.content.missile.AmmoTypeMissile;
import com.builtbroken.icbm.content.missile.EntityMissile;
import com.builtbroken.mc.api.explosive.IExplosiveHandler;
import com.builtbroken.mc.api.items.explosives.IExplosiveContainerItem;
import com.builtbroken.mc.api.items.explosives.IExplosiveItem;
import com.builtbroken.mc.api.items.weapons.IAmmo;
import com.builtbroken.mc.api.items.weapons.IAmmoType;
import com.builtbroken.mc.api.items.weapons.IReloadableWeapon;
import com.builtbroken.mc.api.modules.IModule;
import com.builtbroken.mc.api.modules.IModuleItem;
import com.builtbroken.mc.client.ExplosiveRegistryClient;
import com.builtbroken.mc.core.Engine;
import com.builtbroken.mc.core.content.resources.items.ItemSheetMetal;
import com.builtbroken.mc.core.registry.implement.IPostInit;
import com.builtbroken.mc.lib.helper.LanguageUtility;
import com.builtbroken.mc.lib.world.explosive.ExplosiveRegistry;
import com.builtbroken.mc.prefab.items.ItemStackWrapper;
import com.builtbroken.mc.prefab.recipe.item.sheetmetal.RecipeSheetMetal;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public class ItemMissile
extends Item
implements IExplosiveItem,
IAmmo,
IMissileItem,
IPostInit,
IModularMissileItem,
IExplosiveContainerItem {
    @SideOnly(value=Side.CLIENT)
    IIcon microMissile;
    @SideOnly(value=Side.CLIENT)
    IIcon smallMissile;
    @SideOnly(value=Side.CLIENT)
    IIcon standardMissile;

    public ItemMissile() {
        this.func_77655_b("missile");
        this.func_77656_e(0);
        this.func_77627_a(true);
        this.func_77625_d(1);
    }

    public void onPostInit() {
        ItemStack micro_missile_empty = MissileCasings.MICRO.newModuleStack();
        ItemStack small_missile_empty = MissileCasings.SMALL.newModuleStack();
        if (Engine.itemSheetMetal != null && Engine.itemSheetMetalTools != null) {
            GameRegistry.addRecipe((IRecipe)new RecipeSheetMetal(micro_missile_empty, new Object[]{" rf", "rcf", " rf", Character.valueOf('c'), ItemSheetMetal.SheetMetal.SMALL_CYLINDER.stack(), Character.valueOf('f'), ItemSheetMetal.SheetMetal.FIN_MICRO.stack(), Character.valueOf('r'), "rodIron"}));
            GameRegistry.addRecipe((IRecipe)new RecipeSheetMetal(small_missile_empty, new Object[]{"rrf", "rcf", "rrf", Character.valueOf('c'), MissileCraftingParts.SMALL_MISSILE_CASE.stack(), Character.valueOf('f'), ItemSheetMetal.SheetMetal.FIN_SMALL.stack(), Character.valueOf('r'), "rodIron"}));
        } else {
            GameRegistry.addShapedRecipe((ItemStack)MissileModuleBuilder.INSTANCE.buildMissile(MissileCasings.SMALL, new ItemStack(Blocks.field_150335_W)).toStack(), (Object[])new Object[]{"ITI", "IAI", "IFI", Character.valueOf('A'), Items.field_151032_g, Character.valueOf('I'), Items.field_151042_j, Character.valueOf('T'), Blocks.field_150335_W, Character.valueOf('F'), Blocks.field_150460_al});
        }
    }

    public int func_77647_b(int damage) {
        return damage;
    }

    public String func_77658_a() {
        return "item.icbm:missile";
    }

    public String func_77667_c(ItemStack item) {
        if (item.func_77960_j() < MissileCasings.values().length) {
            MissileCasings size = MissileCasings.values()[item.func_77960_j()];
            if (this.getExplosive(item) == null) {
                return this.func_77658_a() + "." + size.toString().toLowerCase() + ".empty";
            }
            return this.func_77658_a() + "." + size.toString().toLowerCase();
        }
        return this.func_77658_a();
    }

    public IExplosiveHandler getExplosive(ItemStack itemStack) {
        Missile missile = MissileModuleBuilder.INSTANCE.buildMissile(itemStack);
        return missile.getWarhead() != null ? missile.getWarhead().getExplosive() : null;
    }

    public NBTTagCompound getAdditionalExplosiveData(ItemStack itemStack) {
        Missile missile = MissileModuleBuilder.INSTANCE.buildMissile(itemStack);
        return missile.getWarhead() != null ? missile.getWarhead().getAdditionalExplosiveData() : null;
    }

    public double getExplosiveSize(ItemStack itemStack) {
        Missile missile = MissileModuleBuilder.INSTANCE.buildMissile(itemStack);
        return missile.getWarhead() != null ? missile.getWarhead().getExplosiveSize() : 0.0;
    }

    public void func_150895_a(Item item, CreativeTabs tab, List list) {
        for (MissileCasings size : MissileCasings.values()) {
            ItemMissile.getSubItems(size, list);
        }
    }

    public static void getSubItems(MissileCasings size, List list) {
        if (size.enabled) {
            list.add(size.newModuleStack());
            for (IExplosiveHandler ex : ExplosiveRegistry.getExplosives()) {
                List items = ExplosiveRegistry.getItems((IExplosiveHandler)ex);
                if (items == null) continue;
                for (ItemStackWrapper wrapper : items) {
                    Warhead warhead = MissileModuleBuilder.INSTANCE.buildWarhead(WarheadCasings.values()[size.ordinal()], wrapper.itemStack);
                    warhead.explosive.field_77994_a = warhead.getMaxExplosives();
                    Missile missile = MissileModuleBuilder.INSTANCE.buildMissile(size, (ItemStack)null);
                    missile.setWarhead(warhead);
                    list.add(missile.toStack());
                }
            }
        }
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean bool) {
        IExplosiveHandler ex;
        super.func_77624_a(stack, player, list, bool);
        Missile missile = MissileModuleBuilder.INSTANCE.buildMissile(stack);
        String guidance_translation = LanguageUtility.getLocal((String)"info.icbm:guidance.name") + ": ";
        guidance_translation = missile.getEngine() != null ? guidance_translation + LanguageUtility.getLocal((String)(missile.getGuidance().getUnlocalizedName() + ".name")) : guidance_translation + "----";
        list.add(guidance_translation);
        String engine_translation = LanguageUtility.getLocal((String)"info.icbm:engine.name") + ": ";
        engine_translation = missile.getEngine() != null ? engine_translation + LanguageUtility.getLocal((String)(missile.getEngine().getUnlocalizedName() + ".name")) : engine_translation + "----";
        list.add(engine_translation);
        IExplosiveHandler iExplosiveHandler = ex = missile.getWarhead() != null ? missile.getWarhead().getExplosive() : null;
        if (ex != null) {
            ArrayList<String> l = new ArrayList<String>();
            if (ex instanceof IWarheadHandler) {
                ((IWarheadHandler)ex).addInfoToItem(player, missile.getWarhead(), l);
            } else {
                ex.addInfoToItem(player, missile.getWarhead().toStack(), l);
            }
            for (String s : l) {
                list.add(s);
            }
        } else {
            String ex_translation = LanguageUtility.getLocal((String)"info.voltzengine:explosive.name") + ": ";
            ex_translation = ex_translation + "----";
            list.add(ex_translation);
        }
    }

    public boolean isAmmo(ItemStack stack) {
        Missile missile = MissileModuleBuilder.INSTANCE.buildMissile(stack);
        return missile != null && missile.canLaunch();
    }

    public boolean isClip(ItemStack stack) {
        return false;
    }

    public IAmmoType getAmmoType(ItemStack stack) {
        switch (stack.func_77960_j()) {
            case 1: {
                return AmmoTypeMissile.SMALL;
            }
            case 2: {
                return AmmoTypeMissile.STANDARD;
            }
            case 3: {
                return AmmoTypeMissile.MEDIUM;
            }
            case 4: {
                return AmmoTypeMissile.LARGE;
            }
        }
        return AmmoTypeMissile.MICRO;
    }

    public int getAmmoCount(ItemStack ammoStack) {
        return ammoStack.field_77994_a;
    }

    public void fireAmmo(IReloadableWeapon weapon, ItemStack weaponStack, ItemStack ammoStack, Entity firingEntity) {
        EntityMissile.fireMissileByEntity(firingEntity, ammoStack);
    }

    public void consumeAmmo(IReloadableWeapon weapon, ItemStack weaponStack, ItemStack ammoStack, int shotsFired) {
        ammoStack.field_77994_a -= shotsFired;
    }

    @Override
    public Entity getMissileEntity(ItemStack stack) {
        EntityMissile missile = new EntityMissile((World)null);
        missile.setMissile(MissileModuleBuilder.INSTANCE.buildMissile(stack));
        return missile;
    }

    @Override
    public Entity getMissileEntity(ItemStack stack, Entity firedBy) {
        if (firedBy instanceof EntityLivingBase) {
            EntityMissile missile = new EntityMissile((EntityLivingBase)firedBy);
            missile.setMissile(MissileModuleBuilder.INSTANCE.buildMissile(stack));
            return missile;
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister reg) {
        this.microMissile = reg.func_94245_a("icbm:micro.missile");
        this.smallMissile = reg.func_94245_a("icbm:small.missile");
        this.standardMissile = reg.func_94245_a("icbm:standard.missile");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77617_a(int meta) {
        if (meta == 0) {
            return this.microMissile;
        }
        if (meta == 1) {
            return this.smallMissile;
        }
        if (meta == 2) {
            return this.standardMissile;
        }
        return this.microMissile;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(ItemStack stack, int pass) {
        if (pass == 1) {
            return ExplosiveRegistryClient.getCornerIconFor((ItemStack)stack);
        }
        return this.func_77617_a(stack.func_77960_j());
    }

    @SideOnly(value=Side.CLIENT)
    public int getRenderPasses(int metadata) {
        return 2;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77623_v() {
        return true;
    }

    @Override
    public ItemStack getEngine(ItemStack stack) {
        Missile missile = MissileModuleBuilder.INSTANCE.buildMissile(stack);
        return missile != null && missile.getEngine() != null ? missile.getEngine().toStack() : null;
    }

    @Override
    public boolean setEngine(ItemStack m_stack, ItemStack stack, boolean simulate) {
        Missile missile = MissileModuleBuilder.INSTANCE.buildMissile(m_stack);
        if (missile != null) {
            if (missile.getEngine() == null) {
                IModule module;
                if (stack != null && stack.func_77973_b() instanceof IModuleItem && (module = ((IModuleItem)stack.func_77973_b()).getModule(stack)) instanceof RocketEngine) {
                    if (!simulate) {
                        missile.setEngine((RocketEngine)module);
                        missile.toStack();
                    }
                    return true;
                }
            } else if (stack == null) {
                if (!simulate) {
                    missile.setEngine(null);
                    missile.toStack();
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public ItemStack getWarhead(ItemStack stack) {
        Missile missile = MissileModuleBuilder.INSTANCE.buildMissile(stack);
        return missile != null && missile.getWarhead() != null ? missile.getWarhead().toStack() : null;
    }

    @Override
    public boolean setWarhead(ItemStack m_stack, ItemStack stack, boolean simulate) {
        Missile missile = MissileModuleBuilder.INSTANCE.buildMissile(m_stack);
        if (missile != null) {
            if (missile.getWarhead() == null && stack != null && stack.func_77973_b() instanceof IModuleItem) {
                IModule module = ((IModuleItem)stack.func_77973_b()).getModule(stack);
                if (module instanceof Warhead) {
                    if (!simulate) {
                        missile.setWarhead((Warhead)module);
                        m_stack = missile.toStack();
                    }
                    return true;
                }
            } else if (stack == null) {
                if (!simulate) {
                    missile.setWarhead(null);
                    m_stack = missile.toStack();
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public ItemStack getGuidance(ItemStack stack) {
        Missile missile = MissileModuleBuilder.INSTANCE.buildMissile(stack);
        return missile != null && missile.getGuidance() != null ? missile.getGuidance().toStack() : null;
    }

    @Override
    public boolean setGuidance(ItemStack m_stack, ItemStack stack, boolean simulate) {
        Missile missile = MissileModuleBuilder.INSTANCE.buildMissile(m_stack);
        if (missile != null) {
            if (missile.getGuidance() == null && stack != null && stack.func_77973_b() instanceof IModuleItem) {
                IModule module = ((IModuleItem)stack.func_77973_b()).getModule(stack);
                if (module instanceof Guidance) {
                    if (!simulate) {
                        missile.setGuidance((Guidance)module);
                        m_stack = missile.toStack();
                    }
                    return true;
                }
            } else if (stack == null) {
                if (!simulate) {
                    missile.setGuidance(null);
                    m_stack = missile.toStack();
                }
                return true;
            }
        }
        return false;
    }

    public ItemStack getExplosiveStack(ItemStack stack) {
        Missile missile = MissileModuleBuilder.INSTANCE.buildMissile(stack);
        if (missile.getWarhead() != null) {
            return missile.getWarhead().getExplosiveStack();
        }
        return null;
    }

    public boolean setExplosiveStack(ItemStack stack, ItemStack explosive) {
        Missile missile = MissileModuleBuilder.INSTANCE.buildMissile(stack);
        if (missile.getWarhead() != null) {
            return missile.getWarhead().setExplosiveStack(explosive);
        }
        return false;
    }
}

