/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.icbm.content.launcher.silo;

import com.builtbroken.icbm.api.missile.ICustomMissileRender;
import com.builtbroken.icbm.client.Assets;
import com.builtbroken.icbm.content.crafting.missile.casing.Missile;
import com.builtbroken.icbm.content.crafting.missile.casing.MissileCasings;
import com.builtbroken.icbm.content.launcher.TileAbstractLauncher;
import com.builtbroken.icbm.content.launcher.silo.ItemBlockStandardSilo;
import com.builtbroken.jlib.data.vector.IPos3D;
import com.builtbroken.mc.api.items.ISimpleItemRenderer;
import com.builtbroken.mc.api.tile.multiblock.IMultiTile;
import com.builtbroken.mc.api.tile.multiblock.IMultiTileHost;
import com.builtbroken.mc.core.registry.implement.IPostInit;
import com.builtbroken.mc.lib.transform.region.Cube;
import com.builtbroken.mc.lib.transform.vector.Location;
import com.builtbroken.mc.lib.transform.vector.Pos;
import com.builtbroken.mc.prefab.inventory.InventoryUtility;
import com.builtbroken.mc.prefab.tile.Tile;
import com.builtbroken.mc.prefab.tile.multiblock.EnumMultiblock;
import com.builtbroken.mc.prefab.tile.multiblock.MultiBlockHelper;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

public class TileStandardSilo
extends TileAbstractLauncher
implements ISimpleItemRenderer,
IMultiTileHost,
IPostInit {
    public static HashMap<IPos3D, String> tileMapCache = new HashMap();
    private boolean _destroyingStructure = false;

    public TileStandardSilo() {
        super("standardsilo", Material.field_151573_f, 1);
        this.itemBlock = ItemBlockStandardSilo.class;
        this.isOpaque = false;
        this.renderNormalBlock = false;
        this.renderTileEntity = true;
    }

    public void onPostInit() {
    }

    @Override
    public boolean canAcceptMissile(Missile missile) {
        return super.canAcceptMissile(missile) && missile.casing == MissileCasings.STANDARD;
    }

    public Tile newTile() {
        return new TileStandardSilo();
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon() {
        return Blocks.field_150339_S.func_149691_a(0, 0);
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister iconRegister) {
    }

    public String func_145825_b() {
        return "tile.icbm:standardSilo.container";
    }

    public void renderInventoryItem(IItemRenderer.ItemRenderType type, ItemStack itemStack, Object ... data) {
        GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
        GL11.glScaled((double)0.8f, (double)0.8f, (double)0.8f);
        FMLClientHandler.instance().getClient().field_71446_o.func_110577_a(Assets.SMALL_SILO_TEXTURE);
        GL11.glColor3f((float)1.0f, (float)0.0f, (float)0.0f);
        Assets.SMALL_SILO_MODEL.renderOnly(new String[]{"Group_001", "Component_1_001"});
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return new Cube(0.0, 0.0, 0.0, 1.0, 7.0, 1.0).add(this.x(), this.y(), this.z()).toAABB();
    }

    @SideOnly(value=Side.CLIENT)
    public void renderDynamic(Pos pos, float frame, int pass) {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)pos.xf(), (float)pos.yf(), (float)(pos.zf() + 1.0f));
        FMLClientHandler.instance().getClient().field_71446_o.func_110577_a(Assets.STANDARD_SILO_TEXTURE);
        Assets.STANDARD_SILO_MODEL.renderAll();
        GL11.glPopMatrix();
        if (this.getMissile() != null) {
            GL11.glPushMatrix();
            GL11.glTranslatef((float)(pos.xf() + 0.5f), (float)(pos.yf() + 2.75f), (float)(pos.zf() + 0.5f));
            if (this.getMissile() instanceof ICustomMissileRender) {
                ((ICustomMissileRender)((Object)this.getMissile())).renderMissileInWorld(0.0f, 0.0f, frame);
            }
            GL11.glPopMatrix();
        }
    }

    @Override
    public void firstTick() {
        super.firstTick();
        MultiBlockHelper.buildMultiBlock((World)this.world(), (IMultiTileHost)this, (boolean)true, (boolean)true);
    }

    public void onMultiTileAdded(IMultiTile tileMulti) {
        if (tileMulti instanceof TileEntity && tileMapCache.containsKey(new Pos((TileEntity)this).sub((IPos3D)new Pos((TileEntity)tileMulti)))) {
            tileMulti.setHost((IMultiTileHost)this);
        }
    }

    public boolean onMultiTileBroken(IMultiTile tileMulti, Object source, boolean harvest) {
        Pos pos;
        if (!this._destroyingStructure && tileMulti instanceof TileEntity && tileMapCache.containsKey(pos = (Pos)new Pos((TileEntity)tileMulti).sub((IPos3D)new Pos((TileEntity)this)))) {
            MultiBlockHelper.destroyMultiBlockStructure((IMultiTileHost)this, (boolean)harvest, (boolean)true, (boolean)true);
            return true;
        }
        return false;
    }

    public boolean canPlaceBlockAt() {
        return super.canPlaceBlockAt() && this.world().func_147439_a(this.xi(), this.yi() + 1, this.zi()).isReplaceable((IBlockAccess)this.world(), this.xi(), this.yi() + 1, this.zi()) && this.world().func_147439_a(this.xi(), this.yi() + 2, this.zi()).isReplaceable((IBlockAccess)this.world(), this.xi(), this.yi() + 2, this.zi());
    }

    public boolean canPlaceBlockOnSide(ForgeDirection side) {
        return side == ForgeDirection.UP && this.canPlaceBlockAt();
    }

    public boolean removeByPlayer(EntityPlayer player, boolean willHarvest) {
        MultiBlockHelper.destroyMultiBlockStructure((IMultiTileHost)this, (boolean)false, (boolean)true, (boolean)false);
        if (willHarvest && this.getMissileItem() != null) {
            InventoryUtility.dropItemStack((Location)this.toLocation(), (ItemStack)this.getMissileItem());
            this.func_70299_a(0, null);
        }
        return super.removeByPlayer(player, willHarvest);
    }

    public void onTileInvalidate(IMultiTile tileMulti) {
    }

    public boolean onMultiTileActivated(IMultiTile tile, EntityPlayer player, int side, IPos3D hit) {
        return this.onPlayerRightClick(player, side, new Pos(hit));
    }

    public void onMultiTileClicked(IMultiTile tile, EntityPlayer player) {
    }

    public HashMap<IPos3D, String> getLayoutOfMultiBlock() {
        return tileMapCache;
    }

    static {
        tileMapCache.put((IPos3D)new Pos(0.0, 1.0, 0.0), EnumMultiblock.TILE.getName());
        tileMapCache.put((IPos3D)new Pos(0.0, 2.0, 0.0), EnumMultiblock.TILE.getName());
        tileMapCache.put((IPos3D)new Pos(0.0, 3.0, 0.0), EnumMultiblock.TILE.getName());
        tileMapCache.put((IPos3D)new Pos(0.0, 4.0, 0.0), EnumMultiblock.TILE.getName());
        tileMapCache.put((IPos3D)new Pos(0.0, 5.0, 0.0), EnumMultiblock.TILE.getName());
        tileMapCache.put((IPos3D)new Pos(0.0, 6.0, 0.0), EnumMultiblock.TILE.getName());
    }
}

