/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.icbm.content.launcher.launcher.standard;

import com.builtbroken.icbm.api.missile.ICustomMissileRender;
import com.builtbroken.icbm.client.Assets;
import com.builtbroken.icbm.content.crafting.missile.MissileModuleBuilder;
import com.builtbroken.icbm.content.crafting.missile.casing.Missile;
import com.builtbroken.icbm.content.launcher.launcher.standard.StandardMissileCrafting;
import com.builtbroken.icbm.content.launcher.launcher.standard.TileStandardLauncher;
import com.builtbroken.mc.lib.transform.region.Cube;
import com.builtbroken.mc.lib.transform.vector.Pos;
import com.builtbroken.mc.prefab.tile.Tile;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.client.model.obj.GroupObject;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

public class TileStandardLauncherClient
extends TileStandardLauncher {
    private Missile missile;
    private AxisAlignedBB renderBounds;
    private static boolean processedModel = false;
    private static GroupObject[] frame = new GroupObject[7];
    private static GroupObject warhead;
    private static List<GroupObject> engine;
    private static GroupObject guidance;
    private static GroupObject[][] skinLayers;

    @Override
    public Tile newTile() {
        return new TileStandardLauncherClient();
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        if (this.renderBounds == null) {
            this.renderBounds = AxisAlignedBB.func_72330_a((double)this.x(), (double)this.y(), (double)this.z(), (double)(this.z() + 1.0), (double)(this.y() + 1.0), (double)(this.z() + 1.0));
        }
        return this.renderBounds;
    }

    @SideOnly(value=Side.CLIENT)
    public void renderDynamic(Pos center, float f, int pass) {
        if (this.missile != null) {
            GL11.glPushMatrix();
            Pos pos = (Pos)((Pos)center.add(this.getDirection())).add(0.5, 1.9, 0.5);
            GL11.glTranslatef((float)pos.xf(), (float)pos.yf(), (float)pos.zf());
            GL11.glRotatef((float)45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            if (this.missile instanceof ICustomMissileRender) {
                ((ICustomMissileRender)((Object)this.missile)).renderMissileInWorld(0.0f, 0.0f, f);
            }
            GL11.glPopMatrix();
        } else if (this.recipe != null) {
            int i;
            if (!processedModel) {
                TileStandardLauncherClient.processModel();
            }
            GL11.glPushMatrix();
            Pos pos = center;
            float yf = 2.2f;
            switch (ForgeDirection.getOrientation((int)this.getMetadata())) {
                case NORTH: {
                    pos = (Pos)pos.add(-0.65, (double)2.2f, 0.95);
                    break;
                }
                case SOUTH: {
                    pos = (Pos)pos.add(-0.65, (double)2.2f, 2.95);
                    break;
                }
                case EAST: {
                    pos = (Pos)pos.add(0.35, (double)2.2f, 1.95);
                    break;
                }
                case WEST: {
                    pos = (Pos)pos.add(-1.65, (double)2.2f, 1.95);
                }
            }
            GL11.glTranslatef((float)pos.xf(), (float)pos.yf(), (float)pos.zf());
            GL11.glRotatef((float)45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glScalef((float)0.85f, (float)0.85f, (float)0.85f);
            FMLClientHandler.instance().getClient().field_71446_o.func_110577_a(Assets.GREY_FAKE_TEXTURE);
            for (i = 0; i < this.recipe.frameLevel && i < frame.length; ++i) {
                frame[i].render();
            }
            if (this.recipe.frameCompleted) {
                if (this.recipe.warhead != null) {
                    warhead.render();
                }
                if (this.recipe.rocketComputer != null) {
                    guidance.render();
                }
                if (this.recipe.rocketEngine != null) {
                    for (GroupObject o : engine) {
                        o.render();
                    }
                }
                if (this.recipe.platesContained > 0) {
                    for (i = 0; i < this.recipe.platesContained; ++i) {
                        int layer = i / 4;
                        int set = i % 4;
                        if (layer >= skinLayers.length) continue;
                        skinLayers[layer][set].render();
                    }
                }
            }
            GL11.glPopMatrix();
        }
    }

    private static void processModel() {
        processedModel = true;
        for (GroupObject object : Assets.STANDARD_MISSILE_MODEL_2.groupObjects) {
            String name;
            if (object.name.contains("frame")) {
                name = object.name.split("_")[0];
                int layer = 0;
                if (name.contains("1")) {
                    layer = 0;
                } else if (name.contains("2")) {
                    layer = 1;
                } else if (name.contains("3")) {
                    layer = 2;
                } else if (name.contains("4")) {
                    layer = 3;
                } else if (name.contains("5")) {
                    layer = 4;
                } else if (name.contains("6")) {
                    layer = 5;
                } else if (name.contains("7")) {
                    layer = 6;
                }
                TileStandardLauncherClient.frame[layer] = object;
                continue;
            }
            if (object.name.contains("CPcore")) {
                guidance = object;
                continue;
            }
            if (object.name.contains("fual") || object.name.contains("fire")) {
                engine.add(object);
                continue;
            }
            if (object.name.contains("boom")) {
                warhead = object;
                continue;
            }
            if (!object.name.contains("skiln")) continue;
            name = object.name.split("_")[0];
            int set = 0;
            int layer = 0;
            if (name.contains("1")) {
                layer = 0;
            } else if (name.contains("2")) {
                layer = 1;
            } else if (name.contains("3")) {
                layer = 2;
            } else if (name.contains("4")) {
                layer = 3;
            } else if (name.contains("5")) {
                layer = 4;
            } else if (name.contains("6")) {
                layer = 5;
            } else if (name.contains("7")) {
                layer = 6;
            } else if (name.contains("8")) {
                layer = 7;
            } else if (name.contains("9")) {
                layer = 8;
            }
            if (name.contains("RT")) {
                set = 0;
            } else if (name.contains("LB")) {
                set = 1;
            } else if (name.contains("RB")) {
                set = 2;
            } else if (name.contains("LT")) {
                set = 3;
            }
            TileStandardLauncherClient.skinLayers[layer][set] = object;
        }
    }

    @Override
    public void readDescPacket(ByteBuf buf) {
        byte type = buf.readByte();
        if (type == 0) {
            ItemStack missileStack = ByteBufUtils.readItemStack((ByteBuf)buf);
            this.missile = MissileModuleBuilder.INSTANCE.buildMissile(missileStack);
        } else if (type == 1) {
            this.missile = null;
            if (this.recipe == null) {
                this.recipe = new StandardMissileCrafting();
            }
            this.recipe.readBytes(buf);
        } else if (type == 2 || type == 3) {
            this.missile = null;
            this.recipe = null;
            this.isCrafting = false;
        }
        if (this.missile != null || this.recipe != null) {
            this.renderBounds = new Cube(-1.0, 0.0, -1.0, 2.0, 10.0, 2.0).add(this.x(), this.y(), this.z()).toAABB();
        }
    }

    static {
        engine = new ArrayList<GroupObject>();
        skinLayers = new GroupObject[9][4];
    }
}

