/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.icbm.content.launcher.launcher.standard;

import com.builtbroken.icbm.ICBM;
import com.builtbroken.icbm.api.crafting.IModularMissileItem;
import com.builtbroken.icbm.content.crafting.missile.MissileModuleBuilder;
import com.builtbroken.icbm.content.crafting.missile.casing.Missile;
import com.builtbroken.icbm.content.crafting.missile.casing.MissileCasings;
import com.builtbroken.icbm.content.launcher.launcher.TileAbstractLauncherPad;
import com.builtbroken.icbm.content.launcher.launcher.standard.StandardMissileCrafting;
import com.builtbroken.icbm.content.missile.EntityMissile;
import com.builtbroken.jlib.data.vector.IPos3D;
import com.builtbroken.mc.api.tile.multiblock.IMultiTile;
import com.builtbroken.mc.api.tile.multiblock.IMultiTileHost;
import com.builtbroken.mc.core.Engine;
import com.builtbroken.mc.core.network.packet.PacketType;
import com.builtbroken.mc.lib.transform.vector.Location;
import com.builtbroken.mc.lib.transform.vector.Pos;
import com.builtbroken.mc.prefab.inventory.InventoryUtility;
import com.builtbroken.mc.prefab.tile.Tile;
import com.builtbroken.mc.prefab.tile.multiblock.EnumMultiblock;
import com.builtbroken.mc.prefab.tile.multiblock.MultiBlockHelper;
import cpw.mods.fml.common.network.ByteBufUtils;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileStandardLauncher
extends TileAbstractLauncherPad
implements IMultiTileHost {
    private static final HashMap[] STR_MAPS = new HashMap[4];
    protected boolean isCrafting = false;
    protected boolean buildMissileBlocks = false;
    protected boolean destroyMissileBlocks = false;
    protected StandardMissileCrafting recipe;
    private ForgeDirection dir_cache;
    private int frameUpdateCheckTick = 1;

    public TileStandardLauncher() {
        super("standardlauncher");
        this.hardness = 10.0f;
        this.resistance = 10.0f;
    }

    @Override
    public void firstTick() {
        super.firstTick();
        this.frameUpdateCheckTick = 10 + (int)(30.0 * Math.random());
        if (this.isCrafting || this.getMissileItem() != null) {
            this.buildMissileBlocks = true;
        }
    }

    @Override
    public void update() {
        super.update();
        if (this.ticks % 20L == 0L) {
            if (this.buildMissileBlocks) {
                this.buildMissileBlocks = false;
                MultiBlockHelper.buildMultiBlock((World)this.world(), (IMultiTileHost)this, (boolean)true, (boolean)true);
            } else if (this.destroyMissileBlocks) {
                this.destroyMissileBlocks = false;
                MultiBlockHelper.destroyMultiBlockStructure((IMultiTileHost)this, (boolean)false, (boolean)true, (boolean)false);
            }
        }
        if (this.ticks % (long)this.frameUpdateCheckTick == 0L) {
            int count = 0;
            Block block = this.world().func_147439_a(this.xi(), this.yi() + 1, this.zi());
            while (count < 6 && block == ICBM.blockLauncherFrame) {
                block = this.world().func_147439_a(this.xi(), this.yi() + ++count, this.zi());
            }
            if (count != 6) {
                this.dropItems();
                this.world().func_147449_b(this.xi(), this.yi(), this.zi(), ICBM.blockLauncherParts);
            } else {
                int dMeta;
                int meta = this.world().func_72805_g(this.xi(), this.yi() + 6, this.zi());
                if (meta != (dMeta = TileStandardLauncher.getMetaForDirection(this.getDirection()))) {
                    this.field_145850_b.func_72921_c(this.xi(), this.yi() + 6, this.zi(), dMeta, 3);
                }
            }
        }
    }

    private static int getMetaForDirection(ForgeDirection dir) {
        switch (dir) {
            case NORTH: {
                return 1;
            }
            case SOUTH: {
                return 2;
            }
            case EAST: {
                return 3;
            }
            case WEST: {
                return 4;
            }
        }
        return 0;
    }

    public ItemStack getPickBlock(MovingObjectPosition target) {
        return new ItemStack(ICBM.blockLauncherParts, 1, 0);
    }

    protected boolean onPlayerRightClickWrench(EntityPlayer player, int side, Pos hit) {
        if (this.recipe != null && this.isServer()) {
            if (this.recipe.isFinished()) {
                ItemStack stack = this.recipe.getMissileAsItem();
                if (stack != null) {
                    this.disableCraftingMode();
                    this.func_70299_a(0, stack);
                } else {
                    player.func_146105_b((IChatComponent)new ChatComponentText("Error missile stack is null"));
                }
            } else {
                player.func_146105_b(this.recipe.getCurrentRecipeChat());
            }
        }
        return true;
    }

    @Override
    public boolean onPlayerRightClick(EntityPlayer player, int side, Pos hit) {
        if (player.func_70694_bm() != null && player.func_70694_bm().func_77973_b() == Items.field_151055_y && Engine.runningAsDev) {
            if (this.isServer()) {
                player.func_146105_b((IChatComponent)new ChatComponentText("Missile: " + this.getMissile()));
            }
            return true;
        }
        if (this.getMissile() == null) {
            if (player.func_70694_bm() != null && player.func_70694_bm().func_77973_b() instanceof IModularMissileItem) {
                if (this.isServer()) {
                    Missile missile = MissileModuleBuilder.INSTANCE.buildMissile(player.func_70694_bm());
                    if (missile != null) {
                        if (this.canAcceptMissile(missile)) {
                            ItemStack copy = player.func_70694_bm().func_77946_l();
                            copy.field_77994_a = 1;
                            this.func_70299_a(0, copy);
                            if (!player.field_71075_bZ.field_75098_d) {
                                if (player.func_70694_bm().field_77994_a <= 0) {
                                    copy = player.func_70694_bm().func_77946_l();
                                    --copy.field_77994_a;
                                    if (copy.field_77994_a <= 0) {
                                        player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, null);
                                    } else {
                                        player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, copy);
                                    }
                                }
                                player.field_71069_bz.func_75142_b();
                            }
                        } else {
                            player.func_146105_b((IChatComponent)new ChatComponentText("Invalid missile size or type"));
                        }
                    } else {
                        player.func_146105_b((IChatComponent)new ChatComponentText("Invalid missile item"));
                    }
                }
                return true;
            }
            if (StandardMissileCrafting.isPartOfRecipe(player.func_70694_bm())) {
                ItemStack heldItem;
                if (this.recipe == null) {
                    this.triggerCraftingMode();
                    this.recipe = new StandardMissileCrafting();
                    player.func_146105_b((IChatComponent)new ChatComponentText("Starting crafting for new missile"));
                }
                if ((heldItem = player.func_70694_bm()) != null) {
                    if (this.isServer()) {
                        if (this.recipe.canAddItem(heldItem = heldItem.func_77946_l())) {
                            if (!this.recipe.addItem(heldItem)) {
                                if (!this.recipe.isFinished()) {
                                    player.func_146105_b((IChatComponent)new ChatComponentText("Odd that should fit..."));
                                } else {
                                    player.func_146105_b((IChatComponent)new ChatComponentText("Recipe finished, click with wrench or screwdriver."));
                                }
                            } else if (!InventoryUtility.stacksMatchExact((ItemStack)player.func_70694_bm(), (ItemStack)heldItem)) {
                                if (heldItem.field_77994_a <= 0) {
                                    heldItem = null;
                                }
                                player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, heldItem);
                                player.field_71069_bz.func_75142_b();
                                this.sendDescPacket();
                            }
                        } else {
                            player.func_146105_b(this.recipe.getCurrentRecipeChat());
                        }
                        return true;
                    }
                    if (Block.func_149634_a((Item)player.func_70694_bm().func_77973_b()) == null) {
                        if (this.isServer()) {
                            player.func_146105_b(this.recipe.getCurrentRecipeChat());
                        }
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public ForgeDirection getDirection() {
        if (this.dir_cache == null) {
            this.dir_cache = ForgeDirection.getOrientation((int)this.toPos().getBlockMetadata((IBlockAccess)this.world()));
        }
        return this.dir_cache;
    }

    @Override
    public Pos getMissileLaunchOffset() {
        return (Pos)new Pos(this.getDirection()).add(0.5, 7.0, 0.5);
    }

    public void func_70299_a(int slot, ItemStack stack) {
        if (slot == 0 && this.isServer()) {
            ItemStack stackPrev = this.func_70301_a(slot);
            super.func_70299_a(slot, stack);
            ItemStack newStack = this.func_70301_a(slot);
            if (this.isCrafting && this.recipe != null) {
                this.recipe.dropItems((Location)this.toLocation().add((IPos3D)this.getMissileLaunchOffset()));
            } else if (!InventoryUtility.stacksMatch((ItemStack)stackPrev, (ItemStack)newStack)) {
                this.sendDescPacket();
            }
            if (this.getMissileItem() != null) {
                this.buildMissileBlocks = true;
                this.destroyMissileBlocks = false;
                this.disableCraftingMode();
            } else {
                this.buildMissileBlocks = false;
                this.destroyMissileBlocks = true;
            }
        } else {
            super.func_70299_a(slot, stack);
        }
    }

    @Override
    public boolean read(ByteBuf buf, int id, EntityPlayer player, PacketType type) {
        return super.read(buf, id, player, type);
    }

    @Override
    public void writeDescPacket(ByteBuf buf) {
        if (this.getMissileItem() != null) {
            buf.writeByte(0);
            ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)this.getMissileItem());
        } else if (this.isCrafting) {
            if (this.recipe != null) {
                buf.writeByte(1);
                this.recipe.writeBytes(buf);
            } else {
                buf.writeByte(2);
            }
        } else {
            buf.writeByte(3);
        }
    }

    @Override
    protected void onPostMissileFired(Pos target, EntityMissile entity) {
        super.onPostMissileFired(target, entity);
        MultiBlockHelper.destroyMultiBlockStructure((IMultiTileHost)this, (boolean)false, (boolean)true, (boolean)false);
        if (entity.getMissile() != null && entity.getMissile().getEngine() != null && entity.getMissile().getEngine().generatesFire(entity, entity.getMissile())) {
            Location center = (Location)this.toLocation().add(this.getDirection());
            for (int x = -1; x < 2; ++x) {
                block1: for (int z = -1; z < 2; ++z) {
                    Location pos;
                    Block block;
                    if (!(this.world().field_73012_v.nextFloat() < 0.3f) || (block = (pos = (Location)center.add((double)x, 0.0, (double)z)).getBlock()) == ICBM.blockStandardLauncher) continue;
                    if (pos.isAirBlock()) {
                        if (((Location)pos.sub(0.0, 1.0, 0.0)).isSideSolid(ForgeDirection.UP)) {
                            pos.setBlock((Block)Blocks.field_150480_ab);
                            continue;
                        }
                        for (int i = 0; i < 3; ++i) {
                            Location posBellow = (Location)pos.add(0.0, (double)(-i), 0.0);
                            if (!posBellow.isAirBlock() || !((Location)posBellow.sub(0.0, 1.0, 0.0)).isSideSolid(ForgeDirection.UP)) continue;
                            posBellow.setBlock((Block)Blocks.field_150480_ab);
                            continue block1;
                        }
                        continue;
                    }
                    Location posBellow = center;
                    for (int i = 0; i < 3; ++i) {
                        Location posUp = (Location)pos.add(0.0, (double)i, 0.0);
                        if (posUp.isAirBlock()) {
                            if (!posBellow.isSideSolid(ForgeDirection.UP)) continue block1;
                            posUp.setBlock((Block)Blocks.field_150480_ab);
                        }
                        posBellow = posUp;
                    }
                }
            }
        }
    }

    @Override
    public boolean canFireMissile() {
        return !this.isCrafting;
    }

    public Tile newTile() {
        return new TileStandardLauncher();
    }

    @Override
    public boolean canAcceptMissile(Missile missile) {
        return super.canAcceptMissile(missile) && missile.casing == MissileCasings.STANDARD;
    }

    public String func_145825_b() {
        return "tile.icbm:standardLauncher.container";
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        if (nbt.func_74764_b("missileRecipe")) {
            this.triggerCraftingMode();
            this.recipe = new StandardMissileCrafting();
            this.recipe.load(nbt.func_74775_l("missileRecipe"));
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        if (this.recipe != null) {
            NBTTagCompound tag = new NBTTagCompound();
            this.recipe.save(nbt);
            nbt.func_74782_a("missileRecipe", (NBTBase)tag);
        }
    }

    protected void triggerCraftingMode() {
        this.isCrafting = true;
        this.buildMissileBlocks = true;
    }

    protected void disableCraftingMode() {
        this.isCrafting = false;
        this.recipe = null;
        if (this.getMissileItem() == null) {
            this.destroyMissileBlocks = true;
            this.buildMissileBlocks = false;
        }
    }

    public void onMultiTileAdded(IMultiTile tileMulti) {
        if (tileMulti instanceof TileEntity && this.getLayoutOfMultiBlock().containsKey(new Pos((TileEntity)this).sub((IPos3D)new Pos((TileEntity)tileMulti)))) {
            tileMulti.setHost((IMultiTileHost)this);
        }
    }

    public boolean onMultiTileBroken(IMultiTile tileMulti, Object source, boolean harvest) {
        if (this.isCrafting || this.getMissileItem() != null) {
            this.buildMissileBlocks = true;
        }
        return false;
    }

    public void onTileInvalidate(IMultiTile tileMulti) {
    }

    public boolean onMultiTileActivated(IMultiTile tile, EntityPlayer player, int side, IPos3D hit) {
        return this.onPlayerActivated(player, side, new Pos(hit));
    }

    public void onMultiTileClicked(IMultiTile tile, EntityPlayer player) {
    }

    public HashMap<IPos3D, String> getLayoutOfMultiBlock() {
        if (this.getDirection().ordinal() > 1 && this.getDirection() != ForgeDirection.UNKNOWN) {
            return STR_MAPS[this.getDirection().ordinal() - 2];
        }
        return new HashMap<IPos3D, String>();
    }

    public void onRemove(Block block, int par6) {
        super.onRemove(block, par6);
        this.dropItems();
        MultiBlockHelper.destroyMultiBlockStructure((IMultiTileHost)this, (boolean)false, (boolean)true, (boolean)false);
    }

    public boolean removeByPlayer(EntityPlayer player, boolean willHarvest) {
        MultiBlockHelper.destroyMultiBlockStructure((IMultiTileHost)this, (boolean)false, (boolean)true, (boolean)false);
        this.dropItems();
        return super.removeByPlayer(player, willHarvest);
    }

    protected final void dropItems() {
        if (this.getMissileItem() != null) {
            InventoryUtility.dropItemStack((Location)this.toLocation(), (ItemStack)this.getMissileItem());
            this.func_70299_a(0, null);
        }
        if (this.recipe != null) {
            this.recipe.dropItems(this.toLocation());
            this.recipe = null;
        }
    }

    static {
        for (ForgeDirection direction : new ForgeDirection[]{ForgeDirection.NORTH, ForgeDirection.SOUTH, ForgeDirection.WEST, ForgeDirection.EAST}) {
            HashMap<Pos, String> map = new HashMap<Pos, String>();
            for (int i = 0; i < 5; ++i) {
                map.put(new Pos((double)direction.offsetX, (double)i, (double)direction.offsetZ), EnumMultiblock.TILE.getName() + "#bounds={0.3,0,0.3,0.7,1,0.7}");
            }
            TileStandardLauncher.STR_MAPS[direction.ordinal() - 2] = map;
        }
    }
}

