/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.icbm.content.launcher.launcher.small;

import com.builtbroken.icbm.ICBM;
import com.builtbroken.icbm.api.missile.ICustomMissileRender;
import com.builtbroken.icbm.api.modules.IMissile;
import com.builtbroken.icbm.client.Assets;
import com.builtbroken.icbm.content.crafting.missile.casing.Missile;
import com.builtbroken.icbm.content.crafting.missile.casing.MissileCasings;
import com.builtbroken.icbm.content.launcher.TileAbstractLauncher;
import com.builtbroken.icbm.content.launcher.launcher.small.ContainerSmallLauncher;
import com.builtbroken.icbm.content.launcher.launcher.small.GuiSmallLauncher;
import com.builtbroken.jlib.data.vector.IPos3D;
import com.builtbroken.mc.api.items.ISimpleItemRenderer;
import com.builtbroken.mc.api.tile.IGuiTile;
import com.builtbroken.mc.core.Engine;
import com.builtbroken.mc.core.registry.implement.IPostInit;
import com.builtbroken.mc.lib.helper.LanguageUtility;
import com.builtbroken.mc.lib.helper.recipe.UniversalRecipe;
import com.builtbroken.mc.lib.transform.region.Cube;
import com.builtbroken.mc.lib.transform.vector.Pos;
import com.builtbroken.mc.prefab.tile.Tile;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.oredict.ShapedOreRecipe;
import org.lwjgl.opengl.GL11;

public class TileSmallLauncher
extends TileAbstractLauncher
implements ISimpleItemRenderer,
IGuiTile,
IPostInit {
    public TileSmallLauncher() {
        super("smallLauncher", Material.field_151574_g, 1);
        this.hardness = 10.0f;
        this.resistance = 10.0f;
        this.bounds = new Cube(0.0, 0.0, 0.0, 1.0, 0.5, 1.0);
        this.isOpaque = false;
        this.renderNormalBlock = false;
        this.renderTileEntity = true;
    }

    public void onPostInit() {
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(ICBM.blockSmallPortableLauncher), new Object[]{"IIB", "IIB", "CBC", Character.valueOf('I'), "ingotIron", Character.valueOf('B'), "blockIron", Character.valueOf('C'), UniversalRecipe.CIRCUIT_T1.get()}));
    }

    @Override
    public boolean onPlayerRightClick(EntityPlayer player, int side, Pos hit) {
        if (!super.onPlayerRightClick(player, side, hit)) {
            if (player.func_70694_bm() != null && player.func_70694_bm().func_77973_b() == Items.field_151033_d) {
                if (this.isServer()) {
                    if (this.target != null && this.target.y() > -1.0) {
                        double distance = this.target.distance((IPos3D)new Pos((TileEntity)this));
                        if (distance <= 200.0 && distance >= 20.0) {
                            if (this.fireMissile((IPos3D)this.target)) {
                                ICBM.INSTANCE.logger().info("TileSiloInterface: " + player + " fired a missile from " + this);
                            } else {
                                ICBM.INSTANCE.logger().info("TileSiloInterface: " + player + " attempted to fire a missile from " + this);
                            }
                        } else {
                            LanguageUtility.addChatToPlayer((EntityPlayer)player, (String)(this.func_145825_b() + ".invaliddistance"));
                        }
                    } else {
                        LanguageUtility.addChatToPlayer((EntityPlayer)player, (String)(this.func_145825_b() + ".invalidtarget"));
                    }
                }
                return true;
            }
            if (this.isServer()) {
                if (player instanceof EntityPlayerMP) {
                    Engine.instance.packetHandler.sendToPlayer(this.getDescPacket(), (EntityPlayerMP)player);
                }
                this.openGui(player, (Object)ICBM.INSTANCE);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean canAcceptMissile(Missile missile) {
        return super.canAcceptMissile(missile) && missile.casing == MissileCasings.SMALL;
    }

    public Tile newTile() {
        return new TileSmallLauncher();
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon() {
        return Blocks.field_150351_n.func_149691_a(0, 0);
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister iconRegister) {
    }

    public String func_145825_b() {
        return "tile.icbm:portableLauncher.container";
    }

    public void renderInventoryItem(IItemRenderer.ItemRenderType type, ItemStack itemStack, Object ... data) {
        GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
        GL11.glScaled((double)0.8f, (double)0.8f, (double)0.8f);
        FMLClientHandler.instance().getClient().field_71446_o.func_110577_a(Assets.GREY_FAKE_TEXTURE);
        Assets.PORTABLE_LAUNCHER_MODEL.renderAllExcept(new String[]{"rail"});
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return new Cube(0.0, 0.0, 0.0, 1.0, 2.0, 1.0).add(this.x(), this.y(), this.z()).toAABB();
    }

    @SideOnly(value=Side.CLIENT)
    public void renderDynamic(Pos pos, float frame, int pass) {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)(pos.xf() + 0.5f), (float)(pos.yf() + 0.5f), (float)(pos.zf() + 0.5f));
        FMLClientHandler.instance().getClient().field_71446_o.func_110577_a(Assets.GREY_FAKE_TEXTURE);
        Assets.PORTABLE_LAUNCHER_MODEL.renderAll();
        GL11.glPopMatrix();
        IMissile missile = this.getMissile();
        if (missile != null) {
            GL11.glPushMatrix();
            GL11.glTranslatef((float)(pos.xf() + 0.5f), (float)(pos.yf() + 0.4f), (float)(pos.zf() + 0.5f));
            if (missile instanceof ICustomMissileRender) {
                GL11.glTranslatef((float)0.0f, (float)((float)(((Missile)missile).getHeight() / 2.0)), (float)0.0f);
                if (!((ICustomMissileRender)((Object)missile)).renderMissileInWorld(0.0f, 0.0f, frame)) {
                    // empty if block
                }
            }
            GL11.glPopMatrix();
        }
    }

    @Override
    public Object getServerGuiElement(int ID, EntityPlayer player) {
        return new ContainerSmallLauncher(player, (IInventory)this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Object getClientGuiElement(int ID, EntityPlayer player) {
        return new GuiSmallLauncher(this, player);
    }

    public void doUpdateGuiUsers() {
        if (this.ticks % 3L == 0L) {
            this.sendPacketToGuiUsers(this.getDescPacket());
        }
    }
}

