/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.icbm.content.launcher.controller.remote.display;

import com.builtbroken.icbm.ICBM;
import com.builtbroken.icbm.api.controller.ISiloConnectionData;
import com.builtbroken.icbm.api.launcher.ILauncher;
import com.builtbroken.icbm.content.launcher.controller.local.TileLocalController;
import com.builtbroken.icbm.content.launcher.controller.remote.central.TileCommandController;
import com.builtbroken.icbm.content.launcher.controller.remote.connector.SiloConnectionData;
import com.builtbroken.icbm.content.launcher.controller.remote.connector.TileCommandSiloConnector;
import com.builtbroken.jlib.data.vector.IPos3D;
import com.builtbroken.mc.api.items.tools.IWorldPosItem;
import com.builtbroken.mc.api.map.radio.wireless.IWirelessNetwork;
import com.builtbroken.mc.api.map.radio.wireless.IWirelessNetworkObject;
import com.builtbroken.mc.api.tile.IGuiTile;
import com.builtbroken.mc.api.tile.ILinkFeedback;
import com.builtbroken.mc.api.tile.ILinkable;
import com.builtbroken.mc.api.tile.IPassCode;
import com.builtbroken.mc.core.Engine;
import com.builtbroken.mc.core.network.IPacketIDReceiver;
import com.builtbroken.mc.core.network.packet.AbstractPacket;
import com.builtbroken.mc.core.network.packet.PacketTile;
import com.builtbroken.mc.core.network.packet.PacketType;
import com.builtbroken.mc.core.registry.implement.IRecipeContainer;
import com.builtbroken.mc.lib.helper.recipe.UniversalRecipe;
import com.builtbroken.mc.lib.transform.vector.Location;
import com.builtbroken.mc.lib.transform.vector.Pos;
import com.builtbroken.mc.prefab.gui.ContainerDummy;
import com.builtbroken.mc.prefab.tile.Tile;
import com.builtbroken.mc.prefab.tile.TileMachine;
import cpw.mods.fml.common.network.ByteBufUtils;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.IBlockAccess;

public class TileSiloInterface
extends TileMachine
implements ILinkable,
IGuiTile,
IPacketIDReceiver,
IRecipeContainer {
    private Pos commandCenterPos;
    private TileCommandController commandCenter;

    public TileSiloInterface() {
        super("commandSiloDisplay", Material.field_151573_f);
        this.renderNormalBlock = false;
        this.renderTileEntity = true;
        this.hardness = 10.0f;
        this.resistance = 10.0f;
    }

    public Tile newTile() {
        return new TileSiloInterface();
    }

    public String link(Location loc, short code) {
        if (loc.world != this.world()) {
            return "link.error.world.match";
        }
        Pos pos = loc.toPos();
        if (!pos.isAboveBedrock()) {
            return "link.error.pos.invalid";
        }
        if (this.distance((IPos3D)pos) > TileLocalController.MAX_LINK_DISTANCE) {
            return "link.error.pos.distance.max";
        }
        TileEntity tile = pos.getTileEntity((IBlockAccess)loc.world());
        if (!(tile instanceof TileCommandController)) {
            return "link.error.tile.invalid";
        }
        if (tile instanceof IPassCode && ((IPassCode)tile).getCode() != code) {
            return "link.error.code.match";
        }
        if (this.commandCenter == null && !pos.equals((Object)this.commandCenterPos) || tile != this.commandCenter) {
            this.commandCenterPos = pos;
            this.commandCenter = (TileCommandController)tile;
            if (tile instanceof ILinkFeedback) {
                ((ILinkFeedback)tile).onLinked(this.toLocation());
            }
            return "";
        }
        return "link.error.tile.already.added";
    }

    public Object getServerGuiElement(int ID, EntityPlayer player) {
        return new ContainerDummy(player, (TileEntity)this);
    }

    public Object getClientGuiElement(int ID, EntityPlayer player) {
        return null;
    }

    protected boolean onPlayerRightClick(EntityPlayer player, int side, Pos hit) {
        if (player.func_70694_bm() != null) {
            if (player.func_70694_bm().func_77973_b() instanceof IWorldPosItem) {
                return false;
            }
            if (player.func_70694_bm().func_77973_b() == Items.field_151055_y && Engine.runningAsDev) {
                if (this.isServer()) {
                    player.func_146105_b((IChatComponent)new ChatComponentText("Command Center -> " + (Object)((Object)this.commandCenter)));
                }
                return true;
            }
        }
        if (this.isServer()) {
            this.openGui(player, (Object)ICBM.INSTANCE);
        }
        return true;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        if (nbt.func_74764_b("commandCenterPos")) {
            this.commandCenterPos = new Pos(nbt.func_74775_l("commandCenterPos"));
        }
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        if (this.commandCenterPos != null) {
            nbt.func_74782_a("commandCenterPos", (NBTBase)this.commandCenterPos.toNBT());
        }
    }

    public TileCommandController getCommandCenter() {
        if (this.commandCenter != null && this.commandCenter.func_145837_r()) {
            this.commandCenter = null;
        }
        if (this.commandCenter == null && this.commandCenterPos != null && this.world().func_72899_e(this.commandCenterPos.xi(), this.commandCenterPos.yi(), this.commandCenterPos.zi())) {
            TileEntity tile = this.commandCenterPos.getTileEntity((IBlockAccess)this.world());
            if (tile instanceof TileCommandController) {
                this.commandCenter = (TileCommandController)tile;
            } else {
                this.commandCenterPos = null;
            }
        }
        return this.commandCenter;
    }

    public boolean read(ByteBuf buf, int id, EntityPlayer player, PacketType type) {
        if (this.isServer()) {
            if (id == 1) {
                this.sendSiloData(player);
                return true;
            }
            if (id == 2) {
                Pos pos = new Pos(buf);
                SiloConnectionData data = new SiloConnectionData(buf);
                this.openSiloGui(pos, data, player);
                return true;
            }
            if (id == 3) {
                Pos pos = new Pos(buf);
                SiloConnectionData data = new SiloConnectionData(buf);
                this.fireSilo(pos, data, player);
                return true;
            }
        }
        return false;
    }

    public void sendSiloData(EntityPlayer player) {
        if (player instanceof EntityPlayerMP) {
            TileCommandController commandCenter = this.getCommandCenter();
            PacketTile packet = new PacketTile((TileEntity)this, new Object[]{2, commandCenter != null});
            if (commandCenter != null) {
                ArrayList<TileCommandController> controllers = new ArrayList<TileCommandController>();
                if (commandCenter != null) {
                    controllers.add(commandCenter);
                }
                for (IWirelessNetwork network : commandCenter.getAttachedNetworks()) {
                    for (IWirelessNetworkObject object : network.getAttachedObjects()) {
                        if (!(object instanceof TileCommandController) || controllers.contains(object) || ((TileCommandController)object).func_145837_r()) continue;
                        controllers.add((TileCommandController)object);
                    }
                }
                packet.data().writeInt(controllers.size());
                for (TileCommandController controller : controllers) {
                    this.writeConnectorSet(controller, packet.data());
                }
            }
            Engine.instance.packetHandler.sendToPlayer((AbstractPacket)packet, (EntityPlayerMP)player);
        }
    }

    protected void writeConnectorSet(TileCommandController controller, ByteBuf data) {
        ByteBufUtils.writeUTF8String((ByteBuf)data, (String)(controller.getControllerDisplayName() == null ? "--" : controller.getControllerDisplayName()));
        data.writeInt(controller.siloConnectors != null ? controller.siloConnectors.entrySet().size() : 0);
        for (Map.Entry<Pos, TileCommandSiloConnector> entry : controller.siloConnectors.entrySet()) {
            this.writeCommandSiloConnector(entry, data);
        }
    }

    protected void writeCommandSiloConnector(Map.Entry<Pos, TileCommandSiloConnector> entry, ByteBuf data) {
        data.writeInt(entry.getKey().xi());
        data.writeInt(entry.getKey().yi());
        data.writeInt(entry.getKey().zi());
        if (entry.getValue() != null) {
            List<ISiloConnectionData> list = entry.getValue().getSiloConnectionData();
            if (list != null && list.size() > 0) {
                data.writeInt(list.size());
                NBTTagCompound save = new NBTTagCompound();
                NBTTagList tagList = new NBTTagList();
                for (ISiloConnectionData siloData : list) {
                    tagList.func_74742_a((NBTBase)siloData.save(new NBTTagCompound()));
                }
                save.func_74782_a("data", (NBTBase)tagList);
                ByteBufUtils.writeTag((ByteBuf)data, (NBTTagCompound)save);
            } else {
                data.writeInt(0);
            }
        } else {
            data.writeInt(-1);
        }
    }

    public void openSiloGui(Pos pos, ISiloConnectionData iSiloConnectionData, EntityPlayer player) {
        TileCommandSiloConnector controller;
        TileCommandController commandCenter = this.getCommandCenter();
        if (commandCenter != null && commandCenter.siloConnectors.containsKey(pos) && (controller = commandCenter.siloConnectors.get(pos)) != null && controller.getSiloConnectionData() != null && controller.getSiloConnectionData().contains(iSiloConnectionData) && iSiloConnectionData.hasSettingsGui()) {
            iSiloConnectionData.openGui(player, (TileEntity)this, controller);
        }
    }

    public void fireSilo(Pos pos, ISiloConnectionData iSiloConnectionData, EntityPlayer player) {
        if (this.isServer()) {
            ILauncher launcher;
            TileCommandSiloConnector controller;
            TileCommandController commandCenter = this.getCommandCenter();
            if (commandCenter != null && commandCenter.siloConnectors.containsKey(pos) && (controller = commandCenter.siloConnectors.get(pos)) != null && controller.getSiloConnectionData() != null && controller.getSiloConnectionData().contains(iSiloConnectionData) && iSiloConnectionData.hasSettingsGui() && (launcher = iSiloConnectionData.getSilo()) != null) {
                if (!launcher.fireMissile()) {
                    ICBM.INSTANCE.logger().info("TileSiloInterface: " + player + " attempted to fire a missile from " + iSiloConnectionData);
                } else {
                    ICBM.INSTANCE.logger().info("TileSiloInterface: " + player + " fired a missile from " + iSiloConnectionData);
                }
            }
        } else {
            this.sendPacketToServer((AbstractPacket)new PacketTile((TileEntity)this, new Object[]{3, pos, iSiloConnectionData}));
        }
    }

    public void genRecipes(List<IRecipe> recipes) {
        recipes.add(this.newShapedRecipe(ICBM.blockCommandSiloDisplay, new Object[]{"GPG", "CNC", "WSW", Character.valueOf('G'), Blocks.field_150410_aZ, Character.valueOf('P'), "plateIron", Character.valueOf('C'), UniversalRecipe.CIRCUIT_T2.get(), Character.valueOf('N'), "nuggetGold", Character.valueOf('S'), "screwIron", Character.valueOf('W'), "wireCopper"}));
    }
}

