/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.icbm.content.launcher.controller.remote.connector;

import com.builtbroken.icbm.ICBM;
import com.builtbroken.icbm.api.controller.ISiloConnectionData;
import com.builtbroken.icbm.api.controller.ISiloConnectionPoint;
import com.builtbroken.icbm.api.launcher.ILauncher;
import com.builtbroken.icbm.content.launcher.controller.remote.connector.GuiCommandSiloConnector;
import com.builtbroken.icbm.content.launcher.controller.remote.connector.SiloConnectionData;
import com.builtbroken.jlib.data.vector.IPos3D;
import com.builtbroken.mc.api.items.tools.IWorldPosItem;
import com.builtbroken.mc.api.tile.IGuiTile;
import com.builtbroken.mc.api.tile.ILinkFeedback;
import com.builtbroken.mc.api.tile.ILinkable;
import com.builtbroken.mc.api.tile.IPassCode;
import com.builtbroken.mc.core.Engine;
import com.builtbroken.mc.core.network.IPacketIDReceiver;
import com.builtbroken.mc.core.network.packet.AbstractPacket;
import com.builtbroken.mc.core.network.packet.PacketTile;
import com.builtbroken.mc.core.network.packet.PacketType;
import com.builtbroken.mc.core.registry.implement.IRecipeContainer;
import com.builtbroken.mc.lib.helper.recipe.UniversalRecipe;
import com.builtbroken.mc.lib.transform.vector.Location;
import com.builtbroken.mc.lib.transform.vector.Pos;
import com.builtbroken.mc.prefab.gui.ContainerDummy;
import com.builtbroken.mc.prefab.tile.Tile;
import com.builtbroken.mc.prefab.tile.TileModuleMachine;
import cpw.mods.fml.common.network.ByteBufUtils;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;

public class TileCommandSiloConnector
extends TileModuleMachine
implements ILinkable,
ISiloConnectionPoint,
IPacketIDReceiver,
IGuiTile,
IRecipeContainer {
    public static final int MAX_CONNECTIONS = 20;
    public static IIcon texture;
    public static IIcon top_texture;
    public static double MAX_LINK_DISTANCE;
    protected List<ISiloConnectionData> siloData = new ArrayList<ISiloConnectionData>();
    protected HashMap<Pos, ISiloConnectionData> posToData = new HashMap();
    protected String connectorDisplayName;
    protected String connectorGroupName;

    public TileCommandSiloConnector() {
        super("siloWirelessDataPoint", Material.field_151573_f);
        this.hardness = 10.0f;
        this.resistance = 10.0f;
        this.addInventoryModule(2);
    }

    public IIcon getIcon(int side) {
        if (side == 1) {
            return top_texture;
        }
        return texture;
    }

    public void registerIcons(IIconRegister iconRegister) {
        texture = iconRegister.func_94245_a("icbm:commandSiloConnector");
        top_texture = iconRegister.func_94245_a("icbm:commandSiloConnector_top");
    }

    public Tile newTile() {
        return new TileCommandSiloConnector();
    }

    public String func_145825_b() {
        return "tile.icbm:smallSiloController.container.name";
    }

    protected void fireLauncher(int index) {
        ISiloConnectionData data;
        ILauncher launcher;
        if (this.isServer() && index >= 0 && index < this.siloData.size() && (launcher = (data = this.siloData.get(index)).getSilo()) != null) {
            launcher.fireMissile();
        }
    }

    public String link(Location loc, short code) {
        if (loc.world != this.world()) {
            return "link.error.world.match";
        }
        Pos pos = loc.toPos();
        if (!pos.isAboveBedrock()) {
            return "link.error.pos.invalid";
        }
        if (this.distance((IPos3D)pos) > MAX_LINK_DISTANCE) {
            return "link.error.pos.distance.max";
        }
        TileEntity tile = pos.getTileEntity((IBlockAccess)loc.world());
        if (!(tile instanceof ILauncher)) {
            return "link.error.tile.invalid";
        }
        if (tile instanceof IPassCode && ((IPassCode)tile).getCode() != code) {
            return "link.error.code.match";
        }
        if (!this.posToData.containsKey(pos)) {
            ISiloConnectionData data = new SiloConnectionData((ILauncher)tile);
            if (!this.siloData.contains(data)) {
                if (this.siloData.size() < 20) {
                    this.siloData.add(data);
                    this.posToData.put(pos, data);
                    ((ILinkFeedback)tile).onLinked(this.toLocation());
                    return "";
                }
                return "link.error.tile.limit.max";
            }
            data = this.posToData.get(pos);
            this.siloData.add(data);
            this.posToData.put(pos, data);
            ((ILinkFeedback)tile).onLinked(this.toLocation());
            return "link.updated";
        }
        ISiloConnectionData data = this.posToData.get(pos);
        this.siloData.remove(data);
        this.posToData.remove(pos);
        return "link.removed";
    }

    @Override
    public List<ISiloConnectionData> getSiloConnectionData() {
        return this.siloData;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        if (nbt.func_74764_b("siloData")) {
            this.siloData.clear();
            this.posToData.clear();
            NBTTagList list = nbt.func_150295_c("siloData", 10);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                SiloConnectionData data = new SiloConnectionData(list.func_150305_b(i));
                this.siloData.add(data);
                this.posToData.put(new Pos(data.x(), data.y(), data.z()), data);
            }
        }
        if (nbt.func_74764_b("displayName")) {
            this.connectorDisplayName = nbt.func_74779_i("displayName");
        }
        if (nbt.func_74764_b("groupName")) {
            this.connectorGroupName = nbt.func_74779_i("groupName");
        }
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        if (this.siloData.size() > 0) {
            NBTTagList list = new NBTTagList();
            for (ISiloConnectionData data : this.siloData) {
                list.func_74742_a((NBTBase)data.save(new NBTTagCompound()));
            }
            nbt.func_74782_a("siloData", (NBTBase)list);
        }
        if (this.getConnectorDisplayName() != null && !this.getConnectorDisplayName().isEmpty()) {
            nbt.func_74778_a("displayName", this.getConnectorDisplayName());
        }
        if (this.getConnectorGroupName() != null && !this.getConnectorGroupName().isEmpty()) {
            nbt.func_74778_a("groupName", this.getConnectorGroupName());
        }
    }

    protected boolean onPlayerRightClick(EntityPlayer player, int side, Pos hit) {
        if (player.func_70694_bm() != null) {
            if (player.func_70694_bm().func_77973_b() instanceof IWorldPosItem) {
                return false;
            }
            if (player.func_70694_bm().func_77973_b() == Items.field_151055_y && Engine.runningAsDev) {
                if (this.isServer()) {
                    player.func_146105_b((IChatComponent)new ChatComponentText("Silos -> " + this.siloData.size()));
                }
                return true;
            }
        }
        if (this.isServer()) {
            this.openGui(player, (Object)ICBM.INSTANCE);
        }
        return true;
    }

    public String getConnectorDisplayName() {
        return this.connectorDisplayName;
    }

    public void setConnectorDisplayName(String connectorDisplayName) {
        this.connectorDisplayName = connectorDisplayName;
        if (this.isClient()) {
            this.sendPacketToServer((AbstractPacket)new PacketTile((TileEntity)this, new Object[]{2, connectorDisplayName != null ? connectorDisplayName : ""}));
        }
    }

    @Override
    public String getConnectorGroupName() {
        return this.connectorGroupName;
    }

    public void setConnectorGroupName(String connectorGroupName) {
        this.connectorGroupName = connectorGroupName;
        if (this.isClient()) {
            this.sendPacketToServer((AbstractPacket)new PacketTile((TileEntity)this, new Object[]{3, connectorGroupName != null ? connectorGroupName : ""}));
        }
    }

    public boolean read(ByteBuf buf, int id, EntityPlayer player, PacketType type) {
        if (!super.read(buf, id, player, type)) {
            if (this.isServer()) {
                if (id == 2) {
                    this.setConnectorDisplayName(ByteBufUtils.readUTF8String((ByteBuf)buf));
                    return true;
                }
                if (id == 3) {
                    this.setConnectorGroupName(ByteBufUtils.readUTF8String((ByteBuf)buf));
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    public Object getServerGuiElement(int ID, EntityPlayer player) {
        return new ContainerDummy(player, (TileEntity)this);
    }

    public Object getClientGuiElement(int ID, EntityPlayer player) {
        return new GuiCommandSiloConnector(player, this);
    }

    public void readDescPacket(ByteBuf buf) {
        super.readDescPacket(buf);
        this.connectorDisplayName = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.connectorGroupName = ByteBufUtils.readUTF8String((ByteBuf)buf);
    }

    public void writeDescPacket(ByteBuf buf) {
        super.writeDescPacket(buf);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)(this.getConnectorDisplayName() == null ? "" : this.getConnectorDisplayName()));
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)(this.getConnectorGroupName() == null ? "" : this.getConnectorGroupName()));
    }

    public void genRecipes(List<IRecipe> recipes) {
        recipes.add(this.newShapedRecipe(ICBM.blockCommandSiloConnector, new Object[]{"WCW", "RCR", "PCP", Character.valueOf('C'), UniversalRecipe.CIRCUIT_T2.get(), Character.valueOf('W'), "wireIron", Character.valueOf('P'), "plateIron", Character.valueOf('R'), Items.field_151107_aW}));
    }

    static {
        MAX_LINK_DISTANCE = 20.0;
    }
}

