/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.icbm.content.launcher.controller.remote.antenna;

import com.builtbroken.icbm.content.launcher.controller.remote.antenna.TileAntenna;
import com.builtbroken.icbm.content.launcher.controller.remote.antenna.TileAntennaPart;
import com.builtbroken.jlib.data.vector.IPos3D;
import com.builtbroken.mc.lib.transform.region.Cube;
import com.builtbroken.mc.lib.transform.vector.Pos;
import java.util.ArrayList;
import net.minecraft.tileentity.TileEntity;

public class AntennaNetwork
extends ArrayList<TileAntennaPart> {
    public static int MAX_HEIGH_GAIN = 1000;
    public static int RANGE_PER_PEICE = 100;
    TileAntenna base;
    Cube size = new Cube();
    Cube senderRange = new Cube();
    Cube receiveRange = new Cube();
    boolean massAdd = false;

    public AntennaNetwork(TileAntenna base) {
        this.base = base;
        this.size = new Cube(0.0, 0.0, 0.0, 0.0, 1.0, 0.0);
        this.onBoundsChange();
    }

    @Override
    public boolean add(TileAntennaPart e) {
        if (this.base != null && !this.contains((Object)e) && super.add(e)) {
            e.antennaNetwork = this;
            if (!this.massAdd) {
                int ux = this.size.max().xi();
                int uy = this.size.max().yi();
                int uz = this.size.max().zi();
                int lx = this.size.min().xi();
                int ly = this.size.min().yi();
                int lz = this.size.min().zi();
                int x = e.field_145851_c - this.base.field_145851_c;
                int y = e.field_145848_d - this.base.field_145848_d;
                int z = e.field_145849_e - this.base.field_145849_e;
                if (x > ux) {
                    ux = x;
                } else if (x < lx) {
                    lx = x;
                }
                if (y > uy) {
                    uy = y;
                } else if (y < ly) {
                    ly = y;
                }
                if (z > uz) {
                    uz = z;
                } else if (z < lz) {
                    lz = z;
                }
                Cube cube = new Cube((IPos3D)new Pos((double)lx, (double)ly, (double)lz), (IPos3D)new Pos((double)ux, (double)uy, (double)uz));
                if (!this.size.equals((Object)cube)) {
                    this.size = cube;
                    this.onBoundsChange();
                }
            }
            return true;
        }
        return false;
    }

    public void updateBounds() {
        int ux = this.size.max().xi();
        int uy = this.size.max().yi();
        int uz = this.size.max().zi();
        int lx = this.size.min().xi();
        int ly = this.size.min().yi();
        int lz = this.size.min().zi();
        for (TileAntennaPart part : this) {
            int x = part.field_145851_c - this.base.field_145851_c;
            int y = part.field_145848_d - this.base.field_145848_d;
            int z = part.field_145849_e - this.base.field_145849_e;
            if (x > ux) {
                ux = x;
            } else if (x < lx) {
                lx = x;
            }
            if (y > uy) {
                uy = y;
            } else if (y < ly) {
                ly = y;
            }
            if (z > uz) {
                uz = z;
                continue;
            }
            if (z >= lz) continue;
            lz = z;
        }
        Cube cube = new Cube((IPos3D)new Pos((double)lx, (double)ly, (double)lz), (IPos3D)new Pos((double)ux, (double)uy, (double)uz));
        if (!this.size.equals((Object)cube)) {
            this.size = cube;
            this.onBoundsChange();
        }
    }

    protected void onBoundsChange() {
        if (this.base != null) {
            int heighRangeBonus = MAX_HEIGH_GAIN / Math.max(50 - (int)this.size.getSizeY(), 1);
            int yLevelRangeBonus = this.size.max().yi() + this.base.field_145848_d < 64 ? -2000 : MAX_HEIGH_GAIN / Math.max(192 - this.size.max().yi() + this.base.field_145848_d, 1);
            int r = Math.max(heighRangeBonus + yLevelRangeBonus, 0);
            int westRange = Math.max(this.size.min().xi() * RANGE_PER_PEICE + r, 0);
            int northRange = Math.max(this.size.min().zi() * RANGE_PER_PEICE + r, 0);
            int eastRange = Math.max(this.size.max().xi() * RANGE_PER_PEICE + r, 0);
            int southRange = Math.max(this.size.max().zi() * RANGE_PER_PEICE + r, 0);
            this.senderRange = new Cube((double)(-westRange), 0.0, (double)(-northRange), (double)eastRange, 256.0, (double)southRange);
            this.senderRange.add((IPos3D)new Pos((TileEntity)this.base).add(0.5));
            this.receiveRange = this.size.clone().add((IPos3D)new Pos((TileEntity)this.base).add(0.5));
        } else {
            this.senderRange = new Cube();
            this.receiveRange = new Cube();
        }
    }

    public void merge(TileAntennaPart mergePoint) {
        this.massAdd = true;
        if (mergePoint.antennaNetwork != null && mergePoint.antennaNetwork != this) {
            for (TileEntity tile : mergePoint.connections.values()) {
                if (!(tile instanceof TileAntennaPart) || !this.contains(tile)) continue;
                for (TileAntennaPart part : ((TileAntennaPart)tile).antennaNetwork) {
                    if (this.contains((Object)part)) continue;
                    this.add(part);
                }
                this.updateBounds();
                break;
            }
        }
        this.massAdd = false;
    }

    public void split(TileAntennaPart splitPoint) {
        if (this.contains((Object)splitPoint)) {
            TileAntenna base = this.base;
            this.kill();
            if (splitPoint != base) {
                base.doInitScan();
            }
        }
    }

    public void kill() {
        for (TileAntennaPart tile : this) {
            tile.antennaNetwork = null;
        }
        this.clear();
        this.base = null;
    }
}

