/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.icbm.content.launcher.controller.local;

import com.builtbroken.icbm.ICBM;
import com.builtbroken.icbm.client.Assets;
import com.builtbroken.icbm.content.launcher.TileAbstractLauncher;
import com.builtbroken.icbm.content.launcher.controller.LauncherData;
import com.builtbroken.icbm.content.launcher.controller.local.GuiLocalController;
import com.builtbroken.jlib.data.vector.IPos3D;
import com.builtbroken.mc.api.items.ISimpleItemRenderer;
import com.builtbroken.mc.api.items.tools.IWorldPosItem;
import com.builtbroken.mc.api.tile.IGuiTile;
import com.builtbroken.mc.api.tile.ILinkFeedback;
import com.builtbroken.mc.api.tile.ILinkable;
import com.builtbroken.mc.api.tile.IPassCode;
import com.builtbroken.mc.core.network.IPacketIDReceiver;
import com.builtbroken.mc.core.network.packet.AbstractPacket;
import com.builtbroken.mc.core.network.packet.PacketTile;
import com.builtbroken.mc.core.network.packet.PacketType;
import com.builtbroken.mc.core.registry.implement.IPostInit;
import com.builtbroken.mc.lib.helper.recipe.UniversalRecipe;
import com.builtbroken.mc.lib.transform.region.Cube;
import com.builtbroken.mc.lib.transform.vector.Location;
import com.builtbroken.mc.lib.transform.vector.Pos;
import com.builtbroken.mc.prefab.gui.ContainerDummy;
import com.builtbroken.mc.prefab.tile.Tile;
import com.builtbroken.mc.prefab.tile.TileModuleMachine;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.oredict.ShapedOreRecipe;
import org.lwjgl.opengl.GL11;

public class TileLocalController
extends TileModuleMachine
implements ILinkable,
IPacketIDReceiver,
IGuiTile,
ISimpleItemRenderer,
IPostInit {
    public static double MAX_LINK_DISTANCE = 100.0;
    public static int MAX_LAUNCHER_LINK = 6;
    protected List<Pos> launcherLocations = new ArrayList<Pos>();
    protected List<LauncherData> launcherData;

    public TileLocalController() {
        super("missileController", Material.field_151573_f);
        this.hardness = 10.0f;
        this.resistance = 10.0f;
        this.addInventoryModule(2);
        this.renderNormalBlock = false;
        this.renderTileEntity = true;
        this.isOpaque = false;
    }

    public Tile newTile() {
        return new TileLocalController();
    }

    public void onPostInit() {
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(ICBM.blockSiloController), new Object[]{"IGI", "CGC", "ICI", Character.valueOf('I'), "ingotIron", Character.valueOf('G'), Blocks.field_150486_ae, Character.valueOf('C'), UniversalRecipe.CIRCUIT_T1.get()}));
    }

    public String func_145825_b() {
        return "tile.icbm:smallSiloController.container.name";
    }

    protected void fireLauncher(int index, EntityPlayer player) {
        if (this.isServer()) {
            Pos pos;
            TileEntity tile;
            if (index >= 0 && index < this.launcherLocations.size() && (tile = (pos = this.launcherLocations.get(index)).getTileEntity((IBlockAccess)this.world())) instanceof TileAbstractLauncher) {
                if (((TileAbstractLauncher)tile).fireMissile()) {
                    ICBM.INSTANCE.logger().info("TileSiloInterface: " + player + " fired a missile from " + tile);
                } else {
                    ICBM.INSTANCE.logger().info("TileSiloInterface: " + player + " attempted to fire a missile from " + tile);
                }
            }
        } else {
            this.sendPacketToServer((AbstractPacket)new PacketTile((TileEntity)this, new Object[]{2, index}));
        }
    }

    protected void fireAllLaunchers(EntityPlayer player) {
        if (this.isServer()) {
            for (int i = 0; i < this.launcherLocations.size(); ++i) {
                this.fireLauncher(i, player);
            }
        } else {
            this.sendPacketToServer((AbstractPacket)new PacketTile((TileEntity)this, new Object[]{2, -1}));
        }
    }

    public String link(Location loc, short code) {
        if (loc.world != this.world()) {
            return "link.error.world.match";
        }
        Pos pos = loc.toPos();
        if (!pos.isAboveBedrock()) {
            return "link.error.pos.invalid";
        }
        if (this.distance((IPos3D)pos) > MAX_LINK_DISTANCE) {
            return "link.error.pos.distance.max";
        }
        TileEntity tile = pos.getTileEntity((IBlockAccess)loc.world());
        if (!(tile instanceof TileAbstractLauncher)) {
            return "link.error.tile.invalid";
        }
        if (((IPassCode)tile).getCode() != code) {
            return "link.error.code.match";
        }
        if (!this.launcherLocations.contains(pos)) {
            if (this.launcherLocations.size() < MAX_LAUNCHER_LINK) {
                this.launcherLocations.add(pos);
                ((ILinkFeedback)tile).onLinked(this.toLocation());
                return "";
            }
            return "link.error.tile.limit.max";
        }
        return "link.error.tile.already.added";
    }

    public void onNeighborChanged(Pos pos) {
        TileEntity tile;
        super.onNeighborChanged(pos);
        if (!this.launcherLocations.contains(pos) && (tile = pos.getTileEntity((IBlockAccess)this.world())) instanceof TileAbstractLauncher) {
            this.launcherLocations.add(pos);
            ((ILinkFeedback)tile).onLinked(this.toLocation());
        }
    }

    protected void removeLauncher(Pos pos) {
        if (this.isServer()) {
            this.launcherLocations.remove(pos);
        } else {
            this.sendPacketToServer((AbstractPacket)new PacketTile((TileEntity)this, new Object[]{1, pos}));
        }
    }

    protected List<TileAbstractLauncher> getLaunchers() {
        ArrayList<TileAbstractLauncher> list = new ArrayList<TileAbstractLauncher>();
        for (Pos pos : this.launcherLocations) {
            TileEntity tile = pos.getTileEntity((IBlockAccess)this.world());
            if (!(tile instanceof TileAbstractLauncher)) continue;
            list.add((TileAbstractLauncher)tile);
        }
        return list;
    }

    public boolean read(ByteBuf buf, int id, EntityPlayer player, PacketType type) {
        if (!super.read(buf, id, player, type)) {
            if (this.isClient()) {
                if (id == 0) {
                    NBTTagCompound tag = ByteBufUtils.readTag((ByteBuf)buf);
                    this.launcherData = new ArrayList<LauncherData>();
                    if (tag.func_74764_b("launcherData")) {
                        NBTTagList list = tag.func_150295_c("launcherData", 10);
                        for (int i = 0; i < list.func_74745_c(); ++i) {
                            this.launcherData.add(new LauncherData(list.func_150305_b(i)));
                        }
                    }
                    if (Minecraft.func_71410_x().field_71462_r instanceof GuiLocalController) {
                        ((GuiLocalController)Minecraft.func_71410_x().field_71462_r).reloadData();
                    }
                    return true;
                }
            } else {
                if (id == 1) {
                    this.removeLauncher(new Pos(buf));
                    return true;
                }
                if (id == 2) {
                    int index = buf.readInt();
                    if (index == -1) {
                        this.fireAllLaunchers(player);
                    } else {
                        this.fireLauncher(index, player);
                    }
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    public void doUpdateGuiUsers() {
        if (this.launcherLocations.size() > 0) {
            NBTTagCompound nbt = new NBTTagCompound();
            NBTTagList list = new NBTTagList();
            for (TileAbstractLauncher launcher : this.getLaunchers()) {
                if (launcher.world() != this.world()) continue;
                list.func_74742_a((NBTBase)new LauncherData(launcher).toNBT());
            }
            nbt.func_74782_a("launcherData", (NBTBase)list);
            PacketTile packet = new PacketTile((TileEntity)this, new Object[]{0, nbt});
            this.sendPacketToGuiUsers((AbstractPacket)packet);
        }
    }

    public Object getServerGuiElement(int ID, EntityPlayer player) {
        return new ContainerDummy(player, (TileEntity)this);
    }

    public Object getClientGuiElement(int ID, EntityPlayer player) {
        return new GuiLocalController(this, player);
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        if (nbt.func_74764_b("locations")) {
            this.launcherLocations.clear();
            NBTTagList list = nbt.func_150295_c("locations", 10);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                NBTTagCompound tag = list.func_150305_b(i);
                this.launcherLocations.add(new Pos((double)tag.func_74762_e("x"), (double)tag.func_74762_e("y"), (double)tag.func_74762_e("z")));
            }
        }
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        if (this.launcherLocations != null && this.launcherLocations.size() > 0) {
            NBTTagList list = new NBTTagList();
            for (Pos pos : this.launcherLocations) {
                list.func_74742_a((NBTBase)pos.toIntNBT());
            }
            nbt.func_74782_a("locations", (NBTBase)list);
        }
    }

    protected boolean onPlayerRightClick(EntityPlayer player, int side, Pos hit) {
        if (player.func_70694_bm() != null && player.func_70694_bm().func_77973_b() instanceof IWorldPosItem) {
            return false;
        }
        if (this.isServer()) {
            this.openGui(player, (Object)ICBM.INSTANCE);
        }
        return true;
    }

    public void renderInventoryItem(IItemRenderer.ItemRenderType type, ItemStack itemStack, Object ... data) {
        GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
        GL11.glScaled((double)0.8f, (double)0.8f, (double)0.8f);
        FMLClientHandler.instance().getClient().field_71446_o.func_110577_a(Assets.WEAPON_CASE_TEXTURE);
        Assets.WEAPON_CASE_MODEL.renderAll();
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return new Cube(0.0, 0.0, 0.0, 1.0, 2.0, 1.0).add(this.x(), this.y(), this.z()).toAABB();
    }

    @SideOnly(value=Side.CLIENT)
    public void renderDynamic(Pos pos, float frame, int pass) {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)(pos.xf() + 0.5f), (float)(pos.yf() + 0.5f), (float)(pos.zf() + 0.5f));
        switch (this.facing) {
            case EAST: {
                break;
            }
            case WEST: {
                GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case SOUTH: {
                GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            default: {
                GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            }
        }
        FMLClientHandler.instance().getClient().field_71446_o.func_110577_a(Assets.LAUNCHER_CONTROLLER_TEXTURE);
        Assets.LAUNCHER_CONTROLLER_MODEL.renderOnly(new String[]{"screen"});
        FMLClientHandler.instance().getClient().field_71446_o.func_110577_a(Assets.WEAPON_CASE_TEXTURE);
        Assets.LAUNCHER_CONTROLLER_MODEL.renderAllExcept(new String[]{"screen"});
        GL11.glPopMatrix();
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister iconRegister) {
    }

    public IIcon getIcon() {
        return Blocks.field_150351_n.func_149691_a(0, 0);
    }
}

