/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.icbm.content.launcher.controller.local;

import com.builtbroken.icbm.content.launcher.TileAbstractLauncher;
import com.builtbroken.icbm.content.launcher.controller.LauncherData;
import com.builtbroken.icbm.content.launcher.controller.local.TileLocalController;
import com.builtbroken.icbm.content.launcher.silo.TileSmallSilo;
import com.builtbroken.icbm.content.launcher.silo.TileStandardSilo;
import com.builtbroken.mc.core.References;
import com.builtbroken.mc.lib.helper.LanguageUtility;
import com.builtbroken.mc.lib.transform.vector.Pos;
import com.builtbroken.mc.prefab.gui.ContainerDummy;
import com.builtbroken.mc.prefab.gui.GuiContainerBase;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;

public class GuiLocalController
extends GuiContainerBase {
    protected TileLocalController controller;
    GuiButton[] buttons;
    protected GuiTextField x_field;
    protected GuiTextField y_field;
    protected GuiTextField z_field;
    protected GuiTextField name_field;
    protected String errorString = "";
    boolean editMode = false;
    int editMissile = 0;
    long lastClickTime = 0L;
    private int ticks = 0;
    private static int updateGuiTicks = 100;

    public GuiLocalController(TileLocalController launcher, EntityPlayer player) {
        super((Container)new ContainerDummy(player, (TileEntity)launcher));
        this.controller = launcher;
        this.baseTexture = References.GUI__MC_EMPTY_FILE;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        int x = this.field_147003_i + 10;
        int y = this.field_147009_r + 20;
        if (!this.editMode) {
            if (this.controller.launcherData != null) {
                String launcherName = LanguageUtility.getLocalName((String)"gui.icbm:controller.launcher");
                String siloName = LanguageUtility.getLocalName((String)"gui.icbm:controller.silo");
                for (int i = 0; i < this.controller.launcherData.size(); ++i) {
                    this.buttons = new GuiButton[this.controller.launcherData.size() * 2];
                    String buttonName = launcherName;
                    String name = "" + i;
                    TileEntity tile = this.controller.launcherData.get((int)i).location.getTileEntity((IBlockAccess)this.controller.world());
                    if (tile instanceof TileAbstractLauncher) {
                        String n;
                        if (tile instanceof TileSmallSilo || tile instanceof TileStandardSilo) {
                            buttonName = siloName;
                        }
                        if ((n = ((TileAbstractLauncher)tile).getCustomName()) != null && !n.isEmpty() && !n.equals("null")) {
                            if (n.length() > 12) {
                                n = n.substring(0, 11) + "..";
                            }
                            name = n;
                        }
                    }
                    buttonName = buttonName + "[" + name + "]";
                    this.buttons[i] = new GuiButton(i, x, y, 120, 20, buttonName);
                    this.field_146292_n.add(this.buttons[i]);
                    this.buttons[i + this.controller.launcherData.size()] = new GuiButton(i + this.controller.launcherData.size(), x + 125, y, 30, 20, LanguageUtility.getLocalName((String)"gui.icbm:controller.fire"));
                    if (this.controller.launcherData.get((int)i).missile == null) {
                        this.buttons[i + this.controller.launcherData.size()].field_146124_l = false;
                    }
                    this.field_146292_n.add(this.buttons[i + this.controller.launcherData.size()]);
                    y += 22;
                }
            }
        } else {
            this.field_146292_n.add(new GuiButton(0, x + 65, y + 85, 30, 20, LanguageUtility.getLocalName((String)"gui.icbm:controller.back")));
            this.field_146292_n.add(new GuiButton(1, x + 100, y + 85, 50, 20, LanguageUtility.getLocalName((String)"gui.icbm:controller.update")));
            x = this.field_147003_i + 10;
            y = this.field_147009_r + 42;
            TileEntity tile = this.controller.launcherData.get((int)this.editMissile).location.getTileEntity((IBlockAccess)this.controller.world());
            if (tile instanceof TileAbstractLauncher && ((TileAbstractLauncher)tile).target != null) {
                this.x_field = this.newField(x, y, 40, 20, "" + ((TileAbstractLauncher)tile).target.xi());
                this.y_field = this.newField(x + 45, y, 40, 20, "" + ((TileAbstractLauncher)tile).target.yi());
                this.z_field = this.newField(x + 90, y, 40, 20, "" + ((TileAbstractLauncher)tile).target.zi());
                this.name_field = this.newField(x, y + 38, 90, 20, ((TileAbstractLauncher)tile).getCustomName() != null ? ((TileAbstractLauncher)tile).getCustomName() : "");
            }
        }
    }

    protected void func_146976_a(float f, int mouseX, int mouseY) {
        super.func_146976_a(f, mouseX, mouseY);
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        super.func_146979_b(mouseX, mouseY);
        if (this.ticks++ >= updateGuiTicks) {
            this.reloadData();
        }
        String name = LanguageUtility.getLocalName((String)this.controller.func_145825_b());
        if (this.editMode && this.controller != null && this.controller.launcherData != null && this.controller.launcherData.size() > this.editMissile) {
            String localization;
            Block block;
            LauncherData data = this.controller.launcherData.get(this.editMissile);
            if (data.location != null && (block = data.location.getBlock((IBlockAccess)this.controller.world())) != null && (localization = block.func_149732_F()) != null && !localization.contains("tile.")) {
                name = localization;
            }
        }
        this.drawStringCentered(name, 85, 10);
        if (!(this.editMode || this.controller.launcherData != null && this.controller.launcherData.size() != 0)) {
            this.drawStringCentered(LanguageUtility.getLocal((String)"gui.icbm:controller.links.none"), 85, 40);
            this.drawStringCentered(LanguageUtility.getLocal((String)"gui.icbm:controller.links.none.hint"), 85, 50);
        } else if (this.editMode) {
            this.drawString(LanguageUtility.getLocalName((String)"gui.icbm:controller.target"), 10, 30);
            this.drawString(LanguageUtility.getLocalName((String)"gui.icbm:controller.launcherName"), 10, 70);
        }
    }

    public void reloadData() {
        TileEntity tile;
        if (!this.editMode) {
            this.func_73866_w_();
        } else if (this.x_field != null && this.y_field != null && this.z_field != null && this.x_field.func_146206_l() && this.y_field.func_146206_l() && this.z_field.func_146206_l() && (tile = this.controller.launcherData.get((int)this.editMissile).location.getTileEntity((IBlockAccess)this.controller.world())) instanceof TileAbstractLauncher && ((TileAbstractLauncher)tile).target != null) {
            this.x_field.func_146180_a("" + ((TileAbstractLauncher)tile).target.xi());
            this.y_field.func_146180_a("" + ((TileAbstractLauncher)tile).target.yi());
            this.z_field.func_146180_a("" + ((TileAbstractLauncher)tile).target.zi());
            this.name_field.func_146180_a("" + ((TileAbstractLauncher)tile).getCustomName());
        }
    }

    protected void func_146284_a(GuiButton button) {
        TileEntity tile;
        super.func_146284_a(button);
        if (Minecraft.func_71386_F() - this.lastClickTime < 2L) {
            return;
        }
        this.errorString = "";
        if (!this.editMode) {
            if (button.field_146127_k >= 0 && button.field_146127_k < this.buttons.length) {
                if (button.field_146127_k < this.controller.launcherData.size()) {
                    this.editMissile = button.field_146127_k;
                    this.editMode = true;
                    this.func_73866_w_();
                } else {
                    this.controller.fireLauncher(button.field_146127_k - this.controller.launcherData.size(), (EntityPlayer)Minecraft.func_71410_x().field_71439_g);
                }
            }
        } else if (button.field_146127_k == 0) {
            this.editMissile = -1;
            this.editMode = false;
            this.func_73866_w_();
        } else if (button.field_146127_k == 1 && (tile = this.controller.launcherData.get((int)this.editMissile).location.getTileEntity((IBlockAccess)this.controller.world())) instanceof TileAbstractLauncher) {
            try {
                ((TileAbstractLauncher)tile).setTarget(new Pos((double)Integer.parseInt(this.x_field.func_146179_b()), (double)Integer.parseInt(this.y_field.func_146179_b()), (double)Integer.parseInt(this.z_field.func_146179_b())));
            }
            catch (NumberFormatException e) {
                this.errorString = "gui.icbm:controller.invalid.input";
            }
            ((TileAbstractLauncher)tile).setCustomName("" + this.name_field.func_146179_b());
        }
        this.lastClickTime = Minecraft.func_71386_F();
    }
}

