/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.icbm.content.launcher;

import com.builtbroken.icbm.ICBM;
import com.builtbroken.icbm.api.launcher.INamedLauncher;
import com.builtbroken.icbm.api.modules.IMissile;
import com.builtbroken.icbm.content.crafting.missile.casing.Missile;
import com.builtbroken.icbm.content.display.TileMissileContainer;
import com.builtbroken.icbm.content.fof.IFoFStation;
import com.builtbroken.icbm.content.items.ItemRemoteDetonator;
import com.builtbroken.icbm.content.launcher.LauncherReport;
import com.builtbroken.icbm.content.launcher.controller.local.TileLocalController;
import com.builtbroken.icbm.content.launcher.controller.remote.connector.TileCommandSiloConnector;
import com.builtbroken.icbm.content.launcher.controller.remote.display.TileSiloInterface;
import com.builtbroken.icbm.content.launcher.gui.ContainerSilo;
import com.builtbroken.icbm.content.launcher.gui.GuiSiloSettings;
import com.builtbroken.icbm.content.missile.EntityMissile;
import com.builtbroken.icbm.content.missile.tracking.MissileTrackingData;
import com.builtbroken.jlib.data.vector.IPos3D;
import com.builtbroken.mc.api.event.TriggerCause;
import com.builtbroken.mc.api.items.tools.IWorldPosItem;
import com.builtbroken.mc.api.tile.IGuiTile;
import com.builtbroken.mc.api.tile.ILinkFeedback;
import com.builtbroken.mc.api.tile.ILinkable;
import com.builtbroken.mc.api.tile.IPassCode;
import com.builtbroken.mc.core.Engine;
import com.builtbroken.mc.core.network.IPacketIDReceiver;
import com.builtbroken.mc.core.network.packet.AbstractPacket;
import com.builtbroken.mc.core.network.packet.PacketTile;
import com.builtbroken.mc.core.network.packet.PacketType;
import com.builtbroken.mc.lib.helper.MathUtility;
import com.builtbroken.mc.lib.transform.vector.Location;
import com.builtbroken.mc.lib.transform.vector.Pos;
import cpw.mods.fml.common.network.ByteBufUtils;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class TileAbstractLauncher
extends TileMissileContainer
implements INamedLauncher,
IPacketIDReceiver,
IPassCode,
ILinkFeedback,
ILinkable,
IGuiTile {
    public Pos target = new Pos(0.0, -1.0, 0.0);
    public Pos fofStationPos;
    public IFoFStation fofStation;
    protected short link_code;
    protected String customName;
    protected List<LauncherReport> launcherReports = new ArrayList<LauncherReport>();
    public HashMap<EntityPlayer, Object[]> returnGuiData = new HashMap();

    public TileAbstractLauncher(String name, Material mat, int slots) {
        super(name, mat, 1);
    }

    public void setTarget(Pos target) {
        this.target = target;
        this.sendPacketToServer((AbstractPacket)new PacketTile((TileEntity)this, new Object[]{1, target}));
    }

    @Override
    public boolean onPlayerRightClick(EntityPlayer player, int side, Pos hit) {
        if (player.func_70694_bm() != null && player.func_70694_bm().func_77973_b() instanceof IWorldPosItem) {
            return false;
        }
        return super.onPlayerRightClick(player, side, hit);
    }

    public short getCode() {
        if (this.link_code == 0) {
            this.link_code = MathUtility.randomShort();
        }
        return this.link_code;
    }

    public String link(Location loc, short code) {
        if (loc.world != this.world()) {
            return "link.error.world.match";
        }
        Pos pos = loc.toPos();
        if (!pos.isAboveBedrock()) {
            return "link.error.pos.invalid";
        }
        if (this.distance((IPos3D)pos) > TileLocalController.MAX_LINK_DISTANCE) {
            return "link.error.pos.distance.max";
        }
        TileEntity tile = pos.getTileEntity((IBlockAccess)loc.world());
        if (tile instanceof IPassCode && ((IPassCode)tile).getCode() != code) {
            return "link.error.code.match";
        }
        if (tile instanceof TileLocalController) {
            return ((TileLocalController)tile).link(this.toLocation(), this.getCode());
        }
        if (tile instanceof IFoFStation) {
            IFoFStation station = this.getFoFStation();
            if (station == tile) {
                return "link.error.tile.already.added";
            }
            this.fofStation = (IFoFStation)tile;
            this.fofStationPos = new Pos(tile);
            return "";
        }
        return "link.error.tile.invalid";
    }

    public IFoFStation getFoFStation() {
        if ((this.fofStation == null || this.fofStation instanceof TileEntity && ((TileEntity)this.fofStation).func_145837_r()) && this.fofStationPos != null) {
            TileEntity tile = this.fofStationPos.getTileEntity((IBlockAccess)this.world());
            if (tile instanceof IFoFStation) {
                this.fofStation = (IFoFStation)tile;
            } else {
                this.fofStationPos = null;
            }
        }
        return this.fofStation;
    }

    public void firstTick() {
        if (!this.target.isAboveBedrock()) {
            this.target = new Pos((TileEntity)this);
        }
        if (this.link_code == 0) {
            this.link_code = MathUtility.randomShort();
        }
    }

    public void update() {
        super.update();
        if (!this.isServer() || this.ticks % 20L != 0L || !this.world().func_72864_z(this.xi(), this.yi(), this.zi()) || this.fireMissile((IPos3D)this.target)) {
            // empty if block
        }
    }

    public void doCleanupCheck() {
        ArrayList<LauncherReport> newList = new ArrayList<LauncherReport>();
        for (LauncherReport report : this.launcherReports) {
            if (report.entityUUID == null || report.missile == null) continue;
            newList.add(report);
        }
        this.launcherReports.clear();
        this.launcherReports = newList;
    }

    public boolean canFireMissile() {
        return true;
    }

    @Override
    public boolean fireMissile() {
        return this.fireMissile((IPos3D)this.target);
    }

    @Override
    public boolean fireMissile(IPos3D target) {
        IMissile missile;
        if (this.canFireMissile() && (missile = this.getMissile()) != null) {
            if (((Missile)missile).canLaunch()) {
                if (this.isServer()) {
                    EntityMissile entity = new EntityMissile(this.world());
                    entity.setMissile((Missile)missile);
                    ICBM.INSTANCE.logger().info("Firing missile from " + this + ", Missile = " + entity + ", Target = " + target);
                    if (this.fofStation != null) {
                        entity.fofTag = this.fofStation.getProvidedFoFTag();
                    }
                    Pos start = (Pos)new Pos((TileEntity)this).add((IPos3D)this.getMissileLaunchOffset());
                    entity.func_70080_a(start.x(), start.y(), start.z(), 0.0f, 0.0f);
                    entity.field_70181_x = ((Missile)missile).getEngine().getSpeed(missile);
                    entity.setTarget(target, true);
                    entity.sourceOfProjectile = new Pos((TileEntity)this);
                    this.world().func_72838_d((Entity)entity);
                    this.addLaunchReport(entity);
                    entity.setIntoMotion();
                    this.func_70299_a(0, null);
                    this.onPostMissileFired(target instanceof Pos ? (Pos)target : new Pos(target), entity);
                } else {
                    this.triggerLaunchingEffects();
                }
                return true;
            }
            if (this.isServer() && ((Missile)missile).getEngine() == null && this.world().field_73012_v.nextFloat() > 0.9f && ((Missile)missile).getWarhead() != null) {
                ((Missile)missile).getWarhead().trigger((TriggerCause)new TriggerCause.TriggerCauseFire(ForgeDirection.DOWN), this.world(), this.xi(), this.yi(), this.zi());
                this.func_70299_a(0, null);
            }
        }
        return false;
    }

    protected void onPostMissileFired(Pos target, EntityMissile entity) {
        if (this.isServer()) {
            this.sendDescPacket();
        }
    }

    protected void addLaunchReport(EntityMissile missile) {
        this.launcherReports.add(new LauncherReport(missile));
        if (this.launcherReports.size() > 20) {
            this.launcherReports.remove(0);
        }
    }

    public Pos getMissileLaunchOffset() {
        return new Pos(0.5, 3.0, 0.5);
    }

    public void triggerLaunchingEffects() {
        for (int l = 0; l < 20; ++l) {
            double f = this.x() + 0.5 + 0.3 * (double)(this.world().field_73012_v.nextFloat() - this.world().field_73012_v.nextFloat());
            double f1 = this.y() + 0.1 + 0.5 * (double)(this.world().field_73012_v.nextFloat() - this.world().field_73012_v.nextFloat());
            double f2 = this.z() + 0.5 + 0.3 * (double)(this.world().field_73012_v.nextFloat() - this.world().field_73012_v.nextFloat());
            this.world().func_72869_a("largesmoke", f, f1, f2, 0.0, 0.0, 0.0);
        }
    }

    public void onImpactOfMissile(EntityMissile missile) {
        if (this.isServer() && missile != null) {
            for (LauncherReport report : this.launcherReports) {
                if (report.entityUUID == null || report.entityUUID.getMostSignificantBits() != missile.func_110124_au().getMostSignificantBits()) continue;
                report.impacted = true;
                break;
            }
        }
    }

    public void onDeathOfMissile(EntityMissile missile) {
        if (this.isServer() && missile != null) {
            for (LauncherReport report : this.launcherReports) {
                if (report.entityUUID == null || report.entityUUID.getMostSignificantBits() != missile.func_110124_au().getMostSignificantBits()) continue;
                report.deathTime = System.nanoTime();
                break;
            }
        }
    }

    public void onLinked(Location location) {
    }

    public boolean read(ByteBuf buf, int id, EntityPlayer player, PacketType type) {
        if (id == 1) {
            this.target = new Pos(buf);
            return true;
        }
        if (id == 22) {
            this.customName = ByteBufUtils.readUTF8String((ByteBuf)buf);
            return true;
        }
        if (this.isServer()) {
            if (id == 23) {
                ItemStack stack = ((ContainerSilo)player.field_71070_bA).basicInventory.func_70301_a(0);
                if (stack != null && stack.func_77973_b() instanceof ItemRemoteDetonator && this.returnGuiData.containsKey(player) && player.field_71070_bA instanceof ContainerSilo) {
                    if (this.returnGuiData.get(player)[1] instanceof TileCommandSiloConnector && this.returnGuiData.get(player)[0] instanceof TileSiloInterface) {
                        TileCommandSiloConnector connector = (TileCommandSiloConnector)this.returnGuiData.get(player)[1];
                        TileSiloInterface tileSiloInterface = (TileSiloInterface)((Object)this.returnGuiData.get(player)[0]);
                        if (tileSiloInterface.getCommandCenter() != null && tileSiloInterface.getCommandCenter().getAttachedNetworks().size() > 0 && connector.getConnectorGroupName() != null && this.getCustomName() != null) {
                            ((ItemRemoteDetonator)stack.func_77973_b()).encode(stack, tileSiloInterface.getCommandCenter().getAttachedNetworks().get(0).getHz(), this.link_code, connector.getConnectorGroupName(), this.getCustomName());
                        } else if (player instanceof EntityPlayerMP) {
                            if (tileSiloInterface == null || tileSiloInterface.getCommandCenter().getAttachedNetworks().size() <= 0) {
                                Engine.instance.packetHandler.sendToPlayer((AbstractPacket)new PacketTile((TileEntity)this, new Object[]{24, "error.data.missing.hz"}), (EntityPlayerMP)player);
                            } else if (connector.getConnectorGroupName() == null) {
                                Engine.instance.packetHandler.sendToPlayer((AbstractPacket)new PacketTile((TileEntity)this, new Object[]{24, "error.data.missing.groupName"}), (EntityPlayerMP)player);
                            } else if (this.getCustomName() == null) {
                                Engine.instance.packetHandler.sendToPlayer((AbstractPacket)new PacketTile((TileEntity)this, new Object[]{24, "error.data.missing.siloName"}), (EntityPlayerMP)player);
                            } else {
                                Engine.instance.packetHandler.sendToPlayer((AbstractPacket)new PacketTile((TileEntity)this, new Object[]{24, "error.data.missing"}), (EntityPlayerMP)player);
                            }
                        }
                    } else if (player instanceof EntityPlayerMP) {
                        Engine.instance.packetHandler.sendToPlayer((AbstractPacket)new PacketTile((TileEntity)this, new Object[]{24, "error.invalid.connection"}), (EntityPlayerMP)player);
                    }
                }
                return true;
            }
            if (id == 25) {
                if (this.returnGuiData.containsKey(player) && player.field_71070_bA instanceof ContainerSilo && this.returnGuiData.get(player)[0] instanceof TileSiloInterface) {
                    player.openGui((Object)ICBM.INSTANCE, 0, ((TileSiloInterface)((Object)this.returnGuiData.get(player)[0])).world(), ((TileSiloInterface)((Object)this.returnGuiData.get(player)[0])).xi(), ((TileSiloInterface)((Object)this.returnGuiData.get(player)[0])).yi(), ((TileSiloInterface)((Object)this.returnGuiData.get(player)[0])).zi());
                }
                return true;
            }
        } else if (this.isClient() && id == 24) {
            if (Minecraft.func_71410_x().field_71462_r instanceof GuiSiloSettings) {
                ((GuiSiloSettings)Minecraft.func_71410_x().field_71462_r).errorString = ByteBufUtils.readUTF8String((ByteBuf)buf);
            }
            return true;
        }
        return super.read(buf, id, player, type);
    }

    public void setCustomName(String name) {
        this.customName = name;
        if (this.isClient()) {
            this.sendPacketToServer((AbstractPacket)new PacketTile((TileEntity)this, new Object[]{22, name}));
        } else {
            this.sendDescPacket();
        }
    }

    public String getCustomName() {
        return this.customName;
    }

    @Override
    public void readDescPacket(ByteBuf buf) {
        super.readDescPacket(buf);
        this.target = new Pos(buf);
        this.customName = ByteBufUtils.readUTF8String((ByteBuf)buf);
    }

    @Override
    public void writeDescPacket(ByteBuf buf) {
        super.writeDescPacket(buf);
        this.target.writeByteBuf(buf);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)("" + this.customName));
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        if (nbt.func_74764_b("target")) {
            this.target = new Pos(nbt.func_74775_l("target"));
        }
        this.link_code = nbt.func_74764_b("link_code") ? nbt.func_74765_d("link_code") : (short)MathUtility.rand.nextInt(Short.MAX_VALUE);
        if (nbt.func_74764_b("launchReports")) {
            this.launcherReports.clear();
            NBTTagList list = nbt.func_150295_c("launchReports", 10);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                this.launcherReports.add(new LauncherReport(list.func_150305_b(i)));
            }
        }
        if (nbt.func_74764_b("fofStationPos")) {
            this.fofStationPos = new Pos(nbt.func_74775_l("fofStationPos"));
        }
        if (nbt.func_74764_b("customName")) {
            this.customName = nbt.func_74779_i("customName");
        }
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        if (this.target != null) {
            nbt.func_74782_a("target", (NBTBase)this.target.toNBT());
        }
        if (this.link_code != 0) {
            nbt.func_74777_a("link_code", this.link_code);
        }
        if (this.launcherReports != null && this.launcherReports.size() > 0) {
            NBTTagList list = new NBTTagList();
            for (LauncherReport report : this.launcherReports) {
                list.func_74742_a((NBTBase)report.save());
            }
            nbt.func_74782_a("launchReports", (NBTBase)list);
        }
        if (this.fofStationPos != null) {
            nbt.func_74782_a("fofStationPos", (NBTBase)this.fofStationPos.toNBT());
        }
        if (this.customName != null && !this.customName.isEmpty()) {
            nbt.func_74778_a("customName", this.customName);
        }
    }

    public Object getServerGuiElement(int id, EntityPlayer player) {
        if (id == 1) {
            return new ContainerSilo(player, this);
        }
        return null;
    }

    public Object getClientGuiElement(int id, EntityPlayer player) {
        if (id == 1) {
            return new GuiSiloSettings(this, player);
        }
        return null;
    }

    public void encodeItem(EntityPlayer player) {
        this.sendPacketToServer((AbstractPacket)new PacketTile((TileEntity)this, new Object[]{23}));
    }

    public void returnToPrevGui() {
        this.sendPacketToServer((AbstractPacket)new PacketTile((TileEntity)this, new Object[]{25}));
    }

    @Override
    public IPos3D getTarget() {
        return this.target;
    }

    @Override
    public int getTravelTimeTo(IPos3D target) {
        IMissile missile = this.getMissile();
        return missile == null ? -1 : (int)MissileTrackingData.getRespawnTicks(this.toPos(), new Pos(this.getTarget()), ((Missile)missile).getEngine() != null ? ((Missile)missile).getEngine().getSpeed(missile) : 1.0f);
    }

    @Override
    public String getLauncherName() {
        return this.getCustomName();
    }
}

