/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.icbm.content.fof;

import com.builtbroken.icbm.ICBM;
import com.builtbroken.icbm.api.missile.IFoF;
import com.builtbroken.icbm.content.fof.IFoFStation;
import com.builtbroken.icbm.content.fof.ItemBlockFoF;
import com.builtbroken.icbm.content.fof.gui.ContainerFoF;
import com.builtbroken.jlib.data.vector.IPos3D;
import com.builtbroken.jlib.helpers.MathHelper;
import com.builtbroken.jlib.lang.EnglishLetters;
import com.builtbroken.mc.api.tile.IGuiTile;
import com.builtbroken.mc.api.tile.multiblock.IMultiTile;
import com.builtbroken.mc.api.tile.multiblock.IMultiTileHost;
import com.builtbroken.mc.core.Engine;
import com.builtbroken.mc.core.network.IPacketIDReceiver;
import com.builtbroken.mc.core.network.packet.AbstractPacket;
import com.builtbroken.mc.core.network.packet.PacketTile;
import com.builtbroken.mc.core.network.packet.PacketType;
import com.builtbroken.mc.core.registry.implement.IPostInit;
import com.builtbroken.mc.lib.access.AccessProfile;
import com.builtbroken.mc.lib.access.AccessUser;
import com.builtbroken.mc.lib.access.GlobalAccessSystem;
import com.builtbroken.mc.lib.access.IProfileContainer;
import com.builtbroken.mc.lib.access.Permissions;
import com.builtbroken.mc.lib.helper.recipe.UniversalRecipe;
import com.builtbroken.mc.lib.transform.vector.Location;
import com.builtbroken.mc.lib.transform.vector.Pos;
import com.builtbroken.mc.prefab.inventory.InventoryUtility;
import com.builtbroken.mc.prefab.tile.Tile;
import com.builtbroken.mc.prefab.tile.TileModuleMachine;
import com.builtbroken.mc.prefab.tile.multiblock.EnumMultiblock;
import com.builtbroken.mc.prefab.tile.multiblock.MultiBlockHelper;
import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.registry.GameRegistry;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.StringUtils;
import net.minecraft.world.World;
import net.minecraftforge.oredict.ShapedOreRecipe;

public class TileFoF
extends TileModuleMachine
implements IGuiTile,
IMultiTileHost,
IFoFStation,
IPacketIDReceiver,
IProfileContainer,
IPostInit {
    private static final HashMap<IPos3D, String> STRUCTURE = new HashMap();
    protected String userFoFID;
    protected List<String> archivedFoFIDs = new ArrayList<String>();
    private boolean breaking = false;
    private AccessProfile profile;
    private String globalProfileID;

    public TileFoF() {
        super("ICBMxFoF", Material.field_151573_f);
        this.itemBlock = ItemBlockFoF.class;
        this.hardness = 15.0f;
        this.resistance = 50.0f;
        this.renderNormalBlock = false;
        this.addInventoryModule(2);
    }

    public Tile newTile() {
        return new TileFoF();
    }

    public void firstTick() {
        super.firstTick();
        if (this.isServer()) {
            if (this.userFoFID == null || this.userFoFID.isEmpty()) {
                this.userFoFID = this.getRandomString();
            }
            MultiBlockHelper.buildMultiBlock((World)this.world(), (IMultiTileHost)this, (boolean)true, (boolean)true);
        }
    }

    protected String getRandomString() {
        int[] l;
        String string = "";
        for (int i : l = MathHelper.generateRandomIntArray((Random)this.world().field_73012_v, (int)(EnglishLetters.values().length + 9), (int)(10 + this.world().field_73012_v.nextInt(20)))) {
            string = i < 10 ? string + i : (this.world().field_73012_v.nextBoolean() ? string + EnglishLetters.values()[i - 10].name() : string + EnglishLetters.values()[i - 10].name().toLowerCase());
        }
        return string;
    }

    public boolean read(ByteBuf buf, int id, EntityPlayer player, PacketType type) {
        if (!super.read(buf, id, player, type)) {
            if (this.isServer()) {
                if (id == 2) {
                    if (this.hasNode(player, Permissions.machineConfigure.toString())) {
                        String change = ByteBufUtils.readUTF8String((ByteBuf)buf);
                        if (buf.readBoolean() && !this.archivedFoFIDs.contains(this.userFoFID)) {
                            this.archivedFoFIDs.add(this.userFoFID);
                        }
                        this.userFoFID = change;
                        this.sendPacketToGuiUsers((AbstractPacket)new PacketTile((TileEntity)this, new Object[]{1, "confirm"}));
                    } else {
                        this.sendPacketToGuiUsers((AbstractPacket)new PacketTile((TileEntity)this, new Object[]{1, "missing.perm"}));
                    }
                    return true;
                }
                if (id == 3) {
                    if (this.hasNode(player, Permissions.machineConfigure.toString())) {
                        if (buf.readBoolean()) {
                            this.initProfile();
                            this.getAccessProfile().getOwnerGroup().addMember(new AccessUser(player));
                        } else {
                            this.profile = null;
                            this.globalProfileID = null;
                            this.sendDescPacket();
                        }
                        this.sendPacketToGuiUsers((AbstractPacket)new PacketTile((TileEntity)this, new Object[]{1, "[1]confirm"}));
                    } else {
                        this.sendPacketToGuiUsers((AbstractPacket)new PacketTile((TileEntity)this, new Object[]{1, "[2]missing.perm"}));
                    }
                } else if (id == 4) {
                    if (this.hasNode(player, Permissions.machineConfigure.toString())) {
                        int s = this.archivedFoFIDs.size();
                        this.archivedFoFIDs.clear();
                        this.sendPacketToGuiUsers((AbstractPacket)new PacketTile((TileEntity)this, new Object[]{1, "[2]removed.ids{" + s + "}"}));
                    } else {
                        this.sendPacketToGuiUsers((AbstractPacket)new PacketTile((TileEntity)this, new Object[]{1, "[2]missing.perm"}));
                    }
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    public void writeDescPacket(ByteBuf buf) {
        super.writeDescPacket(buf);
        buf.writeBoolean(this.profile != null);
    }

    public void doUpdateGuiUsers() {
        if (this.ticks % 20L == 0L && this.userFoFID != null) {
            this.sendPacketToGuiUsers((AbstractPacket)new PacketTile((TileEntity)this, new Object[]{3, this.userFoFID}));
        }
    }

    protected void initProfile() {
        if (this.profile == null) {
            if (!StringUtils.func_151246_b((String)this.globalProfileID)) {
                this.profile = GlobalAccessSystem.getOrCreateProfile((String)this.globalProfileID, (boolean)true);
            } else {
                this.profile = new AccessProfile().generateNew("Default", (TileEntity)this);
                if (this.username != null) {
                    this.profile.getOwnerGroup().addMember(new AccessUser(this.username, this.owner));
                }
            }
            this.sendDescPacket();
        }
    }

    @Override
    public String getProvidedFoFTag() {
        return this.userFoFID;
    }

    @Override
    public boolean isFriendly(Entity entity) {
        if (entity instanceof IFoF && ((IFoF)entity).getFoFTag() != null) {
            if (((IFoF)entity).getFoFTag().equals(this.getProvidedFoFTag())) {
                return true;
            }
            return this.archivedFoFIDs.contains(((IFoF)entity).getFoFTag());
        }
        return false;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        if (nbt.func_74764_b("fofID")) {
            this.userFoFID = nbt.func_74779_i("fofID");
        }
        if (nbt.func_74764_b("fofArchive")) {
            this.archivedFoFIDs.clear();
            NBTTagCompound tag = nbt.func_74775_l("fofArchive");
            int size = tag.func_74762_e("size");
            for (int i = 0; i < size; ++i) {
                this.archivedFoFIDs.add(tag.func_74779_i("" + i));
            }
        }
        if (nbt.func_74764_b("globalAccessID")) {
            this.globalProfileID = nbt.func_74779_i("globalAccessID");
        } else if (nbt.func_74764_b("localProfile")) {
            this.profile = new AccessProfile(nbt.func_74775_l("localProfile"));
        }
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        if (!StringUtils.func_151246_b((String)this.userFoFID)) {
            nbt.func_74778_a("fofID", this.userFoFID);
        }
        if (!this.archivedFoFIDs.isEmpty()) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74768_a("size", this.archivedFoFIDs.size());
            for (int i = 0; i < this.archivedFoFIDs.size(); ++i) {
                tag.func_74778_a("" + i, this.archivedFoFIDs.get(i));
            }
            nbt.func_74782_a("fofArchive", (NBTBase)tag);
        }
        if (StringUtils.func_151246_b((String)this.globalProfileID)) {
            if (this.profile != null) {
                nbt.func_74782_a("localProfile", (NBTBase)this.profile.save(new NBTTagCompound()));
            }
        } else {
            nbt.func_74778_a("globalAccessID", this.globalProfileID);
        }
    }

    public Object getServerGuiElement(int ID, EntityPlayer player) {
        return new ContainerFoF(player, (IInventory)this);
    }

    public Object getClientGuiElement(int ID, EntityPlayer player) {
        return null;
    }

    public void onMultiTileAdded(IMultiTile tileMulti) {
    }

    public boolean onMultiTileBroken(IMultiTile tileMulti, Object source, boolean harvest) {
        if (!this.breaking && tileMulti instanceof TileEntity && ((TileEntity)tileMulti).field_145851_c == this.field_145851_c && ((TileEntity)tileMulti).field_145848_d == this.field_145848_d + 1 && ((TileEntity)tileMulti).field_145849_e == this.field_145849_e) {
            this.breaking = true;
            Location loc = this.toLocation();
            if (harvest) {
                InventoryUtility.dropItemStack((Location)loc, (ItemStack)this.toItemStack());
            }
            loc.setBlockToAir();
            this.breaking = false;
        }
        return false;
    }

    public void onRemove(Block block, int par6) {
        this.breaking = true;
        this.world().func_147468_f(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e);
        this.setAccessProfile(null);
        this.breaking = false;
    }

    public void onTileInvalidate(IMultiTile tileMulti) {
    }

    public boolean onMultiTileActivated(IMultiTile tile, EntityPlayer player, int side, IPos3D hit) {
        return this.onPlayerActivated(player, side, hit instanceof Pos ? (Pos)hit : new Pos(hit));
    }

    protected boolean onPlayerRightClick(EntityPlayer player, int side, Pos hit) {
        if (this.isServer()) {
            this.openGui(player, (Object)ICBM.INSTANCE);
            if (player instanceof EntityPlayerMP) {
                Engine.instance.packetHandler.sendToPlayer((AbstractPacket)new PacketTile((TileEntity)this, new Object[]{3, this.userFoFID}), (EntityPlayerMP)player);
            }
        }
        return true;
    }

    public void onMultiTileClicked(IMultiTile tile, EntityPlayer player) {
    }

    public HashMap<IPos3D, String> getLayoutOfMultiBlock() {
        return STRUCTURE;
    }

    public AccessProfile getAccessProfile() {
        return this.profile;
    }

    public void setAccessProfile(AccessProfile profile) {
        if (this.profile != null) {
            this.profile.removeContainer((IProfileContainer)this);
        }
        this.profile = profile;
        if (profile != null) {
            profile.addContainer((IProfileContainer)this);
        }
    }

    public boolean canAccess(String username) {
        return this.getAccessProfile() == null || this.getAccessProfile().getUserAccess(username).hasNode(Permissions.machineOpen.toString());
    }

    public boolean hasNode(EntityPlayer player, String node) {
        return this.getAccessProfile() == null || this.getAccessProfile().hasNode(player, node);
    }

    public boolean hasNode(String username, String node) {
        return this.getAccessProfile() == null || this.getAccessProfile().hasNode(username, node);
    }

    public void onProfileChange() {
    }

    public void onPostInit() {
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(ICBM.blockFoFStation), new Object[]{"RCR", "PRP", Character.valueOf('C'), ICBM.blockSiloController, Character.valueOf('R'), UniversalRecipe.CIRCUIT_T2.get(), Character.valueOf('P'), UniversalRecipe.PRIMARY_PLATE.get()}));
    }

    static {
        STRUCTURE.put((IPos3D)new Pos(0.0, 1.0, 0.0), EnumMultiblock.TILE.getName());
    }
}

