/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.icbm.content.display;

import com.builtbroken.icbm.api.missile.IMissileItem;
import com.builtbroken.icbm.content.crafting.missile.MissileModuleBuilder;
import com.builtbroken.icbm.content.crafting.missile.casing.Missile;
import com.builtbroken.mc.core.network.IPacketIDReceiver;
import com.builtbroken.mc.lib.transform.vector.Pos;
import com.builtbroken.mc.prefab.tile.TileModuleMachine;
import cpw.mods.fml.common.network.ByteBufUtils;
import io.netty.buffer.ByteBuf;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;

public class TileMissileContainer
extends TileModuleMachine
implements IPacketIDReceiver {
    public TileMissileContainer(String name, Material material) {
        this(name, material, 1);
    }

    public TileMissileContainer(String name, Material material, int slots) {
        super(name, material);
        this.addInventoryModule(slots);
    }

    public void readDescPacket(ByteBuf buf) {
        super.readDescPacket(buf);
        ItemStack stack = ByteBufUtils.readItemStack((ByteBuf)buf);
        if (stack.func_77973_b() instanceof IMissileItem) {
            this.func_70299_a(0, stack);
        } else {
            this.func_70299_a(0, null);
        }
    }

    public void writeDescPacket(ByteBuf buf) {
        super.writeDescPacket(buf);
        ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)(this.func_70301_a(0) != null ? this.func_70301_a(0) : new ItemStack(Blocks.field_150348_b)));
    }

    public boolean onPlayerRightClick(EntityPlayer player, int side, Pos hit) {
        return this.playerRemoveMissile(player, side, hit) || this.playerAddMissile(player, side, hit);
    }

    public boolean playerRemoveMissile(EntityPlayer player, int side, Pos hit) {
        if (player.func_70694_bm() == null && this.getMissile() != null) {
            if (this.isServer()) {
                player.func_146105_b((IChatComponent)new ChatComponentText("*Removed Missile*"));
                player.field_71071_by.field_70462_a[player.field_71071_by.field_70461_c] = this.getMissile().toStack();
                this.func_70299_a(0, null);
                player.field_71069_bz.func_75142_b();
                this.sendDescPacket();
            }
            return true;
        }
        return false;
    }

    public boolean playerAddMissile(EntityPlayer player, int side, Pos hit) {
        ItemStack heldItem = player.func_70694_bm();
        if (heldItem != null && this.getMissile() == null) {
            if (this.isServer() && heldItem.func_77973_b() instanceof IMissileItem) {
                Missile missile = MissileModuleBuilder.INSTANCE.buildMissile(heldItem);
                if (this.canAcceptMissile(missile)) {
                    player.func_146105_b((IChatComponent)new ChatComponentText("*Added Missile*"));
                    ItemStack stack = heldItem.func_77946_l();
                    stack.field_77994_a = 1;
                    this.func_70299_a(0, stack);
                    if (!player.field_71075_bZ.field_75098_d) {
                        --heldItem.field_77994_a;
                        if (heldItem.field_77994_a <= 0) {
                            player.field_71071_by.field_70462_a[player.field_71071_by.field_70461_c] = null;
                        }
                        player.field_71069_bz.func_75142_b();
                    }
                    this.sendDescPacket();
                } else {
                    player.func_146105_b((IChatComponent)new ChatComponentText("*Missile will not fit*"));
                }
            }
            return true;
        }
        return false;
    }

    public boolean canAcceptMissile(Missile missile) {
        return missile != null;
    }

    public Missile getMissile() {
        return this.getMissileItem() != null ? MissileModuleBuilder.INSTANCE.buildMissile(this.getMissileItem()) : null;
    }

    public ItemStack getMissileItem() {
        return this.func_70301_a(0);
    }

    public int func_70297_j_() {
        return 1;
    }
}

