/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.icbm.content.crafting.station.small;

import com.builtbroken.icbm.client.Assets;
import com.builtbroken.icbm.content.crafting.station.small.TileSmallMissileWorkstation;
import com.builtbroken.jlib.data.vector.IPos3D;
import com.builtbroken.mc.api.items.ISimpleItemRenderer;
import com.builtbroken.mc.core.network.packet.PacketType;
import com.builtbroken.mc.lib.transform.region.Cube;
import com.builtbroken.mc.lib.transform.vector.Pos;
import com.builtbroken.mc.prefab.inventory.InventoryUtility;
import com.builtbroken.mc.prefab.tile.Tile;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

public class TileSmallMissileWorkstationClient
extends TileSmallMissileWorkstation
implements ISimpleItemRenderer {
    private AxisAlignedBB bounds;

    @Override
    public Tile newTile() {
        return new TileSmallMissileWorkstationClient();
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon() {
        return Blocks.field_150339_S.func_149691_a(0, 0);
    }

    public boolean read(ByteBuf buf, int id, EntityPlayer player, PacketType type) {
        if (this.isClient()) {
            if (id == 1) {
                this.rotation = ForgeDirection.getOrientation((int)buf.readByte());
                this.bounds = null;
                ItemStack stack = ByteBufUtils.readItemStack((ByteBuf)buf);
                if (InventoryUtility.stacksMatch((ItemStack)stack, (ItemStack)new ItemStack(Items.field_151034_e))) {
                    this.func_70299_a(0, null);
                } else {
                    this.func_70299_a(0, stack);
                }
                this.field_145850_b.func_147471_g(this.xi(), this.yi(), this.zi());
                return true;
            }
            if (id == 5) {
                this.rotation = ForgeDirection.getOrientation((int)Math.min(0, Math.max(buf.readByte(), 5)));
                this.bounds = null;
                this.field_145850_b.func_147471_g(this.xi(), this.yi(), this.zi());
                return true;
            }
        }
        return false;
    }

    public void renderInventoryItem(IItemRenderer.ItemRenderType type, ItemStack itemStack, Object ... data) {
        GL11.glTranslatef((float)-1.0f, (float)0.0f, (float)0.1f);
        GL11.glRotatef((float)-20.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glScaled((double)0.7f, (double)0.7f, (double)0.7f);
        FMLClientHandler.instance().getClient().field_71446_o.func_110577_a(Assets.SMALL_WORKSTATION_TEXTURE);
        Assets.SMALL_MISSILE_STATION_MODEL.renderAll();
    }

    @SideOnly(value=Side.CLIENT)
    public void renderDynamic(Pos pos, float frame, int pass) {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)(pos.xf() + 1.0f), (float)pos.yf(), (float)(pos.zf() + 2.0f));
        GL11.glRotated((double)90.0, (double)0.0, (double)1.0, (double)0.0);
        FMLClientHandler.instance().getClient().field_71446_o.func_110577_a(Assets.SMALL_WORKSTATION_TEXTURE);
        switch (this.connectedBlockSide) {
            case UP: {
                if (this.getDirection() != ForgeDirection.WEST && this.getDirection() != ForgeDirection.EAST) break;
                GL11.glRotated((double)-90.0, (double)0.0, (double)1.0, (double)0.0);
                GL11.glTranslatef((float)-2.0f, (float)0.0f, (float)-1.0f);
                break;
            }
            case DOWN: {
                GL11.glRotated((double)180.0, (double)1.0, (double)0.0, (double)0.0);
                GL11.glTranslatef((float)0.0f, (float)-1.0f, (float)1.0f);
                if (this.getDirection() != ForgeDirection.WEST && this.getDirection() != ForgeDirection.EAST) break;
                GL11.glRotated((double)-90.0, (double)0.0, (double)1.0, (double)0.0);
                GL11.glTranslatef((float)-2.0f, (float)0.0f, (float)-1.0f);
                break;
            }
            case EAST: {
                GL11.glRotated((double)90.0, (double)1.0, (double)0.0, (double)0.0);
                GL11.glTranslatef((float)0.0f, (float)-1.0f, (float)0.0f);
                if (this.getDirection() != ForgeDirection.UP && this.getDirection() != ForgeDirection.DOWN) break;
                GL11.glRotated((double)-90.0, (double)0.0, (double)1.0, (double)0.0);
                GL11.glTranslatef((float)-2.0f, (float)0.0f, (float)-1.0f);
                break;
            }
            case WEST: {
                GL11.glRotated((double)-90.0, (double)1.0, (double)0.0, (double)0.0);
                if (this.getDirection() == ForgeDirection.UP || this.getDirection() == ForgeDirection.DOWN) {
                    GL11.glRotated((double)-90.0, (double)0.0, (double)1.0, (double)0.0);
                    GL11.glTranslatef((float)-1.0f, (float)0.0f, (float)-1.0f);
                    break;
                }
                GL11.glTranslatef((float)0.0f, (float)0.0f, (float)1.0f);
                break;
            }
            case NORTH: {
                GL11.glRotated((double)90.0, (double)0.0, (double)1.0, (double)0.0);
                GL11.glRotated((double)90.0, (double)1.0, (double)0.0, (double)0.0);
                GL11.glTranslatef((float)-1.0f, (float)1.0f, (float)0.0f);
                if (this.getDirection() != ForgeDirection.UP && this.getDirection() != ForgeDirection.DOWN) break;
                GL11.glRotated((double)-90.0, (double)0.0, (double)1.0, (double)0.0);
                GL11.glTranslatef((float)-2.0f, (float)0.0f, (float)-1.0f);
                break;
            }
            case SOUTH: {
                GL11.glRotated((double)90.0, (double)0.0, (double)1.0, (double)0.0);
                GL11.glRotated((double)-90.0, (double)1.0, (double)0.0, (double)0.0);
                GL11.glTranslatef((float)-1.0f, (float)-2.0f, (float)1.0f);
                if (this.getDirection() != ForgeDirection.UP && this.getDirection() != ForgeDirection.DOWN) break;
                GL11.glRotated((double)-90.0, (double)0.0, (double)1.0, (double)0.0);
                GL11.glTranslatef((float)-2.0f, (float)0.0f, (float)-1.0f);
            }
        }
        Assets.SMALL_MISSILE_STATION_MODEL.renderAll();
        GL11.glPopMatrix();
        if (this.getMissileItem() != null) {
            GL11.glPushMatrix();
            this.renderMissile(pos);
            GL11.glPopMatrix();
        }
    }

    private void renderMissile(Pos pos) {
        GL11.glTranslatef((float)(pos.xf() + 0.5f), (float)(pos.yf() + 0.6f), (float)(pos.zf() + 0.5f));
        switch (this.connectedBlockSide) {
            case UP: 
            case DOWN: {
                this.handleMissileRotationUD();
                break;
            }
            case EAST: 
            case WEST: {
                this.handleMissileRotationEW();
                break;
            }
            case NORTH: 
            case SOUTH: {
                this.handleMissileRotationNS();
            }
        }
        FMLClientHandler.instance().getClient().field_71446_o.func_110577_a(Assets.SMALL_MISSILE_TEXTURE);
        if (this.getMissile().getWarhead() != null) {
            Assets.SMALL_MISSILE_MODEL.renderOnly(new String[]{"Group_005"});
            if (this.getMissile().getWarhead().getExplosive() != null) {
                Assets.SMALL_MISSILE_MODEL.renderOnly(new String[]{"Group_004"});
            }
        }
        if (this.getMissile().getEngine() != null) {
            int i;
            Assets.SMALL_MISSILE_MODEL.renderOnly(new String[]{"Group_002", "Group_003"});
            for (i = 1; i < 9; ++i) {
                Assets.SMALL_MISSILE_MODEL.renderOnly(new String[]{"Component_3_00" + i});
            }
            for (i = 1; i < 5; ++i) {
                Assets.SMALL_MISSILE_MODEL.renderOnly(new String[]{"Component_2_00" + i});
            }
        }
        if (this.getMissile().getGuidance() != null) {
            // empty if block
        }
        Assets.SMALL_MISSILE_MODEL.renderOnly(new String[]{"Group_001", "Component_1_001", "Component_1_002", "Component_1_003", "Component_1_004"});
    }

    private void handleMissileRotationUD() {
        switch (this.getDirection()) {
            case EAST: {
                GL11.glRotated((double)-90.0, (double)0.0, (double)0.0, (double)1.0);
                break;
            }
            case WEST: {
                GL11.glRotated((double)90.0, (double)0.0, (double)0.0, (double)1.0);
                break;
            }
            case NORTH: {
                GL11.glRotated((double)90.0, (double)1.0, (double)0.0, (double)0.0);
                break;
            }
            case SOUTH: {
                GL11.glRotated((double)-90.0, (double)1.0, (double)0.0, (double)0.0);
            }
        }
    }

    private void handleMissileRotationEW() {
        switch (this.getDirection()) {
            case UP: {
                break;
            }
            case DOWN: {
                GL11.glRotated((double)180.0, (double)0.0, (double)0.0, (double)1.0);
                break;
            }
            case NORTH: {
                GL11.glRotated((double)-90.0, (double)1.0, (double)0.0, (double)0.0);
                break;
            }
            case SOUTH: {
                GL11.glRotated((double)90.0, (double)1.0, (double)0.0, (double)0.0);
            }
        }
    }

    private void handleMissileRotationNS() {
        switch (this.getDirection()) {
            case DOWN: {
                GL11.glRotated((double)180.0, (double)0.0, (double)0.0, (double)1.0);
                break;
            }
            case EAST: {
                GL11.glRotated((double)-90.0, (double)0.0, (double)0.0, (double)1.0);
                break;
            }
            case WEST: {
                GL11.glRotated((double)90.0, (double)0.0, (double)0.0, (double)1.0);
            }
        }
    }

    public AxisAlignedBB getRenderBoundingBox() {
        if (this.bounds == null) {
            switch (this.connectedBlockSide) {
                case UP: 
                case DOWN: {
                    if (this.rotation == ForgeDirection.EAST || this.rotation == ForgeDirection.WEST) {
                        this.bounds = new Cube(-1.0, 0.0, 0.0, 1.0, 0.0, 0.0).add((IPos3D)this.toPos()).toAABB();
                        break;
                    }
                    this.bounds = new Cube(0.0, 0.0, -1.0, 0.0, 0.0, 1.0).add((IPos3D)this.toPos()).toAABB();
                    break;
                }
                case EAST: 
                case WEST: {
                    if (this.rotation == ForgeDirection.DOWN || this.rotation == ForgeDirection.UP) {
                        this.bounds = new Cube(0.0, -1.0, 0.0, 0.0, 1.0, 0.0).add((IPos3D)this.toPos()).toAABB();
                        break;
                    }
                    this.bounds = new Cube(0.0, 0.0, -1.0, 0.0, 0.0, 1.0).add((IPos3D)this.toPos()).toAABB();
                    break;
                }
                case NORTH: 
                case SOUTH: {
                    this.bounds = this.rotation == ForgeDirection.DOWN || this.rotation == ForgeDirection.UP ? new Cube(0.0, -1.0, 0.0, 0.0, 1.0, 0.0).add((IPos3D)this.toPos()).toAABB() : new Cube(0.0, 0.0, -1.0, 0.0, 0.0, 1.0).add((IPos3D)this.toPos()).toAABB();
                }
            }
            this.bounds = super.getRenderBoundingBox();
        }
        return this.bounds;
    }
}

