/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.icbm.content.crafting.station.small;

import com.builtbroken.icbm.ICBM;
import com.builtbroken.icbm.api.crafting.IModularMissileItem;
import com.builtbroken.icbm.content.crafting.missile.MissileModuleBuilder;
import com.builtbroken.icbm.content.crafting.missile.casing.Missile;
import com.builtbroken.icbm.content.crafting.missile.casing.MissileCasings;
import com.builtbroken.icbm.content.crafting.missile.engine.RocketEngine;
import com.builtbroken.icbm.content.crafting.missile.guidance.Guidance;
import com.builtbroken.icbm.content.crafting.missile.warhead.Warhead;
import com.builtbroken.icbm.content.crafting.station.TileAbstractWorkstation;
import com.builtbroken.icbm.content.crafting.station.small.ItemBlockMissileStation;
import com.builtbroken.jlib.data.vector.IPos3D;
import com.builtbroken.mc.api.modules.IModule;
import com.builtbroken.mc.api.modules.IModuleItem;
import com.builtbroken.mc.api.tile.IRotatable;
import com.builtbroken.mc.api.tile.multiblock.IMultiTile;
import com.builtbroken.mc.api.tile.multiblock.IMultiTileHost;
import com.builtbroken.mc.core.Engine;
import com.builtbroken.mc.core.network.IPacketIDReceiver;
import com.builtbroken.mc.core.network.packet.AbstractPacket;
import com.builtbroken.mc.core.network.packet.PacketTile;
import com.builtbroken.mc.core.registry.implement.IPostInit;
import com.builtbroken.mc.lib.transform.vector.Location;
import com.builtbroken.mc.lib.transform.vector.Pos;
import com.builtbroken.mc.prefab.inventory.InventoryUtility;
import com.builtbroken.mc.prefab.recipe.item.RecipeTool;
import com.builtbroken.mc.prefab.tile.Tile;
import com.builtbroken.mc.prefab.tile.multiblock.EnumMultiblock;
import com.builtbroken.mc.prefab.tile.multiblock.MultiBlockHelper;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.HashMap;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileSmallMissileWorkstation
extends TileAbstractWorkstation
implements IPacketIDReceiver,
IRotatable,
IPostInit {
    public static final int INPUT_SLOT = 0;
    public static HashMap<IPos3D, String> upDownMap = new HashMap();
    public static HashMap<IPos3D, String> eastWestMap;
    public static HashMap<IPos3D, String> northSouthMap;
    private Missile missile;

    public TileSmallMissileWorkstation() {
        super("missileworkstation", Material.field_151573_f);
        this.resistance = 10.0f;
        this.hardness = 10.0f;
        this.addInventoryModule(5);
        this.itemBlock = ItemBlockMissileStation.class;
        this.renderNormalBlock = false;
        this.renderTileEntity = true;
        this.isOpaque = false;
    }

    public Tile newTile() {
        return new TileSmallMissileWorkstation();
    }

    public void firstTick() {
        super.firstTick();
        this.connectedBlockSide = ForgeDirection.getOrientation((int)this.world().func_72805_g(this.xi(), this.yi(), this.zi()));
        if (!this.isRotationValid() || this.isRotationBlocked(this.rotation)) {
            this.rotation = this.getDirection();
        } else {
            MultiBlockHelper.buildMultiBlock((World)this.world(), (IMultiTileHost)this, (boolean)true, (boolean)true);
        }
        this.world().func_147471_g(this.xi(), this.yi(), this.zi());
    }

    public void update() {
        super.update();
        if (this.getMissileItem() == null && this.ticks % 5L == 0L) {
            this.ejectCraftingItems();
        }
    }

    public void func_70299_a(int slot, ItemStack stack) {
        if (slot == 0) {
            if (stack == null) {
                this.missile = null;
            } else if (!InventoryUtility.stacksMatchExact((ItemStack)this.func_70301_a(slot), (ItemStack)stack)) {
                this.missile = MissileModuleBuilder.INSTANCE.buildMissile(stack);
            }
        }
        super.func_70299_a(slot, stack);
        this.world().func_147471_g(this.xi(), this.yi(), this.zi());
    }

    public void ejectCraftingItems() {
        for (int i = 1; i <= 3; ++i) {
            InventoryUtility.dropItemStack((Location)this.toLocation(), (ItemStack)this.func_70301_a(i));
            this.func_70299_a(i, null);
        }
    }

    public ItemStack getMissileItem() {
        return this.func_70301_a(0);
    }

    public PacketTile getDescPacket() {
        if (this.getMissileItem() != null) {
            return new PacketTile((TileEntity)this, new Object[]{1, (byte)this.rotation.ordinal(), this.getMissileItem()});
        }
        return new PacketTile((TileEntity)this, new Object[]{1, (byte)this.rotation.ordinal(), new ItemStack(Items.field_151034_e)});
    }

    @Override
    public HashMap<IPos3D, String> getLayoutOfMultiBlock(ForgeDirection dir) {
        return TileSmallMissileWorkstation.getLayoutOfMultiBlock(dir, this.connectedBlockSide);
    }

    public static HashMap<IPos3D, String> getLayoutOfMultiBlock(ForgeDirection dir, ForgeDirection connectedBlockSide) {
        switch (connectedBlockSide) {
            case UP: 
            case DOWN: {
                if (dir == ForgeDirection.EAST || dir == ForgeDirection.WEST) {
                    return eastWestMap;
                }
                return northSouthMap;
            }
            case EAST: 
            case WEST: {
                if (dir == ForgeDirection.DOWN || dir == ForgeDirection.UP) {
                    return upDownMap;
                }
                return northSouthMap;
            }
            case NORTH: 
            case SOUTH: {
                if (dir == ForgeDirection.DOWN || dir == ForgeDirection.UP) {
                    return upDownMap;
                }
                return eastWestMap;
            }
        }
        return eastWestMap;
    }

    public boolean isRotationValid() {
        return this.isValidRotation(this.rotation);
    }

    public boolean isValidRotation(ForgeDirection dir) {
        return dir != ForgeDirection.UNKNOWN && dir != this.connectedBlockSide && dir != this.connectedBlockSide.getOpposite();
    }

    public boolean onPlayerRightClick(EntityPlayer player, int side, Pos hit) {
        if (this.isServer()) {
            if (player.func_70694_bm() != null) {
                if (this.getMissileItem() == null) {
                    if (this.func_94041_b(0, player.func_70694_bm())) {
                        if (InventoryUtility.addItemToSlot((EntityPlayer)player, (IInventory)this, (int)0)) {
                            this.updateMissile();
                        } else {
                            player.func_146105_b((IChatComponent)new ChatComponentText("hmm, something seems wrong."));
                        }
                    } else {
                        player.func_146105_b((IChatComponent)new ChatComponentText("I don't think that goes into here."));
                    }
                } else if (this.getMissile() != null) {
                    IModule module = null;
                    if (player.func_70694_bm().func_77973_b() instanceof IModuleItem) {
                        module = ((IModuleItem)player.func_70694_bm().func_77973_b()).getModule(player.func_70694_bm());
                    }
                    if (module instanceof Guidance) {
                        if (this.getMissile().getGuidance() == null) {
                            this.getMissile().setGuidance((Guidance)module);
                            --player.func_70694_bm().field_77994_a;
                            if (player.func_70694_bm().field_77994_a <= 0) {
                                player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, null);
                            }
                            player.field_71069_bz.func_75142_b();
                            this.updateMissileItem();
                        } else {
                            player.func_146105_b((IChatComponent)new ChatComponentText("Guidance already set, right click with empty hand to remove."));
                        }
                    } else if (module instanceof RocketEngine) {
                        player.func_146105_b((IChatComponent)new ChatComponentText("Try clicking the back of the missile"));
                    } else if (module instanceof Warhead) {
                        player.func_146105_b((IChatComponent)new ChatComponentText("Try clicking the front of the missile"));
                    } else {
                        player.func_146105_b((IChatComponent)new ChatComponentText("That doesn't go onto a missile"));
                    }
                }
            } else if (player.func_70093_af()) {
                InventoryUtility.removeItemFromSlot((EntityPlayer)player, (IInventory)this, (int)0);
                this.updateMissile();
            } else if (this.getMissile() != null && this.getMissile().getGuidance() != null) {
                ItemStack stack = this.getMissile().getGuidance().toStack();
                player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, stack);
                this.getMissile().setGuidance(null);
                this.updateMissileItem();
                player.field_71069_bz.func_75142_b();
            }
        }
        return true;
    }

    private void updateMissile() {
        this.missile = this.getMissileItem() != null ? MissileModuleBuilder.INSTANCE.buildMissile(this.getMissileItem()) : null;
    }

    private void updateMissileItem() {
        if (this.getMissile() != null) {
            this.func_70299_a(0, this.getMissile().toStack());
        }
    }

    @Override
    public boolean onMultiTileActivated(IMultiTile tile, EntityPlayer player, int side, IPos3D hit) {
        if (this.isServer()) {
            Pos pos = (Pos)new Pos((TileEntity)tile).sub((double)this.xi(), (double)this.yi(), (double)this.zi());
            if (this.getLayoutOfMultiBlock().containsKey(pos)) {
                if (this.getMissile() != null) {
                    IModule module = null;
                    if (player.func_70694_bm() != null && player.func_70694_bm().func_77973_b() instanceof IModuleItem) {
                        module = ((IModuleItem)player.func_70694_bm().func_77973_b()).getModule(player.func_70694_bm());
                    }
                    if (this.isWarheadSide(pos)) {
                        if (module == null) {
                            if (player.func_70694_bm() == null && this.getMissile().getWarhead() != null) {
                                ItemStack stack = this.getMissile().getWarhead().toStack();
                                player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, stack);
                                this.getMissile().setWarhead(null);
                                this.updateMissileItem();
                                player.field_71069_bz.func_75142_b();
                            }
                        } else if (module instanceof Warhead) {
                            if (this.missile.getWarhead() == null) {
                                this.getMissile().setWarhead((Warhead)module);
                                this.reducePlayerHeldItem(player);
                                this.updateMissileItem();
                            } else {
                                player.func_146105_b((IChatComponent)new ChatComponentText("Warhead already installed."));
                            }
                        } else {
                            player.func_146105_b((IChatComponent)new ChatComponentText("Only warheads can fit on the tip."));
                        }
                    } else if (module == null) {
                        if (player.func_70694_bm() == null && this.getMissile().getEngine() != null) {
                            ItemStack stack = this.getMissile().getEngine().toStack();
                            player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, stack);
                            this.getMissile().setEngine(null);
                            this.updateMissileItem();
                            player.field_71069_bz.func_75142_b();
                        }
                    } else if (module instanceof RocketEngine) {
                        if (this.missile.getEngine() == null) {
                            this.getMissile().setEngine((RocketEngine)module);
                            this.reducePlayerHeldItem(player);
                            this.updateMissileItem();
                        } else {
                            player.func_146105_b((IChatComponent)new ChatComponentText("Engine already installed."));
                        }
                    } else {
                        player.func_146105_b((IChatComponent)new ChatComponentText("Only engines can fit in the end."));
                    }
                } else if (player.func_70694_bm() != null) {
                    return this.onPlayerRightClick(player, side, new Pos(hit));
                }
            }
        }
        return true;
    }

    private boolean isWarheadSide(Pos pos) {
        if (this.rotation == ForgeDirection.NORTH || this.rotation == ForgeDirection.SOUTH) {
            return pos.toForgeDirection() == this.getDirection().getOpposite();
        }
        return pos.toForgeDirection() == this.getDirection();
    }

    private void reducePlayerHeldItem(EntityPlayer player) {
        --player.func_70694_bm().field_77994_a;
        if (player.func_70694_bm().field_77994_a <= 0) {
            player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, null);
        }
        player.field_71069_bz.func_75142_b();
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        if (stack != null && stack.func_77973_b() instanceof IModularMissileItem && slot == 0) {
            Missile missile = MissileModuleBuilder.INSTANCE.buildMissile(stack);
            return missile.casing == MissileCasings.SMALL;
        }
        return false;
    }

    protected boolean onPlayerRightClickWrench(EntityPlayer player, int side, Pos hit) {
        if (this.isServer()) {
            if (player.func_70093_af()) {
                player.func_146105_b((IChatComponent)new ChatComponentText("Inverted station rotation"));
                this.setDirection(this.getDirection().getOpposite());
            } else {
                ForgeDirection newDir = this.getNextRotation();
                if (newDir == ForgeDirection.UNKNOWN) {
                    player.func_146105_b((IChatComponent)new ChatComponentText("Error connect side is not set, remove and replace block"));
                } else if (!this.isRotationBlocked(newDir)) {
                    this.setDirection(newDir);
                    player.func_146105_b((IChatComponent)new ChatComponentText("Rotated to face set to " + this.getDirection()));
                } else {
                    player.func_146105_b((IChatComponent)new ChatComponentText("Can't rotate from " + this.getDirection() + " to " + newDir + " as there are blocks in the way"));
                }
            }
        }
        return true;
    }

    public ForgeDirection getNextRotation() {
        ForgeDirection newDir = ForgeDirection.UNKNOWN;
        switch (this.connectedBlockSide) {
            case UP: 
            case DOWN: {
                if (this.rotation == ForgeDirection.NORTH) {
                    newDir = ForgeDirection.EAST;
                    break;
                }
                if (this.rotation == ForgeDirection.EAST) {
                    newDir = ForgeDirection.SOUTH;
                    break;
                }
                if (this.rotation == ForgeDirection.SOUTH) {
                    newDir = ForgeDirection.WEST;
                    break;
                }
                newDir = ForgeDirection.NORTH;
                break;
            }
            case EAST: 
            case WEST: {
                if (this.rotation == ForgeDirection.NORTH) {
                    newDir = ForgeDirection.DOWN;
                    break;
                }
                if (this.rotation == ForgeDirection.DOWN) {
                    newDir = ForgeDirection.SOUTH;
                    break;
                }
                if (this.rotation == ForgeDirection.SOUTH) {
                    newDir = ForgeDirection.UP;
                    break;
                }
                newDir = ForgeDirection.NORTH;
                break;
            }
            case NORTH: 
            case SOUTH: {
                newDir = this.rotation == ForgeDirection.EAST ? ForgeDirection.DOWN : (this.rotation == ForgeDirection.DOWN ? ForgeDirection.WEST : (this.rotation == ForgeDirection.WEST ? ForgeDirection.UP : ForgeDirection.EAST));
            }
        }
        return newDir;
    }

    @Override
    public void setDirection(ForgeDirection newDir) {
        this.setDirectionDO(newDir, this.isServer());
    }

    @Override
    public ForgeDirection getDirection() {
        if (!this.isValidRotation(this.rotation)) {
            for (int i = 0; i < 5; ++i) {
                if (!this.setDirectionDO(this.getNextRotation(), this.isServer())) continue;
                return this.rotation;
            }
            InventoryUtility.dropBlockAsItem((World)this.world(), (int)this.xi(), (int)this.yi(), (int)this.zi(), (boolean)true);
        }
        return this.rotation;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean setDirectionDO(ForgeDirection newDir, boolean sendPacket) {
        if (this.rotation == newDir || newDir == this.connectedBlockSide || newDir == this.connectedBlockSide.getOpposite()) return false;
        if (newDir != this.rotation.getOpposite()) {
            if (this.isRotationBlocked(newDir)) return false;
            this.rotating = true;
            this.breakDownStructure(false, false);
            this.rotation = newDir;
            MultiBlockHelper.buildMultiBlock((World)this.world(), (IMultiTileHost)this, (boolean)true, (boolean)true);
            MultiBlockHelper.updateStructure((World)this.world(), (IMultiTileHost)this, (boolean)true);
            this.rotating = false;
        } else {
            this.rotation = newDir;
        }
        if (!sendPacket) return true;
        this.sendPacket((AbstractPacket)new PacketTile((TileEntity)this, new Object[]{5, (byte)this.rotation.ordinal()}));
        return true;
    }

    public Missile getMissile() {
        if (this.getMissileItem() != null && this.missile == null) {
            this.missile = MissileModuleBuilder.INSTANCE.buildMissile(this.getMissileItem());
        }
        return this.missile;
    }

    public void onPostInit() {
        Object[] objectArray = new Object[13];
        objectArray[0] = "RRR";
        objectArray[1] = "HCD";
        objectArray[2] = "PPP";
        objectArray[3] = Character.valueOf('R');
        objectArray[4] = "rodIron";
        objectArray[5] = Character.valueOf('P');
        objectArray[6] = "plateIron";
        objectArray[7] = Character.valueOf('H');
        objectArray[8] = Engine.itemSimpleCraftingTools.getHammer();
        objectArray[9] = Character.valueOf('D');
        objectArray[10] = Engine.itemSimpleCraftingTools.getDrill();
        objectArray[11] = Character.valueOf('C');
        objectArray[12] = "circuitBasic";
        GameRegistry.addRecipe((IRecipe)new RecipeTool(new ItemStack(ICBM.blockMissileWorkstation), objectArray));
    }

    static {
        upDownMap.put((IPos3D)new Pos(0.0, 1.0, 0.0), EnumMultiblock.INVENTORY.getName() + "#RenderBlock=false");
        upDownMap.put((IPos3D)new Pos(0.0, -1.0, 0.0), EnumMultiblock.INVENTORY.getName() + "#RenderBlock=false");
        eastWestMap = new HashMap();
        eastWestMap.put((IPos3D)new Pos(1.0, 0.0, 0.0), EnumMultiblock.INVENTORY.getName() + "#RenderBlock=false");
        eastWestMap.put((IPos3D)new Pos(-1.0, 0.0, 0.0), EnumMultiblock.INVENTORY.getName() + "#RenderBlock=false");
        northSouthMap = new HashMap();
        northSouthMap.put((IPos3D)new Pos(0.0, 0.0, 1.0), EnumMultiblock.INVENTORY.getName() + "#RenderBlock=false");
        northSouthMap.put((IPos3D)new Pos(0.0, 0.0, -1.0), EnumMultiblock.INVENTORY.getName() + "#RenderBlock=false");
    }
}

