/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.icbm.content.crafting.station;

import com.builtbroken.jlib.data.vector.IPos3D;
import com.builtbroken.mc.api.tile.multiblock.IMultiTile;
import com.builtbroken.mc.api.tile.multiblock.IMultiTileHost;
import com.builtbroken.mc.lib.transform.vector.Pos;
import com.builtbroken.mc.prefab.tile.TileModuleMachine;
import com.builtbroken.mc.prefab.tile.multiblock.MultiBlockHelper;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class TileAbstractWorkstation
extends TileModuleMachine
implements IMultiTileHost {
    private boolean _destroyingStructure = false;
    protected boolean rotating = false;
    public ForgeDirection rotation = ForgeDirection.NORTH;
    public ForgeDirection connectedBlockSide = ForgeDirection.UP;

    public TileAbstractWorkstation(String name, Material material) {
        super(name, material);
    }

    public void onRemove(Block block, int par6) {
        super.onRemove(block, par6);
        this.breakDownStructure(true, true);
    }

    public void onMultiTileAdded(IMultiTile tileMulti) {
        if (tileMulti instanceof TileEntity) {
            Pos pos = new Pos((TileEntity)tileMulti);
            if (!this.getLayoutOfMultiBlock().containsKey(pos)) {
                tileMulti.setHost(null);
            }
        } else {
            tileMulti.setHost(null);
        }
    }

    public boolean onMultiTileBroken(IMultiTile tileMulti, Object source, boolean harvest) {
        if (!this._destroyingStructure && !this.rotating && tileMulti instanceof TileEntity) {
            Pos pos = (Pos)new Pos((TileEntity)tileMulti).sub((IPos3D)new Pos((TileEntity)this));
            if (this.getLayoutOfMultiBlock().containsKey(pos)) {
                this.breakDownStructure(harvest, true);
                return true;
            }
        }
        return false;
    }

    protected void breakDownStructure(boolean drop, boolean destroy) {
        if (!this._destroyingStructure) {
            this._destroyingStructure = true;
            MultiBlockHelper.destroyMultiBlockStructure((IMultiTileHost)this, (boolean)drop, (boolean)true, (boolean)destroy);
            this._destroyingStructure = false;
        }
    }

    public void onTileInvalidate(IMultiTile tileMulti) {
    }

    public boolean onMultiTileActivated(IMultiTile tile, EntityPlayer player, int side, IPos3D hit) {
        return false;
    }

    public void onMultiTileClicked(IMultiTile tile, EntityPlayer player) {
    }

    public HashMap<IPos3D, String> getLayoutOfMultiBlock() {
        return this.getLayoutOfMultiBlock(this.getDirection());
    }

    public abstract HashMap<IPos3D, String> getLayoutOfMultiBlock(ForgeDirection var1);

    public ForgeDirection getDirection() {
        return this.rotation;
    }

    public void setDirection(ForgeDirection newDir) {
        this.rotation = newDir;
    }

    public boolean isRotationBlocked(ForgeDirection newRotation) {
        for (IPos3D p : this.getLayoutOfMultiBlock(newRotation).keySet()) {
            TileEntity tile;
            Pos pos = (Pos)this.toPos().add(p);
            Block block = this.world().func_147439_a((int)pos.x(), (int)pos.y(), (int)pos.z());
            if (block.isAir((IBlockAccess)this.world(), (int)pos.x(), (int)pos.y(), (int)pos.z()) || (tile = pos.getTileEntity((IBlockAccess)this.world())) instanceof IMultiTile && (((IMultiTile)tile).getHost() == this || ((IMultiTile)tile).getHost() == null)) continue;
            return true;
        }
        return false;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        if (nbt.func_74764_b("siloRotation")) {
            this.rotation = ForgeDirection.getOrientation((int)nbt.func_74771_c("siloRotation"));
        }
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        if (this.rotation != ForgeDirection.NORTH) {
            nbt.func_74774_a("siloRotation", (byte)this.rotation.ordinal());
        }
    }
}

