/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.icbm.content.crafting.parts;

import com.builtbroken.icbm.ICBM;
import com.builtbroken.icbm.client.blast.ECBiomeChange;
import com.builtbroken.icbm.content.blast.biome.ExBiomeChange;
import com.builtbroken.icbm.content.blast.fragment.ExFragment;
import com.builtbroken.icbm.content.blast.fragment.Fragments;
import com.builtbroken.icbm.content.blast.fragment.IFragmentExplosiveHandler;
import com.builtbroken.icbm.content.crafting.parts.ItemExplosiveParts;
import com.builtbroken.jlib.data.Colors;
import com.builtbroken.mc.api.explosive.IExplosiveHandler;
import com.builtbroken.mc.api.items.explosives.IExplosiveItem;
import com.builtbroken.mc.client.ExplosiveRegistryClient;
import com.builtbroken.mc.core.registry.implement.IPostInit;
import com.builtbroken.mc.core.registry.implement.IRegistryInit;
import com.builtbroken.mc.lib.helper.recipe.UniversalRecipe;
import com.builtbroken.mc.lib.world.explosive.ExplosiveItemUtility;
import com.builtbroken.mc.lib.world.explosive.ExplosiveRegistry;
import com.builtbroken.mc.prefab.explosive.ItemNBTExplosive;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.oredict.ShapedOreRecipe;

public class ItemExplosive
extends ItemNBTExplosive
implements IExplosiveItem,
IPostInit,
IRegistryInit {
    public ItemExplosive() {
        this.func_77625_d(10);
        this.func_77655_b("icbm:explosiveItem");
        this.func_111206_d("icbm:explosiveItem");
        this.func_77627_a(true);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean b) {
        Fragments frag;
        list.add(Colors.DARK_GREY.code + "Insert into a warhead to use");
        if (stack.func_77960_j() == ExplosiveItems.BIOME_CHANGE.ordinal()) {
            int id = ExBiomeChange.getBiomeID(stack);
            if (id >= 0) {
                list.add(Colors.RED.code + "!!!Use at your own risk!!!");
                list.add("BiomeID: " + id);
                list.add("Biome: " + (BiomeGenBase.func_150568_d((int)id) == null ? Colors.RED.code + "Error" : BiomeGenBase.func_150568_d((int)id).field_76791_y));
            }
        } else if (stack.func_77960_j() == ExplosiveItems.FRAGMENT.ordinal() && (frag = ExFragment.getFragmentType(this.getAdditionalExplosiveData(stack))) != Fragments.ARROW) {
            list.add(Colors.RED.code + "!!!Not implemented!!!");
        }
    }

    public String func_77667_c(ItemStack stack) {
        if (stack.func_77960_j() == ExplosiveItems.FRAGMENT.ordinal()) {
            if (this.getExplosive(stack) instanceof IFragmentExplosiveHandler) {
                return ((IFragmentExplosiveHandler)ExplosiveItems.FRAGMENT.getExplosive()).getFragmentLocalization(stack);
            }
        } else if (stack.func_77960_j() >= 1 && stack.func_77960_j() < ExplosiveItems.values().length) {
            return super.func_77658_a() + "." + ExplosiveItems.values()[stack.func_77960_j()].ex_name;
        }
        return super.func_77667_c(stack);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister reg) {
        this.field_77791_bV = reg.func_94245_a(this.func_111208_A());
        for (ExplosiveItems item : ExplosiveItems.values()) {
            if (item == ExplosiveItems.FRAGMENT || item == ExplosiveItems.BIOME_CHANGE) continue;
            item.icon = reg.func_94245_a("icbm:explosiveItem." + item.ex_name);
        }
    }

    public IIcon getIcon(ItemStack stack, int pass) {
        if (stack.func_77960_j() == ExplosiveItems.FRAGMENT.ordinal()) {
            if (this.getExplosive(stack) instanceof IFragmentExplosiveHandler) {
                return ((IFragmentExplosiveHandler)ExplosiveItems.FRAGMENT.getExplosive()).getFragmentIcon(stack, pass);
            }
        } else {
            if (stack.func_77960_j() >= 1 && stack.func_77960_j() < ExplosiveItems.values().length && ExplosiveItems.values()[stack.func_77960_j()].icon != null) {
                return ExplosiveItems.values()[stack.func_77960_j()].icon;
            }
            if (this.getExplosive(stack) instanceof IFragmentExplosiveHandler) {
                return ((IFragmentExplosiveHandler)this.getExplosive(stack)).getFragmentIcon(stack, pass);
            }
            if (this.getExplosive(stack) instanceof ECBiomeChange) {
                return ((ECBiomeChange)this.getExplosive(stack)).getIcon(stack, pass);
            }
        }
        return this.field_77791_bV;
    }

    public int getRenderPasses(int metadata) {
        if (metadata == ExplosiveItems.FRAGMENT.ordinal()) {
            if (ExplosiveItems.FRAGMENT.getExplosive() instanceof IFragmentExplosiveHandler) {
                return ((IFragmentExplosiveHandler)ExplosiveItems.FRAGMENT.getExplosive()).getFragmentNumberOfPasses();
            }
        } else if (metadata == ExplosiveItems.BIOME_CHANGE.ordinal()) {
            return 4;
        }
        return 1;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77623_v() {
        return true;
    }

    public boolean setExplosive(ItemStack stack, IExplosiveHandler ex, double size, NBTTagCompound nbt) {
        if (stack != null && size > 0.0) {
            if (stack.func_77978_p() == null) {
                stack.func_77982_d(new NBTTagCompound());
            }
            if (ex != null) {
                boolean found = false;
                for (ExplosiveItems exItem : ExplosiveItems.values()) {
                    IExplosiveHandler handler = exItem.getExplosive();
                    if (handler != ex) continue;
                    stack.func_77964_b(exItem.ordinal());
                    found = true;
                }
                if (!found) {
                    ExplosiveItemUtility.setExplosive((ItemStack)stack, (IExplosiveHandler)ex);
                }
            } else {
                ExplosiveItemUtility.setExplosive((ItemStack)stack, (IExplosiveHandler)null);
            }
            ExplosiveItemUtility.setSize((ItemStack)stack, (double)size);
            stack.func_77978_p().func_74782_a("exData", (NBTBase)nbt);
            return true;
        }
        return false;
    }

    public double getExplosiveSize(ItemStack stack) {
        if (stack.func_77960_j() >= 1 && stack.func_77960_j() < ExplosiveItems.values().length) {
            return ExplosiveItems.values()[stack.func_77960_j()].getSize(stack.field_77994_a);
        }
        return ExplosiveItemUtility.getSize((ItemStack)stack);
    }

    public IExplosiveHandler getExplosive(ItemStack stack) {
        if (stack.func_77960_j() >= 1 && stack.func_77960_j() < ExplosiveItems.values().length) {
            return ExplosiveItems.values()[stack.func_77960_j()].getExplosive();
        }
        return super.getExplosive(stack);
    }

    public void onPostInit() {
        ItemStack explosiveCharge = ItemExplosiveParts.ExplosiveParts.GUNPOWDER_CHARGE.newItem();
        ItemStack magicCharge = ItemExplosiveParts.ExplosiveParts.MAGIC_CHARGE.newItem();
        ItemStack arrowBundle = ItemExplosiveParts.ExplosiveParts.ARROW_BUNDLE.newItem();
        ItemStack arrowFrag = ExplosiveItems.FRAGMENT.newItem();
        arrowFrag.func_77982_d(ExFragment.setFragmentType(new NBTTagCompound(), Fragments.ARROW));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(arrowFrag, new Object[]{"A A", " G ", "A A", Character.valueOf('A'), arrowBundle, Character.valueOf('G'), explosiveCharge}));
        this.newRecipe(ExplosiveItems.THERMIC_EXO, " B ", "BMB", " B ", Character.valueOf('B'), Items.field_151065_br, Character.valueOf('M'), magicCharge);
        this.newRecipe(ExplosiveItems.THERMIC_ENDO, " B ", "BMB", " B ", Character.valueOf('B'), Blocks.field_150432_aD, Character.valueOf('M'), magicCharge);
        this.newRecipe(ExplosiveItems.ANTIMATTER, " B ", "EME", " B ", Character.valueOf('B'), Items.field_151156_bN, Character.valueOf('E'), Items.field_151061_bv, Character.valueOf('M'), magicCharge);
        this.newRecipe(ExplosiveItems.FIRE_BOMB, " B ", "EGE", " B ", Character.valueOf('B'), Items.field_151044_h, Character.valueOf('E'), Items.field_151121_aF, Character.valueOf('G'), explosiveCharge);
        this.newRecipe(ExplosiveItems.FIRE_FLASH, " B ", "BGB", " B ", Character.valueOf('B'), Items.field_151059_bz, Character.valueOf('G'), explosiveCharge);
        this.newRecipe(ExplosiveItems.TORCH_EATER, "TBM", "BEB", "MBT", Character.valueOf('B'), Items.field_151071_bq, Character.valueOf('E'), Items.field_151061_bv, Character.valueOf('T'), Blocks.field_150478_aa, Character.valueOf('M'), magicCharge);
        this.newRecipe(ExplosiveItems.ENDER_BLOCKS, "ZBM", "BEB", "MBZ", Character.valueOf('B'), "ingotGold", Character.valueOf('E'), Items.field_151061_bv, Character.valueOf('Z'), Items.field_151079_bi, Character.valueOf('M'), magicCharge);
        this.newRecipe(ExplosiveItems.ANTI_PLANT, "FTF", "BMB", "FTF", Character.valueOf('T'), "treeSapling", Character.valueOf('F'), Items.field_151071_bq, Character.valueOf('B'), "treeLeaves", Character.valueOf('M'), magicCharge);
        this.newRecipe(ExplosiveItems.PLANT_LIFE, "FTF", "BMB", "FTF", Character.valueOf('T'), "treeSapling", Character.valueOf('F'), Items.field_151103_aS, Character.valueOf('B'), "treeLeaves", Character.valueOf('M'), magicCharge);
        this.newRecipe(ExplosiveItems.CAKE, "PPP", "PCP", "RRR", Character.valueOf('C'), Items.field_151105_aU, Character.valueOf('P'), Blocks.field_150410_aZ, Character.valueOf('R'), UniversalRecipe.PRIMARY_PLATE.get());
    }

    private void newRecipe(ExplosiveItems item, Object ... objects) {
        this.newRecipe(item.newItem(), objects);
    }

    private void newRecipe(ItemStack stack, Object ... objects) {
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(stack, objects));
    }

    public void onRegistered() {
        ItemStack stack;
        for (ExplosiveItems explosiveItems : ExplosiveItems.values()) {
            if (explosiveItems.ex_name == null || explosiveItems == ExplosiveItems.FRAGMENT || explosiveItems == ExplosiveItems.BIOME_CHANGE) continue;
            ExplosiveRegistry.registerExplosiveItem((ItemStack)explosiveItems.newItem());
        }
        for (Enum enum_ : Fragments.values()) {
            stack = ExplosiveItems.FRAGMENT.newItem();
            ExFragment.setFragmentType(stack, (Fragments)enum_);
            ExplosiveRegistry.registerExplosiveItem((ItemStack)stack);
        }
        for (Enum enum_ : BiomeGenBase.func_150565_n()) {
            if (enum_ == null || ((BiomeGenBase)enum_).field_76756_M < 0) continue;
            stack = ExplosiveItems.BIOME_CHANGE.newItem();
            this.getAdditionalExplosiveData(stack).func_74774_a("biomeID", (byte)((BiomeGenBase)enum_).field_76756_M);
            ExplosiveRegistry.registerExplosiveItem((ItemStack)stack);
        }
    }

    public void onClientRegistered() {
        ExplosiveRegistryClient.registerIcon((ItemStack)ExplosiveItems.ORE_PULLER.newItem(), (String)"icbm:ex.icon.ore");
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tab, List list) {
        for (int i = 1; i < ExplosiveItems.values().length; ++i) {
            ItemStack stack;
            if (i == ExplosiveItems.FRAGMENT.ordinal()) {
                for (Fragments fragments : Fragments.values()) {
                    stack = ExplosiveItems.values()[i].newItem();
                    ExFragment.setFragmentType(stack, fragments);
                    list.add(stack);
                }
                continue;
            }
            if (i == ExplosiveItems.BIOME_CHANGE.ordinal()) {
                for (Fragments fragments : BiomeGenBase.func_150565_n()) {
                    if (fragments == null || ((BiomeGenBase)fragments).field_76756_M < 0 || ((BiomeGenBase)fragments).field_76756_M >= BiomeGenBase.func_150565_n().length) continue;
                    stack = ExplosiveItems.values()[i].newItem();
                    this.getAdditionalExplosiveData(stack).func_74768_a("biomeID", ((BiomeGenBase)fragments).field_76756_M);
                    list.add(stack);
                }
                continue;
            }
            list.add(ExplosiveItems.values()[i].newItem());
        }
    }

    public static enum ExplosiveItems {
        NBT(null, 1.0),
        FRAGMENT("Fragment", 5.0),
        THERMIC_EXO("ExoThermic", 3.0),
        THERMIC_ENDO("EndoThermic", 3.0),
        FIRE_BOMB("FireBomb", 1.0),
        FIRE_FLASH("FlashFire", 2.0),
        TORCH_EATER("TorchEater", 4.0),
        ENDER_BLOCKS("EnderBlocks", 2.0),
        ANTIMATTER("Antimatter", 5.0),
        ANTI_PLANT("AntiPlant", 4.0),
        REGEN("Regen", 1.0),
        REGEN_LOCAL("RegenLocal", 1.0),
        PLANT_LIFE("PlantLife", 4.0),
        CAKE("Cake", 1.0),
        BIOME_CHANGE("BiomeChange", 1.0),
        ORE_PULLER("OrePuller", 20.0),
        SLIME_RAIN("SlimeRain", 5.0);

        public final String ex_name;
        public final double sizePerUnit;
        public IIcon icon;
        private static HashMap<IExplosiveHandler, ExplosiveItems> cache;
        private HashMap<Integer, Double> stackSizeToExplosiveSize = new HashMap();

        private ExplosiveItems(String ex_name, double sizePerUnit) {
            this.ex_name = ex_name;
            this.sizePerUnit = sizePerUnit;
        }

        public IExplosiveHandler getExplosive() {
            return ExplosiveRegistry.get((String)this.ex_name);
        }

        public double getSize(int stackSize) {
            if (stackSize == 1) {
                return this.sizePerUnit;
            }
            if (!this.stackSizeToExplosiveSize.containsKey(stackSize)) {
                this.stackSizeToExplosiveSize.put(stackSize, ExplosiveRegistry.getExplosiveSize((double)this.sizePerUnit, (double)stackSize));
            }
            return this.stackSizeToExplosiveSize.get(stackSize);
        }

        public ItemStack newItem() {
            return new ItemStack(ICBM.itemExplosive, 1, this.ordinal());
        }

        public static ItemStack get(IExplosiveHandler handler) {
            if (cache == null) {
                cache = new HashMap();
                for (ExplosiveItems item : ExplosiveItems.values()) {
                    cache.put(item.getExplosive(), item);
                }
            }
            if (cache.containsKey(handler)) {
                return cache.get(handler).newItem();
            }
            return null;
        }
    }
}

