/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.icbm.content.crafting.missile.engine.fluid;

import com.builtbroken.icbm.api.missile.IMissileEntity;
import com.builtbroken.icbm.api.modules.IMissile;
import com.builtbroken.icbm.content.crafting.missile.engine.RocketEngine;
import com.builtbroken.mc.core.registry.implement.IPostInit;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidTank;

public class RocketEngineFluid
extends RocketEngine
implements IFluidTank,
IPostInit {
    protected FluidTank tank;

    public RocketEngineFluid(ItemStack item, String name, int volume) {
        super(item, name);
        this.tank = new FluidTank(volume);
    }

    public FluidStack getFluid() {
        return this.tank.getFluid();
    }

    public int getFluidAmount() {
        return this.tank.getFluidAmount();
    }

    public int getCapacity() {
        return this.tank.getCapacity();
    }

    public FluidTankInfo getInfo() {
        return this.tank.getInfo();
    }

    public int fill(FluidStack resource, boolean doFill) {
        return this.tank.fill(resource, doFill);
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        return this.tank.drain(maxDrain, doDrain);
    }

    @Override
    public boolean generatesFire(IMissileEntity missile, IMissile missileModule) {
        return this.tank != null && this.tank.getFluidAmount() > 0;
    }

    @Override
    public void load(NBTTagCompound nbt) {
        if (nbt.func_74764_b("fuelTank")) {
            this.tank.readFromNBT(nbt.func_74775_l("fuelTank"));
        }
    }

    @Override
    public NBTTagCompound save(NBTTagCompound nbt) {
        if (this.tank.getFluidAmount() > 0) {
            nbt.func_74782_a("fuelTank", (NBTBase)this.tank.writeToNBT(new NBTTagCompound()));
        }
        return nbt;
    }

    public void onPostInit() {
    }
}

