/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.icbm.content.crafting.missile.engine;

import com.builtbroken.icbm.ICBM;
import com.builtbroken.icbm.content.crafting.AbstractModule;
import com.builtbroken.icbm.content.crafting.missile.MissileModuleBuilder;
import com.builtbroken.icbm.content.crafting.missile.engine.RocketEngine;
import com.builtbroken.icbm.content.crafting.missile.engine.RocketEngineCreative;
import com.builtbroken.icbm.content.crafting.missile.engine.fluid.RocketEngineFuel;
import com.builtbroken.icbm.content.crafting.missile.engine.fluid.RocketEngineOil;
import com.builtbroken.icbm.content.crafting.missile.engine.solid.RocketEngineCoalPowered;
import com.builtbroken.icbm.content.crafting.missile.engine.solid.RocketEngineGunpowder;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;

public enum Engines {
    CREATIVE_ENGINE("engine.creative", RocketEngineCreative.class),
    COAL_ENGINE("engine.coal", RocketEngineCoalPowered.class),
    OIL_ENGINE("engine.oil", RocketEngineOil.class),
    FUEL_ENGINE("engine.fuel", RocketEngineFuel.class),
    GUNPOWDER_ENGINE("engine.gunpowder", RocketEngineGunpowder.class);

    protected final String name;
    protected final Class<? extends AbstractModule> clazz;
    protected IIcon icon;

    private Engines(String name, Class<? extends AbstractModule> clazz) {
        this.name = name;
        this.clazz = clazz;
    }

    public static Engines get(ItemStack stack) {
        return Engines.get(stack.func_77960_j());
    }

    public static Engines get(int meta) {
        if (meta >= 0 && meta < Engines.values().length) {
            return Engines.values()[meta];
        }
        return null;
    }

    public ItemStack newModuleStack() {
        ItemStack stack = new ItemStack((Item)ICBM.itemEngineModules, 1, this.ordinal());
        stack.func_77982_d(new NBTTagCompound());
        stack.func_77978_p().func_74778_a("moduleID", "icbm." + this.name);
        return stack;
    }

    public RocketEngine newModule() {
        return MissileModuleBuilder.INSTANCE.buildEngine(this.newModuleStack());
    }

    public static void register() {
        for (Engines module : Engines.values()) {
            MissileModuleBuilder.INSTANCE.register("icbm", module.name, module.clazz, true);
        }
    }
}

