/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.icbm.content.crafting.missile.casing;

import com.builtbroken.icbm.api.missile.ICustomMissileRender;
import com.builtbroken.icbm.client.Assets;
import com.builtbroken.icbm.content.crafting.missile.casing.Missile;
import com.builtbroken.icbm.content.crafting.missile.casing.MissileCasings;
import com.builtbroken.icbm.content.missile.RenderMissile;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.model.obj.GroupObject;
import org.lwjgl.opengl.GL11;

public final class MissileStandard
extends Missile
implements ICustomMissileRender {
    private static final float inventoryScale = 0.45f;
    private static final float worldScale = 1.0f;
    private static GroupObject BODY;
    private static GroupObject FINS;

    public MissileStandard(ItemStack stack) {
        super(stack, MissileCasings.STANDARD);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean renderMissileItem(IItemRenderer.ItemRenderType type, ItemStack stack, Object ... data) {
        FMLClientHandler.instance().getClient().field_71446_o.func_110577_a(Assets.STANDARD_MISSILE_TEXTURE);
        if (type == IItemRenderer.ItemRenderType.INVENTORY) {
            GL11.glScalef((float)0.45f, (float)0.45f, (float)0.45f);
            GL11.glRotatef((float)-15.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glRotatef((float)10.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glTranslatef((float)1.0f, (float)0.0f, (float)-1.0f);
        } else if (type == IItemRenderer.ItemRenderType.EQUIPPED_FIRST_PERSON) {
            GL11.glTranslatef((float)2.0f, (float)1.0f, (float)2.0f);
            GL11.glRotatef((float)-60.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)100.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        } else if (type == IItemRenderer.ItemRenderType.EQUIPPED) {
            GL11.glRotatef((float)30.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)70.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glTranslatef((float)-1.7f, (float)-1.0f, (float)2.3f);
        }
        this.render();
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean renderMissileInWorld(float yaw, float pitch, float f) {
        GL11.glRotatef((float)yaw, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)pitch, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glScalef((float)1.0f, (float)1.0f, (float)1.0f);
        this.render();
        return true;
    }

    @Override
    public boolean renderMissileEntity(Entity entity, float f, float f1) {
        GL11.glTranslated((double)0.5, (double)1.0, (double)0.5);
        float yaw = RenderMissile.interpolateRotation(entity.field_70126_B, entity.field_70177_z, f1) - 90.0f;
        GL11.glRotatef((float)yaw, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)(RenderMissile.interpolateRotation(entity.field_70127_C, entity.field_70125_A, f1) - 90.0f), (float)0.0f, (float)0.0f, (float)1.0f);
        this.render();
        return true;
    }

    private final void render() {
        if (BODY == null || FINS == null) {
            for (GroupObject object : Assets.STANDARD_MISSILE_MODEL.groupObjects) {
                if (object.name.equals("Body_SmallSilo.002")) {
                    BODY = object;
                    continue;
                }
                if (!object.name.equals("Fins_SmallSilo.006")) continue;
                FINS = object;
            }
        }
        FMLClientHandler.instance().getClient().field_71446_o.func_110577_a(Assets.STANDARD_MISSILE_TEXTURE);
        BODY.render();
        FMLClientHandler.instance().getClient().field_71446_o.func_110577_a(Assets.STANDARD_MISSILE_FINS_TEXTURE);
        FINS.render();
    }

    @Override
    public double getHeight() {
        return 5.0;
    }

    @Override
    public double getWidth() {
        return 0.6;
    }
}

