/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.icbm.content.crafting.missile.casing;

import com.builtbroken.icbm.ICBM;
import com.builtbroken.icbm.content.crafting.missile.MissileModuleBuilder;
import com.builtbroken.icbm.content.crafting.missile.casing.Missile;
import com.builtbroken.icbm.content.crafting.missile.casing.MissileLarge;
import com.builtbroken.icbm.content.crafting.missile.casing.MissileMedium;
import com.builtbroken.icbm.content.crafting.missile.casing.MissileMicro;
import com.builtbroken.icbm.content.crafting.missile.casing.MissileSmall;
import com.builtbroken.icbm.content.crafting.missile.casing.MissileStandard;
import com.builtbroken.icbm.content.crafting.missile.warhead.WarheadCasings;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public enum MissileCasings {
    MICRO(WarheadCasings.EXPLOSIVE_MICRO, MissileMicro.class, 1200, 3.0f, true),
    SMALL(WarheadCasings.EXPLOSIVE_SMALL, MissileSmall.class, 12000, 10.0f, true),
    STANDARD(WarheadCasings.EXPLOSIVE_STANDARD, MissileStandard.class, 72000, 100.0f, true),
    MEDIUM(WarheadCasings.EXPLOSIVE_MEDIUM, MissileMedium.class, 360000, 700.0f, false),
    LARGE(WarheadCasings.EXPLOSIVE_LARGE, MissileLarge.class, 1440000, 2000.0f, false);

    public final WarheadCasings warhead_casing;
    public final Class<? extends Missile> missile_clazz;
    public final int maxFlightTimeInTicks;
    public boolean enabled = true;
    private final float maxHitPoints;

    private MissileCasings(WarheadCasings warhead, Class<? extends Missile> missile_clazz, int maxFlightTicks, float maxHitPoints, boolean enabled) {
        this.warhead_casing = warhead;
        this.missile_clazz = missile_clazz;
        this.maxFlightTimeInTicks = maxFlightTicks;
        this.enabled = enabled;
        this.maxHitPoints = maxHitPoints;
    }

    public ItemStack newModuleStack() {
        ItemStack stack = new ItemStack(ICBM.itemMissile, 1, this.ordinal());
        stack.func_77982_d(new NBTTagCompound());
        stack.func_77978_p().func_74778_a("moduleID", "icbm.missile_" + this.name().toLowerCase());
        return stack;
    }

    public Missile newModule() {
        return MissileModuleBuilder.INSTANCE.buildMissile(this.newModuleStack());
    }

    public static void register() {
        for (MissileCasings size : MissileCasings.values()) {
            MissileModuleBuilder.INSTANCE.register("icbm", "missile_" + size.name().toLowerCase(), size.missile_clazz);
        }
    }

    public float getMaxHitPoints() {
        return this.maxHitPoints;
    }
}

