/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.icbm.content.crafting.missile.casing;

import com.builtbroken.icbm.api.modules.IMissile;
import com.builtbroken.icbm.content.crafting.AbstractModule;
import com.builtbroken.icbm.content.crafting.missile.MissileModuleBuilder;
import com.builtbroken.icbm.content.crafting.missile.casing.MissileCasings;
import com.builtbroken.icbm.content.crafting.missile.engine.RocketEngine;
import com.builtbroken.icbm.content.crafting.missile.guidance.Guidance;
import com.builtbroken.icbm.content.crafting.missile.warhead.Warhead;
import com.builtbroken.mc.api.modules.IModule;
import com.builtbroken.mc.lib.helper.LanguageUtility;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public abstract class Missile
extends AbstractModule
implements IMissile {
    public final MissileCasings casing;
    private Warhead warhead;
    private Guidance guidance;
    private RocketEngine engine;

    public Missile(ItemStack stack, MissileCasings casing) {
        super(stack, "missile");
        this.casing = casing;
        this.load(stack);
    }

    @Override
    public void load(NBTTagCompound nbt) {
        if (nbt.func_74764_b("warhead")) {
            this.setWarhead(MissileModuleBuilder.INSTANCE.buildWarhead(ItemStack.func_77949_a((NBTTagCompound)nbt.func_74775_l("warhead"))));
        }
        if (nbt.func_74764_b("engine")) {
            this.setEngine(MissileModuleBuilder.INSTANCE.buildEngine(ItemStack.func_77949_a((NBTTagCompound)nbt.func_74775_l("engine"))));
        }
        if (nbt.func_74764_b("guidance")) {
            this.setGuidance(MissileModuleBuilder.INSTANCE.buildGuidance(ItemStack.func_77949_a((NBTTagCompound)nbt.func_74775_l("guidance"))));
        }
    }

    @Override
    public NBTTagCompound save(NBTTagCompound nbt) {
        if (this.getWarhead() != null) {
            nbt.func_74782_a("warhead", (NBTBase)this.getWarhead().toStack().func_77955_b(new NBTTagCompound()));
        }
        if (this.getEngine() != null) {
            nbt.func_74782_a("engine", (NBTBase)this.getEngine().toStack().func_77955_b(new NBTTagCompound()));
        }
        if (this.getGuidance() != null) {
            nbt.func_74782_a("guidance", (NBTBase)this.getGuidance().toStack().func_77955_b(new NBTTagCompound()));
        }
        return nbt;
    }

    public boolean canInstallModule(ItemStack stack, IModule module) {
        return module instanceof RocketEngine || module instanceof Warhead || module instanceof Guidance;
    }

    public boolean installModule(ItemStack stack, IModule module) {
        if (module instanceof RocketEngine && this.engine == null) {
            this.setEngine((RocketEngine)module);
            return this.getEngine() == module;
        }
        if (module instanceof Warhead && this.warhead == null) {
            this.setWarhead((Warhead)module);
            return this.getWarhead() == module;
        }
        if (module instanceof Guidance && this.guidance == null) {
            this.setGuidance((Guidance)module);
            return this.getGuidance() == module;
        }
        return false;
    }

    @Override
    public boolean canLaunch() {
        return this.getEngine() != null && this.getEngine().getMaxDistance(this) > 0.0f && this.getEngine().getSpeed(this) > 0.0f;
    }

    public void setWarhead(Warhead warhead) {
        this.warhead = warhead;
    }

    public void setGuidance(Guidance guidance) {
        this.guidance = guidance;
    }

    public void setEngine(RocketEngine engine) {
        this.engine = engine;
    }

    public Warhead getWarhead() {
        return this.warhead;
    }

    public Guidance getGuidance() {
        return this.guidance;
    }

    public RocketEngine getEngine() {
        return this.engine;
    }

    @Override
    public int getMissileSize() {
        return this.casing.ordinal();
    }

    public String toString() {
        return LanguageUtility.capitalizeFirst((String)this.casing.name().toLowerCase()) + "Missile[" + this.getWarhead() + ", " + this.getGuidance() + ", " + this.getEngine() + "]";
    }

    public float getMaxHitPoints() {
        return this.casing.getMaxHitPoints();
    }

    public abstract double getHeight();

    public abstract double getWidth();
}

