/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.icbm.content.crafting.missile;

import com.builtbroken.icbm.ICBM;
import com.builtbroken.icbm.content.crafting.AbstractModule;
import com.builtbroken.icbm.content.crafting.ModuleBuilder;
import com.builtbroken.icbm.content.crafting.missile.casing.Missile;
import com.builtbroken.icbm.content.crafting.missile.casing.MissileCasings;
import com.builtbroken.icbm.content.crafting.missile.engine.Engines;
import com.builtbroken.icbm.content.crafting.missile.engine.RocketEngine;
import com.builtbroken.icbm.content.crafting.missile.guidance.Guidance;
import com.builtbroken.icbm.content.crafting.missile.guidance.GuidanceModules;
import com.builtbroken.icbm.content.crafting.missile.warhead.Warhead;
import com.builtbroken.icbm.content.crafting.missile.warhead.WarheadCasings;
import com.builtbroken.mc.api.explosive.IExplosiveHandler;
import com.builtbroken.mc.api.modules.IModule;
import com.builtbroken.mc.lib.world.explosive.ExplosiveRegistry;
import com.builtbroken.mc.prefab.items.ItemStackWrapper;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.item.ItemStack;

public class MissileModuleBuilder
extends ModuleBuilder {
    public static MissileModuleBuilder INSTANCE = new MissileModuleBuilder();
    public HashMap<String, Class<? extends Warhead>> registeredWarheads = new HashMap();
    public HashMap<String, Class<? extends RocketEngine>> registeredEngines = new HashMap();
    public HashMap<String, Class<? extends Guidance>> registeredGuidances = new HashMap();
    public List<String> idToUseWithModuleItem = new ArrayList<String>();

    public boolean register(String mod_id, String name, Class<? extends AbstractModule> clazz, boolean useItem) {
        if (this.register(mod_id, name, clazz)) {
            if (useItem) {
                this.idToUseWithModuleItem.add(mod_id + "." + name);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean register(String mod_id, String name, Class<? extends AbstractModule> clazz) {
        if (super.register(mod_id, name, clazz)) {
            String id = mod_id + "." + name;
            if (Warhead.class.isAssignableFrom(clazz)) {
                this.registeredWarheads.put(id, clazz);
            } else if (RocketEngine.class.isAssignableFrom(clazz)) {
                this.registeredEngines.put(id, clazz);
            } else if (Guidance.class.isAssignableFrom(clazz)) {
                this.registeredGuidances.put(id, clazz);
            }
            return true;
        }
        return false;
    }

    public Missile buildMissile(ItemStack stack) {
        IModule module = super.build(stack);
        if (module instanceof Missile) {
            return (Missile)module;
        }
        return null;
    }

    public Warhead buildWarhead(ItemStack stack) {
        IModule module = super.build(stack);
        if (module instanceof Warhead) {
            return (Warhead)module;
        }
        return null;
    }

    public RocketEngine buildEngine(ItemStack stack) {
        IModule module = super.build(stack);
        if (module instanceof RocketEngine) {
            return (RocketEngine)module;
        }
        return null;
    }

    public Guidance buildGuidance(ItemStack stack) {
        IModule module = super.build(stack);
        if (module instanceof Guidance) {
            return (Guidance)module;
        }
        return null;
    }

    @Deprecated
    public Missile buildMissile(MissileCasings missileSize, IExplosiveHandler ex) {
        return this.buildMissile(missileSize, this.getExplosiveItem(ex));
    }

    public Missile buildMissile(MissileCasings missileSize, ItemStack ex) {
        return this.buildMissile(missileSize, ex, Engines.CREATIVE_ENGINE.newModule(), GuidanceModules.CHIP_THREE.newModule());
    }

    @Deprecated
    public Warhead buildWarhead(WarheadCasings size, IExplosiveHandler ex) {
        try {
            Warhead warhead = size.warhead_clazz.getConstructor(ItemStack.class).newInstance(new ItemStack(ICBM.blockWarhead, 1, size.ordinal()));
            ItemStack explosive = this.getExplosiveItem(ex);
            if (explosive != null) {
                warhead.setExplosiveStack(explosive);
            } else {
                warhead.setExplosive(ex, -1.0, null);
            }
            return warhead;
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return null;
    }

    private ItemStack getExplosiveItem(IExplosiveHandler ex) {
        List stacks = ExplosiveRegistry.getItems((IExplosiveHandler)ex);
        if (stacks != null && stacks.size() > 0) {
            return ((ItemStackWrapper)stacks.get((int)0)).itemStack;
        }
        return null;
    }

    public Warhead buildWarhead(WarheadCasings size, ItemStack explosive) {
        Warhead warhead = this.buildWarhead(size);
        if (explosive != null) {
            warhead.setExplosiveStack(explosive);
        }
        return warhead;
    }

    public Warhead buildWarhead(WarheadCasings size) {
        try {
            return size.warhead_clazz.getConstructor(ItemStack.class).newInstance(new ItemStack(ICBM.blockWarhead, 1, size.ordinal()));
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return null;
    }

    public Missile buildMissile(MissileCasings missileSize, ItemStack explosive, RocketEngine engine, Guidance guidance) {
        try {
            Missile missile = missileSize.missile_clazz.getConstructor(ItemStack.class).newInstance(missileSize.newModuleStack());
            missile.setEngine(engine);
            missile.setGuidance(guidance);
            if (explosive != null) {
                missile.setWarhead(this.buildWarhead(missileSize.warhead_casing, explosive));
            }
            return missile;
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return null;
    }
}

