/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.icbm.content.crafting;

import com.builtbroken.icbm.ICBM;
import com.builtbroken.icbm.content.crafting.AbstractModule;
import com.builtbroken.mc.api.modules.IModule;
import com.builtbroken.mc.core.Engine;
import com.google.common.collect.HashBiMap;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import net.minecraft.item.ItemStack;

public class ModuleBuilder {
    public static final String SAVE_ID = "moduleID";
    HashBiMap<String, Class<? extends AbstractModule>> idToCLassMap = HashBiMap.create();
    HashMap<String, List<String>> modToModules = new HashMap();

    protected boolean register(String mod_id, String name, Class<? extends AbstractModule> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("ModuleBuidler.register(" + mod_id + ", " + name + ", clazz) clazz can not be null");
        }
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("ModuleBuidler.register(" + mod_id + ", name, " + clazz + ") name can not be empty");
        }
        if (mod_id == null || mod_id.isEmpty()) {
            throw new IllegalArgumentException("ModuleBuidler.register(mod_id, " + name + ", " + clazz + ") mod_id is invalid");
        }
        String id = mod_id + "." + name;
        if (!this.idToCLassMap.containsKey((Object)id)) {
            this.idToCLassMap.put((Object)id, clazz);
            List<String> list = null;
            if (this.modToModules.containsKey(mod_id)) {
                list = this.modToModules.get(mod_id);
            }
            if (list == null) {
                list = new ArrayList<String>();
            }
            list.add(id);
            this.modToModules.put(mod_id, list);
            return true;
        }
        return false;
    }

    public boolean isRegistered(String id) {
        return this.idToCLassMap.containsKey((Object)id);
    }

    public Set<String> getIDs() {
        return this.idToCLassMap.keySet();
    }

    public String getID(AbstractModule module) {
        Class<?> clazz = module.getClass();
        if (this.idToCLassMap.inverse().containsKey(clazz)) {
            return (String)this.idToCLassMap.inverse().get(clazz);
        }
        return module.getClass().getSimpleName();
    }

    public IModule build(ItemStack stack) {
        block17: {
            if (stack != null && stack.func_77978_p() != null && stack.func_77978_p().func_74764_b(SAVE_ID)) {
                String id = stack.func_77978_p().func_74779_i(SAVE_ID);
                if (this.idToCLassMap.containsKey((Object)id)) {
                    if (this.idToCLassMap.get((Object)id) != null) {
                        try {
                            return ((AbstractModule)((Class)this.idToCLassMap.get((Object)id)).getConstructor(ItemStack.class).newInstance(stack)).load();
                        }
                        catch (InstantiationException e) {
                            ICBM.INSTANCE.logger().error("ModuleBuilder failed to create module from class " + this.idToCLassMap.get((Object)id));
                            if (Engine.runningAsDev) {
                                e.printStackTrace();
                            }
                            break block17;
                        }
                        catch (IllegalAccessException e) {
                            ICBM.INSTANCE.logger().error("ModuleBuilder was prevented access to class " + this.idToCLassMap.get((Object)id));
                            if (Engine.runningAsDev) {
                                e.printStackTrace();
                            }
                            break block17;
                        }
                        catch (NoSuchMethodException e) {
                            ICBM.INSTANCE.logger().error("ModuleBuilder failed to find  constructor(ItemStack.class) for class " + this.idToCLassMap.get((Object)id));
                            if (Engine.runningAsDev) {
                                e.printStackTrace();
                            }
                            break block17;
                        }
                        catch (InvocationTargetException e) {
                            ICBM.INSTANCE.logger().error("ModuleBuilder failed to invoke constructor(ItemStack.class) for class " + this.idToCLassMap.get((Object)id));
                            if (Engine.runningAsDev) {
                                e.printStackTrace();
                            }
                            break block17;
                        }
                    }
                    ICBM.INSTANCE.logger().error("ModuleBuilder, module " + id + " has no class registered.");
                }
            } else if (stack != null) {
                if (Engine.runningAsDev) {
                    ICBM.INSTANCE.logger().error("ModuleBuilder failed to create module due to NBT data being " + (stack.func_77978_p() == null ? "null" : "invalid ") + " for item stack " + stack);
                }
            } else if (Engine.runningAsDev) {
                ICBM.INSTANCE.logger().error("ModuleBuilder failed to create module due to stack being null");
            }
        }
        return null;
    }
}

