/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.icbm.content.blast.thaum;

import com.builtbroken.icbm.ICBM;
import com.builtbroken.icbm.content.blast.thaum.BlastNodeJar;
import com.builtbroken.icbm.content.blast.thaum.BlastTaint;
import com.builtbroken.icbm.content.blast.thaum.BlastTaintBottle;
import com.builtbroken.icbm.content.blast.thaum.ExplosiveHandlerNode;
import com.builtbroken.icbm.content.blast.thaum.ResearchItemICBM;
import com.builtbroken.icbm.content.crafting.missile.MissileModuleBuilder;
import com.builtbroken.icbm.content.crafting.missile.warhead.WarheadCasings;
import com.builtbroken.mc.api.explosive.IExplosiveHandler;
import com.builtbroken.mc.lib.helper.LanguageUtility;
import com.builtbroken.mc.lib.mod.loadable.AbstractLoadable;
import com.builtbroken.mc.lib.world.explosive.ExplosiveRegistry;
import com.builtbroken.mc.prefab.explosive.ExplosiveHandlerGeneric;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import thaumcraft.api.ThaumcraftApi;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.crafting.IArcaneRecipe;
import thaumcraft.api.crafting.ShapedArcaneRecipe;
import thaumcraft.api.research.ResearchCategories;
import thaumcraft.api.research.ResearchPage;
import thaumcraft.common.config.ConfigBlocks;
import thaumcraft.common.config.ConfigItems;

public class ThaumBlastLoader
extends AbstractLoadable {
    private static Map<String, ResearchPage> researchPages = new HashMap<String, ResearchPage>();

    public void init() {
        super.init();
        try {
            ExplosiveRegistry.registerOrGetExplosive((String)"icbm", (String)"ThaumTaint", (IExplosiveHandler)new ExplosiveHandlerGeneric("ThaumTaint", BlastTaint.class, 2));
            ExplosiveRegistry.registerOrGetExplosive((String)"icbm", (String)"ThaumTaintBottle", (IExplosiveHandler)new ExplosiveHandlerGeneric("ThaumTaintBottle", BlastTaintBottle.class, 5));
            ExplosiveRegistry.registerOrGetExplosive((String)"icbm", (String)"ThaumNode", (IExplosiveHandler)new ExplosiveHandlerNode());
            ExplosiveRegistry.registerOrGetExplosive((String)"icbm", (String)"ThaumJar", (IExplosiveHandler)new ExplosiveHandlerGeneric("ThaumJar", BlastNodeJar.class, 2));
        }
        catch (Exception e) {
            ICBM.INSTANCE.logger().error("Failed to load thaumcraft support", (Throwable)e);
        }
        ResearchCategories.registerCategory((String)"ICBM", (ResourceLocation)new ResourceLocation("icbm", "textures/blocks/warhead.micro.png"), (ResourceLocation)new ResourceLocation("thaumcraft", "textures/gui/gui_researchback.png"));
    }

    public void postInit() {
        super.postInit();
        this.taintWarheadRecipes();
        this.taintBottleWarheadRecipes();
        this.jarWarheadRecipes();
        this.nodeWarheadRecipes();
    }

    private void taintBottleWarheadRecipes() {
        ItemStack taintBottleMicroMissile = MissileModuleBuilder.INSTANCE.buildWarhead(WarheadCasings.EXPLOSIVE_MICRO, ExplosiveRegistry.get((String)"ThaumTaintBottle")).toStack();
        ItemStack taintBottleSmallMissile = MissileModuleBuilder.INSTANCE.buildWarhead(WarheadCasings.EXPLOSIVE_SMALL, ExplosiveRegistry.get((String)"ThaumTaintBottle")).toStack();
        ItemStack micro_warhead_empty = MissileModuleBuilder.INSTANCE.buildWarhead(WarheadCasings.EXPLOSIVE_MICRO, (ItemStack)null).toStack();
        ItemStack small_warhead_empty = MissileModuleBuilder.INSTANCE.buildWarhead(WarheadCasings.EXPLOSIVE_SMALL, (ItemStack)null).toStack();
        ShapedArcaneRecipe taintBottleMicroMissileRecipe = ThaumcraftApi.addArcaneCraftingRecipe((String)"MicroTaintBottleWarhead", (ItemStack)taintBottleMicroMissile, (AspectList)new AspectList().add(Aspect.ORDER, 25).add(Aspect.FIRE, 25), (Object[])new Object[]{"I", "M", "I", Character.valueOf('I'), ConfigItems.itemBottleTaint, Character.valueOf('M'), micro_warhead_empty});
        ShapedArcaneRecipe taintBottleSmallMissileRecipe = ThaumcraftApi.addArcaneCraftingRecipe((String)"SmallTaintBottleWarhead", (ItemStack)taintBottleSmallMissile, (AspectList)new AspectList().add(Aspect.ORDER, 25).add(Aspect.FIRE, 25), (Object[])new Object[]{" I ", "IMI", " I ", Character.valueOf('I'), ConfigItems.itemBottleTaint, Character.valueOf('M'), small_warhead_empty});
        AspectList aspects = new AspectList();
        aspects.add(Aspect.TOOL, 1).add(Aspect.MECHANISM, 2).add(Aspect.TRAVEL, 1).add(Aspect.TAINT, 5);
        ResearchItemICBM taintBottleMissilePage = new ResearchItemICBM("BottledTaintWarhead", "ICBM", aspects, 0, 2, 3, taintBottleMicroMissile);
        taintBottleMissilePage.setPages(new ResearchPage[]{ThaumBlastLoader.getResearchPage("BottledTaintWarhead"), new ResearchPage((IArcaneRecipe)taintBottleMicroMissileRecipe), new ResearchPage((IArcaneRecipe)taintBottleSmallMissileRecipe)}).setParents(new String[]{"BOTTLETAINT", "ENTROPICPROCESSING", "TaintWarhead"}).registerResearchItem();
    }

    private void jarWarheadRecipes() {
        ItemStack jarMicroMissile = MissileModuleBuilder.INSTANCE.buildWarhead(WarheadCasings.EXPLOSIVE_MICRO, ExplosiveRegistry.get((String)"ThaumJar")).toStack();
        ItemStack jarSmallMissile = MissileModuleBuilder.INSTANCE.buildWarhead(WarheadCasings.EXPLOSIVE_SMALL, ExplosiveRegistry.get((String)"ThaumJar")).toStack();
        ItemStack micro_warhead_empty = MissileModuleBuilder.INSTANCE.buildWarhead(WarheadCasings.EXPLOSIVE_MICRO, (ItemStack)null).toStack();
        ItemStack small_warhead_empty = MissileModuleBuilder.INSTANCE.buildWarhead(WarheadCasings.EXPLOSIVE_SMALL, (ItemStack)null).toStack();
        AspectList list = new AspectList().add(Aspect.ORDER, 75).add(Aspect.FIRE, 75).add(Aspect.EARTH, 75).add(Aspect.WATER, 75).add(Aspect.AIR, 75).add(Aspect.ENTROPY, 75);
        ShapedArcaneRecipe taintMicroMissileRecipe = ThaumcraftApi.addArcaneCraftingRecipe((String)"JarWarhead", (ItemStack)jarMicroMissile, (AspectList)list, (Object[])new Object[]{"J", "M", Character.valueOf('J'), new ItemStack(ConfigBlocks.blockJar), Character.valueOf('M'), micro_warhead_empty});
        ShapedArcaneRecipe taintSmallMissileRecipe = ThaumcraftApi.addArcaneCraftingRecipe((String)"JarWarhead", (ItemStack)jarSmallMissile, (AspectList)list, (Object[])new Object[]{"J", "M", Character.valueOf('J'), new ItemStack(ConfigBlocks.blockJar), Character.valueOf('M'), small_warhead_empty});
        AspectList aspects = new AspectList();
        aspects.add(Aspect.TOOL, 1).add(Aspect.MECHANISM, 2).add(Aspect.TRAVEL, 1);
        ResearchItemICBM taintMissilePage = new ResearchItemICBM("JarWarhead", "ICBM", aspects, -1, 4, 3, jarMicroMissile);
        taintMissilePage.setPages(new ResearchPage[]{ThaumBlastLoader.getResearchPage("JarWarhead"), new ResearchPage((IArcaneRecipe)taintMicroMissileRecipe), new ResearchPage((IArcaneRecipe)taintSmallMissileRecipe)}).setParents(new String[]{"NODEJAR"}).registerResearchItem();
    }

    private void nodeWarheadRecipes() {
        ItemStack micro_warhead_empty = MissileModuleBuilder.INSTANCE.buildWarhead(WarheadCasings.EXPLOSIVE_MICRO, (ItemStack)null).toStack();
        ItemStack small_warhead_empty = MissileModuleBuilder.INSTANCE.buildWarhead(WarheadCasings.EXPLOSIVE_SMALL, (ItemStack)null).toStack();
        ItemStack taintBottleMicroMissile = MissileModuleBuilder.INSTANCE.buildWarhead(WarheadCasings.EXPLOSIVE_MICRO, ExplosiveRegistry.get((String)"ThaumNode")).toStack();
        AspectList aspects = new AspectList();
        aspects.add(Aspect.TOOL, 1).add(Aspect.MECHANISM, 2).add(Aspect.TRAVEL, 1);
    }

    private void taintWarheadRecipes() {
        ItemStack taintMicroMissile = MissileModuleBuilder.INSTANCE.buildWarhead(WarheadCasings.EXPLOSIVE_MICRO, ExplosiveRegistry.get((String)"ThaumTaint")).toStack();
        ItemStack taintSmallMissile = MissileModuleBuilder.INSTANCE.buildWarhead(WarheadCasings.EXPLOSIVE_SMALL, ExplosiveRegistry.get((String)"ThaumTaint")).toStack();
        ItemStack micro_warhead_empty = MissileModuleBuilder.INSTANCE.buildWarhead(WarheadCasings.EXPLOSIVE_MICRO, (ItemStack)null).toStack();
        ItemStack small_warhead_empty = MissileModuleBuilder.INSTANCE.buildWarhead(WarheadCasings.EXPLOSIVE_SMALL, (ItemStack)null).toStack();
        ShapedArcaneRecipe taintMicroMissileRecipe = ThaumcraftApi.addArcaneCraftingRecipe((String)"TaintWarhead", (ItemStack)taintMicroMissile, (AspectList)new AspectList().add(Aspect.ORDER, 25).add(Aspect.FIRE, 25), (Object[])new Object[]{"I", "M", "I", Character.valueOf('I'), new ItemStack(ConfigItems.itemResource, 1, 11), Character.valueOf('M'), micro_warhead_empty});
        ShapedArcaneRecipe taintSmallMissileRecipe = ThaumcraftApi.addArcaneCraftingRecipe((String)"TaintWarhead", (ItemStack)taintSmallMissile, (AspectList)new AspectList().add(Aspect.ORDER, 25).add(Aspect.FIRE, 25), (Object[])new Object[]{" I ", "IMI", " I ", Character.valueOf('I'), new ItemStack(ConfigItems.itemResource, 1, 11), Character.valueOf('M'), small_warhead_empty});
        AspectList aspects = new AspectList();
        aspects.add(Aspect.TOOL, 1).add(Aspect.MECHANISM, 2).add(Aspect.TRAVEL, 1).add(Aspect.TAINT, 2);
        ResearchItemICBM taintMissilePage = new ResearchItemICBM("TaintWarhead", "ICBM", aspects, 0, 0, 3, taintMicroMissile);
        taintMissilePage.setPages(new ResearchPage[]{ThaumBlastLoader.getResearchPage("TaintWarhead"), new ResearchPage((IArcaneRecipe)taintMicroMissileRecipe), new ResearchPage((IArcaneRecipe)taintSmallMissileRecipe)}).setParents(new String[]{"ENTROPICPROCESSING"}).registerResearchItem();
    }

    private static ResearchPage createResearchPage(String key, int pageNum) {
        return new ResearchPage(LanguageUtility.getLocal((String)String.format("thaumcraft.research.%s.page.%d", key, pageNum)).replace("\n", "<BR>").replace("---", "<LINE>").replace("{img}", "<IMG>").replace("{/img}", "</IMG>"));
    }

    public static ResearchPage getResearchPage(String researchTag) {
        ResearchPage page = researchPages.get(researchTag);
        if (page == null) {
            page = ThaumBlastLoader.createResearchPage(researchTag, 1);
            researchPages.put(researchTag, page);
        }
        return page;
    }
}

