/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.icbm.content.blast.thaum;

import com.builtbroken.icbm.api.IWarheadHandler;
import com.builtbroken.icbm.api.blast.IBlastHandler;
import com.builtbroken.icbm.api.blast.IExHandlerTileMissile;
import com.builtbroken.icbm.api.missile.IMissileEntity;
import com.builtbroken.icbm.api.modules.IMissile;
import com.builtbroken.icbm.api.modules.IWarhead;
import com.builtbroken.icbm.content.blast.thaum.BlastNode;
import com.builtbroken.icbm.content.missile.EntityMissile;
import com.builtbroken.mc.api.edit.IWorldChangeAction;
import com.builtbroken.mc.api.event.TriggerCause;
import com.builtbroken.mc.lib.transform.vector.Location;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.nodes.NodeModifier;
import thaumcraft.api.nodes.NodeType;
import thaumcraft.common.Thaumcraft;
import thaumcraft.common.tiles.TileJarNode;
import thaumcraft.common.tiles.TileNode;

public final class ExplosiveHandlerNode
implements IWarheadHandler,
IBlastHandler,
IExHandlerTileMissile {
    private String id;
    private String modID;

    public IWorldChangeAction createBlastForTrigger(World world, double x, double y, double z, TriggerCause triggerCause, double size, NBTTagCompound tag) {
        Entity source;
        BlastNode blast = new BlastNode(new Location(world, x, y, z), tag);
        if (!(triggerCause instanceof TriggerCause.TriggerCauseEntity) || (source = ((TriggerCause.TriggerCauseEntity)triggerCause).source) instanceof EntityMissile) {
            // empty if block
        }
        return blast;
    }

    public static NBTTagCompound convertToNBT(Location location) {
        TileEntity tile = location.getTileEntity();
        if (tile instanceof TileJarNode) {
            NBTTagCompound tag = new NBTTagCompound();
            ((TileJarNode)tile).writeCustomNBT(tag);
            return tag;
        }
        if (tile instanceof TileNode) {
            NBTTagCompound tag = new NBTTagCompound();
            ((TileNode)tile).writeCustomNBT(tag);
            return tag;
        }
        return null;
    }

    public void addInfoToItem(EntityPlayer player, ItemStack stack, List<String> lines) {
    }

    @Override
    public void addInfoToItem(EntityPlayer player, IWarhead warhead, List<String> list) {
        NBTTagCompound nbt = warhead.getAdditionalExplosiveData();
        if (nbt != null && nbt.func_74764_b("thuamNode")) {
            nbt = nbt.func_74775_l("thaumNode");
            String desc = "\ufffd9" + StatCollector.func_74838_a((String)("nodetype." + this.getNodeType(nbt) + ".name"));
            if (this.getNodeModifier(nbt) != null) {
                desc = desc + ", " + StatCollector.func_74838_a((String)("nodemod." + this.getNodeModifier(nbt) + ".name"));
            }
            list.add(desc);
            AspectList aspects = this.getAspects(nbt);
            if (aspects != null && aspects.size() > 0) {
                for (Aspect tag : aspects.getAspectsSorted()) {
                    if (Thaumcraft.proxy.playerKnowledge.hasDiscoveredAspect(player.func_70005_c_(), tag)) {
                        list.add(tag.getName() + " x " + aspects.getAmount(tag));
                        continue;
                    }
                    list.add(StatCollector.func_74838_a((String)"tc.aspect.unknown"));
                }
            }
        }
    }

    public AspectList getAspects(NBTTagCompound tag) {
        AspectList aspects = new AspectList();
        aspects.readFromNBT(tag);
        return aspects.size() > 0 ? aspects : null;
    }

    public NodeType getNodeType(NBTTagCompound tag) {
        return NodeType.values()[tag.func_74762_e("nodetype")];
    }

    public NodeModifier getNodeModifier(NBTTagCompound tag) {
        return tag.func_74764_b("nodemod") ? NodeModifier.values()[tag.func_74762_e("nodemod")] : null;
    }

    public String getNodeId(NBTTagCompound tag) {
        return tag.func_74779_i("nodeid");
    }

    public void onRegistered(String id, String modID) {
        this.id = id;
        this.modID = modID;
    }

    public String getTranslationKey() {
        return "explosive." + this.modID + ":ThaumNode";
    }

    public String getID() {
        return this.id;
    }

    @Override
    public boolean doesDamageMissile(IMissileEntity entity, IMissile missile, IWarhead warhead, boolean warheadBlew, boolean engineBlew) {
        return engineBlew;
    }

    @Override
    public boolean doesSpawnMissileTile(IMissile missile, IMissileEntity entity) {
        return true;
    }
}

