/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.icbm.content.blast.thaum;

import com.builtbroken.mc.api.edit.IWorldEdit;
import com.builtbroken.mc.lib.transform.vector.Location;
import com.builtbroken.mc.lib.world.edit.BlockEditResult;
import net.minecraft.block.Block;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.nodes.INode;
import thaumcraft.api.nodes.NodeModifier;
import thaumcraft.api.nodes.NodeType;
import thaumcraft.common.config.ConfigBlocks;
import thaumcraft.common.tiles.TileJarNode;

public class BlockEditJar
implements IWorldEdit {
    Block oldBlock;
    int oldMeta;
    World world;
    int x;
    int y;
    int z;

    public BlockEditJar(Location location) {
        this.world = location.world;
        this.x = location.xi();
        this.y = location.yi();
        this.z = location.zi();
    }

    public boolean hasChanged() {
        return this.oldBlock != ConfigBlocks.blockJar;
    }

    public BlockEditResult place() {
        if (this.world != null) {
            Chunk chunk = this.world.func_72938_d(this.x, this.z);
            if (chunk != null && chunk.field_76636_d) {
                if (this.oldBlock != this.getBlock() && this.oldMeta != this.getBlockMetadata()) {
                    return BlockEditResult.PREV_BLOCK_CHANGED;
                }
                if (this.getBlock() == this.getNewBlock() && this.getBlockMetadata() == this.getNewMeta()) {
                    return BlockEditResult.ALREADY_PLACED;
                }
                if (BlockEditJar.jarNode(this.world, this.x, this.y, this.z)) {
                    return BlockEditResult.PLACED;
                }
                return BlockEditResult.BLOCKED;
            }
            return BlockEditResult.CHUNK_UNLOADED;
        }
        return BlockEditResult.NULL_WORLD;
    }

    public static boolean jarNode(World world, int x, int y, int z) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof INode) {
            INode node = (INode)tile;
            AspectList na = node.getAspects().copy();
            int nodeType = node.getNodeType().ordinal();
            int nodeModifier = -1;
            if (node.getNodeModifier() != null) {
                nodeModifier = node.getNodeModifier().ordinal();
            }
            if (world.field_73012_v.nextFloat() < 0.75f) {
                if (node.getNodeModifier() == null) {
                    nodeModifier = NodeModifier.PALE.ordinal();
                } else if (node.getNodeModifier() == NodeModifier.BRIGHT) {
                    nodeModifier = -1;
                } else if (node.getNodeModifier() == NodeModifier.PALE) {
                    nodeModifier = NodeModifier.FADING.ordinal();
                }
            }
            String nid = node.getId();
            node.setAspects(new AspectList());
            world.func_147475_p(x, y, z);
            world.func_147465_d(x, y, z, ConfigBlocks.blockJar, 2, 3);
            tile = world.func_147438_o(x, y, z);
            TileJarNode jar = (TileJarNode)tile;
            jar.setAspects(na);
            if (nodeModifier >= 0) {
                jar.setNodeModifier(NodeModifier.values()[nodeModifier]);
            }
            jar.setNodeType(NodeType.values()[nodeType]);
            jar.setId(nid);
            world.func_147452_c(x, y, z, ConfigBlocks.blockJar, 9, 0);
            return true;
        }
        return false;
    }

    public AxisAlignedBB getBounds() {
        return null;
    }

    public Block getNewBlock() {
        return ConfigBlocks.blockJar;
    }

    public int getNewMeta() {
        return 2;
    }

    public Block getBlock() {
        return this.oldBlock;
    }

    public int getBlockMetadata() {
        return this.oldMeta;
    }

    public TileEntity getTileEntity() {
        return this.world.func_147438_o(this.x, this.y, this.z);
    }

    public World world() {
        return this.world;
    }

    public double x() {
        return this.x;
    }

    public double y() {
        return this.y;
    }

    public double z() {
        return this.z;
    }
}

