/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.icbm.content.blast.temp;

import com.builtbroken.jlib.data.vector.IPos3D;
import com.builtbroken.mc.api.IWorldPosition;
import com.builtbroken.mc.api.edit.IWorldEdit;
import com.builtbroken.mc.lib.transform.vector.Location;
import com.builtbroken.mc.lib.world.edit.BlockEdit;
import com.builtbroken.mc.lib.world.edit.PlacementData;
import com.builtbroken.mc.lib.world.heat.HeatedBlockRegistry;
import com.builtbroken.mc.prefab.entity.damage.DamageSources;
import com.builtbroken.mc.prefab.entity.selector.EntitySelectors;
import com.builtbroken.mc.prefab.explosive.blast.BlastSimplePath;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.util.DamageSource;
import net.minecraftforge.common.util.ForgeDirection;

public class BlastEndoThermic
extends BlastSimplePath<BlastEndoThermic> {
    public BlockEdit changeBlock(Location location) {
        Location loc;
        Block block = location.getBlock();
        PlacementData data = HeatedBlockRegistry.getResultCoolDown((Block)block, (int)this.getTempForDistance(location.distance(this.x, this.y, this.z)));
        if (data != null && data.block() != null) {
            BlockEdit edit = new BlockEdit((IWorldPosition)location);
            edit.set(data.block(), data.meta() == -1 ? 0 : data.meta(), false, true);
            return edit;
        }
        if (location.isAirBlock() && !(loc = (Location)location.add(0.0, -1.0, 0.0)).isAirBlock() && loc.isSideSolid(ForgeDirection.UP)) {
            BlockEdit edit = new BlockEdit((IWorldPosition)location);
            edit.set(Blocks.field_150431_aC, 0, false, true);
            return edit;
        }
        return null;
    }

    public boolean shouldPathTo(Location last, Location next) {
        if (super.shouldPathTo(last, next)) {
            if (last.isAirBlock() && next.isAirBlock()) {
                return ((Location)last.sub((IPos3D)next)).toForgeDirection() != ForgeDirection.UP;
            }
            return true;
        }
        return false;
    }

    private int getTempForDistance(double distance) {
        return 0 + (int)(Math.max(10.0, 293.0 / this.size) * distance);
    }

    public void doEffectOther(boolean beforeBlocksPlaced) {
        if (!beforeBlocksPlaced) {
            DamageSource source = DamageSources.THERMAL_DECREASE.getSource((Object)this);
            List list = EntitySelectors.LIVING_SELECTOR.selector().getEntities((IWorldPosition)this, this.size * 2.0);
            for (Entity entity : list) {
                double distance = entity.func_70011_f(this.x, this.y, this.z);
                int temp = this.getTempForDistance(distance);
                if (temp > 250) continue;
                float damage = Math.max(1, 250 - temp) / 25;
                entity.func_70097_a(source, damage);
                if (!entity.func_70027_ad()) continue;
                entity.func_70066_B();
            }
        }
    }

    public void doStartDisplay() {
    }

    public void doEndDisplay() {
    }

    public void displayEffectForEdit(IWorldEdit blocks) {
    }

    public void playAudioForEdit(IWorldEdit blocks) {
    }
}

