/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.icbm.content.ams;

import com.builtbroken.icbm.ICBM;
import com.builtbroken.icbm.api.missile.IMissileEntity;
import com.builtbroken.icbm.content.ams.ContainerAMSTurret;
import com.builtbroken.icbm.content.ams.EntityTargetingSelector;
import com.builtbroken.icbm.content.ams.ItemBlockAMSTurret;
import com.builtbroken.icbm.content.fof.IFoFStation;
import com.builtbroken.icbm.content.launcher.controller.local.TileLocalController;
import com.builtbroken.icbm.content.missile.EntityMissile;
import com.builtbroken.icbm.content.prefab.ItemBlockICBM;
import com.builtbroken.jlib.data.vector.IPos3D;
import com.builtbroken.mc.api.items.tools.IWorldPosItem;
import com.builtbroken.mc.api.tile.IGuiTile;
import com.builtbroken.mc.api.tile.ILinkable;
import com.builtbroken.mc.api.tile.IPassCode;
import com.builtbroken.mc.core.Engine;
import com.builtbroken.mc.core.network.IPacketIDReceiver;
import com.builtbroken.mc.core.network.packet.AbstractPacket;
import com.builtbroken.mc.core.network.packet.PacketSpawnParticleStream;
import com.builtbroken.mc.core.network.packet.PacketTile;
import com.builtbroken.mc.core.network.packet.PacketType;
import com.builtbroken.mc.core.registry.implement.IPostInit;
import com.builtbroken.mc.lib.helper.recipe.UniversalRecipe;
import com.builtbroken.mc.lib.transform.region.Cube;
import com.builtbroken.mc.lib.transform.rotation.EulerAngle;
import com.builtbroken.mc.lib.transform.vector.Location;
import com.builtbroken.mc.lib.transform.vector.Pos;
import com.builtbroken.mc.lib.world.radar.RadarRegistry;
import com.builtbroken.mc.prefab.inventory.InventoryUtility;
import com.builtbroken.mc.prefab.tile.Tile;
import com.builtbroken.mc.prefab.tile.TileModuleMachine;
import com.builtbroken.mc.prefab.tile.module.TileModuleInventory;
import cpw.mods.fml.common.registry.GameRegistry;
import io.netty.buffer.ByteBuf;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.command.IEntitySelector;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;

public class TileAMS
extends TileModuleMachine
implements IPacketIDReceiver,
IGuiTile,
ILinkable,
IPostInit {
    protected static double ROTATION_SPEED = 10.0;
    protected final EulerAngle aim = new EulerAngle(0.0, 0.0, 0.0);
    protected final EulerAngle currentAim = new EulerAngle(0.0, 0.0, 0.0);
    protected final EulerAngle defaultAim = new EulerAngle(0.0, 0.0, 0.0);
    protected EntityTargetingSelector selector;
    protected Entity target = null;
    protected Cube fireArea = null;
    public Pos fofStationPos;
    public IFoFStation fofStation;
    protected long lastRotationUpdate = System.nanoTime();
    protected double deltaTime;
    protected int weaponTicks = 0;

    public TileAMS() {
        super("AMS", Material.field_151573_f);
        this.itemBlock = ItemBlockAMSTurret.class;
        this.hardness = 15.0f;
        this.resistance = 50.0f;
        this.itemBlock = ItemBlockICBM.class;
        this.renderNormalBlock = false;
        this.addInventoryModule(10);
    }

    public void update() {
        super.update();
        if (this.isServer()) {
            this.deltaTime = (double)(System.nanoTime() - this.lastRotationUpdate) / 1.0E8;
            this.lastRotationUpdate = System.nanoTime();
            if (this.selector == null) {
                this.selector = new EntityTargetingSelector(this);
            }
            if (this.fireArea == null) {
                this.fireArea = new Cube((IPos3D)this.toPos().add(-100.0, -200.0, -100.0), (IPos3D)this.toPos().add(100.0, 200.0, 100.0));
            }
            if (this.target != null && (this.target.field_70128_L || !this.selector.func_82704_a(this.target) || this.toPos().distance(this.target) > 200.0)) {
                this.target = null;
            }
            if (this.target == null) {
                this.target = this.getClosestTarget();
            }
            if (this.ticks % 10L != 0L || !this.aim.isWithin(this.currentAim, ROTATION_SPEED)) {
                // empty if block
            }
            this.currentAim.moveTowards(this.aim, ROTATION_SPEED, this.deltaTime).clampTo360();
            if (this.target != null) {
                if (this.ticks % 3L == 0L) {
                    Pos aimPoint = new Pos(this.target);
                    Pos center = (Pos)this.toPos().add(0.5);
                    if (Engine.runningAsDev) {
                        this.sendPacket((AbstractPacket)new PacketSpawnParticleStream(this.world().field_73011_w.field_76574_g, (IPos3D)center, (IPos3D)aimPoint));
                    }
                    this.aim.set(center.toEulerAngle((IPos3D)aimPoint).clampTo360());
                    this.sendAimPacket();
                }
                if (this.aim.isWithin(this.currentAim, 1.0) && this.weaponTicks++ % 20 == 0) {
                    this.fireAt(this.target);
                    this.weaponTicks = 0;
                }
            } else if (this.ticks % 3L == 0L && !this.aim.isZero()) {
                this.aim.set(this.defaultAim);
                this.sendAimPacket();
            }
        }
    }

    protected void fireAt(Entity target) {
        if (this.eatAmmo()) {
            this.field_145850_b.func_72908_a(this.x() + 0.5, this.y() + 0.5, this.z() + 0.5, "icbm:icbm.gun", ICBM.ams_gun_volume, 1.0f);
            float rand = this.world().field_73012_v.nextFloat();
            System.out.println(rand);
            if ((double)rand >= 0.3 && target instanceof IMissileEntity) {
                if (target instanceof EntityMissile || target instanceof EntityLivingBase) {
                    target.func_70097_a(DamageSource.field_76377_j, 3.0f + this.world().field_73012_v.nextFloat() * 2.0f);
                } else {
                    ((IMissileEntity)target).destroyMissile((Object)this, DamageSource.field_76377_j, 0.1f, true, true, true);
                }
                this.sendPacket((AbstractPacket)new PacketTile((TileEntity)this, new Object[]{2}));
                if (target.field_70128_L) {
                    this.target = null;
                    this.currentAim.setYaw(0.0);
                    this.currentAim.setPitch(0.0);
                    this.sendAimPacket();
                }
            }
        } else {
            this.field_145850_b.func_72908_a(this.x() + 0.5, this.y() + 0.5, this.z() + 0.5, "icbm:icbm.gun.empty", ICBM.ams_gun_volume, 1.0f);
        }
    }

    protected void sendAimPacket() {
        this.sendPacket((AbstractPacket)new PacketTile((TileEntity)this, new Object[]{3, this.aim}));
    }

    protected boolean eatAmmo() {
        if (this.getInventory() instanceof TileModuleInventory && !((TileModuleInventory)this.getInventory()).isEmpty()) {
            Iterator it = ((TileModuleInventory)this.getInventory()).iterator();
            while (it.hasNext()) {
                Map.Entry e = (Map.Entry)it.next();
                if (e == null || e.getValue() == null) continue;
                ItemStack stack = (ItemStack)e.getValue();
                if (this.isAmmo(stack)) {
                    --stack.field_77994_a;
                    return true;
                }
                if (stack.field_77994_a > 0) continue;
                it.remove();
            }
        }
        return false;
    }

    public boolean isAmmo(ItemStack stack) {
        if (stack.field_77994_a > 0) {
            for (int id : OreDictionary.getOreIDs((ItemStack)stack)) {
                String name = OreDictionary.getOreName((int)id);
                if (!name.startsWith("nugget")) continue;
                return true;
            }
        }
        return false;
    }

    protected Entity getClosestTarget() {
        List list;
        if (this.fireArea != null && !(list = RadarRegistry.getAllLivingObjectsWithin((World)this.world(), (Cube)this.fireArea, (IEntitySelector)this.selector)).isEmpty()) {
            return (Entity)list.get(0);
        }
        return null;
    }

    public IFoFStation getFoFStation() {
        if ((this.fofStation == null || this.fofStation instanceof TileEntity && ((TileEntity)this.fofStation).func_145837_r()) && this.fofStationPos != null) {
            TileEntity tile = this.fofStationPos.getTileEntity((IBlockAccess)this.world());
            if (tile instanceof IFoFStation) {
                this.fofStation = (IFoFStation)tile;
            } else {
                this.fofStationPos = null;
            }
        }
        return this.fofStation;
    }

    public String link(Location loc, short code) {
        if (loc.world != this.world()) {
            return "link.error.world.match";
        }
        Pos pos = loc.toPos();
        if (!pos.isAboveBedrock()) {
            return "link.error.pos.invalid";
        }
        if (this.distance((IPos3D)pos) > TileLocalController.MAX_LINK_DISTANCE) {
            return "link.error.pos.distance.max";
        }
        TileEntity tile = pos.getTileEntity((IBlockAccess)loc.world());
        if (tile instanceof IPassCode && ((IPassCode)tile).getCode() != code) {
            return "link.error.code.match";
        }
        if (tile instanceof IFoFStation) {
            IFoFStation station = this.getFoFStation();
            if (station == tile) {
                return "link.error.tile.already.added";
            }
            this.fofStation = (IFoFStation)tile;
            this.fofStationPos = new Pos(tile);
            return "";
        }
        return "link.error.tile.invalid";
    }

    protected boolean onPlayerRightClick(EntityPlayer player, int side, Pos hit) {
        if (player.func_70694_bm() != null && player.func_70694_bm().func_77973_b() instanceof IWorldPosItem) {
            return false;
        }
        if (this.isServer()) {
            this.openGui(player, (Object)ICBM.INSTANCE);
        }
        return true;
    }

    public void onRemove(Block block, int par6) {
        if (this.isServer()) {
            Location loc = this.toLocation();
            for (int slot = 0; slot < this.getInventory().func_70302_i_(); ++slot) {
                ItemStack stack = this.getInventory().func_70304_b(slot);
                if (stack == null) continue;
                InventoryUtility.dropItemStack((Location)loc, (ItemStack)stack);
                this.getInventory().func_70299_a(slot, null);
            }
        }
    }

    public void writeDescPacket(ByteBuf buf) {
        super.writeDescPacket(buf);
        this.aim.writeBytes(buf);
        this.currentAim.writeBytes(buf);
        this.defaultAim.writeBytes(buf);
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        if (nbt.func_74764_b("aim")) {
            this.aim.readFromNBT(nbt.func_74775_l("aim"));
        }
        if (nbt.func_74764_b("currentAim")) {
            this.currentAim.readFromNBT(nbt.func_74775_l("currentAim"));
        }
        if (nbt.func_74764_b("fofStationPos")) {
            this.fofStationPos = new Pos(nbt.func_74775_l("fofStationPos"));
        }
        if (nbt.func_74764_b("defaultAim")) {
            this.defaultAim.readFromNBT(nbt.func_74775_l("defaultAim"));
        }
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74782_a("aim", (NBTBase)this.aim.toNBT());
        nbt.func_74782_a("currentAim", (NBTBase)this.currentAim.toNBT());
        nbt.func_74782_a("defaultAim", (NBTBase)this.defaultAim.toNBT());
        if (this.fofStationPos != null) {
            nbt.func_74782_a("fofStationPos", (NBTBase)this.fofStationPos.toNBT());
        }
    }

    public boolean read(ByteBuf buf, int id, EntityPlayer player, PacketType type) {
        if (!super.read(buf, id, player, type)) {
            if (id == 4) {
                this.defaultAim.setYaw((double)buf.readFloat());
                this.defaultAim.setPitch((double)buf.readFloat());
                return true;
            }
            return false;
        }
        return true;
    }

    public Tile newTile() {
        return new TileAMS();
    }

    public Object getServerGuiElement(int ID, EntityPlayer player) {
        return new ContainerAMSTurret(player, this);
    }

    public Object getClientGuiElement(int ID, EntityPlayer player) {
        return null;
    }

    public void onPostInit() {
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(ICBM.blockAMS), new Object[]{"RPP", "RCP", "PTP", Character.valueOf('C'), UniversalRecipe.CIRCUIT_T2.get(), Character.valueOf('P'), UniversalRecipe.PRIMARY_PLATE.get(), Character.valueOf('R'), "ingotIron", Character.valueOf('T'), Blocks.field_150409_cd}));
    }
}

