/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.icbm.client;

import com.builtbroken.icbm.CommonProxy;
import com.builtbroken.icbm.ICBM;
import com.builtbroken.icbm.client.blast.ECAntiPlant;
import com.builtbroken.icbm.client.blast.ECAntimatter;
import com.builtbroken.icbm.client.blast.ECBiomeChange;
import com.builtbroken.icbm.client.blast.ECCake;
import com.builtbroken.icbm.client.blast.ECEnderBlocks;
import com.builtbroken.icbm.client.blast.ECEndo;
import com.builtbroken.icbm.client.blast.ECExo;
import com.builtbroken.icbm.client.blast.ECFireBomb;
import com.builtbroken.icbm.client.blast.ECFlashFire;
import com.builtbroken.icbm.client.blast.ECFragment;
import com.builtbroken.icbm.client.blast.ECPlantLife;
import com.builtbroken.icbm.client.blast.ECTorchEater;
import com.builtbroken.icbm.content.ams.TileAMSClient;
import com.builtbroken.icbm.content.blast.entity.ExSlimeRain;
import com.builtbroken.icbm.content.blast.entity.ExplosiveHandlerSpawn;
import com.builtbroken.icbm.content.blast.explosive.BlastPathTester;
import com.builtbroken.icbm.content.blast.explosive.ExMicroQuake;
import com.builtbroken.icbm.content.blast.util.ExOrePuller;
import com.builtbroken.icbm.content.blast.util.ExRegen;
import com.builtbroken.icbm.content.blast.util.ExRegenLocal;
import com.builtbroken.icbm.content.crafting.missile.casing.Missile;
import com.builtbroken.icbm.content.crafting.station.small.TileSmallMissileWorkstationClient;
import com.builtbroken.icbm.content.fof.TileFoFClient;
import com.builtbroken.icbm.content.launcher.controller.remote.antenna.ItemRendererAntennaFrame;
import com.builtbroken.icbm.content.launcher.controller.remote.antenna.TESRAntenna;
import com.builtbroken.icbm.content.launcher.controller.remote.antenna.TileAntennaPart;
import com.builtbroken.icbm.content.launcher.controller.remote.display.TileSiloInterfaceClient;
import com.builtbroken.icbm.content.launcher.launcher.standard.TileStandardLauncherClient;
import com.builtbroken.icbm.content.missile.EntityMissile;
import com.builtbroken.icbm.content.missile.RenderMissile;
import com.builtbroken.icbm.content.rocketlauncher.RenderRocketLauncher;
import com.builtbroken.jlib.data.vector.IPos3D;
import com.builtbroken.mc.api.explosive.IExplosiveHandler;
import com.builtbroken.mc.core.Engine;
import com.builtbroken.mc.lib.mod.compat.nei.NEIProxy;
import com.builtbroken.mc.lib.render.fx.FXElectricBolt;
import com.builtbroken.mc.lib.render.fx.FXElectricBoltSpawner;
import com.builtbroken.mc.lib.render.fx.FXEnderPortalPartical;
import com.builtbroken.mc.lib.render.fx.FXShockWave;
import com.builtbroken.mc.lib.render.fx.FXSmoke;
import com.builtbroken.mc.lib.render.fx.FxRocketFire;
import com.builtbroken.mc.lib.render.fx.FxRocketSmokeTrail;
import com.builtbroken.mc.lib.transform.vector.Pos;
import com.builtbroken.mc.lib.world.explosive.ExplosiveRegistry;
import com.builtbroken.mc.prefab.explosive.ExplosiveHandlerGeneric;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.client.registry.ClientRegistry;
import cpw.mods.fml.client.registry.RenderingRegistry;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.ReflectionHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EffectRenderer;
import net.minecraft.client.particle.EntityDiggingFX;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.world.World;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.common.MinecraftForge;
import org.apache.logging.log4j.Level;

@SideOnly(value=Side.CLIENT)
public class ClientProxy
extends CommonProxy {
    private boolean disableReflectionFX = false;

    public void preInit() {
        super.preInit();
        ICBM.blockMissileWorkstation = ICBM.INSTANCE.getManager().newBlock("SmallMissileWorkStation", TileSmallMissileWorkstationClient.class, new Object[0]);
        ICBM.blockStandardLauncher = ICBM.INSTANCE.getManager().newBlock("StandardMissileLauncher", TileStandardLauncherClient.class, new Object[0]);
        ICBM.blockAMS = ICBM.INSTANCE.getManager().newBlock("ICBMxAMS", TileAMSClient.class, new Object[0]);
        ICBM.blockFoFStation = ICBM.INSTANCE.getManager().newBlock("ICBMxFoF", TileFoFClient.class, new Object[0]);
        ICBM.blockCommandSiloDisplay = ICBM.INSTANCE.getManager().newBlock("icbmCommandSiloDisplay", TileSiloInterfaceClient.class, new Object[0]);
        ICBM.blockStandardLauncher.func_149647_a(null);
        NEIProxy.hideItem((Block)ICBM.blockStandardLauncher);
    }

    @Override
    public void init() {
        super.init();
        ClientRegistry.bindTileEntitySpecialRenderer(TileAntennaPart.class, (TileEntitySpecialRenderer)new TESRAntenna());
        MinecraftForgeClient.registerItemRenderer((Item)Item.func_150898_a((Block)ICBM.blockAntenna), (IItemRenderer)new ItemRendererAntennaFrame());
        MinecraftForgeClient.registerItemRenderer((Item)ICBM.itemRocketLauncher, (IItemRenderer)new RenderRocketLauncher());
        MinecraftForgeClient.registerItemRenderer((Item)ICBM.itemMissile, (IItemRenderer)RenderMissile.INSTANCE);
        RenderingRegistry.registerEntityRenderingHandler(EntityMissile.class, (Render)RenderMissile.INSTANCE);
        MinecraftForge.EVENT_BUS.register((Object)this);
        FMLCommonHandler.instance().bus().register((Object)this);
    }

    @Override
    public int getParticleSetting() {
        return Minecraft.func_71410_x().field_71474_y.field_74362_aa;
    }

    @Override
    public void spawnParticle(String name, World world, Pos position, double motionX, double motionY, double motionZ, float red, float green, float blue, float scale, double distance) {
        FXSmoke fx = null;
        if (name.equals("smoke")) {
            fx = new FXSmoke(world, position, red, green, blue, scale, distance);
        } else if (name.equals("missile_smoke")) {
            fx = new FXSmoke(world, position, red, green, blue, scale, distance).setAge(100);
        } else if (name.equals("portal")) {
            fx = new FXEnderPortalPartical(world, position, red, green, blue, scale, distance);
        } else if (!name.equals("antimatter")) {
            if (name.equals("digging")) {
                fx = new EntityDiggingFX(world, position.x(), position.y(), position.z(), motionX, motionY, motionZ, Block.func_149729_e((int)((int)red)), 0, (int)green);
                fx.func_70541_f(blue);
            } else if (name.equals("shockwave")) {
                fx = new FXShockWave(world, position, red, green, blue, scale, distance);
            }
        }
        if (fx != null) {
            fx.field_70159_w = motionX;
            fx.field_70181_x = motionY;
            fx.field_70179_y = motionZ;
            FMLClientHandler.instance().getClient().field_71452_i.func_78873_a((EntityFX)fx);
        }
    }

    @Override
    public void spawnRocketTail(Entity entity) {
        if (Minecraft.func_71410_x().field_71474_y.field_74362_aa != 2) {
            Pos motion = (Pos)new Pos(entity.field_70159_w, entity.field_70181_x, entity.field_70179_y).normalize();
            Pos vel = new Pos((double)((entity.field_70170_p.field_73012_v.nextFloat() - 0.5f) / 8.0f), (double)((entity.field_70170_p.field_73012_v.nextFloat() - 0.5f) / 8.0f), (double)((entity.field_70170_p.field_73012_v.nextFloat() - 0.5f) / 8.0f));
            vel = (Pos)vel.multiply((IPos3D)motion);
            this.doRocketFire(entity, vel);
            this.doRocketSmoke(entity, vel);
        }
    }

    @Override
    public void doRocketFire(Entity entity, Pos vel) {
        Missile missile;
        FxRocketFire fx = new FxRocketFire(entity.field_70170_p, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, vel.x(), vel.y(), vel.z());
        if (entity instanceof EntityMissile && (missile = ((EntityMissile)entity).getMissile()).getEngine() != null && missile.getEngine().engineFireColor != null) {
            fx = new FxRocketFire(entity.field_70170_p, missile.getEngine().engineFireColor, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, vel.x(), vel.y(), vel.z());
        }
        Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
    }

    @Override
    public void doRocketSmoke(Entity entity, Pos vel) {
        if (Minecraft.func_71410_x().field_71474_y.field_74347_j && Minecraft.func_71410_x().field_71474_y.field_74362_aa != 1) {
            Missile missile;
            FxRocketSmokeTrail fx = new FxRocketSmokeTrail(entity.field_70170_p, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, vel.x(), vel.y(), vel.z(), 200);
            if (entity instanceof EntityMissile && (missile = ((EntityMissile)entity).getMissile()).getEngine() != null && missile.getEngine().engineSmokeColor != null) {
                fx = new FxRocketSmokeTrail(entity.field_70170_p, missile.getEngine().engineSmokeColor, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, vel.x(), vel.y(), vel.z(), 200);
            }
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
        }
    }

    @Override
    public void playRocketAudio(Entity entity) {
        entity.field_70170_p.func_72956_a(entity, "icbm:engine.main", ICBM.missile_engine_volume, 1.0f);
    }

    @Override
    public void spawnShock(World world, Pos startVec, Pos targetVec) {
        FMLClientHandler.instance().getClient().field_71452_i.func_78873_a((EntityFX)new FXElectricBolt(world, startVec, targetVec, 0L));
    }

    @Override
    public void spawnShock(World world, Pos startVec, Pos targetVec, int duration) {
        FMLClientHandler.instance().getClient().field_71452_i.func_78873_a((EntityFX)new FXElectricBoltSpawner(world, startVec, targetVec, 0L, duration));
    }

    @Override
    public List<Entity> getEntityFXs() {
        if (!this.disableReflectionFX) {
            try {
                EffectRenderer renderer = Minecraft.func_71410_x().field_71452_i;
                List[] fxLayers = (List[])ReflectionHelper.getPrivateValue(EffectRenderer.class, (Object)renderer, (int)2);
                return fxLayers[0];
            }
            catch (Exception e) {
                ICBM.INSTANCE.logger().log(Level.ERROR, "Failed to use reflection on entity effects.");
                e.printStackTrace();
                this.disableReflectionFX = true;
            }
        }
        return null;
    }

    @Override
    public void registerExplosives() {
        ExplosiveRegistry.registerOrGetExplosive((String)"icbm", (String)"EntitySpawn", (IExplosiveHandler)new ExplosiveHandlerSpawn());
        ExplosiveRegistry.registerOrGetExplosive((String)"icbm", (String)"ExoThermic", (IExplosiveHandler)new ECExo());
        ExplosiveRegistry.registerOrGetExplosive((String)"icbm", (String)"EndoThermic", (IExplosiveHandler)new ECEndo());
        ExplosiveRegistry.registerOrGetExplosive((String)"icbm", (String)"Fragment", (IExplosiveHandler)new ECFragment());
        ExplosiveRegistry.registerOrGetExplosive((String)"icbm", (String)"ArrowFragment", (IExplosiveHandler)ExplosiveRegistry.get((String)"Fragment"));
        ExplosiveRegistry.registerOrGetExplosive((String)"icbm", (String)"Antimatter", (IExplosiveHandler)new ECAntimatter());
        ExplosiveRegistry.registerOrGetExplosive((String)"icbm", (String)"FireBomb", (IExplosiveHandler)new ECFireBomb());
        ExplosiveRegistry.registerOrGetExplosive((String)"icbm", (String)"FlashFire", (IExplosiveHandler)new ECFlashFire());
        ExplosiveRegistry.registerOrGetExplosive((String)"icbm", (String)"EnderBlocks", (IExplosiveHandler)new ECEnderBlocks());
        ExplosiveRegistry.registerOrGetExplosive((String)"icbm", (String)"TorchEater", (IExplosiveHandler)new ECTorchEater());
        ExplosiveRegistry.registerOrGetExplosive((String)"icbm", (String)"PlantLife", (IExplosiveHandler)new ECPlantLife());
        ExplosiveRegistry.registerOrGetExplosive((String)"icbm", (String)"AntiPlant", (IExplosiveHandler)new ECAntiPlant());
        ExplosiveRegistry.registerOrGetExplosive((String)"icbm", (String)"Regen", (IExplosiveHandler)new ExRegen());
        ExplosiveRegistry.registerOrGetExplosive((String)"icbm", (String)"RegenLocal", (IExplosiveHandler)new ExRegenLocal());
        ExplosiveRegistry.registerOrGetExplosive((String)"icbm", (String)"MicroQuake", (IExplosiveHandler)new ExMicroQuake());
        ExplosiveRegistry.registerOrGetExplosive((String)"icbm", (String)"Cake", (IExplosiveHandler)new ECCake());
        ExplosiveRegistry.registerOrGetExplosive((String)"icbm", (String)"BiomeChange", (IExplosiveHandler)new ECBiomeChange());
        ExplosiveRegistry.registerOrGetExplosive((String)"icbm", (String)"OrePuller", (IExplosiveHandler)new ExOrePuller());
        ExplosiveRegistry.registerOrGetExplosive((String)"icbm", (String)"SlimeRain", (IExplosiveHandler)new ExSlimeRain());
        if (Engine.runningAsDev) {
            ExplosiveRegistry.registerOrGetExplosive((String)"icbm", (String)"SimplePathTest1", (IExplosiveHandler)new ExplosiveHandlerGeneric("SimplePathTest1", BlastPathTester.class, 1));
            ExplosiveRegistry.registerOrGetExplosive((String)"icbm", (String)"SimplePathTest2", (IExplosiveHandler)new ExplosiveHandlerGeneric("SimplePathTest2", BlastPathTester.class, 2));
            ExplosiveRegistry.registerOrGetExplosive((String)"icbm", (String)"SimplePathTest3", (IExplosiveHandler)new ExplosiveHandlerGeneric("SimplePathTest3", BlastPathTester.class, 3));
            ExplosiveRegistry.registerOrGetExplosive((String)"icbm", (String)"SimplePathTest10", (IExplosiveHandler)new ExplosiveHandlerGeneric("SimplePathTest10", BlastPathTester.class, 10));
            ExplosiveRegistry.registerOrGetExplosive((String)"icbm", (String)"SimplePathTest20", (IExplosiveHandler)new ExplosiveHandlerGeneric("SimplePathTest20", BlastPathTester.class, 20));
        }
    }
}

