/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.util.helpers;

import cofh.lib.util.helpers.MathHelper;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public final class FireworksHelper {
    private FireworksHelper() {
    }

    public static ItemStack getFireworksStack(int n, Explosion ... itemStack) {
        NBTTagCompound nBTTagCompound = new NBTTagCompound();
        NBTTagCompound nBTTagCompound2 = new NBTTagCompound();
        NBTTagList nBTTagList = new NBTTagList();
        if (itemStack != null) {
            for (Explosion explosion : itemStack) {
                if (explosion == null) continue;
                nBTTagList.func_74742_a((NBTBase)explosion.getTagCompound());
            }
        }
        nBTTagCompound2.func_74774_a("Flight", (byte)MathHelper.clamp(n, 0, 3));
        nBTTagCompound2.func_74782_a("Explosions", (NBTBase)nBTTagList);
        nBTTagCompound.func_74782_a("Fireworks", (NBTBase)nBTTagCompound2);
        ItemStack itemStack2 = new ItemStack(Items.field_151152_bP);
        itemStack2.func_77982_d(nBTTagCompound);
        return itemStack2;
    }

    public static ItemStack getRandomFireworks(int n, int n2, int n3, int n4) {
        n2 = MathHelper.clamp(n2, 0, Integer.MAX_VALUE);
        Explosion[] explosionArray = new Explosion[n2];
        for (int i = 0; i < n2; ++i) {
            explosionArray[i] = Explosion.getRandom(n3, n4);
        }
        return FireworksHelper.getFireworksStack(n, explosionArray);
    }

    public static final class Explosion {
        private boolean twinkle = false;
        private boolean trail = false;
        private List<Integer> primaryColors = new ArrayList<Integer>();
        private List<Integer> fadeColors = new ArrayList<Integer>();
        private Type type = Type.BALL;

        public static Explosion getRandom(int n, int n2) {
            Color color;
            int n3;
            n = MathHelper.clamp(n, 1, Integer.MAX_VALUE);
            n2 = MathHelper.clamp(n2, 1, Integer.MAX_VALUE);
            Explosion explosion = new Explosion();
            int n4 = MathHelper.RANDOM.nextInt(4);
            switch (n4) {
                case 0: 
                case 2: {
                    explosion.setTwinkle(true);
                    if (n4 == 0) break;
                }
                case 1: {
                    explosion.setTrail(true);
                }
            }
            explosion.setType(MathHelper.RANDOM.nextInt(5));
            for (n3 = 0; n3 < n; ++n3) {
                color = new Color(Color.HSBtoRGB(MathHelper.RANDOM.nextFloat() * 360.0f, MathHelper.RANDOM.nextFloat() * 0.15f + 0.8f, 0.85f));
                explosion.addPrimaryColor(color.getRed(), color.getGreen(), color.getBlue());
            }
            for (n3 = 0; n3 < n2; ++n3) {
                color = new Color(Color.HSBtoRGB(MathHelper.RANDOM.nextFloat() * 360.0f, MathHelper.RANDOM.nextFloat() * 0.15f + 0.8f, 0.85f));
                explosion.addFadeColor(color.getRed(), color.getGreen(), color.getBlue());
            }
            return explosion;
        }

        public Explosion setTwinkle(boolean bl) {
            this.twinkle = bl;
            return this;
        }

        public Explosion setTrail(boolean bl) {
            this.trail = bl;
            return this;
        }

        public Explosion setType(Type type) {
            this.type = type;
            return this;
        }

        public Explosion setType(int n) {
            this.setType(Type.values()[MathHelper.clamp(n, 0, Type.values().length - 1)]);
            return this;
        }

        public Explosion addPrimaryColor(int n, int n2, int n3) {
            this.primaryColors.add((n << 16) + (n2 << 8) + n3);
            return this;
        }

        public Explosion addFadeColor(int n, int n2, int n3) {
            this.fadeColors.add((n << 16) + (n2 << 8) + n3);
            return this;
        }

        public NBTTagCompound getTagCompound() {
            int n;
            NBTTagCompound nBTTagCompound = new NBTTagCompound();
            nBTTagCompound.func_74757_a("Flicker", this.twinkle);
            nBTTagCompound.func_74757_a("Trail", this.trail);
            nBTTagCompound.func_74774_a("Type", (byte)this.type.ordinal());
            int[] nArray = new int[this.primaryColors.size()];
            for (n = 0; n < this.primaryColors.size(); ++n) {
                nArray[n] = this.primaryColors.get(n);
            }
            nBTTagCompound.func_74783_a("Colors", nArray);
            nArray = new int[this.fadeColors.size()];
            for (n = 0; n < this.fadeColors.size(); ++n) {
                nArray[n] = this.fadeColors.get(n);
            }
            nBTTagCompound.func_74783_a("FadeColors", nArray);
            return nBTTagCompound;
        }

        public ItemStack getFireworkStarStack() {
            NBTTagCompound nBTTagCompound = new NBTTagCompound();
            NBTTagCompound nBTTagCompound2 = this.getTagCompound();
            nBTTagCompound.func_74782_a("Explosion", (NBTBase)nBTTagCompound2);
            ItemStack itemStack = new ItemStack(Items.field_151154_bQ);
            itemStack.func_77982_d(nBTTagCompound);
            return itemStack;
        }

        public static enum Type {
            BALL,
            LARGE_BALL,
            STAR,
            CREEPER,
            BURST;

        }
    }
}

