/*
 * Decompiled with CFR 0.152.
 */
package io.endertech.item;

import io.endertech.config.ItemConfig;
import io.endertech.handler.WorldEventHandler;
import io.endertech.item.IKeyHandler;
import io.endertech.item.ItemExchangerBase;
import io.endertech.util.BlockCoord;
import io.endertech.util.Exchange;
import io.endertech.util.Geometry;
import io.endertech.util.IItemBlockAffector;
import io.endertech.util.IOutlineDrawer;
import io.endertech.util.Key;
import io.endertech.util.RGBA;
import io.endertech.util.helper.KeyHelper;
import io.endertech.util.helper.LocalisationHelper;
import io.endertech.util.helper.LogHelper;
import io.endertech.util.helper.RenderHelper;
import io.endertech.util.helper.StringHelper;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import net.minecraftforge.common.util.ForgeDirection;

public class ItemExchanger
extends ItemExchangerBase
implements IKeyHandler,
IOutlineDrawer,
IItemBlockAffector {
    public static final int[] RECEIVE = new int[]{0, 2000, 20000};
    public static final int[] SEND = new int[]{10000000, 10000000, 10000000};
    public static final int[] CAPACITY = new int[]{0, 2000000, 10000000};
    public static Set<Block> creativeOverrideBlocks;
    private static Set<Key.KeyCode> handledKeys;

    public ItemExchanger() {
        this.setNoRepair();
    }

    public static boolean isCreative(ItemStack stack) {
        if (stack == null) {
            return false;
        }
        return stack.func_77960_j() == Types.CREATIVE.ordinal();
    }

    @Override
    public int getMaxEnergyStored(ItemStack stack) {
        return CAPACITY[stack.func_77960_j()];
    }

    @Override
    public int getMaxReceiveRate(ItemStack stack) {
        return RECEIVE[stack.func_77960_j()];
    }

    @Override
    public int getMaxExtractRate(ItemStack stack) {
        return SEND[stack.func_77960_j()];
    }

    @Override
    public boolean isDamaged(ItemStack stack) {
        return stack.func_77960_j() != 0;
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean check) {
        super.func_77624_a(stack, player, list, check);
        if (KeyHelper.isShiftDown()) {
            ItemStack pb;
            if (stack.field_77990_d == null) {
                ItemExchanger.setDefaultTag(stack, 0);
            }
            if (ItemExchanger.isCreative(stack)) {
                list.add(LocalisationHelper.localiseString("info.charge", "Infinite"));
            } else {
                list.add(LocalisationHelper.localiseString("info.charge", StringHelper.getEnergyString(this.getEnergyStored(stack)) + " / " + StringHelper.getEnergyString(this.getMaxEnergyStored(stack)) + " RF"));
            }
            if (this.getMaxReceiveRate(stack) > 0) {
                list.add(LocalisationHelper.localiseString("info.charge.receive", StringHelper.getEnergyString(this.getMaxReceiveRate(stack)) + " RF/t"));
            }
            if ((pb = this.getSourceItemStack(stack)) == null) {
                list.add(LocalisationHelper.localiseString("info.exchanger.source", "None"));
            } else {
                list.add(EnumChatFormatting.GREEN + LocalisationHelper.localiseString("info.exchanger.source", pb.func_82833_r()) + EnumChatFormatting.RESET);
            }
            list.add(EnumChatFormatting.GREEN + LocalisationHelper.localiseString("info.exchanger.radius", this.getTargetRadius(stack)));
            list.add(EnumChatFormatting.AQUA + "" + EnumChatFormatting.ITALIC + LocalisationHelper.localiseString("info.exchanger.shift_to_select_source", new Object[0]) + EnumChatFormatting.RESET);
        } else {
            list.add(StringHelper.holdShiftForDetails);
        }
    }

    public boolean func_77648_a(ItemStack itemstack, EntityPlayer player, World world, int x, int y, int z, int side, float xFloat, float yFloat, float zFloat) {
        int meta;
        Block source;
        BlockCoord coord;
        LogHelper.debug("Exchanger use on " + x + " " + y + " " + z, new Object[0]);
        if (player.func_70093_af()) {
            LogHelper.debug("Shift right click", new Object[0]);
            Block source2 = player.field_70170_p.func_147439_a(x, y, z);
            int sourceMeta = player.field_70170_p.func_72805_g(x, y, z);
            if (Exchange.blockSuitableForSelection(new BlockCoord(x, y, z), world, source2, sourceMeta, itemstack)) {
                LogHelper.debug("Setting source block to " + source2.func_149732_F(), new Object[0]);
                this.setSourceBlock(itemstack, new ItemStack(source2, 1, sourceMeta));
            } else {
                LogHelper.debug("Failed to set source block", new Object[0]);
            }
            return false;
        }
        ItemStack pb = this.getSourceItemStack(itemstack);
        if (pb != null && player.field_70170_p.func_147438_o(x, y, z) == null && !player.field_70170_p.field_72995_K && Exchange.blockSuitableForExchange(coord = new BlockCoord(x, y, z), world, source = player.field_70170_p.func_147439_a(x, y, z), meta = player.field_70170_p.func_72805_g(x, y, z), pb, itemstack, 0)) {
            WorldEventHandler.queueExchangeRequest(player.field_70170_p, coord, this.getTargetRadius(itemstack), source, meta, pb, player, player.field_71071_by.field_70461_c, ForgeDirection.getOrientation((int)side));
        }
        return true;
    }

    @Override
    public int extractEnergy(ItemStack container, int maxExtract, boolean simulate) {
        if (ItemExchanger.isCreative(container)) {
            return maxExtract;
        }
        return super.extractEnergy(container, maxExtract, simulate);
    }

    public void setSourceBlock(ItemStack stack, ItemStack source) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        NBTTagCompound sourceNBT = new NBTTagCompound();
        stack.func_77983_a("source", (NBTBase)source.func_77955_b(sourceNBT));
    }

    public ItemStack getSourceItemStack(ItemStack stack) {
        boolean hasKey;
        boolean bl = hasKey = stack.func_77942_o() && stack.field_77990_d.func_74764_b("source");
        if (hasKey) {
            ItemStack ret = new ItemStack(Blocks.field_150350_a);
            ret.func_77963_c(stack.field_77990_d.func_74775_l("source"));
            return ret;
        }
        return null;
    }

    public void setTargetRadius(ItemStack stack, int radius) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.func_77978_p().func_74768_a("targetRadius", radius);
    }

    public int getTargetRadius(ItemStack stack) {
        int radius = 3;
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("targetRadius")) {
            radius = stack.func_77978_p().func_74762_e("targetRadius");
        }
        if (radius > ItemConfig.itemExchangerMaxRadius) {
            radius = ItemConfig.itemExchangerMaxRadius;
        }
        return radius;
    }

    @Override
    public void handleKey(EntityPlayer player, ItemStack itemStack, Key.KeyCode key) {
        LogHelper.debug("Handling key for Exchanger " + key.toString(), new Object[0]);
        int radius = this.getTargetRadius(itemStack);
        if (key == Key.KeyCode.TOOL_INCREASE) {
            radius = player.func_70093_af() ? ItemConfig.itemExchangerMaxRadius : ++radius;
            LogHelper.debug("Tool Increase", new Object[0]);
        } else if (key == Key.KeyCode.TOOL_DECREASE) {
            radius = player.func_70093_af() ? 1 : --radius;
            LogHelper.debug("Tool Decrease", new Object[0]);
        }
        if (radius > ItemConfig.itemExchangerMaxRadius) {
            radius = ItemConfig.itemExchangerMaxRadius;
        }
        if (radius < 1) {
            radius = 1;
        }
        LogHelper.debug("Setting tool radius to " + radius, new Object[0]);
        this.setTargetRadius(itemStack, radius);
    }

    @Override
    public Set<Key.KeyCode> getHandledKeys() {
        return handledKeys;
    }

    @Override
    public EnumRarity func_77613_e(ItemStack par1ItemStack) {
        int type = par1ItemStack.func_77960_j();
        if (type == Types.CREATIVE.ordinal()) {
            return EnumRarity.epic;
        }
        if (type == Types.REDSTONE.ordinal()) {
            return EnumRarity.uncommon;
        }
        if (type == Types.RESONANT.ordinal()) {
            return EnumRarity.rare;
        }
        return EnumRarity.common;
    }

    @Override
    public boolean drawOutline(DrawBlockHighlightEvent event) {
        BlockCoord target = new BlockCoord(event.target.field_72311_b, event.target.field_72312_c, event.target.field_72309_d);
        World world = event.player.field_70170_p;
        if (event.player.func_70093_af()) {
            int blockMeta;
            Block block = world.func_147439_a(target.x, target.y, target.z);
            if (!Exchange.blockSuitableForSelection(target, world, block, blockMeta = world.func_72805_g(target.x, target.y, target.z), event.player.func_71045_bC())) {
                RenderHelper.renderBlockOutline(event.context, event.player, target, RGBA.Red.setAlpha(0.6f), 2.0f, event.partialTicks);
            } else {
                RenderHelper.renderBlockOutline(event.context, event.player, target, RGBA.Green.setAlpha(0.6f), 2.0f, event.partialTicks);
            }
            return true;
        }
        if (this.getSourceItemStack(event.currentItem) == null) {
            return false;
        }
        Set<BlockCoord> blocks = this.blocksAffected(event.currentItem, world, target, ForgeDirection.getOrientation((int)event.target.field_72310_e));
        if (blocks == null || blocks.size() == 0) {
            return false;
        }
        for (BlockCoord blockCoord : blocks) {
            RenderHelper.renderBlockOutline(event.context, event.player, blockCoord, RGBA.White.setAlpha(0.6f), 2.0f, event.partialTicks);
        }
        return true;
    }

    @Override
    public Set<BlockCoord> blocksAffected(ItemStack item, World world, BlockCoord origin, ForgeDirection side) {
        if (!(item.func_77973_b() instanceof ItemExchanger)) {
            return null;
        }
        LinkedHashSet<BlockCoord> ret = new LinkedHashSet<BlockCoord>();
        int exchangerRadius = this.getTargetRadius(item) - 1;
        Block targetBlock = world.func_147439_a(origin.x, origin.y, origin.z);
        int targetMeta = world.func_72805_g(origin.x, origin.y, origin.z);
        for (int radius = 0; radius <= exchangerRadius; ++radius) {
            Set<BlockCoord> squareSet = Geometry.squareSet(radius, new BlockCoord(origin.x, origin.y, origin.z), side);
            for (BlockCoord blockCoord : squareSet) {
                if (!Exchange.blockSuitableForExchange(blockCoord, world, targetBlock, targetMeta, this.getSourceItemStack(item), item, radius)) continue;
                ret.add(blockCoord);
            }
        }
        return ret;
    }

    static {
        handledKeys = new HashSet<Key.KeyCode>();
        handledKeys.add(Key.KeyCode.TOOL_INCREASE);
        handledKeys.add(Key.KeyCode.TOOL_DECREASE);
        creativeOverrideBlocks = new HashSet<Block>();
        creativeOverrideBlocks.add(Blocks.field_150357_h);
    }

    public static enum Types {
        CREATIVE,
        REDSTONE,
        RESONANT;

    }
}

