/*
 * Decompiled with CFR 0.152.
 */
package universalteam.flatbedrock.handler;

import com.google.common.collect.Lists;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.event.FMLInterModComms;
import java.util.List;
import net.minecraft.nbt.NBTTagCompound;
import universalteam.flatbedrock.custom.CustomDimensionManager;

public class IMCHandler {
    public static int number = 0;
    public static List<CustomDimensionManager.DimensionEntry> entries = Lists.newArrayList();

    public static void processMessages(List<FMLInterModComms.IMCMessage> messages) {
        for (FMLInterModComms.IMCMessage message : messages) {
            if (!message.key.equals("addDimension") || !message.isNBTMessage() || !message.getNBTValue().func_74764_b("dimensionID") || IMCHandler.hasMessage(message.getNBTValue().func_74762_e("dimensionID"))) continue;
            IMCHandler.handleDimensionMessage(message.getNBTValue(), message.getSender());
        }
    }

    public static boolean hasMessage(int dimID) {
        for (CustomDimensionManager.DimensionEntry entry : entries) {
            if (entry.dimID != dimID) continue;
            return true;
        }
        return false;
    }

    public static void handleDimensionMessage(NBTTagCompound compound, String modID) {
        CustomDimensionManager.DimensionEntry dimension = new CustomDimensionManager.DimensionEntry();
        if (!compound.func_74764_b("fileName")) {
            FMLLog.severe((String)"[%s] %s didn't set a fileName value in it's IMC message, aborting! This will not flatten the bedrock in the specified dimension!", (Object[])new Object[]{"FlatBedrockx", modID});
            return;
        }
        String fileName = compound.func_74779_i("fileName");
        if (CustomDimensionManager.doesFileExist(fileName)) {
            return;
        }
        if (!compound.func_74764_b("dimensionID")) {
            FMLLog.severe((String)"[%s] %s didn't set a dimensionID value in it's IMC message, aborting! This will not flatten the bedrock in the specified dimension!", (Object[])new Object[]{"FlatBedrockx", modID});
            return;
        }
        dimension.dimID = compound.func_74762_e("dimensionID");
        dimension.genTop = compound.func_74764_b("generateFlatTop") ? compound.func_74767_n("generateFlatTop") : true;
        dimension.genBottom = compound.func_74764_b("generateFlatBottom") ? compound.func_74767_n("generateFlatBottom") : true;
        dimension.fillBlock = compound.func_74764_b("fillBlock") ? compound.func_74779_i("fillBlock") : "minecraft:stone";
        dimension.retroGenTop = false;
        dimension.retroGenBottom = false;
        CustomDimensionManager.createJSONFile(fileName, dimension);
    }
}

