/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.dimension.world.types;

import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.BiomeDictionary;

public enum ControllerType {
    CONTROLLER_DEFAULT(0, null),
    CONTROLLER_SINGLE(1, null),
    CONTROLLER_CHECKERBOARD(2, null),
    CONTROLLER_COLD(0, new BiomeFilter(){

        @Override
        public boolean match(BiomeGenBase biome) {
            return biome.func_150561_m() == BiomeGenBase.TempCategory.COLD;
        }

        @Override
        public double calculateBiomeDistance(BiomeGenBase a, BiomeGenBase b) {
            return this.calculateBiomeDistance(a, b, false, true, false);
        }
    }),
    CONTROLLER_MEDIUM(0, new BiomeFilter(){

        @Override
        public boolean match(BiomeGenBase biome) {
            return biome.func_150561_m() == BiomeGenBase.TempCategory.MEDIUM;
        }

        @Override
        public double calculateBiomeDistance(BiomeGenBase a, BiomeGenBase b) {
            return this.calculateBiomeDistance(a, b, false, true, false);
        }
    }),
    CONTROLLER_WARM(0, new BiomeFilter(){

        @Override
        public boolean match(BiomeGenBase biome) {
            return biome.func_150561_m() == BiomeGenBase.TempCategory.WARM;
        }

        @Override
        public double calculateBiomeDistance(BiomeGenBase a, BiomeGenBase b) {
            return this.calculateBiomeDistance(a, b, false, true, false);
        }
    }),
    CONTROLLER_DRY(0, new BiomeFilter(){

        @Override
        public boolean match(BiomeGenBase biome) {
            return (double)biome.field_76751_G < 0.1;
        }

        @Override
        public double calculateBiomeDistance(BiomeGenBase a, BiomeGenBase b) {
            return this.calculateBiomeDistance(a, b, true, false, false);
        }
    }),
    CONTROLLER_WET(0, new BiomeFilter(){

        @Override
        public boolean match(BiomeGenBase biome) {
            return biome.func_76736_e();
        }

        @Override
        public double calculateBiomeDistance(BiomeGenBase a, BiomeGenBase b) {
            return this.calculateBiomeDistance(a, b, true, false, false);
        }
    }),
    CONTROLLER_FIELDS(0, new BiomeFilter(){

        @Override
        public boolean match(BiomeGenBase biome) {
            return (double)biome.field_76749_E < 0.11 && biome.field_76748_D < 0.25f;
        }

        @Override
        public double calculateBiomeDistance(BiomeGenBase a, BiomeGenBase b) {
            return this.calculateBiomeDistance(a, b, false, false, true);
        }
    }),
    CONTROLLER_MOUNTAINS(0, new BiomeFilter(){

        @Override
        public boolean match(BiomeGenBase biome) {
            return biome.field_76749_E > 0.45f;
        }

        @Override
        public double calculateBiomeDistance(BiomeGenBase a, BiomeGenBase b) {
            return this.calculateBiomeDistance(a, b, false, false, true);
        }
    }),
    CONTROLLER_FILTERED(-1, null),
    CONTROLLER_MAGICAL(0, new BiomeFilter(){

        @Override
        public boolean match(BiomeGenBase biome) {
            return BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.MAGICAL) || BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SPOOKY);
        }

        @Override
        public double calculateBiomeDistance(BiomeGenBase a, BiomeGenBase b) {
            return this.calculateBiomeDistance(a, b, false, false, false);
        }
    }),
    CONTROLLER_FOREST(0, new BiomeFilter(){

        @Override
        public boolean match(BiomeGenBase biome) {
            return biome.field_76760_I.field_76832_z >= 5;
        }

        @Override
        public double calculateBiomeDistance(BiomeGenBase a, BiomeGenBase b) {
            return this.calculateBiomeDistance(a, b, false, false, false);
        }
    });

    private final int neededBiomes;
    private final BiomeFilter filter;

    private ControllerType(int neededBiomes, BiomeFilter filter) {
        this.neededBiomes = neededBiomes;
        this.filter = filter;
    }

    public int getNeededBiomes() {
        return this.neededBiomes;
    }

    public BiomeFilter getFilter() {
        return this.filter;
    }

    public static abstract class BiomeFilter {
        public abstract boolean match(BiomeGenBase var1);

        public abstract double calculateBiomeDistance(BiomeGenBase var1, BiomeGenBase var2);

        public double calculateBiomeDistance(BiomeGenBase a, BiomeGenBase b, boolean ignoreRain, boolean ignoreTemperature, boolean ignoreHeight) {
            float dr = a.field_76751_G - b.field_76751_G;
            if (ignoreRain) {
                dr = 0.0f;
            }
            float dt = a.field_76750_F - b.field_76750_F;
            if (ignoreTemperature) {
                dt = 0.0f;
            }
            float dv = a.field_76749_E - b.field_76749_E;
            float dh = a.field_76748_D - b.field_76748_D;
            if (ignoreHeight) {
                dv = 0.0f;
                dh = 0.0f;
            }
            return Math.sqrt(dr * dr + dt * dt + dv * dv + dh * dh);
        }
    }
}

