/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.commands;

import java.util.UUID;
import mcjty.rftools.blocks.dimlets.DimletSetup;
import mcjty.rftools.commands.AbstractRfToolsCommand;
import mcjty.rftools.dimension.DimensionInformation;
import mcjty.rftools.dimension.RfToolsDimensionManager;
import mcjty.rftools.dimension.description.DimensionDescriptor;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.DimensionManager;

public class CmdRecover
extends AbstractRfToolsCommand {
    @Override
    public String getHelp() {
        return "[<dimension>]";
    }

    @Override
    public String getCommand() {
        return "recover";
    }

    @Override
    public int getPermissionLevel() {
        return 2;
    }

    @Override
    public boolean isClientSide() {
        return false;
    }

    @Override
    public void execute(ICommandSender sender, String[] args) {
        RfToolsDimensionManager dimensionManager;
        DimensionInformation information;
        if (args.length > 2) {
            sender.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + "Too many parameters!"));
            return;
        }
        World world = sender.func_130014_f_();
        ItemStack heldItem = null;
        String playerName = null;
        UUID playerUUID = null;
        if (sender instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)sender;
            heldItem = player.func_70694_bm();
            playerName = player.getDisplayName();
            playerUUID = player.func_146103_bH().getId();
        }
        if (heldItem == null || heldItem.func_77973_b() != DimletSetup.realizedDimensionTab) {
            sender.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + "You need to hold a realized dimension tab in your hand!"));
            return;
        }
        int specifiedDim = -1;
        if (args.length == 2) {
            specifiedDim = this.fetchInt(sender, args, 1, -1);
        }
        NBTTagCompound tagCompound = heldItem.func_77978_p();
        int dim = tagCompound.func_74762_e("id");
        if (!tagCompound.func_74764_b("id") || dim == 0 || dim == -1) {
            if (specifiedDim == -1) {
                sender.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + "The dimension id is missing from the tab!"));
                sender.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + "You can specify a dimension id manually"));
                return;
            }
            dim = specifiedDim;
        }
        if ((information = (dimensionManager = RfToolsDimensionManager.getDimensionManager(world)).getDimensionInformation(dim)) != null) {
            sender.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + "The dimension information is already present!"));
            return;
        }
        if (DimensionManager.isDimensionRegistered((int)dim)) {
            sender.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + "This dimension is already registered!"));
            return;
        }
        DimensionDescriptor descriptor = new DimensionDescriptor(tagCompound);
        String name = tagCompound.func_74779_i("name");
        dimensionManager.recoverDimension(world, dim, descriptor, name, playerName, playerUUID);
        sender.func_145747_a((IChatComponent)new ChatComponentText("Dimension was succesfully recovered"));
    }
}

