/*
 * Decompiled with CFR 0.152.
 */
package com.jdlogic.ranchablefluidcows.ranchable;

import cofh.lib.inventory.IInventoryManager;
import cofh.lib.inventory.InventoryManager;
import com.jdlogic.ranchablefluidcows.RanchableFluidCows;
import com.jdlogic.ranchablefluidcows.handler.ConfigHandler;
import com.jdlogic.ranchablefluidcows.network.CowUpdateMessage;
import com.robrit.moofluids.common.entity.EntityFluidCow;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import powercrystals.minefactoryreloaded.api.IFactoryRanchable;
import powercrystals.minefactoryreloaded.api.RanchedItem;
import powercrystals.minefactoryreloaded.tile.machine.TileEntityRancher;

public class RanchableFC
implements IFactoryRanchable {
    @Override
    public Class<? extends EntityLivingBase> getRanchableEntity() {
        return EntityFluidCow.class;
    }

    @Override
    public List<RanchedItem> ranch(World world, EntityLivingBase entity, IInventory rancher) {
        if (entity instanceof EntityFluidCow) {
            EntityFluidCow entityFluidCow = (EntityFluidCow)entity;
            if (entityFluidCow.getCurrentUseCooldown() > 0) {
                RanchableFC.updateClient(entityFluidCow, world.func_82737_E());
                return null;
            }
            List<RanchedItem> retList = RanchableFC.getAcceptableItemList(entityFluidCow.getEntityFluid(), rancher);
            if (retList != null) {
                int maxCooldown = (int)((float)entityFluidCow.getEntityTypeData().getMaxUseCooldown() * ConfigHandler.penaltyMultiplier);
                entityFluidCow.setCurrentUseCooldown(maxCooldown);
                RanchableFC.sendPacket(entityFluidCow);
                return retList;
            }
        }
        return null;
    }

    public static void updateClient(EntityFluidCow fluidCow, long worldTime) {
        NBTTagCompound tag = fluidCow.getEntityData();
        if (tag.func_74764_b("rfc:nextUpdate") && tag.func_74763_f("rfc:nextUpdate") > worldTime) {
            return;
        }
        RanchableFC.sendPacket(fluidCow);
        tag.func_74772_a("rfc:nextUpdate", worldTime + 200L);
    }

    public static void sendPacket(EntityFluidCow fluidCow) {
        NetworkRegistry.TargetPoint targetPoint = new NetworkRegistry.TargetPoint(fluidCow.field_71093_bK, fluidCow.field_70165_t, fluidCow.field_70163_u, fluidCow.field_70161_v, 128.0);
        RanchableFluidCows.network.sendToAllAround((IMessage)new CowUpdateMessage(fluidCow), targetPoint);
    }

    public static List<RanchedItem> getAcceptableItemList(Fluid cowFluid, IInventory inv) {
        ItemStack filledItemStack;
        ItemStack bucket;
        FluidStack localFluidStack = new FluidStack(cowFluid, 1000);
        IInventoryManager localIInventoryManager = InventoryManager.create((Object)inv, (ForgeDirection)ForgeDirection.UP);
        int i = localIInventoryManager.findItem(bucket = new ItemStack(Items.field_151133_ar));
        if (i >= 0 && (filledItemStack = FluidContainerRegistry.fillFluidContainer((FluidStack)localFluidStack, (ItemStack)bucket)) != null) {
            LinkedList<RanchedItem> retList = new LinkedList<RanchedItem>();
            retList.add(new RanchedItem(filledItemStack));
            inv.func_70298_a(i, 1);
            return retList;
        }
        if (inv instanceof TileEntityRancher) {
            FluidTankInfo[] tankInfoArr;
            TileEntityRancher rancher = (TileEntityRancher)inv;
            for (FluidTankInfo tankInfo : tankInfoArr = rancher.getTankInfo(ForgeDirection.UP)) {
                if (tankInfo.fluid != null && (tankInfo.fluid.getFluid() != cowFluid || rancher.fill(localFluidStack, false) != 1000)) continue;
                LinkedList<RanchedItem> retList = new LinkedList<RanchedItem>();
                retList.add(new RanchedItem(localFluidStack));
                return retList;
            }
        }
        return null;
    }
}

