/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.guide;

import cpw.mods.fml.common.ObfuscationReflectionHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;
import shetiphian.core.client.GuiFunctions;
import shetiphian.core.client.Localization;
import shetiphian.core.common.Function;
import shetiphian.guide.ButtonLink;
import shetiphian.guide.GuideLoader;
import shetiphian.guide.GuidePage;

public class GuideGUI
extends GuiScreen {
    private static final ResourceLocation background = new ResourceLocation("shetiphianguide", "gui/blank.png");
    private GuidePage currentPage;
    private String[] modpagekeys;
    private int xSize;
    private int ySize;
    private int guiLeft;
    private int guiTop;
    private int pageindex;
    private Map<String, GuidePage> activemod;
    private Stack<GuidePage> history = new Stack();
    private long lastkey;
    private ItemStack coalstack = new ItemStack(Items.field_151044_h);
    private ItemStack hoverstack;
    private boolean loadmouse;
    private Object[] currentRecipeParts = null;
    private List<ItemStack> currentRecipeCache = null;
    private int currentRecipeCountdown = 0;

    public void func_73866_w_() {
        this.xSize = 182;
        this.ySize = 193;
        this.guiLeft = (this.field_146294_l - this.xSize) / 2;
        this.guiTop = (this.field_146295_m - this.ySize) / 2 - 18;
        this.modpagekeys = GuideLoader.getModKeys();
        this.setupButtons();
    }

    private void setupButtons() {
        this.field_146292_n.clear();
        this.field_146292_n.add(new ButtonLink(0, "", "MENU", this.guiLeft + 8, this.guiTop + 8, 10, 10, background, 0, 204, 10, 204));
        this.field_146292_n.add(new ButtonLink(1, "", "EXIT", this.guiLeft + 164, this.guiTop + 8, 10, 10, background, 20, 204, 30, 204));
        this.field_146292_n.add(new ButtonLink(2, "", "BACK", this.guiLeft + 10, this.guiTop + 173, 79, 10, background, 0, 246, 83, 246));
        this.field_146292_n.add(new ButtonLink(3, "", "NEXT", this.guiLeft + 93, this.guiTop + 173, 79, 10, background, 0, 246, 83, 246));
        this.field_146292_n.add(new ButtonLink(4, "", "INFO", this.guiLeft + 160, this.guiTop + 96, 10, 10, background, 40, 204, 50, 204));
        this.field_146292_n.add(new ButtonLink(5, "", "RETN", this.guiLeft + 20, this.guiTop + 8, 10, 10, background, 60, 204, 70, 204));
        ((GuiButton)this.field_146292_n.get((int)4)).field_146125_m = false;
        boolean bl = ((GuiButton)this.field_146292_n.get((int)5)).field_146125_m = !this.history.isEmpty();
        if (this.currentPage == null) {
            int modindex;
            ((GuiButton)this.field_146292_n.get((int)2)).field_146125_m = this.pageindex > 0;
            ((GuiButton)this.field_146292_n.get((int)3)).field_146125_m = this.modpagekeys.length - this.pageindex * 8 > 8;
            for (int index = 0; index < 8 && this.modpagekeys.length > (modindex = this.pageindex * 8 + index); index = (int)((byte)(index + 1))) {
                this.field_146292_n.add(new ButtonLink(index + 6, this.modpagekeys[modindex], this.modpagekeys[modindex], this.guiLeft + 10, this.guiTop + 29 + index * 18, 162, 16, background, 0, 214, 0, 230));
            }
        } else {
            ((GuiButton)this.field_146292_n.get((int)2)).field_146125_m = this.currentPage.hasLinkBack();
            ((GuiButton)this.field_146292_n.get((int)3)).field_146125_m = this.currentPage.hasLinkNext();
            switch (this.currentPage.getType()) {
                case TOC: {
                    boolean single = !this.currentPage.hasLinkBack() && !this.currentPage.hasLinkNext();
                    for (int index = 0; index < (single ? 17 : 15) && index < this.currentPage.getLinkList().size(); index = (int)((byte)(index + 1))) {
                        GuidePage page = this.activemod.get(this.currentPage.getLinkList().get(index));
                        if (page == null) continue;
                        int posx = this.guiLeft + 11;
                        int posy = this.guiTop + 29 + index * 9;
                        if (!single) {
                            posy += 3;
                        }
                        this.field_146292_n.add(new ButtonLink(index + 6, page.getTitle(), page.getId(), posx, posy, 160, 9));
                    }
                    break;
                }
                case TEXT: {
                    break;
                }
                case CUSTOM: 
                case IMAGE: {
                    if (!this.currentPage.hasText()) {
                        ((GuiButton)this.field_146292_n.get((int)4)).field_146129_i = 185;
                    }
                }
                default: {
                    ((GuiButton)this.field_146292_n.get((int)2)).field_146125_m = false;
                    ((GuiButton)this.field_146292_n.get((int)3)).field_146125_m = false;
                    if (!this.currentPage.hasLinkNext()) break;
                    ((ButtonLink)((Object)this.field_146292_n.get(4))).setLink("", this.currentPage.getLinkNext());
                    ((GuiButton)this.field_146292_n.get((int)4)).field_146125_m = true;
                }
            }
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        if (this.loadmouse) {
            Mouse.setGrabbed((boolean)false);
            this.loadmouse = false;
        }
        this.hoverstack = null;
        if (this.currentPage == null) {
            this.drawBackground(background);
            this.drawTitle(Localization.get("info.shetiphian.guide.txt"));
        } else {
            this.drawModScreen(mouseX, mouseY);
        }
        super.func_73863_a(mouseX, mouseY, partialTicks);
        if (this.hoverstack != null) {
            GuiFunctions.renderToolTip(this.hoverstack, mouseX, mouseY, this);
        }
    }

    public void drawModScreen(int mouseX, int mouseY) {
        switch (this.currentPage.getType()) {
            case TOC: 
            case TEXT: {
                if (!this.currentPage.hasLinkBack() && !this.currentPage.hasLinkNext()) {
                    this.drawBackground(GuidePage.EnumPageType.TEXT.getBackground());
                    break;
                }
                this.drawBackground(GuidePage.EnumPageType.TOC.getBackground());
                break;
            }
            case IMAGE: {
                if (!this.currentPage.hasText()) {
                    this.drawBackground(background);
                    break;
                }
            }
            default: {
                this.drawBackground(this.currentPage.getBackground());
            }
        }
        this.drawTitle(this.currentPage.getTitle());
        switch (this.currentPage.getType()) {
            case CRAFTING: {
                if (this.currentRecipeParts == null) {
                    ItemStack search = this.currentPage.getCraftOutput();
                    for (Object recipeObject : CraftingManager.func_77594_a().func_77592_b()) {
                        IRecipe recipe;
                        ItemStack output;
                        if (!(recipeObject instanceof IRecipe) || (output = (recipe = (IRecipe)recipeObject).func_77571_b()) == null || output.field_77994_a != search.field_77994_a || !output.func_77969_a(search)) continue;
                        if (recipe instanceof ShapelessRecipes) {
                            this.currentRecipeParts = new Object[recipe.func_77570_a()];
                            int item = 0;
                            for (Object stackObject : ((ShapelessRecipes)recipe).field_77579_b) {
                                if (!(stackObject instanceof ItemStack)) continue;
                                this.currentRecipeParts[item] = (ItemStack)stackObject;
                                ++item;
                            }
                        } else if (recipe instanceof ShapedRecipes) {
                            ShapedRecipes shapedRecipe = (ShapedRecipes)recipe;
                            this.currentRecipeParts = new Object[9];
                            int item = 0;
                            for (int height = 0; height < 3; height = (int)((byte)(height + 1))) {
                                for (int width = 0; width < 3; width = (int)((byte)(width + 1))) {
                                    if (height + 1 <= shapedRecipe.field_77577_c && width + 1 <= shapedRecipe.field_77576_b) {
                                        this.currentRecipeParts[height * 3 + width] = shapedRecipe.field_77574_d[item];
                                        ++item;
                                        continue;
                                    }
                                    this.currentRecipeParts[height * 3 + width] = null;
                                }
                            }
                        } else if (recipe instanceof ShapelessOreRecipe) {
                            this.currentRecipeParts = new Object[recipe.func_77570_a()];
                            int item = 0;
                            for (Object stack : ((ShapelessOreRecipe)recipe).getInput()) {
                                this.currentRecipeParts[item] = stack;
                                ++item;
                            }
                        } else {
                            if (!(recipe instanceof ShapedOreRecipe)) break;
                            ShapedOreRecipe shapedRecipe = (ShapedOreRecipe)recipe;
                            this.currentRecipeParts = new Object[9];
                            int recipeWidth = (Integer)ObfuscationReflectionHelper.getPrivateValue(ShapedOreRecipe.class, (Object)shapedRecipe, (String[])new String[]{"width"});
                            int recipeHeight = (Integer)ObfuscationReflectionHelper.getPrivateValue(ShapedOreRecipe.class, (Object)shapedRecipe, (String[])new String[]{"height"});
                            int item = 0;
                            for (int height = 0; height < 3; height = (int)((byte)(height + 1))) {
                                for (int width = 0; width < 3; width = (int)((byte)(width + 1))) {
                                    if (height + 1 <= recipeHeight && width + 1 <= recipeWidth) {
                                        this.currentRecipeParts[height * 3 + width] = shapedRecipe.getInput()[item];
                                        ++item;
                                        continue;
                                    }
                                    this.currentRecipeParts[height * 3 + width] = null;
                                }
                            }
                        }
                        break;
                    }
                }
                if (this.currentRecipeParts != null) {
                    if (this.currentRecipeCache == null || this.currentRecipeCountdown > 20) {
                        this.currentRecipeCountdown = 0;
                        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
                        for (Object item : this.currentRecipeParts) {
                            if (item instanceof ItemStack) {
                                ItemStack stack = ((ItemStack)item).func_77946_l();
                                if (stack.func_77960_j() == Short.MAX_VALUE) {
                                    ArrayList stacks = new ArrayList();
                                    stack.func_77973_b().func_150895_a(stack.func_77973_b(), CreativeTabs.field_78027_g, stacks);
                                    stack = ((ItemStack)stacks.get(this.field_146297_k.field_71441_e.field_73012_v.nextInt(stacks.size()))).func_77946_l();
                                }
                                list.add(stack);
                                continue;
                            }
                            if (item instanceof List) {
                                Object object;
                                List array = (List)item;
                                Object v0 = object = array.size() > 0 ? array.get(this.field_146297_k.field_71441_e.field_73012_v.nextInt(array.size())) : null;
                                if (object instanceof ItemStack) {
                                    ItemStack stack = ((ItemStack)object).func_77946_l();
                                    if (stack.func_77960_j() == Short.MAX_VALUE) {
                                        ArrayList stacks = new ArrayList();
                                        stack.func_77973_b().func_150895_a(stack.func_77973_b(), CreativeTabs.field_78027_g, stacks);
                                        stack = ((ItemStack)stacks.get(this.field_146297_k.field_71441_e.field_73012_v.nextInt(stacks.size()))).func_77946_l();
                                    }
                                    list.add(stack);
                                    continue;
                                }
                            }
                            list.add(null);
                        }
                        this.currentRecipeCache = list;
                    }
                    ++this.currentRecipeCountdown;
                    this.drawGrid(this.currentRecipeCache, 33, 39, mouseX, mouseY);
                }
                this.drawStack(this.currentPage.getCraftOutput(), 128, 58, mouseX, mouseY);
                this.drawText(this.currentPage.getText(), false);
                break;
            }
            case IMAGE: {
                if (this.currentPage.hasText()) {
                    this.drawImage(this.currentPage.getImage(), false);
                    this.drawText(this.currentPage.getText(), false);
                    break;
                }
                this.drawImage(this.currentPage.getImage(), true);
                break;
            }
            case SMELTING: {
                if (this.currentRecipeParts == null) {
                    for (Map.Entry entryObject : FurnaceRecipes.func_77602_a().func_77599_b().entrySet()) {
                        Map.Entry entry;
                        if (!(entryObject instanceof Map.Entry) || !((entry = entryObject).getValue() instanceof ItemStack) || !Function.areItemStacksEqual((ItemStack)entry.getValue(), this.currentPage.getCraftOutput())) continue;
                        this.currentRecipeParts = new Object[1];
                        this.currentRecipeParts[0] = entry.getKey();
                    }
                }
                if (this.currentRecipeParts != null) {
                    if (this.currentRecipeCache == null || this.currentRecipeCountdown > 20) {
                        this.currentRecipeCountdown = 0;
                        ArrayList list = new ArrayList();
                        if (this.currentRecipeParts[0] instanceof ItemStack) {
                            ItemStack stack = ((ItemStack)this.currentRecipeParts[0]).func_77946_l();
                            if (stack.func_77960_j() == Short.MAX_VALUE) {
                                ArrayList stacks = new ArrayList();
                                stack.func_77973_b().func_150895_a(stack.func_77973_b(), CreativeTabs.field_78027_g, stacks);
                                stack = ((ItemStack)stacks.get(this.field_146297_k.field_71441_e.field_73012_v.nextInt(stacks.size()))).func_77946_l();
                            }
                            list.add(stack);
                        }
                        this.currentRecipeCache = list;
                    }
                    this.drawStack(this.currentRecipeCache.get(0), 51, 40, mouseX, mouseY);
                }
                this.drawStack(this.coalstack, 51, 76, mouseX, mouseY);
                this.drawStack(this.currentPage.getCraftOutput(), 111, 58, mouseX, mouseY);
                this.drawText(this.currentPage.getText(), false);
                break;
            }
            case TEXT: {
                this.drawText(this.currentPage.getText(), true);
                break;
            }
        }
    }

    private void drawBackground(ResourceLocation background) {
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(background);
        this.func_73729_b(this.guiLeft, this.guiTop, 0, 0, this.xSize, this.ySize);
        GL11.glDisable((int)3042);
    }

    private void drawTitle(String title) {
        this.func_73732_a(this.field_146289_q, title, this.field_146294_l / 2, this.guiTop + 9, 0xFFFFFF);
    }

    private void drawImage(GuideLoader.ImageData img, boolean full) {
        this.field_146297_k.func_110434_K().func_110577_a(img.getTexture());
        int posx = (int)(((double)this.field_146294_l - (double)img.getWidth() * img.getScale()) / 2.0);
        int posy = (int)(((double)this.field_146295_m - (double)img.getHeight() * img.getScale()) / 2.0);
        GuiFunctions.drawTextureScaled(posx, posy -= full ? 8 : 48, img.getMinU(), img.getMinV(), img.getSizeU(), img.getSizeV(), img.getScale(), this.field_73735_i, img.getWidth(), img.getHeight());
    }

    private void drawText(String text, boolean full) {
        this.field_146289_q.func_78264_a(true);
        List lines = this.field_146289_q.func_78271_c(text, 158);
        int max = Math.min(lines.size(), full ? 17 : 8);
        int posy = full ? 29 : 108;
        for (int line = 0; line < max; line = (int)((byte)(line + 1))) {
            this.func_73731_b(this.field_146289_q, (String)lines.get(line), this.guiLeft + 12, this.guiTop + posy, 0xFFFFFF);
            posy += 9;
        }
        this.field_146289_q.func_78264_a(false);
    }

    private void drawStack(ItemStack stack, int x, int y, int mouseX, int mouseY) {
        if (stack == null) {
            return;
        }
        x += this.guiLeft;
        y += this.guiTop;
        RenderHelper.func_74520_c();
        GL11.glEnable((int)32826);
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
        GL11.glPushMatrix();
        this.field_73735_i = 200.0f;
        GuiScreen.field_146296_j.field_77023_b = 200.0f;
        FontRenderer font = stack.func_77973_b().getFontRenderer(stack);
        if (font == null) {
            font = this.field_146289_q;
        }
        field_146296_j.func_82406_b(font, this.field_146297_k.func_110434_K(), stack, x, y);
        field_146296_j.func_94148_a(font, this.field_146297_k.func_110434_K(), stack, x, y, null);
        this.field_73735_i = 0.0f;
        GuiScreen.field_146296_j.field_77023_b = 0.0f;
        GL11.glPopMatrix();
        if (mouseX >= x && mouseX <= x + 16 && mouseY >= y && mouseY <= y + 16) {
            this.hoverstack = stack;
        }
    }

    private void drawGrid(List<ItemStack> list, int x, int y, int mouseX, int mouseY) {
        int posx = x;
        int posy = y;
        for (int index = 0; index < Math.min(list.size(), 9); index = (int)((byte)(index + 1))) {
            this.drawStack(list.get(index), posx + 1, posy + 1, mouseX, mouseY);
            if (index % 3 == 2) {
                posx = x;
                posy += 18;
                continue;
            }
            posx += 18;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void func_146284_a(GuiButton button) {
        if (this.lastkey > Minecraft.func_71386_F()) {
            return;
        }
        this.lastkey = Minecraft.func_71386_F() + 20L;
        this.currentRecipeParts = null;
        this.currentRecipeCache = null;
        if (button.field_146127_k == 1) {
            this.field_146297_k.func_147108_a((GuiScreen)null);
            this.field_146297_k.func_71381_h();
        } else if (button.field_146127_k == 0) {
            if (this.currentPage == null) {
                if (this.pageindex <= 0) return;
                this.pageindex = 0;
            } else {
                this.currentPage = this.activemod != null && !this.currentPage.getId().equals("TOC") ? this.activemod.get("TOC") : null;
                if (!this.history.isEmpty()) {
                    this.history.clear();
                }
            }
        } else {
            ButtonLink linkbutton = (ButtonLink)button;
            if (this.currentPage == null) {
                if (button.field_146127_k == 2 && this.pageindex > 0) {
                    --this.pageindex;
                } else if (button.field_146127_k == 3) {
                    ++this.pageindex;
                } else if (button.field_146127_k > 5) {
                    this.activemod = GuideLoader.getModPages(linkbutton.getLink());
                    if (this.activemod != null) {
                        this.currentPage = this.activemod.get("TOC");
                    }
                }
            } else if (this.activemod != null) {
                GuidePage page = null;
                if (button.field_146127_k == 2) {
                    page = this.activemod.get(this.currentPage.getLinkBack());
                } else if (button.field_146127_k == 3) {
                    page = this.activemod.get(this.currentPage.getLinkNext());
                } else if (button.field_146127_k == 4) {
                    page = this.activemod.get(this.currentPage.getLinkNext());
                } else if (button.field_146127_k == 5) {
                    if (!this.history.isEmpty()) {
                        this.currentPage = this.history.pop();
                    }
                } else {
                    page = this.activemod.get(linkbutton.getLink());
                }
                if (page != null) {
                    this.history.push(this.currentPage);
                    this.currentPage = page;
                }
            }
        }
        this.setupButtons();
    }
}

