/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.client;

import java.util.Iterator;
import java.util.List;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import org.lwjgl.opengl.GL11;

public class GuiFunctions {
    public static GuiPass guiPass = new GuiPass();

    private static double[] getPixelScale(int ... imagesize) {
        int imagewidth;
        int n = imagewidth = imagesize.length >= 1 ? imagesize[0] : 256;
        int imageheight = imagesize.length >= 2 ? imagesize[1] : (imagesize.length == 1 ? imagewidth : 256);
        return new double[]{1.0 / (double)imagewidth, 1.0 / (double)imageheight};
    }

    public static void drawTexture(int posX, int posY, int posU, int posV, int sizeU, int sizeV, float zLevel, int ... imagesize) {
        GuiFunctions.drawTextureScaled(posX, posY, posU, posV, sizeU, sizeV, 1.0, zLevel, imagesize);
    }

    public static void drawTextureScaled(int posX, int posY, int posU, int posV, int sizeU, int sizeV, double scale, float zLevel, int ... imagesize) {
        double[] pscale = GuiFunctions.getPixelScale(imagesize);
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78374_a((double)(posX + 0), (double)posY + (double)sizeV * scale, (double)zLevel, (double)(posU + 0) * pscale[0], (double)(posV + sizeV) * pscale[1]);
        tessellator.func_78374_a((double)posX + (double)sizeU * scale, (double)posY + (double)sizeV * scale, (double)zLevel, (double)(posU + sizeU) * pscale[0], (double)(posV + sizeV) * pscale[1]);
        tessellator.func_78374_a((double)posX + (double)sizeU * scale, (double)(posY + 0), (double)zLevel, (double)(posU + sizeU) * pscale[0], (double)(posV + 0) * pscale[1]);
        tessellator.func_78374_a((double)(posX + 0), (double)(posY + 0), (double)zLevel, (double)(posU + 0) * pscale[0], (double)(posV + 0) * pscale[1]);
        tessellator.func_78381_a();
    }

    public static void drawTextureMirrored(int posX, int posY, int posU, int posV, int sizeU, int sizeV, float zLevel, int ... imagesize) {
        GuiFunctions.drawTextureMirroredAndScaled(posX, posY, posU, posV, sizeU, sizeV, 1.0, zLevel, imagesize);
    }

    public static void drawTextureMirroredAndScaled(int posX, int posY, int posU, int posV, int sizeU, int sizeV, double scale, float zLevel, int ... imagesize) {
        double[] pscale = GuiFunctions.getPixelScale(imagesize);
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78374_a((double)(posX + 0), (double)posY + (double)sizeV * scale, (double)zLevel, (double)(posU + sizeU) * pscale[0], (double)(posV + sizeV) * pscale[1]);
        tessellator.func_78374_a((double)posX + (double)sizeU * scale, (double)posY + (double)sizeV * scale, (double)zLevel, (double)(posU + 0) * pscale[0], (double)(posV + sizeV) * pscale[1]);
        tessellator.func_78374_a((double)posX + (double)sizeU * scale, (double)(posY + 0), (double)zLevel, (double)(posU + 0) * pscale[0], (double)(posV + 0) * pscale[1]);
        tessellator.func_78374_a((double)(posX + 0), (double)(posY + 0), (double)zLevel, (double)(posU + sizeU) * pscale[0], (double)(posV + 0) * pscale[1]);
        tessellator.func_78381_a();
    }

    public static void drawTextureInverted(int posX, int posY, int posU, int posV, int sizeU, int sizeV, float zLevel, int ... imagesize) {
        GuiFunctions.drawTextureInvertedAndScaled(posX, posY, posU, posV, sizeU, sizeV, 1.0, zLevel, imagesize);
    }

    public static void drawTextureInvertedAndScaled(int posX, int posY, int posU, int posV, int sizeU, int sizeV, double scale, float zLevel, int ... imagesize) {
        double[] pscale = GuiFunctions.getPixelScale(imagesize);
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78374_a((double)(posX + 0), (double)posY + (double)sizeV * scale, (double)zLevel, (double)(posU + 0) * pscale[0], (double)(posV + 0) * pscale[1]);
        tessellator.func_78374_a((double)posX + (double)sizeU * scale, (double)posY + (double)sizeV * scale, (double)zLevel, (double)(posU + sizeU) * pscale[0], (double)(posV + 0) * pscale[1]);
        tessellator.func_78374_a((double)posX + (double)sizeU * scale, (double)(posY + 0), (double)zLevel, (double)(posU + sizeU) * pscale[0], (double)(posV + sizeV) * pscale[1]);
        tessellator.func_78374_a((double)(posX + 0), (double)(posY + 0), (double)zLevel, (double)(posU + 0) * pscale[0], (double)(posV + sizeV) * pscale[1]);
        tessellator.func_78381_a();
    }

    public static void renderToolTip(ItemStack stack, int x, int y, GuiScreen parent) {
        List list = stack.func_82840_a((EntityPlayer)parent.field_146297_k.field_71439_g, parent.field_146297_k.field_71474_y.field_82882_x);
        for (int line = 0; line < list.size(); ++line) {
            if (line == 0) {
                list.set(line, stack.func_77953_t().field_77937_e + (String)list.get(line));
                continue;
            }
            list.set(line, EnumChatFormatting.GRAY + (String)list.get(line));
        }
        FontRenderer font = stack.func_77973_b().getFontRenderer(stack);
        GuiFunctions.drawHoveringText(list, x, y, font == null ? parent.field_146297_k.field_71466_p : font, parent);
    }

    public static void drawHoveringText(List<String> list, int x, int y, FontRenderer fontRenderer, GuiScreen parent) {
        if (list == null || list.isEmpty()) {
            return;
        }
        GL11.glDisable((int)32826);
        RenderHelper.func_74518_a();
        GL11.glDisable((int)2929);
        int width = 0;
        Iterator<String> iterator = list.iterator();
        while (iterator.hasNext()) {
            int linewidth = fontRenderer.func_78256_a(iterator.next());
            if (linewidth <= width) continue;
            width = linewidth;
        }
        int left = x + 12;
        int top = y - 12;
        int height = 8;
        if (list.size() > 1) {
            height += 2 + (list.size() - 1) * 10;
        }
        if (left + width > parent.field_146294_l) {
            left = parent.field_146294_l - width - 6;
        }
        if (top + height + 6 > parent.field_146295_m) {
            top = parent.field_146295_m - height - 6;
        }
        guiPass.setZLevel(300.0f);
        int color1 = -267386864;
        guiPass.func_73733_a(left - 3, top - 4, left + width + 3, top - 3, color1, color1);
        guiPass.func_73733_a(left - 3, top + height + 3, left + width + 3, top + height + 4, color1, color1);
        guiPass.func_73733_a(left - 3, top - 3, left + width + 3, top + height + 3, color1, color1);
        guiPass.func_73733_a(left - 4, top - 3, left - 3, top + height + 3, color1, color1);
        guiPass.func_73733_a(left + width + 3, top - 3, left + width + 4, top + height + 3, color1, color1);
        int color2 = 0x505000FF;
        int color3 = (color2 & 0xFEFEFE) >> 1 | color2 & 0xFF000000;
        guiPass.func_73733_a(left - 3, top - 3 + 1, left - 3 + 1, top + height + 3 - 1, color2, color3);
        guiPass.func_73733_a(left + width + 2, top - 3 + 1, left + width + 3, top + height + 3 - 1, color2, color3);
        guiPass.func_73733_a(left - 3, top - 3, left + width + 3, top - 3 + 1, color2, color2);
        guiPass.func_73733_a(left - 3, top + height + 2, left + width + 3, top + height + 3, color3, color3);
        for (int index = 0; index < list.size(); ++index) {
            String line = list.get(index);
            fontRenderer.func_78261_a(line, left, top, -1);
            if (index == 0) {
                top += 2;
            }
            top += 10;
        }
        guiPass.setZLevel(0.0f);
        GL11.glEnable((int)2896);
        GL11.glEnable((int)2929);
        RenderHelper.func_74519_b();
        GL11.glEnable((int)32826);
    }

    public static class GuiPass
    extends GuiScreen {
        public void setZLevel(float zLevel) {
            this.field_73735_i = zLevel;
            GuiScreen.field_146296_j.field_77023_b = zLevel;
        }

        public void func_73733_a(int x1, int y1, int x2, int y2, int color1, int color2) {
            super.func_73733_a(x1, y1, x2, y2, color1, color2);
        }
    }
}

