/*
 * Decompiled with CFR 0.152.
 */
package glassmaker.extratic.common;

import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.registry.GameRegistry;
import glassmaker.extratic.metals.MoltenMetalBucketItem;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.FillBucketEvent;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class BucketHandler {
    private static BucketHandler INSTANCE = new BucketHandler();
    private static HashMap<Block, ItemStack> FILLED_BUCKETS = new HashMap();

    public static BucketHandler getInstance() {
        return INSTANCE;
    }

    public static void addBuckets() {
        ItemStack bucketStack;
        int bucketId;
        MoltenMetalBucketItem bucket = new MoltenMetalBucketItem(null);
        GameRegistry.registerItem((Item)bucket, (String)"extra.bucket");
        int bucketVol = 1000;
        ItemStack emptyBucketStack = FluidContainerRegistry.EMPTY_BUCKET.func_77946_l();
        FluidStack fluidStack = FluidRegistry.getFluidStack((String)"fairy.molten", (int)bucketVol);
        if (fluidStack != null) {
            bucketId = 1;
            bucket.addTextureMaping(bucketId, fluidStack.getFluid().getName(), "bucket_fill_fairy");
            bucketStack = new ItemStack((Item)bucket, 1, bucketId);
            FILLED_BUCKETS.put(fluidStack.getFluid().getBlock(), bucketStack);
            FluidContainerRegistry.registerFluidContainer((FluidStack)fluidStack, (ItemStack)bucketStack, (ItemStack)emptyBucketStack);
        }
        if ((fluidStack = FluidRegistry.getFluidStack((String)"refined.glowstone.molten", (int)bucketVol)) != null) {
            bucketId = 2;
            bucket.addTextureMaping(bucketId, fluidStack.getFluid().getName(), "bucket_fill_glowstone");
            bucketStack = new ItemStack((Item)bucket, 1, bucketId);
            FILLED_BUCKETS.put(fluidStack.getFluid().getBlock(), bucketStack);
            FluidContainerRegistry.registerFluidContainer((FluidStack)fluidStack, (ItemStack)bucketStack, (ItemStack)emptyBucketStack);
        }
        if ((fluidStack = FluidRegistry.getFluidStack((String)"osmium.molten", (int)bucketVol)) != null) {
            bucketId = 3;
            bucket.addTextureMaping(bucketId, fluidStack.getFluid().getName(), "bucket_fill_osmium");
            bucketStack = new ItemStack((Item)bucket, 1, bucketId);
            FILLED_BUCKETS.put(fluidStack.getFluid().getBlock(), bucketStack);
            FluidContainerRegistry.registerFluidContainer((FluidStack)fluidStack, (ItemStack)bucketStack, (ItemStack)emptyBucketStack);
        }
        if ((fluidStack = FluidRegistry.getFluidStack((String)"pokefennium.molten", (int)bucketVol)) != null) {
            bucketId = 4;
            bucket.addTextureMaping(bucketId, fluidStack.getFluid().getName(), "bucket_fill_pokefennium");
            bucketStack = new ItemStack((Item)bucket, 1, bucketId);
            FILLED_BUCKETS.put(fluidStack.getFluid().getBlock(), bucketStack);
            FluidContainerRegistry.registerFluidContainer((FluidStack)fluidStack, (ItemStack)bucketStack, (ItemStack)emptyBucketStack);
        }
        if ((fluidStack = FluidRegistry.getFluidStack((String)"red.aurum.molten", (int)bucketVol)) != null) {
            bucketId = 5;
            bucket.addTextureMaping(bucketId, fluidStack.getFluid().getName(), "bucket_fill_red_aurum");
            bucketStack = new ItemStack((Item)bucket, 1, bucketId);
            FILLED_BUCKETS.put(fluidStack.getFluid().getBlock(), bucketStack);
            FluidContainerRegistry.registerFluidContainer((FluidStack)fluidStack, (ItemStack)bucketStack, (ItemStack)emptyBucketStack);
        }
        if ((fluidStack = FluidRegistry.getFluidStack((String)"desh.molten", (int)bucketVol)) != null) {
            bucketId = 6;
            bucket.addTextureMaping(bucketId, fluidStack.getFluid().getName(), "bucket_fill_desh");
            bucketStack = new ItemStack((Item)bucket, 1, bucketId);
            FILLED_BUCKETS.put(fluidStack.getFluid().getBlock(), bucketStack);
            FluidContainerRegistry.registerFluidContainer((FluidStack)fluidStack, (ItemStack)bucketStack, (ItemStack)emptyBucketStack);
        }
        if ((fluidStack = FluidRegistry.getFluidStack((String)"potato.soup", (int)bucketVol)) != null) {
            bucketId = 7;
            bucket.addTextureMaping(bucketId, fluidStack.getFluid().getName(), "bucket_fill_potato_soup");
            bucketStack = new ItemStack((Item)bucket, 1, bucketId);
            FILLED_BUCKETS.put(fluidStack.getFluid().getBlock(), bucketStack);
            FluidContainerRegistry.registerFluidContainer((FluidStack)fluidStack, (ItemStack)bucketStack, (ItemStack)emptyBucketStack);
        }
        if ((fluidStack = FluidRegistry.getFluidStack((String)"drulloy.molten", (int)bucketVol)) != null) {
            bucketId = 8;
            bucket.addTextureMaping(bucketId, fluidStack.getFluid().getName(), "bucket_fill_drulloy");
            bucketStack = new ItemStack((Item)bucket, 1, bucketId);
            FILLED_BUCKETS.put(fluidStack.getFluid().getBlock(), bucketStack);
            FluidContainerRegistry.registerFluidContainer((FluidStack)fluidStack, (ItemStack)bucketStack, (ItemStack)emptyBucketStack);
        }
        if ((fluidStack = FluidRegistry.getFluidStack((String)"dark.steel.molten", (int)bucketVol)) != null) {
            bucketId = 9;
            bucket.addTextureMaping(bucketId, fluidStack.getFluid().getName(), "bucket_fill_darksteel");
            bucketStack = new ItemStack((Item)bucket, 1, bucketId);
            FILLED_BUCKETS.put(fluidStack.getFluid().getBlock(), bucketStack);
            FluidContainerRegistry.registerFluidContainer((FluidStack)fluidStack, (ItemStack)bucketStack, (ItemStack)emptyBucketStack);
        }
        if ((fluidStack = FluidRegistry.getFluidStack((String)"zinc.molten", (int)bucketVol)) != null) {
            bucketId = 10;
            bucket.addTextureMaping(bucketId, fluidStack.getFluid().getName(), "bucket_fill_zinc");
            bucketStack = new ItemStack((Item)bucket, 1, bucketId);
            FILLED_BUCKETS.put(fluidStack.getFluid().getBlock(), bucketStack);
            FluidContainerRegistry.registerFluidContainer((FluidStack)fluidStack, (ItemStack)bucketStack, (ItemStack)emptyBucketStack);
        }
        if ((fluidStack = FluidRegistry.getFluidStack((String)"brass.molten", (int)bucketVol)) != null) {
            bucketId = 11;
            bucket.addTextureMaping(bucketId, fluidStack.getFluid().getName(), "bucket_fill_brass");
            bucketStack = new ItemStack((Item)bucket, 1, bucketId);
            FILLED_BUCKETS.put(fluidStack.getFluid().getBlock(), bucketStack);
            FluidContainerRegistry.registerFluidContainer((FluidStack)fluidStack, (ItemStack)bucketStack, (ItemStack)emptyBucketStack);
        }
        if ((fluidStack = FluidRegistry.getFluidStack((String)"adamantine.molten", (int)bucketVol)) != null) {
            bucketId = 12;
            bucket.addTextureMaping(bucketId, fluidStack.getFluid().getName(), "bucket_fill_adamantine");
            bucketStack = new ItemStack((Item)bucket, 1, bucketId);
            FILLED_BUCKETS.put(fluidStack.getFluid().getBlock(), bucketStack);
            FluidContainerRegistry.registerFluidContainer((FluidStack)fluidStack, (ItemStack)bucketStack, (ItemStack)emptyBucketStack);
        }
        if ((fluidStack = FluidRegistry.getFluidStack((String)"manasteel.molten", (int)bucketVol)) != null) {
            bucketId = 13;
            bucket.addTextureMaping(bucketId, fluidStack.getFluid().getName(), "bucket_fill_manasteel");
            bucketStack = new ItemStack((Item)bucket, 1, bucketId);
            FILLED_BUCKETS.put(fluidStack.getFluid().getBlock(), bucketStack);
            FluidContainerRegistry.registerFluidContainer((FluidStack)fluidStack, (ItemStack)bucketStack, (ItemStack)emptyBucketStack);
        }
        if ((fluidStack = FluidRegistry.getFluidStack((String)"terrasteel.molten", (int)bucketVol)) != null) {
            bucketId = 14;
            bucket.addTextureMaping(bucketId, fluidStack.getFluid().getName(), "bucket_fill_terrasteel");
            bucketStack = new ItemStack((Item)bucket, 1, bucketId);
            FILLED_BUCKETS.put(fluidStack.getFluid().getBlock(), bucketStack);
            FluidContainerRegistry.registerFluidContainer((FluidStack)fluidStack, (ItemStack)bucketStack, (ItemStack)emptyBucketStack);
        }
        if ((fluidStack = FluidRegistry.getFluidStack((String)"elementium.molten", (int)bucketVol)) != null) {
            bucketId = 15;
            bucket.addTextureMaping(bucketId, fluidStack.getFluid().getName(), "bucket_fill_elementium");
            bucketStack = new ItemStack((Item)bucket, 1, bucketId);
            FILLED_BUCKETS.put(fluidStack.getFluid().getBlock(), bucketStack);
            FluidContainerRegistry.registerFluidContainer((FluidStack)fluidStack, (ItemStack)bucketStack, (ItemStack)emptyBucketStack);
        }
        if ((fluidStack = FluidRegistry.getFluidStack((String)"voidmetal.molten", (int)bucketVol)) != null) {
            bucketId = 16;
            bucket.addTextureMaping(bucketId, fluidStack.getFluid().getName(), "bucket_fill_voidmetal");
            bucketStack = new ItemStack((Item)bucket, 1, bucketId);
            FILLED_BUCKETS.put(fluidStack.getFluid().getBlock(), bucketStack);
            FluidContainerRegistry.registerFluidContainer((FluidStack)fluidStack, (ItemStack)bucketStack, (ItemStack)emptyBucketStack);
        }
        if ((fluidStack = FluidRegistry.getFluidStack((String)"blutonium.molten", (int)bucketVol)) != null) {
            bucketId = 17;
            bucket.addTextureMaping(bucketId, fluidStack.getFluid().getName(), "bucket_fill_blutonium");
            bucketStack = new ItemStack((Item)bucket, 1, bucketId);
            FILLED_BUCKETS.put(fluidStack.getFluid().getBlock(), bucketStack);
            FluidContainerRegistry.registerFluidContainer((FluidStack)fluidStack, (ItemStack)bucketStack, (ItemStack)emptyBucketStack);
        }
        if ((fluidStack = FluidRegistry.getFluidStack((String)"ludicrite.molten", (int)bucketVol)) != null) {
            bucketId = 18;
            bucket.addTextureMaping(bucketId, fluidStack.getFluid().getName(), "bucket_fill_ludicrite");
            bucketStack = new ItemStack((Item)bucket, 1, bucketId);
            FILLED_BUCKETS.put(fluidStack.getFluid().getBlock(), bucketStack);
            FluidContainerRegistry.registerFluidContainer((FluidStack)fluidStack, (ItemStack)bucketStack, (ItemStack)emptyBucketStack);
        }
        if ((fluidStack = FluidRegistry.getFluidStack((String)"bedrockium.molten", (int)bucketVol)) != null) {
            bucketId = 19;
            bucket.addTextureMaping(bucketId, fluidStack.getFluid().getName(), "bucket_fill_bedrockium");
            bucketStack = new ItemStack((Item)bucket, 1, bucketId);
            FILLED_BUCKETS.put(fluidStack.getFluid().getBlock(), bucketStack);
            FluidContainerRegistry.registerFluidContainer((FluidStack)fluidStack, (ItemStack)bucketStack, (ItemStack)emptyBucketStack);
        }
        if ((fluidStack = FluidRegistry.getFluidStack((String)"witheriron.molten", (int)bucketVol)) != null) {
            bucketId = 20;
            bucket.addTextureMaping(bucketId, fluidStack.getFluid().getName(), "bucket_fill_witheriron");
            bucketStack = new ItemStack((Item)bucket, 1, bucketId);
            FILLED_BUCKETS.put(fluidStack.getFluid().getBlock(), bucketStack);
            FluidContainerRegistry.registerFluidContainer((FluidStack)fluidStack, (ItemStack)bucketStack, (ItemStack)emptyBucketStack);
        }
        if ((fluidStack = FluidRegistry.getFluidStack((String)"amethyst.molten", (int)bucketVol)) != null) {
            bucketId = 21;
            bucket.addTextureMaping(bucketId, fluidStack.getFluid().getName(), "bucket_fill_amethyst");
            bucketStack = new ItemStack((Item)bucket, 1, bucketId);
            FILLED_BUCKETS.put(fluidStack.getFluid().getBlock(), bucketStack);
            FluidContainerRegistry.registerFluidContainer((FluidStack)fluidStack, (ItemStack)bucketStack, (ItemStack)emptyBucketStack);
        }
        if ((fluidStack = FluidRegistry.getFluidStack((String)"emberstone.molten", (int)bucketVol)) != null) {
            bucketId = 22;
            bucket.addTextureMaping(bucketId, fluidStack.getFluid().getName(), "bucket_fill_emberstone");
            bucketStack = new ItemStack((Item)bucket, 1, bucketId);
            FILLED_BUCKETS.put(fluidStack.getFluid().getBlock(), bucketStack);
            FluidContainerRegistry.registerFluidContainer((FluidStack)fluidStack, (ItemStack)bucketStack, (ItemStack)emptyBucketStack);
        }
        if ((fluidStack = FluidRegistry.getFluidStack((String)"jade.molten", (int)bucketVol)) != null) {
            bucketId = 23;
            bucket.addTextureMaping(bucketId, fluidStack.getFluid().getName(), "bucket_fill_jade");
            bucketStack = new ItemStack((Item)bucket, 1, bucketId);
            FILLED_BUCKETS.put(fluidStack.getFluid().getBlock(), bucketStack);
            FluidContainerRegistry.registerFluidContainer((FluidStack)fluidStack, (ItemStack)bucketStack, (ItemStack)emptyBucketStack);
        }
        if ((fluidStack = FluidRegistry.getFluidStack((String)"limonite.molten", (int)bucketVol)) != null) {
            bucketId = 24;
            bucket.addTextureMaping(bucketId, fluidStack.getFluid().getName(), "bucket_fill_limonite");
            bucketStack = new ItemStack((Item)bucket, 1, bucketId);
            FILLED_BUCKETS.put(fluidStack.getFluid().getBlock(), bucketStack);
            FluidContainerRegistry.registerFluidContainer((FluidStack)fluidStack, (ItemStack)bucketStack, (ItemStack)emptyBucketStack);
        }
        if ((fluidStack = FluidRegistry.getFluidStack((String)"rosite.molten", (int)bucketVol)) != null) {
            bucketId = 25;
            bucket.addTextureMaping(bucketId, fluidStack.getFluid().getName(), "bucket_fill_rosite");
            bucketStack = new ItemStack((Item)bucket, 1, bucketId);
            FILLED_BUCKETS.put(fluidStack.getFluid().getBlock(), bucketStack);
            FluidContainerRegistry.registerFluidContainer((FluidStack)fluidStack, (ItemStack)bucketStack, (ItemStack)emptyBucketStack);
        }
        if ((fluidStack = FluidRegistry.getFluidStack((String)"sapphire.molten", (int)bucketVol)) != null) {
            bucketId = 26;
            bucket.addTextureMaping(bucketId, fluidStack.getFluid().getName(), "bucket_fill_sapphire");
            bucketStack = new ItemStack((Item)bucket, 1, bucketId);
            FILLED_BUCKETS.put(fluidStack.getFluid().getBlock(), bucketStack);
            FluidContainerRegistry.registerFluidContainer((FluidStack)fluidStack, (ItemStack)bucketStack, (ItemStack)emptyBucketStack);
        }
        if ((fluidStack = FluidRegistry.getFluidStack((String)"skeletal.molten", (int)bucketVol)) != null) {
            bucketId = 27;
            bucket.addTextureMaping(bucketId, fluidStack.getFluid().getName(), "bucket_fill_skeletal");
            bucketStack = new ItemStack((Item)bucket, 1, bucketId);
            FILLED_BUCKETS.put(fluidStack.getFluid().getBlock(), bucketStack);
            FluidContainerRegistry.registerFluidContainer((FluidStack)fluidStack, (ItemStack)bucketStack, (ItemStack)emptyBucketStack);
        }
        if ((fluidStack = FluidRegistry.getFluidStack((String)"baronyte.molten", (int)bucketVol)) != null) {
            bucketId = 28;
            bucket.addTextureMaping(bucketId, fluidStack.getFluid().getName(), "bucket_fill_baronyte");
            bucketStack = new ItemStack((Item)bucket, 1, bucketId);
            FILLED_BUCKETS.put(fluidStack.getFluid().getBlock(), bucketStack);
            FluidContainerRegistry.registerFluidContainer((FluidStack)fluidStack, (ItemStack)bucketStack, (ItemStack)emptyBucketStack);
        }
        if ((fluidStack = FluidRegistry.getFluidStack((String)"blazium.molten", (int)bucketVol)) != null) {
            bucketId = 29;
            bucket.addTextureMaping(bucketId, fluidStack.getFluid().getName(), "bucket_fill_blazium");
            bucketStack = new ItemStack((Item)bucket, 1, bucketId);
            FILLED_BUCKETS.put(fluidStack.getFluid().getBlock(), bucketStack);
            FluidContainerRegistry.registerFluidContainer((FluidStack)fluidStack, (ItemStack)bucketStack, (ItemStack)emptyBucketStack);
        }
        if ((fluidStack = FluidRegistry.getFluidStack((String)"elecanium.molten", (int)bucketVol)) != null) {
            bucketId = 30;
            bucket.addTextureMaping(bucketId, fluidStack.getFluid().getName(), "bucket_fill_elecanium");
            bucketStack = new ItemStack((Item)bucket, 1, bucketId);
            FILLED_BUCKETS.put(fluidStack.getFluid().getBlock(), bucketStack);
            FluidContainerRegistry.registerFluidContainer((FluidStack)fluidStack, (ItemStack)bucketStack, (ItemStack)emptyBucketStack);
        }
        if ((fluidStack = FluidRegistry.getFluidStack((String)"ghastly.molten", (int)bucketVol)) != null) {
            bucketId = 31;
            bucket.addTextureMaping(bucketId, fluidStack.getFluid().getName(), "bucket_fill_ghastly");
            bucketStack = new ItemStack((Item)bucket, 1, bucketId);
            FILLED_BUCKETS.put(fluidStack.getFluid().getBlock(), bucketStack);
            FluidContainerRegistry.registerFluidContainer((FluidStack)fluidStack, (ItemStack)bucketStack, (ItemStack)emptyBucketStack);
        }
        if ((fluidStack = FluidRegistry.getFluidStack((String)"ghoulish.molten", (int)bucketVol)) != null) {
            bucketId = 32;
            bucket.addTextureMaping(bucketId, fluidStack.getFluid().getName(), "bucket_fill_ghoulish");
            bucketStack = new ItemStack((Item)bucket, 1, bucketId);
            FILLED_BUCKETS.put(fluidStack.getFluid().getBlock(), bucketStack);
            FluidContainerRegistry.registerFluidContainer((FluidStack)fluidStack, (ItemStack)bucketStack, (ItemStack)emptyBucketStack);
        }
        if ((fluidStack = FluidRegistry.getFluidStack((String)"lyon.molten", (int)bucketVol)) != null) {
            bucketId = 33;
            bucket.addTextureMaping(bucketId, fluidStack.getFluid().getName(), "bucket_fill_lyon");
            bucketStack = new ItemStack((Item)bucket, 1, bucketId);
            FILLED_BUCKETS.put(fluidStack.getFluid().getBlock(), bucketStack);
            FluidContainerRegistry.registerFluidContainer((FluidStack)fluidStack, (ItemStack)bucketStack, (ItemStack)emptyBucketStack);
        }
        if ((fluidStack = FluidRegistry.getFluidStack((String)"mystite.molten", (int)bucketVol)) != null) {
            bucketId = 34;
            bucket.addTextureMaping(bucketId, fluidStack.getFluid().getName(), "bucket_fill_mystite");
            bucketStack = new ItemStack((Item)bucket, 1, bucketId);
            FILLED_BUCKETS.put(fluidStack.getFluid().getBlock(), bucketStack);
            FluidContainerRegistry.registerFluidContainer((FluidStack)fluidStack, (ItemStack)bucketStack, (ItemStack)emptyBucketStack);
        }
        if ((fluidStack = FluidRegistry.getFluidStack((String)"varsium.molten", (int)bucketVol)) != null) {
            bucketId = 35;
            bucket.addTextureMaping(bucketId, fluidStack.getFluid().getName(), "bucket_fill_varsium");
            bucketStack = new ItemStack((Item)bucket, 1, bucketId);
            FILLED_BUCKETS.put(fluidStack.getFluid().getBlock(), bucketStack);
            FluidContainerRegistry.registerFluidContainer((FluidStack)fluidStack, (ItemStack)bucketStack, (ItemStack)emptyBucketStack);
        }
        if ((fluidStack = FluidRegistry.getFluidStack((String)"constantan.molten", (int)bucketVol)) != null) {
            bucketId = 36;
            bucket.addTextureMaping(bucketId, fluidStack.getFluid().getName(), "bucket_fill_constantan");
            bucketStack = new ItemStack((Item)bucket, 1, bucketId);
            FILLED_BUCKETS.put(fluidStack.getFluid().getBlock(), bucketStack);
            FluidContainerRegistry.registerFluidContainer((FluidStack)fluidStack, (ItemStack)bucketStack, (ItemStack)emptyBucketStack);
        }
    }

    public void fillEvent(FillBucketEvent event) {
        World world = event.world;
        MovingObjectPosition pos = event.target;
        Block block = world.func_147439_a(pos.field_72311_b, pos.field_72312_c, pos.field_72309_d);
        ItemStack bucketStack = BucketHandler.getFilledBucket(block);
        if (bucketStack == null) {
            return;
        }
        world.func_147468_f(pos.field_72311_b, pos.field_72312_c, pos.field_72309_d);
        event.result = bucketStack;
        event.setResult(Event.Result.ALLOW);
    }

    public static HashMap<Block, ItemStack> getAllBuckets() {
        return FILLED_BUCKETS;
    }

    public static ItemStack getFilledBucket(Block fluidBlock) {
        return FILLED_BUCKETS.get(fluidBlock);
    }

    public static ItemStack getFilledBucket(String fluidName) {
        Block fluidBlock = FluidRegistry.getFluid((String)fluidName).getBlock();
        return FILLED_BUCKETS.get(fluidBlock).func_77946_l();
    }

    public static boolean isAvailableBucket(int fluidBlockId) {
        return FILLED_BUCKETS.containsKey(fluidBlockId);
    }

    public static boolean isAvailableBucket(String fluidName) {
        Block fluidBlock = FluidRegistry.getFluid((String)fluidName).getBlock();
        return FILLED_BUCKETS.containsKey(fluidBlock);
    }

    public static Block getBlock(ItemStack bucketStack) {
        Block block = Blocks.field_150350_a;
        for (Map.Entry<Block, ItemStack> entry : FILLED_BUCKETS.entrySet()) {
            ItemStack stack = entry.getValue();
            if (!stack.func_77969_a(bucketStack)) continue;
            block = entry.getKey();
            break;
        }
        return block;
    }
}

