/*
 * Decompiled with CFR 0.152.
 */
package eureka.networking;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import eureka.Eureka;
import eureka.api.EurekaAPI;
import eureka.api.IEurekaInfo;
import eureka.core.PlayerResearch;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import net.minecraft.entity.player.EntityPlayer;

public class MessageResearch
implements IMessage,
IMessageHandler<MessageResearch, IMessage> {
    public PlayerResearch research;
    public HashMap<String, Integer> progress = new HashMap();
    public HashMap<String, Boolean> finished = new HashMap();

    public MessageResearch() {
    }

    public MessageResearch(EntityPlayer player) {
        this.research = PlayerResearch.get(player);
    }

    public void fromBytes(ByteBuf buf) {
        for (IEurekaInfo info : EurekaAPI.API.getAllKeys()) {
            this.progress.put(info.getName(), buf.readInt());
            this.finished.put(info.getName(), buf.readBoolean());
        }
    }

    public void toBytes(ByteBuf buf) {
        for (IEurekaInfo info : EurekaAPI.API.getAllKeys()) {
            buf.writeInt(this.research.getProgress(info.getName()));
            buf.writeBoolean(this.research.isFinished(info.getName()));
        }
    }

    public IMessage onMessage(MessageResearch message, MessageContext ctx) {
        this.research = PlayerResearch.get(Eureka.proxy.getPlayer());
        for (IEurekaInfo info : EurekaAPI.API.getAllKeys()) {
            this.research.overrideProgress(info.getName(), message.progress.get(info.getName()));
            this.research.overrideFinished(info.getName(), message.finished.get(info.getName()));
        }
        return null;
    }
}

