/*
 * Decompiled with CFR 0.152.
 */
package eureka.json;

import com.google.common.base.Strings;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import cpw.mods.fml.common.registry.GameRegistry;
import eureka.api.BasicEurekaCategory;
import eureka.api.BasicEurekaInfo;
import eureka.api.EurekaAPI;
import eureka.core.Logger;
import eureka.json.JSONCategory;
import eureka.json.JSONChapter;
import java.io.File;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;

public class ConfigReader {
    public static File mainfolder;
    public static File catagoryFolder;
    public static File keyFolder;
    public static File localizations;
    private static Gson gson;

    public static void read() {
        ConfigReader.createFolderIfNeeded(mainfolder);
        if (!mainfolder.exists()) {
            return;
        }
        catagoryFolder = new File(mainfolder, "Categories");
        keyFolder = new File(mainfolder, "Keys");
        localizations = new File(mainfolder, "Localizations");
        ConfigReader.createFolderIfNeeded(catagoryFolder);
        ConfigReader.createFolderIfNeeded(keyFolder);
        ConfigReader.createFolderIfNeeded(localizations);
        ConfigReader.createFolderIfNeeded(new File(localizations, "en_US"));
        if (!catagoryFolder.exists()) {
            return;
        }
        for (File file : catagoryFolder.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".json");
            }
        })) {
            ConfigReader.readCategory(file);
        }
        if (!keyFolder.exists()) {
            return;
        }
        for (File file : keyFolder.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".json");
            }
        })) {
            ConfigReader.readKey(file);
        }
    }

    private static void readCategory(File file) {
        try {
            JSONCategory category = (JSONCategory)gson.fromJson((Reader)new FileReader(file), JSONCategory.class);
            EurekaAPI.API.registerCategory(new BasicEurekaCategory(category.name, ConfigReader.getStack(category.displayStack)));
        }
        catch (Throwable t) {
            Logger.error("Failed to read category file (" + file.getName() + ")");
        }
    }

    private static void readKey(File file) {
        try {
            JSONChapter chapter = (JSONChapter)gson.fromJson((Reader)new FileReader(file), JSONChapter.class);
            ArrayList<ItemStack> objects = new ArrayList<ItemStack>();
            for (String string : chapter.blockedObjects) {
                objects.add(ConfigReader.getStack(string));
            }
            EurekaAPI.API.register(new BasicEurekaInfo(chapter.name, chapter.category, chapter.maxProgress, ConfigReader.getStack(chapter.displayStack), chapter.requiredResearch.toArray(new String[100])));
            for (ItemStack itemStack : objects) {
                EurekaAPI.API.bindToKey(itemStack, chapter.name);
            }
            if (chapter.progressOption != null) {
                ItemStack itemStack = ConfigReader.getStack(chapter.progressObject);
                Object obj = itemStack != null && itemStack.func_77973_b() instanceof ItemBlock ? ((ItemBlock)itemStack.func_77973_b()).field_150939_a : itemStack;
                EurekaAPI.API.registerProgressOption(chapter.name, chapter.progressOption, obj);
            }
        }
        catch (Throwable t) {
            Logger.error("Failed to read category file (" + file.getName() + ")");
            t.printStackTrace();
        }
    }

    private static ItemStack getStack(String name) {
        if (Strings.isNullOrEmpty((String)name)) {
            return null;
        }
        int meta = -1;
        if (name.contains("@")) {
            meta = Integer.getInteger(name.split("@")[1]);
        }
        String[] split = name.split(":");
        ItemStack stack = GameRegistry.findItemStack((String)split[0], (String)split[1], (int)1);
        if (meta != -1 && stack != null) {
            stack.func_77964_b(meta);
        }
        return stack;
    }

    private static void createFolderIfNeeded(File folder) {
        try {
            if (!Files.exists(folder.toPath(), new LinkOption[0])) {
                Files.createDirectory(folder.toPath(), new FileAttribute[0]);
            }
        }
        catch (Throwable e) {
            Logger.error("Something went wrong while checking or creating the Eureka folders");
            e.printStackTrace();
        }
    }

    static {
        gson = new GsonBuilder().setPrettyPrinting().create();
    }
}

