/*
 * Decompiled with CFR 0.152.
 */
package eureka.gui.Widgets;

import eureka.api.ICategory;
import eureka.core.Logger;
import eureka.core.RenderUtils;
import eureka.core.TextGetter;
import eureka.gui.GuiEngineeringDiary;
import eureka.gui.Widgets.WidgetBase;
import java.util.List;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class WidgetCategory
extends WidgetBase {
    private final ResourceLocation UNSELECTED = new ResourceLocation("eureka:textures/gui/pieces/categoryUnselected.png");
    private final ResourceLocation SELECTED = new ResourceLocation("eureka:textures/gui/pieces/categorySelected.png");
    private final ICategory category;
    private boolean selected;

    public WidgetCategory(int x, int y, int width, int height, GuiEngineeringDiary gui, ICategory category) {
        super(x, y, width, height, gui);
        this.category = category;
        this.selected = false;
    }

    @Override
    public void render(int mouseX, int mouseY) {
        if (!this.enabled) {
            return;
        }
        RenderUtils.drawImage(this.selected ? this.SELECTED : this.UNSELECTED, this.x, this.y, this.width, this.height);
        this.renderItem(this.category.getDisplayStack(), this.x + 6, this.y + 4);
    }

    private void renderItem(ItemStack stack, int x, int y) {
        RenderItem itemRender = new RenderItem();
        try {
            itemRender.func_82406_b(this.gui.getFontRendererObj(), RenderUtils.textureManager(), stack, x, y);
        }
        catch (Throwable e) {
            try {
                itemRender.func_77015_a(this.gui.getFontRendererObj(), RenderUtils.textureManager(), stack, x, y);
            }
            catch (Throwable e2) {
                Logger.error("Failed to render item for category " + this.category.getName());
            }
        }
        GL11.glDisable((int)2896);
        GL11.glEnable((int)3008);
    }

    public WidgetCategory setSelected(boolean selected) {
        this.selected = selected;
        return this;
    }

    public ICategory getCategory() {
        return this.category;
    }

    @Override
    public void addTooltip(List<String> list, boolean shift) {
        list.add(TextGetter.getTitle(this.category.getName()));
    }
}

