/*
 * Decompiled with CFR 0.152.
 */
package eureka.gui;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import eureka.api.EurekaAPI;
import eureka.api.ICategory;
import eureka.api.IEurekaInfo;
import eureka.core.PlayerResearch;
import eureka.core.RenderUtils;
import eureka.core.TextGetter;
import eureka.gui.ContainerEngineeringDiary;
import eureka.gui.Widgets.WidgetBase;
import eureka.gui.Widgets.WidgetCategory;
import eureka.gui.Widgets.WidgetCategoryDown;
import eureka.gui.Widgets.WidgetCategoryUp;
import eureka.gui.Widgets.WidgetChapter;
import eureka.gui.Widgets.WidgetChapterDown;
import eureka.gui.Widgets.WidgetChapterUp;
import eureka.gui.Widgets.WidgetNextPage;
import eureka.gui.Widgets.WidgetPrevPage;
import eureka.gui.Widgets.WidgetProgressBar;
import eureka.networking.MessageBookSave;
import eureka.networking.PacketHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import org.apache.commons.lang3.text.WordUtils;
import org.lwjgl.opengl.GL11;

public class GuiEngineeringDiary
extends GuiContainer {
    private ResourceLocation TEXTURE = new ResourceLocation("eureka:textures/gui/EngineeringDiary.png");
    private ArrayList<WidgetBase> widgets = new ArrayList();
    private int numCategories = EurekaAPI.API.getCategories().size();
    private int categoryOffset;
    private int maxCategoryOffset;
    private int chapterOffset;
    private int maxChapterOffset;
    private int numChapters;
    private int page;
    private int pages;
    private List<ICategory> categories = EurekaAPI.API.getCategories();
    private ICategory currentCategory;
    private List<IEurekaInfo> chapters;
    private IEurekaInfo currentChapter;
    private PlayerResearch research;
    private EntityPlayer player;
    private int currentLine = 1;
    private int[] xOffSet = new int[]{70, 75, 52, 35, 25, 15, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10};
    private int[] maxLength = new int[]{80, 40, 38, 35, 35, 40, 40, 40, 40, 40, 37, 35, 33, 30, 30};
    private HashMap<Integer, List<String>> pageLists = new HashMap();

    public GuiEngineeringDiary(EntityPlayer player) {
        super((Container)new ContainerEngineeringDiary());
        NBTTagCompound tag;
        this.research = PlayerResearch.get(player);
        this.field_146999_f = 300;
        this.field_147000_g = 179;
        this.currentCategory = this.categories.get(0);
        this.categoryOffset = 0;
        this.player = player;
        this.maxCategoryOffset = this.categories.size() > 7 ? this.categories.size() - 7 : 0;
        this.resetChapters();
        this.page = 0;
        int page2 = 0;
        this.splitIntroPages(this.currentCategory.getName());
        if (player.func_71045_bC().field_77990_d == null) {
            player.func_71045_bC().field_77990_d = new NBTTagCompound();
        }
        if ((tag = player.func_71045_bC().field_77990_d).func_74764_b("categoryOffset")) {
            this.currentCategory = EurekaAPI.API.getCategories().get(tag.func_74762_e("category"));
            this.resetChapters();
            this.categoryOffset = tag.func_74762_e("categoryOffset");
            this.chapterOffset = tag.func_74762_e("chapterOffset");
            page2 = tag.func_74762_e("page");
            if (tag.func_74762_e("chapter") != -1) {
                this.currentChapter = EurekaAPI.API.getAllKeys().get(tag.func_74762_e("chapter"));
                this.splitIntroPages(this.currentChapter.getName());
            }
        }
        this.resetWidgets();
        this.page = page2;
    }

    private void resetChapters() {
        this.chapters = EurekaAPI.API.getKeys(this.currentCategory.getName());
        this.currentChapter = null;
        this.numChapters = this.chapters.size();
        this.maxChapterOffset = this.numChapters - 7;
    }

    private void splitIntroPages(String key) {
        int pagenum = 0;
        this.page = 0;
        this.pages = 0;
        this.pageLists.clear();
        if (!TextGetter.getDesc(key).equals("")) {
            this.pageLists.put(0, this.splitLine(TextGetter.getDesc(key), 3));
            ++this.pages;
            ++pagenum;
        }
        int linenum = 3;
        List<String> list = TextGetter.getText(key);
        ArrayList<String> page = new ArrayList<String>();
        if (list.isEmpty()) {
            return;
        }
        for (String line : list) {
            if (line.length() > this.maxLength[linenum]) {
                String s = line;
                while (s.length() > this.maxLength[linenum]) {
                    List<String> temp = this.splitLine(s, linenum);
                    page.add(temp.get(0));
                    s = temp.get(1);
                    if (++linenum != 13) continue;
                    String[] a = new String[page.size()];
                    page.toArray(a);
                    ArrayList<String> pagelist = new ArrayList<String>();
                    pagelist.addAll(Arrays.asList(a));
                    this.pageLists.put(pagenum, pagelist);
                    linenum = 3;
                    ++pagenum;
                    page.clear();
                    ++this.pages;
                }
                page.add(s);
                if (++linenum != 13) continue;
                String[] a = new String[page.size()];
                page.toArray(a);
                ArrayList<String> pagelist = new ArrayList<String>();
                pagelist.addAll(Arrays.asList(a));
                this.pageLists.put(pagenum, pagelist);
                linenum = 3;
                ++pagenum;
                page.clear();
                ++this.pages;
                continue;
            }
            page.add(line);
            if (++linenum != 13) continue;
            String[] a = new String[page.size()];
            page.toArray(a);
            ArrayList<String> pagelist = new ArrayList<String>();
            pagelist.addAll(Arrays.asList(a));
            this.pageLists.put(pagenum, pagelist);
            linenum = 3;
            ++pagenum;
            page.clear();
            ++this.pages;
        }
        this.pageLists.put(pagenum, page);
    }

    private List<String> splitLine(String line, int linenum) {
        ArrayList<String> list = new ArrayList<String>();
        String[] lines = WordUtils.wrap((String)line, (int)this.maxLength[linenum]).split(System.getProperty("line.separator"));
        list.add(lines[0]);
        String temp = "";
        for (int t = 1; t < lines.length; ++t) {
            temp = temp + " " + lines[t];
        }
        list.add(temp);
        return list;
    }

    protected void func_146976_a(float fl, int x, int y) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderUtils.bindTexture(this.TEXTURE);
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, 256, 179);
        for (WidgetBase widget : this.widgets) {
            widget.render(x, y);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    protected void func_146979_b(int x, int y) {
        String title;
        this.currentLine = 1;
        if (this.currentChapter == null) {
            title = TextGetter.getTitle(this.currentCategory.getName());
        } else {
            title = TextGetter.getTitle(this.currentChapter.getName());
            this.currentLine = 3;
            if (this.page == 0) {
                String text = StatCollector.func_74838_a((String)"engineeringDiary.requiredResearch");
                List<String> list = this.currentChapter.getRequiredResearch();
                if (!list.isEmpty()) {
                    for (String research : list) {
                        text = text + " " + TextGetter.getTitle(research) + ",";
                    }
                    text = text.substring(0, text.length() - 1);
                } else {
                    text = text + " " + StatCollector.func_74838_a((String)"engineeringDiary.noRequiredResearch");
                }
                this.splitAndDrawText(text, 0xFF0000);
                String progress = this.research.getProgress(this.currentChapter.getName()) != EurekaAPI.API.getMaxProgress(this.currentChapter.getName()) ? StatCollector.func_74838_a((String)"engineeringDiary.progress") + " " + this.research.getProgress(this.currentChapter.getName()) + " / " + EurekaAPI.API.getMaxProgress(this.currentChapter.getName()) : StatCollector.func_74838_a((String)"engineeringDiary.unlocked");
                this.drawText(progress, 16753920);
                this.splitAndDrawText("How to make progress: " + TextGetter.getProgressText(this.currentChapter.getName()), 65280);
            }
        }
        this.drawText(this.pageLists.get(this.page), 0xFFFFFF);
        this.drawText(title, 0, 0xFFCC00, true);
    }

    private void drawText(List<String> lines, int color) {
        if (lines == null || lines.isEmpty()) {
            return;
        }
        for (String text : lines) {
            if (this.currentLine == 16) {
                return;
            }
            this.drawText(text, color);
        }
    }

    private void splitAndDrawText(String text, int color) {
        this.drawText(this.splitLine(text, this.currentLine), color);
    }

    private void drawText(String text, int color) {
        this.drawText(text, this.currentLine, color, false);
    }

    private void drawText(String text, int line, int color, boolean centered) {
        this.field_146289_q.func_78276_b(text, centered ? (int)((double)(this.xOffSet[line] + this.maxLength[line]) - (double)text.length() * 2.5) : this.xOffSet[line], 15 + 12 * line, color);
        ++this.currentLine;
    }

    public void onWidgetClicked(WidgetBase widget) {
        if (widget instanceof WidgetCategory) {
            this.currentCategory = ((WidgetCategory)widget).getCategory();
            this.splitIntroPages(this.currentCategory.getName());
            this.resetChapters();
        } else if (widget instanceof WidgetCategoryDown) {
            ++this.categoryOffset;
        } else if (widget instanceof WidgetCategoryUp) {
            --this.categoryOffset;
        } else if (widget instanceof WidgetChapter) {
            this.currentChapter = ((WidgetChapter)widget).getChapter();
            this.splitIntroPages(this.currentChapter.getName());
        } else if (widget instanceof WidgetChapterUp) {
            --this.chapterOffset;
        } else if (widget instanceof WidgetChapterDown) {
            ++this.chapterOffset;
        } else if (widget instanceof WidgetNextPage) {
            ++this.page;
        } else if (widget instanceof WidgetPrevPage) {
            --this.page;
        }
        this.resetWidgets();
    }

    protected void func_73864_a(int x, int y, int button) {
        super.func_73864_a(x, y, button);
        for (WidgetBase widget : this.widgets) {
            if (!widget.getBounds().contains(x, y)) continue;
            widget.clicked();
            return;
        }
    }

    public void func_73863_a(int x, int y, float f) {
        super.func_73863_a(x, y, f);
        ArrayList<String> tooltips = new ArrayList<String>();
        for (WidgetBase widget : this.widgets) {
            if (!widget.getBounds().contains(x, y)) continue;
            widget.addTooltip(tooltips, GuiEngineeringDiary.func_146272_n());
        }
        if (!tooltips.isEmpty()) {
            ArrayList<String> finalLines = new ArrayList<String>();
            for (String line : tooltips) {
                String[] lines = WordUtils.wrap((String)line, (int)30).split(System.getProperty("line.separator"));
                finalLines.addAll(Arrays.asList(lines));
            }
            this.drawHoveringText(finalLines, x - 5, y, this.field_146289_q);
        }
    }

    public void func_146280_a(Minecraft mc, int width, int height) {
        super.func_146280_a(mc, width, height);
        this.resetWidgets();
    }

    private void resetWidgets() {
        WidgetBase widget;
        int t;
        this.widgets.clear();
        int max = this.numCategories > 7 ? 7 : this.numCategories;
        for (t = 0; t < max; ++t) {
            ((WidgetCategory)widget).setSelected(((WidgetCategory)(widget = new WidgetCategory(this.field_147003_i - 25, this.field_147009_r + 5 + 24 * t, 25, 24, this, this.categories.get(t + this.categoryOffset)))).getCategory() == this.currentCategory);
            this.widgets.add(widget);
        }
        if (this.numCategories > 7 && this.categoryOffset < this.maxCategoryOffset) {
            this.widgets.add(new WidgetCategoryDown(this.field_147003_i - 20, this.field_147009_r + 180, 40, 16, this));
        }
        if (this.categoryOffset > 0) {
            this.widgets.add(new WidgetCategoryUp(this.field_147003_i - 20, this.field_147009_r - 16, 40, 16, this));
        }
        max = this.numChapters > 7 ? 7 : this.numChapters;
        for (t = 0; t < max; ++t) {
            ((WidgetChapter)widget).setSelected(((WidgetChapter)(widget = new WidgetChapter(this.field_147003_i + 256, this.field_147009_r + 5 + 24 * t, 25, 24, this, this.chapters.get(t + this.chapterOffset)))).getChapter() == this.currentChapter);
            this.widgets.add(widget);
        }
        if (this.numChapters > 7 && this.chapterOffset < this.maxChapterOffset) {
            this.widgets.add(new WidgetChapterDown(this.field_147003_i + 245, this.field_147009_r + 180, 40, 16, this));
        }
        if (this.chapterOffset > 0) {
            this.widgets.add(new WidgetChapterUp(this.field_147003_i + 245, this.field_147009_r - 16, 40, 16, this));
        }
        if (this.currentChapter != null) {
            this.widgets.add(new WidgetProgressBar(this.field_147003_i + 60, this.field_147009_r + 25, 180, 7, this, this.research.getProgress(this.currentChapter.getName()), this.currentChapter.getMaxProgress()));
        }
        if (this.page < this.pages && (this.currentChapter == null || this.research.isFinished(this.currentChapter.getName()))) {
            this.widgets.add(new WidgetNextPage(this.field_147003_i + 215, this.field_147009_r + 155, 16, 16, this));
        }
        if (this.page > 0) {
            this.widgets.add(new WidgetPrevPage(this.field_147003_i + 20, this.field_147009_r + 10, 16, 16, this));
        }
    }

    public FontRenderer getFontRendererObj() {
        return this.field_146289_q;
    }

    public void func_146281_b() {
        super.func_146281_b();
        int category = -1;
        List<ICategory> categories = EurekaAPI.API.getCategories();
        for (int i = 0; i < categories.size(); ++i) {
            ICategory c = categories.get(i);
            if (!c.getName().equals(this.currentCategory.getName())) continue;
            category = i;
            break;
        }
        int chapter = -1;
        if (this.currentChapter != null) {
            List<IEurekaInfo> chapters = EurekaAPI.API.getAllKeys();
            for (int i = 0; i < chapters.size(); ++i) {
                IEurekaInfo info = chapters.get(i);
                if (!info.getName().equals(this.currentChapter.getName())) continue;
                chapter = i;
                break;
            }
        }
        PacketHandler.instance.sendToServer((IMessage)new MessageBookSave(this.categoryOffset, this.chapterOffset, this.page, category, chapter));
    }
}

