/*
 * Decompiled with CFR 0.152.
 */
package eureka.core;

import eureka.api.EurekaAPI;
import eureka.api.IEurekaInfo;
import eureka.core.PlayerResearch;
import eureka.core.TextGetter;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;

public class EurekaCommand
extends CommandBase {
    public String func_71517_b() {
        return "eureka";
    }

    public String func_71518_a(ICommandSender sender) {
        return "type '/eureka help' for possible commands and syntax";
    }

    public void func_71515_b(ICommandSender sender, String[] args) {
        if (args == null || args.length == 0) {
            sender.func_145747_a((IChatComponent)new ChatComponentText(this.func_71518_a(sender)));
            return;
        }
        if (args[0].equalsIgnoreCase("help")) {
            sender.func_145747_a((IChatComponent)new ChatComponentText("Eureka Command help:"));
            sender.func_145747_a((IChatComponent)new ChatComponentText("/eureka lock <playername> <key>  : locks the research identified by the key for the specified player"));
            sender.func_145747_a((IChatComponent)new ChatComponentText("/eureka unlock <playername> <key>  : unlocks the research identified by the key for the specified player"));
            sender.func_145747_a((IChatComponent)new ChatComponentText("/eureka keylist  : lists all registered keys and there localized titles"));
            return;
        }
        if (args[0].equalsIgnoreCase("keylist")) {
            for (IEurekaInfo info : EurekaAPI.API.getAllKeys()) {
                sender.func_145747_a((IChatComponent)new ChatComponentText(info.getName() + ": " + TextGetter.getTitle(info.getName())));
            }
            return;
        }
        EntityPlayer player = null;
        for (EntityPlayer p : (ArrayList)MinecraftServer.func_71276_C().func_71203_ab().field_72404_b) {
            if (!p.getDisplayName().equals(args[1])) continue;
            player = p;
            break;
        }
        if (player == null) {
            throw new WrongUsageException("Invalid playername", new Object[0]);
        }
        if (!EurekaAPI.API.keyRegistered(args[2])) {
            throw new WrongUsageException("Invalid key", new Object[0]);
        }
        PlayerResearch research = PlayerResearch.get(player);
        if (args[0].equalsIgnoreCase("lock")) {
            research.overrideFinished(args[2], false);
            research.overrideProgress(args[2], 0);
            sender.func_145747_a((IChatComponent)new ChatComponentText("Research locked"));
        } else if (args[0].equalsIgnoreCase("unlock")) {
            research.overrideFinished(args[2], true);
            sender.func_145747_a((IChatComponent)new ChatComponentText("Research unlocked"));
        }
    }

    public int func_82362_a() {
        return super.func_82362_a();
    }

    public List func_71516_a(ICommandSender sender, String[] args) {
        if (args.length == 2) {
            ArrayList<String> names = new ArrayList<String>();
            for (EntityPlayer player : (ArrayList)MinecraftServer.func_71276_C().func_71203_ab().field_72404_b) {
                names.add(player.getDisplayName());
            }
            return names;
        }
        return null;
    }
}

