/*
 * Decompiled with CFR 0.152.
 */
package eureka.core;

import com.google.common.collect.ImmutableList;
import cpw.mods.fml.common.registry.GameRegistry;
import eureka.api.EnumProgressOptions;
import eureka.api.ICategory;
import eureka.api.IDropHandler;
import eureka.api.IEurekAPI;
import eureka.api.IEurekaInfo;
import eureka.core.Logger;
import eureka.core.PlayerResearch;
import eureka.items.ItemResearchNote;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class EurekaAPIImplementation
implements IEurekAPI {
    private ArrayList<ICategory> categories = new ArrayList();
    private HashMap<String, ICategory> category = new HashMap();
    private HashMap<String, List<IEurekaInfo>> keys = new HashMap();
    private ArrayList<IEurekaInfo> keylist = new ArrayList();
    private HashMap<String, IEurekaInfo> keylookup = new HashMap();
    private ArrayList<IDropHandler> dropHandlers = new ArrayList();
    private HashMap<Block, String> blockMap = new HashMap();
    private HashMap<Item, String> itemMap = new HashMap();
    private EnumMap<EnumProgressOptions, HashMap<Object, List<String>>> progress = new EnumMap(EnumProgressOptions.class);

    @Override
    public void registerCategory(ICategory category) {
        this.categories.add(category);
        this.keys.put(category.getName(), new ArrayList());
        this.category.put(category.getName(), category);
    }

    @Override
    public void register(IEurekaInfo info) {
        if (this.keys.keySet().contains(info.getName())) {
            Logger.error("Duplicate registation: '" + info.getName() + "' is already used");
        } else {
            if (!this.categories.contains(this.category.get(info.getCategory()))) {
                Logger.error("Warning: Key with non-existing category added");
                return;
            }
            this.keylist.add(info);
            List<IEurekaInfo> list = this.keys.get(info.getCategory());
            list.add(info);
            this.keys.remove(info.getCategory());
            this.keys.put(info.getCategory(), list);
            this.keylookup.put(info.getName(), info);
        }
        ItemResearchNote note = new ItemResearchNote(info.getName());
        GameRegistry.registerItem((Item)note, (String)("researchNote" + info.getName()));
    }

    @Override
    public void registerDropHandler(IDropHandler handler) {
        this.dropHandlers.add(handler);
    }

    @Override
    public List<IEurekaInfo> getAllKeys() {
        return ImmutableList.copyOf(this.keylist);
    }

    @Override
    public List<IEurekaInfo> getKeys(String category) {
        return ImmutableList.copyOf((Collection)this.keys.get(category));
    }

    @Override
    public List<ICategory> getCategories() {
        return ImmutableList.copyOf(this.categories);
    }

    @Override
    public int getMaxProgress(String key) {
        if (!this.keylist.contains(this.keylookup.get(key))) {
            return 0;
        }
        return this.keylookup.get(key).getMaxProgress();
    }

    @Override
    public boolean hasPlayerFinishedResearch(String key, EntityPlayer player) {
        return PlayerResearch.get(player).isFinished(key);
    }

    @Override
    public void makeProgress(String key, EntityPlayer player) {
        PlayerResearch.get(player).makeProgress(key);
    }

    @Override
    public void revertProgress(String key, EntityPlayer player) {
        PlayerResearch.get(player).revertProgress(key);
    }

    @Override
    public int getProgress(String key, EntityPlayer player) {
        return PlayerResearch.get(player).getProgress(key);
    }

    @Override
    public void bindToKey(Object o, String key) {
        if (o instanceof Item) {
            this.itemMap.put((Item)o, key);
        } else if (o instanceof Block) {
            this.blockMap.put((Block)o, key);
        }
    }

    @Override
    public String getKey(Object o) {
        if (o instanceof ItemStack) {
            o = ((ItemStack)o).func_77973_b();
        }
        if (o instanceof Item) {
            return this.itemMap.get(o);
        }
        if (o instanceof Block) {
            return this.blockMap.get(o);
        }
        return "";
    }

    @Override
    public List<ItemStack> getDrops(ItemStack stack) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        boolean handled = false;
        for (IDropHandler handler : this.dropHandlers) {
            if (!handler.handles(stack)) continue;
            handled = true;
            List<ItemStack> temp = handler.getDrops(stack);
            for (ItemStack stack2 : temp) {
                list.addAll(this.getDrops(stack2));
            }
        }
        if (!handled) {
            list.add(stack);
        }
        return list;
    }

    @Override
    public boolean keyRegistered(String key) {
        return this.keylookup.keySet().contains(key);
    }

    @Override
    public void registerProgressOption(String key, EnumProgressOptions option, Object arg) {
        List<Object> list;
        HashMap<Object, List<String>> map = this.progress.get((Object)option);
        if (map == null) {
            map = new HashMap();
        }
        if (!option.hasArg()) {
            arg = null;
        }
        if (arg == null) {
            arg = "ANY";
        }
        if (!(list = map.containsKey(arg) ? map.get(arg) : new ArrayList()).contains(key)) {
            list.add(key);
        }
        map.remove(arg);
        map.put(arg, list);
        this.progress.remove((Object)option);
        this.progress.put(option, map);
    }

    @Override
    public void completeResearch(EntityPlayer player, String key) {
        PlayerResearch.get(player).completeResearch(key);
    }

    @Override
    public IEurekaInfo getInfo(String key) {
        return this.keylookup.get(key);
    }

    public List<String> getKeysforProgress(EnumProgressOptions option, Object arg) {
        HashMap<Object, List<String>> map = this.progress.get((Object)option);
        if (arg == null) {
            arg = "ANY";
        }
        if (map == null || !map.containsKey(arg)) {
            return Collections.EMPTY_LIST;
        }
        return ImmutableList.copyOf((Collection)map.get(arg));
    }

    @Override
    public ICategory getCategory(String key) {
        return this.category.get(key);
    }
}

